/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import java.util.List;
import org.eclipse.draw2dl.IFigure;

public class FocusTraverseManager {
    IFigure currentFocusOwner;

    private IFigure findDeepestRightmostChildOf(IFigure fig) {
        while (fig.getChildren().size() != 0) {
            fig = fig.getChildren().get(fig.getChildren().size() - 1);
        }
        return fig;
    }

    public IFigure getNextFocusableFigure(IFigure root, IFigure prevFocus) {
        boolean found = false;
        IFigure nextFocus = prevFocus;
        if (prevFocus == null) {
            if (root.getChildren().size() != 0) {
                nextFocus = root.getChildren().get(0);
                if (this.isFocusEligible(nextFocus)) {
                    return nextFocus;
                }
            } else {
                return null;
            }
        }
        int siblingPos = nextFocus.getParent().getChildren().indexOf(nextFocus);
        while (!found) {
            IFigure parent = nextFocus.getParent();
            List<IFigure> siblings = parent.getChildren();
            if (nextFocus.getChildren().size() != 0) {
                nextFocus = nextFocus.getChildren().get(0);
                siblingPos = 0;
                if (!this.isFocusEligible(nextFocus)) continue;
                found = true;
                continue;
            }
            if (siblingPos < siblings.size() - 1) {
                if (!this.isFocusEligible(nextFocus = siblings.get(++siblingPos))) continue;
                found = true;
                continue;
            }
            boolean untraversedSiblingFound = false;
            while (!untraversedSiblingFound) {
                IFigure p = nextFocus.getParent();
                IFigure gp = p.getParent();
                if (gp != null) {
                    int parentSiblingCount = gp.getChildren().size();
                    int parentIndex = gp.getChildren().indexOf(p);
                    if (parentIndex < parentSiblingCount - 1) {
                        nextFocus = p.getParent().getChildren().get(parentIndex + 1);
                        siblingPos = parentIndex + 1;
                        untraversedSiblingFound = true;
                        if (!this.isFocusEligible(nextFocus)) continue;
                        found = true;
                        continue;
                    }
                    nextFocus = p;
                    continue;
                }
                nextFocus = null;
                untraversedSiblingFound = true;
                found = true;
            }
        }
        return nextFocus;
    }

    public IFigure getPreviousFocusableFigure(IFigure root, IFigure prevFocus) {
        if (prevFocus == null) {
            return null;
        }
        boolean found = false;
        IFigure nextFocus = prevFocus;
        while (!found) {
            IFigure parent = nextFocus.getParent();
            if (parent == null) {
                return null;
            }
            List<IFigure> siblings = parent.getChildren();
            int siblingPos = siblings.indexOf(nextFocus);
            if (siblingPos != 0) {
                IFigure child = this.findDeepestRightmostChildOf(siblings.get(siblingPos - 1));
                if (this.isFocusEligible(child)) {
                    found = true;
                    nextFocus = child;
                    continue;
                }
                if (child.equals(nextFocus)) {
                    if (!this.isFocusEligible(nextFocus)) continue;
                    found = true;
                    continue;
                }
                nextFocus = child;
                continue;
            }
            nextFocus = parent;
            if (!this.isFocusEligible(nextFocus)) continue;
            found = true;
        }
        return nextFocus;
    }

    public IFigure getCurrentFocusOwner() {
        return this.currentFocusOwner;
    }

    private boolean isFocusEligible(IFigure fig) {
        return fig != null && fig.isFocusTraversable() && fig.isShowing();
    }

    public void setCurrentFocusOwner(IFigure fig) {
        this.currentFocusOwner = fig;
    }
}

