/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceTask;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEnumWithValue;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class JDBCUtils {
    private static final Log log = Log.getLog(JDBCUtils.class);
    private static final Map<String, Integer> badColumnNames = new HashMap<String, Integer>();

    @Nullable
    public static String safeGetString(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getString(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static String safeGetStringTrimmed(ResultSet dbResult, String columnName) {
        try {
            String value = dbResult.getString(columnName);
            if (value != null && !value.isEmpty()) {
                return value.trim();
            }
            return value;
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static String safeGetString(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getString(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static String safeGetStringTrimmed(ResultSet dbResult, int columnIndex) {
        try {
            String value = dbResult.getString(columnIndex);
            if (value != null && !value.isEmpty()) {
                return value.trim();
            }
            return value;
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    public static int safeGetInt(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getInt(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return 0;
        }
    }

    public static int safeGetInt(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getInt(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return 0;
        }
    }

    @Nullable
    public static Integer safeGetInteger(ResultSet dbResult, String columnName) {
        int result;
        block3: {
            try {
                result = dbResult.getInt(columnName);
                if (!dbResult.wasNull()) break block3;
                return null;
            }
            catch (Exception e) {
                JDBCUtils.debugColumnRead(dbResult, columnName, e);
                return null;
            }
        }
        return result;
    }

    @Nullable
    public static Integer safeGetInteger(ResultSet dbResult, int columnIndex) {
        int result;
        block3: {
            try {
                result = dbResult.getInt(columnIndex);
                if (!dbResult.wasNull()) break block3;
                return null;
            }
            catch (Exception e) {
                JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
                return null;
            }
        }
        return result;
    }

    public static long safeGetLong(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getLong(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return 0L;
        }
    }

    public static long safeGetLong(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getLong(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return 0L;
        }
    }

    @Nullable
    public static Long safeGetLongNullable(ResultSet dbResult, String columnName) {
        try {
            long result = dbResult.getLong(columnName);
            return dbResult.wasNull() ? null : Long.valueOf(result);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    public static double safeGetDouble(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getDouble(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return 0.0;
        }
    }

    public static double safeGetDouble(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getDouble(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return 0.0;
        }
    }

    public static float safeGetFloat(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getFloat(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return 0.0f;
        }
    }

    public static float safeGetFloat(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getFloat(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return 0.0f;
        }
    }

    @Nullable
    public static BigDecimal safeGetBigDecimal(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getBigDecimal(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static BigDecimal safeGetBigDecimal(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getBigDecimal(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    public static boolean safeGetBoolean(ResultSet dbResult, String columnName) {
        return JDBCUtils.safeGetBoolean(dbResult, columnName, false);
    }

    public static boolean safeGetBoolean(ResultSet dbResult, String columnName, boolean defValue) {
        try {
            return dbResult.getBoolean(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return defValue;
        }
    }

    public static boolean safeGetBoolean(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getBoolean(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return false;
        }
    }

    public static boolean safeGetBoolean(@NotNull ResultSet dbResult, int columnIndex, @NotNull String trueValue) {
        try {
            String strValue = dbResult.getString(columnIndex);
            return strValue != null && strValue.startsWith(trueValue);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return false;
        }
    }

    public static boolean safeGetBoolean(ResultSet dbResult, String columnName, String trueValue) {
        try {
            String strValue = dbResult.getString(columnName);
            return strValue != null && strValue.startsWith(trueValue);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return false;
        }
    }

    @Nullable
    public static byte[] safeGetBytes(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getBytes(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Timestamp safeGetTimestamp(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getTimestamp(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Timestamp safeGetTimestamp(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getTimestamp(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static Date safeGetDate(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getDate(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Date safeGetDate(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getDate(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static Time safeGetTime(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getTime(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Time safeGetTime(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getTime(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static SQLXML safeGetXML(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getSQLXML(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static SQLXML safeGetXML(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getSQLXML(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static Object safeGetObject(ResultSet dbResult, String columnName) {
        try {
            return dbResult.getObject(columnName);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Object safeGetObject(ResultSet dbResult, int columnIndex) {
        try {
            return dbResult.getObject(columnIndex);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static <T> T safeGetArray(ResultSet dbResult, String columnName) {
        try {
            Array array = dbResult.getArray(columnName);
            return (T)(array == null ? null : array.getArray());
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
            return null;
        }
    }

    @Nullable
    public static Object safeGetArray(ResultSet dbResult, int columnIndex) {
        try {
            Array array = dbResult.getArray(columnIndex);
            return array == null ? null : array.getArray();
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnIndex, e);
            return null;
        }
    }

    @Nullable
    public static <T extends Enum<T>> T safeGetEnum(@NotNull ResultSet dbResult, @NotNull String columnName, @NotNull Class<T> type) {
        try {
            int value = dbResult.getInt(columnName);
            Enum[] enumArray = (Enum[])type.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum constant = enumArray[n2];
                if (((DBPEnumWithValue)((Object)constant)).getValue() == value) {
                    return (T)constant;
                }
                ++n2;
            }
            log.debug("Can't convert value " + value + " to enum type " + type);
        }
        catch (Exception e) {
            JDBCUtils.debugColumnRead(dbResult, columnName, e);
        }
        return null;
    }

    @Nullable
    public static String normalizeIdentifier(@Nullable String value) {
        return value == null ? null : value.trim();
    }

    public static boolean isConnectionAlive(DBPDataSource dataSource, Connection connection) {
        try {
            if (connection == null || connection.isClosed()) {
                return false;
            }
        }
        catch (SQLException e) {
            log.debug(e);
            return false;
        }
        for (DBPDataSourceTask task : dataSource.getContainer().getTasks()) {
            if (!task.isActiveTask()) continue;
            return true;
        }
        String testSQL = dataSource.getSQLDialect().getTestSQL();
        int invalidateTimeout = dataSource.getContainer().getPreferenceStore().getInt("connection.validation.timeout");
        boolean[] isValid = new boolean[1];
        RuntimeUtils.runTask(monitor -> {
            block14: {
                try {
                    if (!CommonUtils.isEmpty((String)testSQL)) {
                        Throwable throwable = null;
                        Object var6_7 = null;
                        try (Statement dbStat = connection.createStatement();){
                            dbStat.execute(testSQL);
                            blArray[0] = true;
                            break block14;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        blArray[0] = connection.isValid(invalidateTimeout);
                    }
                    catch (Throwable throwable) {
                        connection.getMetaData().getTables(null, null, "DBEAVERFAKETABLENAMEFORPING", null);
                        blArray[0] = true;
                    }
                }
                catch (SQLException sQLException) {
                    blArray[0] = false;
                }
            }
        }, "Ping connection " + dataSource.getContainer().getName(), invalidateTimeout + 2000, true);
        return isValid[0];
    }

    public static void scrollResultSet(ResultSet dbResult, long offset, boolean forceFetch) throws SQLException {
        boolean scrolled = false;
        if (!forceFetch) {
            try {
                scrolled = dbResult.absolute((int)offset);
            }
            catch (IncompatibleClassChangeError | UnsupportedOperationException | SQLException e) {
                log.debug(e.getMessage());
            }
        }
        if (!scrolled) {
            long i = 1L;
            while (i <= offset) {
                try {
                    dbResult.next();
                }
                catch (SQLException e) {
                    throw new SQLException("Can't scroll result set to row " + offset, e);
                }
                ++i;
            }
        }
    }

    public static void reportWarnings(JDBCSession session, SQLWarning rootWarning) {
        SQLWarning warning = rootWarning;
        while (warning != null) {
            if (warning.getMessage() != null || warning.getErrorCode() != 0) {
                log.warn("SQL Warning (DataSource: " + session.getDataSource().getContainer().getName() + "; Code: " + warning.getErrorCode() + "; State: " + warning.getSQLState() + "): " + warning.getLocalizedMessage());
            }
            warning = warning.getNextWarning();
        }
    }

    @NotNull
    public static String limitQueryLength(@NotNull String query, int maxLength) {
        return query.length() <= maxLength ? query : query.substring(0, maxLength);
    }

    public static DBSForeignKeyModifyRule getCascadeFromNum(int num) {
        switch (num) {
            case 3: {
                return DBSForeignKeyModifyRule.NO_ACTION;
            }
            case 0: {
                return DBSForeignKeyModifyRule.CASCADE;
            }
            case 2: {
                return DBSForeignKeyModifyRule.SET_NULL;
            }
            case 4: {
                return DBSForeignKeyModifyRule.SET_DEFAULT;
            }
            case 1: {
                return DBSForeignKeyModifyRule.RESTRICT;
            }
        }
        return DBSForeignKeyModifyRule.UNKNOWN;
    }

    public static DBSForeignKeyModifyRule getCascadeFromName(String name) {
        switch (name) {
            case "NO ACTION": {
                return DBSForeignKeyModifyRule.NO_ACTION;
            }
            case "CASCADE": {
                return DBSForeignKeyModifyRule.CASCADE;
            }
            case "SET NULL": {
                return DBSForeignKeyModifyRule.SET_NULL;
            }
            case "SET DEFAULT": {
                return DBSForeignKeyModifyRule.SET_DEFAULT;
            }
            case "RESTRICT": {
                return DBSForeignKeyModifyRule.RESTRICT;
            }
        }
        return DBSForeignKeyModifyRule.UNKNOWN;
    }

    public static void executeSQL(Connection session, String sql, Object ... params) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement dbStat = session.prepareStatement(sql);){
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    dbStat.setObject(i + 1, params[i]);
                    ++i;
                }
            }
            dbStat.execute();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static int executeUpdate(Connection session, String sql, Object ... params) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement dbStat = session.prepareStatement(sql);){
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    dbStat.setObject(i + 1, params[i]);
                    ++i;
                }
            }
            return dbStat.executeUpdate();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void executeProcedure(Connection session, String sql) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (CallableStatement dbStat = session.prepareCall(sql);){
            dbStat.execute();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public static <T> T executeQuery(Connection session, String sql, Object ... params) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void executeStatement(Connection session, String sql, Object ... params) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement dbStat = session.prepareStatement(sql);){
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    dbStat.setObject(i + 1, params[i]);
                    ++i;
                }
            }
            dbStat.execute();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void executeStatement(Connection session, String sql) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement dbStat = session.createStatement();){
            dbStat.execute(sql);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static String queryString(Connection session, String sql, Object ... args) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static <T> T queryObject(Connection session, String sql, Object ... args) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void debugColumnRead(ResultSet dbResult, String columnName, Exception error) {
        String colFullId = columnName;
        if (dbResult instanceof JDBCResultSet) {
            colFullId = String.valueOf(colFullId) + ":" + ((JDBCResultSet)dbResult).getSession().getDataSource().getContainer().getId();
        }
        Map<String, Integer> map = badColumnNames;
        synchronized (map) {
            Integer errorCount = badColumnNames.get(colFullId);
            if (errorCount == null) {
                log.debug("Can't get column '" + columnName + "': " + error.getMessage());
            }
            badColumnNames.put(colFullId, errorCount == null ? 0 : errorCount + 1);
        }
    }

    private static void debugColumnRead(ResultSet dbResult, int columnIndex, Exception error) {
        JDBCUtils.debugColumnRead(dbResult, "#" + columnIndex, error);
    }

    public static void appendFilterClause(@NotNull StringBuilder sql, @NotNull DBSObjectFilter filter, @NotNull String columnAlias, @NotNull boolean firstClause) {
        JDBCUtils.appendFilterClause(sql, filter, columnAlias, firstClause, null);
    }

    public static void appendFilterClause(@NotNull StringBuilder sql, @NotNull DBSObjectFilter filter, @NotNull String columnAlias, @NotNull boolean firstClause, DBPDataSource dataSource) {
        List<String> exclude;
        if (filter.isNotApplicable()) {
            return;
        }
        if (filter.hasSingleMask()) {
            if (columnAlias != null) {
                firstClause = SQLUtils.appendFirstClause(sql, firstClause);
                sql.append(columnAlias);
            }
            SQLUtils.appendLikeCondition(sql, filter.getSingleMask(), false, dataSource != null ? dataSource.getSQLDialect() : null);
            return;
        }
        List<String> include = filter.getInclude();
        if (!CommonUtils.isEmpty(include)) {
            if (columnAlias != null) {
                firstClause = SQLUtils.appendFirstClause(sql, firstClause);
            }
            sql.append("(");
            int i = 0;
            int includeSize = include.size();
            while (i < includeSize) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                if (columnAlias != null) {
                    sql.append(columnAlias);
                }
                SQLUtils.appendLikeCondition(sql, include.get(i), false, dataSource != null ? dataSource.getSQLDialect() : null);
                ++i;
            }
            sql.append(")");
        }
        if (!CommonUtils.isEmpty(exclude = filter.getExclude())) {
            if (columnAlias != null) {
                SQLUtils.appendFirstClause(sql, firstClause);
            }
            sql.append("NOT (");
            int i = 0;
            int excludeSize = exclude.size();
            while (i < excludeSize) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                if (columnAlias != null) {
                    sql.append(columnAlias);
                }
                SQLUtils.appendLikeCondition(sql, exclude.get(i), false, dataSource != null ? dataSource.getSQLDialect() : null);
                ++i;
            }
            sql.append(")");
        }
    }

    public static void setFilterParameters(PreparedStatement statement, int paramIndex, DBSObjectFilter filter) throws SQLException {
        if (filter.isNotApplicable()) {
            return;
        }
        for (String inc : CommonUtils.safeCollection(filter.getInclude())) {
            statement.setString(paramIndex++, SQLUtils.makeSQLLike(inc));
        }
        for (String exc : CommonUtils.safeCollection(filter.getExclude())) {
            statement.setString(paramIndex++, SQLUtils.makeSQLLike(exc));
        }
    }

    public static void rethrowSQLException(Throwable e) throws SQLException {
        if (e instanceof InvocationTargetException) {
            Throwable targetException = ((InvocationTargetException)e).getTargetException();
            if (targetException instanceof SQLException) {
                throw (SQLException)targetException;
            }
            throw new SQLException(targetException);
        }
    }

    @NotNull
    public static DBPDataKind resolveDataKind(@Nullable DBPDataSource dataSource, String typeName, int typeID) {
        if (dataSource == null) {
            return JDBCDataSource.getDataKind(typeName, typeID);
        }
        if (dataSource instanceof DBPDataTypeProvider) {
            return ((DBPDataTypeProvider)((Object)dataSource)).resolveDataKind(typeName, typeID);
        }
        return DBPDataKind.UNKNOWN;
    }

    public static String escapeWildCards(JDBCSession session, String string) {
        if (string == null || string.isEmpty() || string.indexOf(37) == -1 && string.indexOf(95) == -1) {
            return string;
        }
        try {
            SQLDialect dialect = SQLUtils.getDialectFromDataSource(session.getDataSource());
            String escapeStr = dialect.getSearchStringEscape();
            if (CommonUtils.isEmpty((String)escapeStr) || escapeStr.equals(" ")) {
                return string;
            }
            return string.replace("%", String.valueOf(escapeStr) + "%").replace("_", String.valueOf(escapeStr) + "_");
        }
        catch (Throwable e) {
            log.debug("Error escaping wildcard string", e);
            return string;
        }
    }

    public static boolean queryHasOutputParameters(SQLDialect sqlDialect, String sqlQuery) {
        return sqlQuery.contains("?");
    }

    public static Long queryLong(Connection session, String sql, Object ... params) throws SQLException {
        Number result = (Number)JDBCUtils.executeQuery(session, sql, params);
        if (result != null) {
            return result.longValue();
        }
        return null;
    }

    public static long executeInsertAutoIncrement(Connection session, String sql, Object ... params) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement dbStat = session.prepareStatement(sql, 1);){
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    dbStat.setObject(i + 1, params[i]);
                    ++i;
                }
            }
            dbStat.execute();
            return JDBCUtils.getGeneratedKey(dbStat);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static long getGeneratedKey(PreparedStatement dbStat) throws SQLException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ResultSet keysRS = dbStat.getGeneratedKeys();){
            keysRS.next();
            return keysRS.getLong(1);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

