/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs.nio;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.jkiss.dbeaver.model.fs.nio.NIOFile;
import org.jkiss.dbeaver.model.fs.nio.NIOFileSystemRoot;
import org.jkiss.dbeaver.model.fs.nio.NIOFolder;
import org.jkiss.dbeaver.model.fs.nio.NIOResource;
import org.jkiss.dbeaver.utils.GeneralUtils;

public abstract class NIOContainer
extends NIOResource
implements IContainer {
    protected NIOContainer(NIOFileSystemRoot root, java.nio.file.Path path) {
        super(root, path);
    }

    public int getType() {
        return 0;
    }

    public boolean exists(IPath path) {
        IResource member = this.findMember(path);
        return member.exists();
    }

    public IResource findMember(IPath path) {
        if (path.isEmpty()) {
            return this;
        }
        java.nio.file.Path member = this.getNioPath().resolve(path.toString());
        LinkedList<java.nio.file.Path> backendResources = new LinkedList<java.nio.file.Path>();
        java.nio.file.Path it2 = member;
        while (it2 != this.getNioPath()) {
            backendResources.addFirst(it2);
            it2 = it2.getParent();
        }
        for (java.nio.file.Path it2 : backendResources) {
            if (!Files.isDirectory(it2, new LinkOption[0])) {
                return new NIOFile(this.getRoot(), it2);
            }
            new NIOFolder(this.getRoot(), it2);
        }
        return null;
    }

    public IResource findMember(IPath path, boolean includePhantoms) {
        return this.findMember(path);
    }

    public IResource findMember(String path, boolean includePhantoms) {
        return this.findMember(path);
    }

    public IResource findMember(String path) {
        return this.findMember((IPath)new Path(path));
    }

    public String getDefaultCharset() throws CoreException {
        return "UTF-8";
    }

    public String getDefaultCharset(boolean checkImplicit) throws CoreException {
        return this.getDefaultCharset();
    }

    public IFile getFile(IPath path) {
        java.nio.file.Path childBackendFile = this.getNioPath().resolve(path.toString());
        return new NIOFile(this.getRoot(), childBackendFile);
    }

    public IFolder getFolder(IPath path) {
        java.nio.file.Path childBackendFolder = this.getNioPath().resolve(path.toString());
        return new NIOFolder(this.getRoot(), childBackendFolder);
    }

    public IResource[] members() throws CoreException {
        ArrayList members = new ArrayList();
        try {
            Files.list(this.getNioPath()).forEach(member -> {
                if (Files.isDirectory(member, new LinkOption[0])) {
                    members.add(new NIOFolder(this.getRoot(), (java.nio.file.Path)member));
                } else {
                    members.add(new NIOFile(this.getRoot(), (java.nio.file.Path)member));
                }
            });
        }
        catch (IOException e) {
            throw new CoreException(GeneralUtils.makeExceptionStatus(e));
        }
        return members.toArray(new IResource[0]);
    }

    public IResource[] members(boolean includePhantoms) throws CoreException {
        return this.members();
    }

    public IResource[] members(int memberFlags) throws CoreException {
        return this.members();
    }

    public IFile[] findDeletedMembersWithHistory(int depth, IProgressMonitor monitor) throws CoreException {
        return new IFile[0];
    }

    @Deprecated
    public void setDefaultCharset(String charset) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public void setDefaultCharset(String charset, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public IResourceFilterDescription createFilter(int type, FileInfoMatcherDescription matcherDescription, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new NIOResource.FeatureNotSupportedException();
    }

    public IResourceFilterDescription[] getFilters() throws CoreException {
        return new IResourceFilterDescription[0];
    }

    @Override
    protected boolean visit(IResourceVisitor visitor, int depth) throws CoreException {
        if (!super.visit(visitor, depth)) {
            return false;
        }
        if (depth < 1) {
            return false;
        }
        --depth;
        IResource[] iResourceArray = this.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            ((NIOResource)member).visit(visitor, depth);
            ++n2;
        }
        return true;
    }
}

