/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.auth;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.model.auth.AuthPropertyDescriptor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SMAuthCredentialsProfile {
    private final String id;
    private final String label;
    private final String description;
    private final Map<String, AuthPropertyDescriptor> credentialParameters = new LinkedHashMap<String, AuthPropertyDescriptor>();

    public SMAuthCredentialsProfile(IConfigurationElement cfg) {
        this.id = cfg.getAttribute("id");
        this.label = cfg.getAttribute("label");
        this.description = cfg.getAttribute("description");
        for (IConfigurationElement propGroup : ArrayUtils.safeArray((Object[])cfg.getChildren("propertyGroup"))) {
            IConfigurationElement[] propElements;
            String category = propGroup.getAttribute("label");
            IConfigurationElement[] iConfigurationElementArray = propElements = propGroup.getChildren("property");
            int n = propElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement prop = iConfigurationElementArray[n2];
                AuthPropertyDescriptor propertyDescriptor = new AuthPropertyDescriptor(category, prop);
                this.credentialParameters.put(CommonUtils.toString((Object)propertyDescriptor.getId()), propertyDescriptor);
                ++n2;
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public List<AuthPropertyDescriptor> getCredentialParameters() {
        return new ArrayList<AuthPropertyDescriptor>(this.credentialParameters.values());
    }

    public AuthPropertyDescriptor getCredentialParameter(String id) {
        return this.credentialParameters.get(id);
    }
}

