/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableIndex;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableIndexColumn;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndexColumn;

public class MySQLTableIndexColumn
extends AbstractTableIndexColumn {
    private MySQLTableIndex index;
    private MySQLTableColumn tableColumn;
    private int ordinalPosition;
    private boolean ascending;
    private boolean nullable;
    private String subPart;

    public MySQLTableIndexColumn(MySQLTableIndex index, MySQLTableColumn tableColumn, int ordinalPosition, boolean ascending, boolean nullable, String subPart) {
        this.index = index;
        this.tableColumn = tableColumn;
        this.ordinalPosition = ordinalPosition;
        this.ascending = ascending;
        this.nullable = nullable;
        this.subPart = subPart;
    }

    MySQLTableIndexColumn(DBRProgressMonitor monitor, MySQLTableIndex toIndex, DBSTableIndexColumn source) throws DBException {
        this.index = toIndex;
        if (source.getTableColumn() != null) {
            this.tableColumn = ((MySQLTable)toIndex.getTable()).getAttribute(monitor, source.getTableColumn().getName());
        }
        this.ordinalPosition = source.getOrdinalPosition();
        this.ascending = source.isAscending();
        if (source instanceof MySQLTableIndexColumn) {
            this.nullable = ((MySQLTableIndexColumn)source).nullable;
            this.subPart = ((MySQLTableIndexColumn)source).subPart;
        }
    }

    @NotNull
    public MySQLTableIndex getIndex() {
        return this.index;
    }

    @NotNull
    public String getName() {
        return this.tableColumn.getName();
    }

    @Property(id="name", viewable=true, order=1)
    @Nullable
    public MySQLTableColumn getTableColumn() {
        return this.tableColumn;
    }

    @Property(viewable=false, order=2)
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @Property(viewable=true, order=3)
    public boolean isAscending() {
        return this.ascending;
    }

    @Property(viewable=true, order=4)
    public boolean isNullable() {
        return this.nullable;
    }

    @Property(viewable=true, order=5)
    public String getSubPart() {
        return this.subPart;
    }

    @Nullable
    public String getDescription() {
        return this.tableColumn.getDescription();
    }

    public MySQLTableIndex getParentObject() {
        return this.index;
    }

    @NotNull
    public MySQLDataSource getDataSource() {
        return this.index.getDataSource();
    }
}

