/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLProcedure;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSPackage;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureContainer;

public class MySQLPackage
implements DBPScriptObject,
DBPScriptObjectExt,
DBSObjectContainer,
DBPRefreshableObject,
DBSProcedureContainer,
DBSPackage,
DBPQualifiedObject {
    private MySQLCatalog catalog;
    private String name;
    private String description;
    private boolean persisted;
    private final ProceduresCache proceduresCache = new ProceduresCache();
    private String sourceDeclaration;
    private String sourceDefinition;

    public MySQLPackage(MySQLCatalog catalog, ResultSet dbResult) {
        this.catalog = catalog;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment");
        this.persisted = true;
    }

    public MySQLPackage(MySQLCatalog catalog, String name) {
        this.catalog = catalog;
        this.name = name;
        this.persisted = false;
    }

    public DBPDataSource getDataSource() {
        return this.catalog.getDataSource();
    }

    public DBSObject getParentObject() {
        return this.catalog;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    @Property(viewable=true, order=1)
    public String getName() {
        return this.name;
    }

    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getCatalog(), this});
    }

    @Property(viewable=true, order=100)
    public String getDescription() {
        return this.description;
    }

    public MySQLCatalog getCatalog() {
        return this.catalog;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBCException {
        if (this.sourceDeclaration == null && monitor != null) {
            this.sourceDeclaration = this.readSource(monitor, false);
        }
        return this.sourceDeclaration;
    }

    public void setObjectDefinitionText(String sourceDeclaration) {
        this.sourceDeclaration = sourceDeclaration;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getExtendedDefinitionText(DBRProgressMonitor monitor) throws DBException {
        if (this.sourceDefinition == null && monitor != null) {
            this.sourceDefinition = this.readSource(monitor, true);
        }
        return this.sourceDefinition;
    }

    public void setExtendedDefinitionText(String source) {
        this.sourceDefinition = source;
    }

    @Association
    public Collection<MySQLProcedure> getProcedures(DBRProgressMonitor monitor) throws DBException {
        return this.proceduresCache.getAllObjects(monitor, (DBSObject)this);
    }

    public MySQLProcedure getProcedure(DBRProgressMonitor monitor, String uniqueName) throws DBException {
        return (MySQLProcedure)this.proceduresCache.getObject(monitor, (DBSObject)this, uniqueName);
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.proceduresCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.proceduresCache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return MySQLProcedure.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.proceduresCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.proceduresCache.clearCache();
        this.sourceDeclaration = null;
        this.sourceDefinition = null;
        return this;
    }

    /*
     * Exception decompiling
     */
    private String readSource(DBRProgressMonitor monitor, boolean isBody) throws DBCException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static class ProceduresCache
    extends JDBCObjectCache<MySQLPackage, MySQLProcedure> {
        ProceduresCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull MySQLPackage owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT P.*,CASE WHEN A.DATA_TYPE IS NULL THEN 'PROCEDURE' ELSE 'FUNCTION' END as PROCEDURE_TYPE FROM ALL_PROCEDURES P\nLEFT OUTER JOIN ALL_ARGUMENTS A ON A.OWNER=P.OWNER AND A.PACKAGE_NAME=P.OBJECT_NAME AND A.OBJECT_NAME=P.PROCEDURE_NAME AND A.ARGUMENT_NAME IS NULL AND A.DATA_LEVEL=0\nWHERE P.OWNER=? AND P.OBJECT_NAME=?\nORDER BY P.PROCEDURE_NAME");
            dbStat.setString(1, owner.getCatalog().getName());
            dbStat.setString(2, owner.getName());
            return dbStat;
        }

        protected MySQLProcedure fetchObject(@NotNull JDBCSession session, @NotNull MySQLPackage owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new MySQLProcedure(owner.getCatalog(), (ResultSet)dbResult);
        }
    }
}

