/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.edit.DBEObjectManager;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ISearchExecutor;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;

public class ObjectEditorPageControl
extends ProgressPageControl {
    private static final Log log = Log.getLog(ObjectEditorPageControl.class);
    private IDatabaseEditor workbenchPart;
    private IPropertyListener propertyListener;
    private volatile LoadingJob curService = null;

    public ObjectEditorPageControl(Composite parent, int style, IDatabaseEditor workbenchPart) {
        super(parent, style);
        this.workbenchPart = workbenchPart;
    }

    public void disposeControl() {
        if (this.propertyListener != null) {
            this.getMainEditorPart().removePropertyListener(this.propertyListener);
            this.propertyListener = null;
        }
        super.disposeControl();
    }

    public IDatabaseEditor getEditorPart() {
        return this.workbenchPart;
    }

    public boolean isObjectEditable() {
        IEditorInput editorInput = this.getEditorPart().getEditorInput();
        if (editorInput instanceof IDatabaseEditorInput) {
            DBCExecutionContext context = ((IDatabaseEditorInput)editorInput).getExecutionContext();
            if (context == null) {
                return false;
            }
            if (context.getDataSource().getInfo().isReadOnlyMetaData()) {
                return false;
            }
            DBSObject databaseObject = ((IDatabaseEditorInput)editorInput).getDatabaseObject();
            return databaseObject != null && DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(databaseObject.getClass(), DBEObjectManager.class) != null;
        }
        return false;
    }

    private IEditorPart getMainEditorPart() {
        IWorkbenchPartSite site = this.workbenchPart.getSite();
        if (site instanceof MultiPageEditorSite) {
            return ((MultiPageEditorSite)site).getMultiPageEditor();
        }
        return this.workbenchPart;
    }

    protected ISearchExecutor getSearchRunner() {
        ISearchExecutor searchRunner = super.getSearchRunner();
        if (searchRunner != null) {
            return searchRunner;
        }
        return new ISearchExecutor(){

            public boolean performSearch(String searchString, int options) {
                return false;
            }

            public void cancelSearch() {
            }
        };
    }

    public void fillCustomActions(IContributionManager contributionManager) {
        super.fillCustomActions(contributionManager);
    }

    protected synchronized boolean cancelProgress() {
        if (this.curService != null) {
            this.curService.cancel();
            return true;
        }
        return false;
    }

    public synchronized <OBJECT_TYPE> void runService(LoadingJob<OBJECT_TYPE> service) {
        this.curService = service;
        service.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                ObjectEditorPageControl objectEditorPageControl = ObjectEditorPageControl.this;
                synchronized (objectEditorPageControl) {
                    ObjectEditorPageControl.this.curService = null;
                }
            }
        });
        service.schedule();
    }

    public <OBJECT_TYPE> ObjectsLoadVisualizer<OBJECT_TYPE> createDefaultLoadVisualizer(DBRRunnableParametrized<OBJECT_TYPE> listener) {
        ObjectsLoadVisualizer<OBJECT_TYPE> visualizer = new ObjectsLoadVisualizer<OBJECT_TYPE>();
        if (listener != null) {
            visualizer.addLoadListener(listener);
        }
        return visualizer;
    }

    public class ObjectsLoadVisualizer<OBJECT_TYPE>
    extends ProgressPageControl.ProgressVisualizer<OBJECT_TYPE> {
        private List<DBRRunnableParametrized<OBJECT_TYPE>> listeners;

        public ObjectsLoadVisualizer() {
            super((ProgressPageControl)ObjectEditorPageControl.this);
            this.listeners = new ArrayList<DBRRunnableParametrized<OBJECT_TYPE>>();
        }

        public void addLoadListener(DBRRunnableParametrized<OBJECT_TYPE> listener) {
            this.listeners.add(listener);
        }

        public void completeLoading(OBJECT_TYPE result) {
            super.completeLoading(result);
            if (!this.listeners.isEmpty()) {
                for (DBRRunnableParametrized<OBJECT_TYPE> listener : this.listeners) {
                    try {
                        listener.run(result);
                    }
                    catch (InvocationTargetException e) {
                        log.error((Object)e.getTargetException());
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            this.listeners.clear();
        }
    }
}

