/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tools;

import java.util.Collection;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLDatabaseExportInfo;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLExportSettings;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLExportWizardPageObjects;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLExportWizardPageSettings;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.registry.task.TaskPreferenceStore;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractNativeExportWizard;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

class MySQLExportWizard
extends AbstractNativeExportWizard<MySQLExportSettings, MySQLDatabaseExportInfo> {
    private MySQLExportWizardPageObjects objectsPage;
    private MySQLExportWizardPageSettings settingsPage;

    MySQLExportWizard(Collection<DBSObject> objects) {
        super(objects, MySQLUIMessages.tools_db_export_wizard_task_name);
        ((MySQLExportSettings)this.getSettings()).fillExportObjectsFromInput();
    }

    MySQLExportWizard(DBTTask task) {
        super(task);
    }

    protected MySQLExportSettings createSettings() {
        return new MySQLExportSettings();
    }

    public String getTaskTypeId() {
        return "mysqlDatabaseBackup";
    }

    public void saveTaskState(DBRRunnableContext runnableContext, DBTTask task, Map<String, Object> state) {
        if (this.objectsPage.getControl() != null) {
            this.objectsPage.saveState();
        }
        if (this.settingsPage.getControl() != null) {
            this.settingsPage.saveState();
        }
        ((MySQLExportSettings)this.getSettings()).saveSettings(runnableContext, (DBPPreferenceStore)new TaskPreferenceStore(state));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.objectsPage = new MySQLExportWizardPageObjects(this);
        this.settingsPage = new MySQLExportWizardPageSettings(this);
    }

    public void addPages() {
        this.addTaskConfigPages();
        this.addPage((IWizardPage)this.objectsPage);
        this.addPage((IWizardPage)this.settingsPage);
        super.addPages();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.settingsPage) {
            return null;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.logPage) {
            return this.settingsPage;
        }
        return super.getPreviousPage(page);
    }

    public void onSuccess(long workTime) {
        UIUtils.showMessageBox((Shell)this.getShell(), (String)MySQLUIMessages.tools_db_export_wizard_title, (String)CommonUtils.truncateString((String)NLS.bind((String)MySQLUIMessages.tools_db_export_wizard_message_export_completed, (Object)this.getObjectsName()), (int)255), (int)2);
        ShellUtils.launchProgram((String)((MySQLExportSettings)this.getSettings()).getOutputFolder().getAbsolutePath());
    }
}

