/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.bigquery;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.bigquery.model.BigQueryDataSource;
import org.jkiss.dbeaver.ext.bigquery.model.BigQueryMetaModel;
import org.jkiss.dbeaver.ext.generic.GenericDataSourceProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class BigQueryDataSourceProvider
extends GenericDataSourceProvider {
    private static final Log log = Log.getLog(BigQueryDataSourceProvider.class);

    public void init(@NotNull DBPPlatform platform) {
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new BigQueryDataSource(monitor, container, new BigQueryMetaModel());
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        StringBuilder url = new StringBuilder();
        url.append("jdbc:bigquery://").append(connectionInfo.getHostName());
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            url.append(":").append(connectionInfo.getHostPort());
        }
        return url.toString();
    }
}

