/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSequence;

public class SQLServerSequence
implements DBSSequence,
DBPQualifiedObject {
    private SQLServerSchema schema;
    private long objectId;
    private String name;
    private String description;
    private Number lastValue;
    private Number minValue;
    private Number maxValue;
    private Number incrementBy;
    private boolean persisted;

    public SQLServerSequence(SQLServerSchema schema, long objectId, String name, Number lastValue, Number minValue, Number maxValue, Number incrementBy, boolean persisted) {
        this.schema = schema;
        this.name = name;
        this.objectId = objectId;
        this.description = this.description;
        this.lastValue = lastValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.incrementBy = incrementBy;
        this.persisted = persisted;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isPersisted() {
        return true;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=10)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.schema;
    }

    @NotNull
    public SQLServerDataSource getDataSource() {
        return this.schema.getDataSource();
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        if (!SQLServerUtils.supportsCrossDatabaseQueries(this.getDataSource())) {
            return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.schema, this});
        }
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.schema.getDatabase(), this.schema, this});
    }

    @Property(viewable=true, order=2)
    public Number getLastValue() {
        return this.lastValue;
    }

    public void setLastValue(Number lastValue) {
        this.lastValue = lastValue;
    }

    @Property(viewable=true, order=3)
    public Number getMinValue() {
        return this.minValue;
    }

    @Property(viewable=true, order=4)
    public Number getMaxValue() {
        return this.maxValue;
    }

    @Property(viewable=true, order=5)
    public Number getIncrementBy() {
        return this.incrementBy;
    }
}

