/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.gis.IGeometryViewer;
import org.jkiss.utils.CommonUtils;

public class GeometryViewerDescriptor
extends AbstractDescriptor {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.data.gis.geometryViewer";
    private static final Log log = Log.getLog(GeometryViewerDescriptor.class);
    private final AbstractDescriptor.ObjectType type;
    private final String id;
    private final String label;
    private final String description;
    private final DBPImage icon;
    private boolean supportsInline;
    private final List<String> supportedDataSources = new ArrayList<String>();

    GeometryViewerDescriptor(IConfigurationElement config) {
        super(config);
        this.type = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.supportsInline = CommonUtils.getBoolean((String)config.getAttribute("supportsInline"), (boolean)false);
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("datasource");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement dsElement = iConfigurationElementArray[n2];
            String dsId = dsElement.getAttribute("id");
            if (dsId != null) {
                this.supportedDataSources.add(dsId);
            }
            ++n2;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public IGeometryViewer createGeometryViewer(IValueController valueController) throws DBException {
        try {
            return (IGeometryViewer)this.type.getObjectClass().getConstructor(IValueController.class).newInstance(valueController);
        }
        catch (Throwable e) {
            throw new DBException("Error instantiating geometry viewer", e);
        }
    }

    public boolean supportsInlineView() {
        return this.supportsInline;
    }

    public boolean supportedBy(DBPDataSource dataSource) {
        if (!this.supportedDataSources.isEmpty()) {
            if (dataSource == null) {
                return false;
            }
            if (!this.supportedDataSources.contains(dataSource.getContainer().getDriver().getProviderId())) {
                return false;
            }
        }
        return true;
    }
}

