/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.data.preferences;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.data.internal.DataEditorsMessages;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageResultSetPresentation
extends TargetPrefPage {
    private static final Log log = Log.getLog(PrefPageResultSetPresentation.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.resultset.presentation";
    private Button autoSwitchMode;
    private Button showDescription;
    private Button columnWidthByValue;
    private Button showConnectionName;
    private Button transformComplexTypes;
    private Button rightJustifyNumbers;
    private Button rightJustifyDateTime;
    private Button autoCompleteProposal;

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("resultset.behavior.autoSwitchMode") || store.contains("resultset.show.columnDescription") || store.contains("resultset.calc.columnWidthByValues") || store.contains("resultset.show.connectionName") || store.contains("resultset.transform.complex.type") || store.contains("resultset.show.rightJustifyNumbers") || store.contains("resultset.show.rightJustifyDateTime") || store.contains("resultset.behavior.autoCompleteProposial");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    protected Control createPreferenceContent(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        Group uiGroup = UIUtils.createControlGroup((Composite)composite, (String)DataEditorsMessages.pref_page_database_resultsets_group_common, (int)1, (int)0, (int)0);
        ((GridData)uiGroup.getLayoutData()).horizontalSpan = 2;
        this.autoSwitchMode = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_switch_mode_on_rows, (boolean)false);
        this.showDescription = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_column_description, (boolean)false);
        this.columnWidthByValue = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_calc_column_width_by_values, (String)DataEditorsMessages.pref_page_database_resultsets_label_calc_column_width_by_values_tip, (boolean)false, (int)1);
        this.showConnectionName = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_show_connection_name, (boolean)false);
        this.transformComplexTypes = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_structurize_complex_types, (String)DataEditorsMessages.pref_page_database_resultsets_label_structurize_complex_types_tip, (boolean)false, (int)1);
        this.rightJustifyNumbers = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_right_justify_numbers_and_date, null, (boolean)false, (int)1);
        this.rightJustifyDateTime = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_right_justify_datetime, null, (boolean)false, (int)1);
        this.autoCompleteProposal = UIUtils.createCheckbox((Composite)uiGroup, (String)DataEditorsMessages.pref_page_database_resultsets_label_auto_completion, (String)DataEditorsMessages.pref_page_database_resultsets_label_auto_completion_tip, (boolean)true, (int)1);
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.autoSwitchMode.setSelection(store.getBoolean("resultset.behavior.autoSwitchMode"));
            this.showDescription.setSelection(store.getBoolean("resultset.show.columnDescription"));
            this.columnWidthByValue.setSelection(store.getBoolean("resultset.calc.columnWidthByValues"));
            this.showConnectionName.setSelection(store.getBoolean("resultset.show.connectionName"));
            this.rightJustifyNumbers.setSelection(store.getBoolean("resultset.show.rightJustifyNumbers"));
            this.rightJustifyDateTime.setSelection(store.getBoolean("resultset.show.rightJustifyDateTime"));
            this.transformComplexTypes.setSelection(store.getBoolean("resultset.transform.complex.type"));
            this.autoCompleteProposal.setSelection(store.getBoolean("resultset.behavior.autoCompleteProposial"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("resultset.behavior.autoSwitchMode", this.autoSwitchMode.getSelection());
            store.setValue("resultset.show.columnDescription", this.showDescription.getSelection());
            store.setValue("resultset.calc.columnWidthByValues", this.columnWidthByValue.getSelection());
            store.setValue("resultset.show.connectionName", this.showConnectionName.getSelection());
            store.setValue("resultset.show.rightJustifyNumbers", this.rightJustifyNumbers.getSelection());
            store.setValue("resultset.show.rightJustifyDateTime", this.rightJustifyDateTime.getSelection());
            store.setValue("resultset.transform.complex.type", this.transformComplexTypes.getSelection());
            store.setValue("resultset.behavior.autoCompleteProposial", this.autoCompleteProposal.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("resultset.behavior.autoSwitchMode");
        store.setToDefault("resultset.show.columnDescription");
        store.setToDefault("resultset.calc.columnWidthByValues");
        store.setToDefault("resultset.show.connectionName");
        store.setToDefault("resultset.show.rightJustifyNumbers");
        store.setToDefault("resultset.show.rightJustifyDateTime");
        store.setToDefault("resultset.transform.complex.type");
        store.setToDefault("resultset.behavior.autoCompleteProposial");
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

