/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.editparts;

import java.util.Iterator;
import java.util.List;
import org.eclipse.gef3.DragTracker;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.TreeEditPart;
import org.eclipse.gef3.editparts.AbstractEditPart;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractTreeEditPart
extends AbstractEditPart
implements TreeEditPart {
    protected Widget widget;
    private boolean expanded;

    public AbstractTreeEditPart(Object model) {
        this.setModel(model);
    }

    public AbstractTreeEditPart() {
    }

    @Override
    protected void addChildVisual(EditPart childEditPart, int index) {
        Widget widget = this.getWidget();
        TreeItem item = widget instanceof Tree ? new TreeItem((Tree)widget, 0, index) : new TreeItem((TreeItem)widget, 0, index);
        ((TreeEditPart)childEditPart).setWidget((Widget)item);
    }

    protected final boolean checkTreeItem() {
        return this.widget != null && !this.widget.isDisposed() && !(this.widget instanceof Tree);
    }

    @Override
    protected void createEditPolicies() {
    }

    @Override
    public DragTracker getDragTracker(Request req) {
        return null;
    }

    protected Image getImage() {
        return null;
    }

    protected String getText() {
        return this.getClass().getName();
    }

    @Override
    public Widget getWidget() {
        return this.widget;
    }

    @Override
    protected void refreshVisuals() {
        this.setWidgetImage(this.getImage());
        this.setWidgetText(this.getText());
    }

    @Override
    protected void removeChildVisual(EditPart childEditPart) {
        TreeEditPart treeEditPart = (TreeEditPart)childEditPart;
        treeEditPart.getWidget().dispose();
        treeEditPart.setWidget(null);
    }

    @Override
    protected void reorderChild(EditPart editpart, int index) {
        super.reorderChild(editpart, index);
        editpart.refresh();
    }

    @Override
    public void setWidget(Widget widget) {
        List children = this.getChildren();
        if (widget != null) {
            widget.setData((Object)this);
            if (widget instanceof TreeItem) {
                final TreeItem item = (TreeItem)widget;
                item.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        AbstractTreeEditPart.this.expanded = item.getExpanded();
                    }
                });
            }
            int i = 0;
            while (i < children.size()) {
                TreeEditPart tep = (TreeEditPart)children.get(i);
                if (widget instanceof TreeItem) {
                    tep.setWidget((Widget)new TreeItem((TreeItem)widget, 0));
                } else {
                    tep.setWidget((Widget)new TreeItem((Tree)widget, 0));
                }
                tep.refresh();
                ++i;
            }
            if (widget instanceof TreeItem) {
                ((TreeItem)widget).setExpanded(this.expanded);
            }
        } else {
            Iterator iter = this.getChildren().iterator();
            while (iter.hasNext()) {
                ((TreeEditPart)iter.next()).setWidget(null);
            }
        }
        this.widget = widget;
    }

    protected final void setWidgetImage(Image image) {
        if (this.checkTreeItem()) {
            ((TreeItem)this.getWidget()).setImage(image);
        }
    }

    protected final void setWidgetText(String text) {
        if (this.checkTreeItem()) {
            ((TreeItem)this.getWidget()).setText(text);
        }
    }
}

