/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.layout.algorithm.direct;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2dl.AbsoluteBendpoint;
import org.eclipse.draw2dl.Connection;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.PolylineConnection;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.graph.DirectedGraph;
import org.eclipse.draw2dl.graph.Edge;
import org.eclipse.draw2dl.graph.Node;
import org.eclipse.draw2dl.graph.NodeList;
import org.eclipse.draw2dl.graph.Subgraph;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.NodeEditPart;
import org.eclipse.gef3.editparts.AbstractConnectionEditPart;
import org.eclipse.gef3.editparts.AbstractGraphicalEditPart;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.ui.layout.GraphAnimation;
import org.jkiss.dbeaver.erd.ui.layout.algorithm.direct.NodeJoiningDirectedGraphLayout;
import org.jkiss.dbeaver.erd.ui.model.ERDDecorator;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;

public class DirectedGraphLayoutVisitor {
    private static final Log log = Log.getLog(DirectedGraphLayoutVisitor.class);
    private final ERDDecorator decorator;
    private Map<EditPart, Object> partToNodesMap;
    private DirectedGraph graph;

    public DirectedGraphLayoutVisitor(ERDDecorator decorator) {
        this.decorator = decorator;
    }

    public void layoutDiagram(AbstractGraphicalEditPart diagram) {
        this.partToNodesMap = new IdentityHashMap<EditPart, Object>();
        this.graph = new DirectedGraph();
        this.graph.setDirection(16);
        this.addDiagramNodes(diagram);
        if (this.graph.nodes.size() > 0) {
            this.addDiagramEdges(diagram);
            try {
                new NodeJoiningDirectedGraphLayout(diagram).visit(this.graph);
            }
            catch (Exception e) {
                log.error((Object)"Diagram layout error", (Throwable)e);
            }
            this.applyDiagramResults(diagram);
        }
    }

    protected void addDiagramNodes(AbstractGraphicalEditPart diagram) {
        GraphAnimation.recordInitialState(diagram.getFigure());
        for (Object child : diagram.getChildren()) {
            this.addEntityNode((NodeEditPart)child);
        }
    }

    protected void addEntityNode(NodeEditPart nodeEditPart) {
        Object entityNode = nodeEditPart instanceof EntityPart && ((EntityPart)nodeEditPart).getEntity().hasSelfLinks() ? new Subgraph((Object)nodeEditPart) : new Node((Object)nodeEditPart);
        Dimension preferredSize = nodeEditPart.getFigure().getPreferredSize(-1, -1);
        entityNode.width = preferredSize.width;
        entityNode.height = preferredSize.height;
        entityNode.setPadding(this.decorator.getDefaultEntityInsets());
        this.partToNodesMap.put((EditPart)nodeEditPart, entityNode);
        this.graph.nodes.add(entityNode);
        if (entityNode instanceof Subgraph) {
            Node sourceAnchor = new Node((Object)"Fake node for source links", (Subgraph)entityNode);
            sourceAnchor.width = 0;
            sourceAnchor.height = 0;
            Node targetAnchor = new Node((Object)"Fake node for target links", (Subgraph)entityNode);
            targetAnchor.width = 0;
            targetAnchor.height = 0;
        }
    }

    protected void addDiagramEdges(AbstractGraphicalEditPart diagram) {
        for (Object child : diagram.getChildren()) {
            this.addEntityEdges((GraphicalEditPart)child);
        }
    }

    protected void addEntityEdges(GraphicalEditPart entityPart) {
        List outgoing = entityPart.getSourceConnections();
        int i = 0;
        while (i < outgoing.size()) {
            AbstractConnectionEditPart connectionPart = (AbstractConnectionEditPart)outgoing.get(i);
            this.addConnectionEdges(connectionPart);
            ++i;
        }
    }

    protected void addConnectionEdges(AbstractConnectionEditPart connectionPart) {
        GraphAnimation.recordInitialState((Connection)connectionPart.getFigure());
        Node source = (Node)this.partToNodesMap.get(connectionPart.getSource());
        Node target = (Node)this.partToNodesMap.get(connectionPart.getTarget());
        if (source == null || target == null) {
            log.warn((Object)"Source or target node not found");
            return;
        }
        if (source instanceof Subgraph && target instanceof Subgraph) {
            source = ((Subgraph)source).members.getNode(0);
            target = ((Subgraph)target).members.getNode(1);
        }
        Edge e = new Edge((Object)connectionPart, source, target);
        e.setPadding(10);
        e.weight = 2;
        this.graph.edges.add((Object)e);
        this.partToNodesMap.put((EditPart)connectionPart, e);
    }

    protected void applyDiagramResults(AbstractGraphicalEditPart diagram) {
        for (Object child : diagram.getChildren()) {
            this.applyEntityResults((GraphicalEditPart)child);
        }
    }

    public void applyEntityResults(GraphicalEditPart entityPart) {
        Node n = (Node)this.partToNodesMap.get(entityPart);
        IFigure tableFigure = entityPart.getFigure();
        Dimension preferredSize = tableFigure.getPreferredSize();
        Dimension snapSize = this.decorator.getEntitySnapSize();
        Rectangle bounds = new Rectangle(n.x, n.y, preferredSize.width, preferredSize.height);
        if (snapSize != null) {
            bounds.translate(n.x / snapSize.width * snapSize.width - n.x, n.y / snapSize.height * snapSize.height - n.y);
        }
        tableFigure.setBounds(bounds);
        int i = 0;
        while (i < entityPart.getSourceConnections().size()) {
            AbstractConnectionEditPart relationship = (AbstractConnectionEditPart)entityPart.getSourceConnections().get(i);
            this.applyConnectionResults(relationship);
            ++i;
        }
    }

    protected void applyConnectionResults(AbstractConnectionEditPart connectionPart) {
        Edge connEdge = (Edge)this.partToNodesMap.get(connectionPart);
        NodeList edgeNodes = connEdge.vNodes;
        PolylineConnection conn = (PolylineConnection)connectionPart.getConnectionFigure();
        if (edgeNodes != null && edgeNodes.size() > 1) {
            ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
            int i = 0;
            while (i < edgeNodes.size()) {
                Node vn = edgeNodes.getNode(i);
                int x = vn.x;
                int y = vn.y;
                bends.add(new AbsoluteBendpoint(x, y));
                ++i;
            }
            conn.setRoutingConstraint(bends);
        }
    }
}

