/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2dl.Border;
import org.eclipse.draw2dl.Figure;
import org.eclipse.draw2dl.GridData;
import org.eclipse.draw2dl.GridLayout;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.Label;
import org.eclipse.draw2dl.LayoutManager;
import org.eclipse.draw2dl.LineBorder;
import org.eclipse.draw2dl.MarginBorder;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.ui.ERDColors;
import org.jkiss.dbeaver.erd.ui.editor.ERDViewStyle;
import org.jkiss.dbeaver.erd.ui.figures.AttributeItemFigure;
import org.jkiss.dbeaver.erd.ui.figures.AttributeListFigure;
import org.jkiss.dbeaver.erd.ui.figures.EditableLabel;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIActivator;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class EntityFigure
extends Figure {
    private final EntityPart part;
    private AttributeListFigure keyFigure;
    private AttributeListFigure attributeFigure;
    private EditableLabel nameLabel;

    public EntityFigure(EntityPart part) {
        String entityName;
        this.part = part;
        ERDEntity entity = part.getEntity();
        boolean useFQN = part.getDiagram().hasAttributeStyle(ERDViewStyle.ENTITY_FQN);
        boolean showComments = part.getDiagram().hasAttributeStyle(ERDViewStyle.COMMENTS);
        Image tableImage = DBeaverIcons.getImage((DBPImage)((DBSEntity)entity.getObject()).getEntityType().getIcon());
        this.keyFigure = new AttributeListFigure(entity, true);
        this.attributeFigure = new AttributeListFigure(entity, false);
        String string = entityName = useFQN ? DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)entity.getObject()), (DBPEvaluationContext)DBPEvaluationContext.DDL) : ((DBSEntity)entity.getObject()).getName();
        if (!CommonUtils.isEmpty((String)entity.getAlias())) {
            entityName = String.valueOf(entityName) + " " + entity.getAlias();
        }
        this.nameLabel = new EditableLabel(entityName){

            public IFigure getToolTip() {
                return null;
            }
        };
        this.nameLabel.setIcon(tableImage);
        this.nameLabel.setBorder((Border)new MarginBorder(3));
        Label descLabel = null;
        if (showComments && !CommonUtils.isEmpty((String)((DBSEntity)entity.getObject()).getDescription())) {
            descLabel = new Label(((DBSEntity)entity.getObject()).getDescription());
        }
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.setLayoutManager((LayoutManager)layout);
        LineBorder border = new LineBorder(this.getBorderColor(), 2);
        this.setBorder((Border)border);
        this.setOpaque(true);
        this.add((IFigure)this.nameLabel, new GridData(768));
        if (descLabel != null) {
            this.add((IFigure)descLabel, new GridData(768));
        }
        this.add((IFigure)this.keyFigure, new GridData(768));
        this.add((IFigure)this.attributeFigure, new GridData(1808));
        this.refreshColors();
    }

    @NotNull
    private IFigure createToolTip() {
        ERDEntity entity = this.part.getEntity();
        DBPDataSourceContainer dataSource = entity.getDataSource().getContainer();
        Figure toolTip = new Figure();
        toolTip.setOpaque(true);
        toolTip.setBorder(this.getBorder());
        toolTip.setLayoutManager((LayoutManager)new GridLayout(1, false));
        Label dsLabel = new Label(dataSource.getName());
        dsLabel.setIcon(DBeaverIcons.getImage((DBPImage)dataSource.getDriver().getIcon()));
        dsLabel.setBorder((Border)new MarginBorder(2));
        toolTip.add((IFigure)dsLabel);
        Label entityLabel = new Label(DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)entity.getObject()), (DBPEvaluationContext)DBPEvaluationContext.UI));
        entityLabel.setIcon(DBeaverIcons.getImage((DBPImage)((DBSEntity)entity.getObject()).getEntityType().getIcon()));
        entityLabel.setBorder((Border)new MarginBorder(2));
        toolTip.add((IFigure)entityLabel);
        return toolTip;
    }

    protected Color getBorderColor() {
        int dsIndex = this.getPart().getDiagram().getDataSourceIndex(this.part.getEntity().getDataSource().getContainer());
        boolean changeBorderColors = ERDUIActivator.getDefault().getPreferenceStore().getBoolean("erd.diagram.change.borders.colors");
        if (dsIndex == 0 || !changeBorderColors) {
            return UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.lines.foreground");
        }
        return ERDColors.getBorderColor(dsIndex - 1);
    }

    public EntityPart getPart() {
        return this.part;
    }

    public void refreshColors() {
        ColorRegistry colorRegistry = UIUtils.getColorRegistry();
        this.setForegroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.entity.name.foreground"));
        if (this.part.getEntity().isPrimary()) {
            this.setBackgroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.entity.primary.background"));
        } else if (((DBSEntity)this.part.getEntity().getObject()).getEntityType() == DBSEntityType.ASSOCIATION) {
            this.setBackgroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.entity.association.background"));
        } else {
            boolean changeHeaderColors = ERDUIActivator.getDefault().getPreferenceStore().getBoolean("erd.diagram.change.header.colors");
            if (changeHeaderColors) {
                this.changeHeaderColor(colorRegistry);
            } else {
                this.setBackgroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.entity.regular.background"));
            }
        }
    }

    private void changeHeaderColor(ColorRegistry colorRegistry) {
        DBSObjectContainer container = (DBSObjectContainer)DBUtils.getParentOfType(DBSObjectContainer.class, (DBSObject)((DBSObject)this.part.getEntity().getObject()));
        if (container != null) {
            DBPDataSourceContainer dataSourceContainer = container.getDataSource().getContainer();
            if (dataSourceContainer != null) {
                int containerIndex = this.part.getDiagram().getContainerIndex(dataSourceContainer, container);
                if (containerIndex == 0) {
                    this.setBackgroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.entity.regular.background"));
                } else {
                    this.setBackgroundColor(ERDColors.getHeaderColor(containerIndex - 1));
                }
            } else {
                this.setBackgroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.entity.regular.background"));
            }
        } else {
            this.setBackgroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.entity.regular.background"));
        }
    }

    public void updateTitleForegroundColor() {
        Color bgColor = this.getBackgroundColor();
        if (bgColor == null) {
            this.nameLabel.setForegroundColor(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.entity.name.foreground"));
        } else {
            this.nameLabel.setForegroundColor(UIUtils.getContrastColor((Color)bgColor));
        }
    }

    public void setBackgroundColor(Color bg) {
        super.setBackgroundColor(bg);
        this.updateTitleForegroundColor();
    }

    public void setSelected(boolean isSelected) {
        LineBorder lineBorder = (LineBorder)this.getBorder();
        if (isSelected) {
            lineBorder.setWidth(3);
        } else {
            lineBorder.setWidth(2);
        }
    }

    public EditableLabel getNameLabel() {
        return this.nameLabel;
    }

    public AttributeListFigure getKeyFigure() {
        return this.keyFigure;
    }

    public AttributeListFigure getColumnsFigure() {
        return this.attributeFigure;
    }

    public void add(IFigure figure, Object constraint, int index) {
        if (figure instanceof AttributeItemFigure) {
            ColorRegistry colorRegistry = UIUtils.getColorRegistry();
            figure.setForegroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.attributes.foreground"));
            figure.setBackgroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.attributes.background"));
            IFigure attrExtra = this.createRightPanel();
            AttributeItemFigure attributeItemFigure = (AttributeItemFigure)figure;
            attributeItemFigure.setRightPanel(attrExtra);
            if (attributeItemFigure.getAttribute().isInPrimaryKey()) {
                this.keyFigure.add(figure, new GridData(32, 2, true, false));
                this.keyFigure.add(attrExtra, new GridData(130));
            } else {
                this.attributeFigure.add(figure, new GridData(32, 2, true, false));
                this.attributeFigure.add(attrExtra, new GridData(130));
            }
        } else {
            super.add(figure, constraint, index);
        }
    }

    protected IFigure createRightPanel() {
        EditableLabel label = new EditableLabel("");
        label.setTextAlignment(4);
        return label;
    }

    public List<AttributeItemFigure> getAttributeFigures() {
        ArrayList<AttributeItemFigure> result = new ArrayList<AttributeItemFigure>();
        result.addAll(this.keyFigure.getAttributes());
        result.addAll(this.attributeFigure.getAttributes());
        return result;
    }

    public void remove(IFigure figure) {
        if (figure instanceof AttributeItemFigure) {
            AttributeItemFigure attrFigure = (AttributeItemFigure)figure;
            AttributeListFigure listFigure = this.keyFigure.getAttributes().contains(figure) ? this.keyFigure : this.attributeFigure;
            listFigure.remove((IFigure)attrFigure);
            if (attrFigure.getRightPanel() != null) {
                listFigure.remove(attrFigure.getRightPanel());
            }
            this.revalidate();
        } else {
            super.remove(figure);
        }
    }
}

