/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.notifications;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.jkiss.dbeaver.ui.notifications.AbstractNotification;
import org.jkiss.dbeaver.ui.notifications.AbstractUiNotification;
import org.jkiss.dbeaver.ui.notifications.AbstractWorkbenchNotificationPopup;
import org.jkiss.dbeaver.ui.notifications.ScalingHyperlink;

public class NotificationPopup
extends AbstractWorkbenchNotificationPopup {
    private static final int NUM_NOTIFICATIONS_TO_DISPLAY = 4;
    public static final Color HYPERLINK_WIDGET_COLOR = new Color((Device)Display.getDefault(), 12, 81, 172);
    private List<AbstractNotification> notifications;

    public NotificationPopup(Shell parent) {
        super(parent.getDisplay());
    }

    @Override
    protected void createContentArea(Composite parent) {
        int count = 0;
        for (final AbstractNotification notification : this.notifications) {
            Composite notificationComposite = new Composite(parent, 524288);
            GridLayout gridLayout = new GridLayout(2, false);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)notificationComposite);
            notificationComposite.setLayout((Layout)gridLayout);
            notificationComposite.setBackground(parent.getBackground());
            if (count < 4) {
                Label notificationLabelIcon = new Label(notificationComposite, 524288);
                notificationLabelIcon.setBackground(parent.getBackground());
                if (notification instanceof AbstractUiNotification) {
                    notificationLabelIcon.setImage(((AbstractUiNotification)notification).getNotificationKindImage());
                }
                ScalingHyperlink itemLink = new ScalingHyperlink(notificationComposite, 524289);
                GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)itemLink);
                itemLink.setForeground(HYPERLINK_WIDGET_COLOR);
                itemLink.registerMouseTrackListener();
                itemLink.setText(LegacyActionTools.escapeMnemonics((String)notification.getLabel()));
                if (notification instanceof AbstractUiNotification) {
                    itemLink.setImage(((AbstractUiNotification)notification).getNotificationImage());
                }
                itemLink.setBackground(parent.getBackground());
                itemLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        Shell windowShell;
                        IWorkbenchWindow window;
                        if (notification instanceof AbstractUiNotification) {
                            ((AbstractUiNotification)notification).open();
                        }
                        if ((window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (windowShell = window.getShell()) != null) {
                            if (windowShell.getMinimized()) {
                                windowShell.setMinimized(false);
                            }
                            windowShell.open();
                            windowShell.forceActive();
                        }
                    }
                });
                String descriptionText = null;
                if (notification.getDescription() != null) {
                    descriptionText = notification.getDescription();
                }
                if (descriptionText != null && !descriptionText.trim().equals("")) {
                    Label descriptionLabel = new Label(notificationComposite, 524288);
                    descriptionLabel.setText(LegacyActionTools.escapeMnemonics((String)descriptionText));
                    descriptionLabel.setBackground(parent.getBackground());
                    GridDataFactory.fillDefaults().span(2, -1).grab(true, false).align(4, 128).applyTo((Control)descriptionLabel);
                }
            } else {
                int numNotificationsRemain = this.notifications.size() - count;
                ScalingHyperlink remainingLink = new ScalingHyperlink(notificationComposite, 524288);
                remainingLink.setForeground(HYPERLINK_WIDGET_COLOR);
                remainingLink.registerMouseTrackListener();
                remainingLink.setBackground(parent.getBackground());
                remainingLink.setText(NLS.bind((String)"{0} more", (Object)numNotificationsRemain));
                GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)remainingLink);
                remainingLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        Shell windowShell;
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window != null && (windowShell = window.getShell()) != null) {
                            windowShell.setMaximized(true);
                            windowShell.open();
                        }
                    }
                });
                break;
            }
            ++count;
        }
    }

    @Override
    protected void createTitleArea(Composite parent) {
        super.createTitleArea(parent);
    }

    public List<AbstractNotification> getNotifications() {
        return new ArrayList<AbstractNotification>(this.notifications);
    }

    public void setContents(List<AbstractNotification> notifications) {
        this.notifications = notifications;
    }
}

