/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.notifications;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AnimationUtil {
    public static final long FADE_RESCHEDULE_DELAY = 80L;
    public static final int FADE_IN_INCREMENT = 15;
    public static final int FADE_OUT_INCREMENT = -20;

    public static FadeJob fastFadeIn(Shell shell, IFadeListener listener) {
        return new FadeJob(shell, 30, 80L, listener);
    }

    public static FadeJob fadeIn(Shell shell, IFadeListener listener) {
        return new FadeJob(shell, 15, 80L, listener);
    }

    public static FadeJob fadeOut(Shell shell, IFadeListener listener) {
        return new FadeJob(shell, -20, 80L, listener);
    }

    public static class FadeJob
    extends Job {
        private final Shell shell;
        private final int increment;
        private volatile boolean stopped;
        private volatile int currentAlpha;
        private final long delay;
        private final IFadeListener fadeListener;

        public FadeJob(Shell shell, int increment, long delay, IFadeListener fadeListener) {
            super("Fading");
            if (increment < -255 || increment == 0 || increment > 255) {
                throw new IllegalArgumentException("-255 <= increment <= 255 && increment != 0");
            }
            if (delay < 1L) {
                throw new IllegalArgumentException("delay must be > 0");
            }
            this.currentAlpha = shell.getAlpha();
            this.shell = shell;
            this.increment = increment;
            this.delay = delay;
            this.fadeListener = fadeListener;
            this.setSystem(true);
            this.schedule(delay);
        }

        protected void canceling() {
            this.stopped = true;
        }

        private void reschedule() {
            if (this.stopped) {
                return;
            }
            this.schedule(this.delay);
        }

        public void cancelAndWait(final boolean setAlpha) {
            if (this.stopped) {
                return;
            }
            this.cancel();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (setAlpha) {
                        shell.setAlpha(this.getLastAlpha());
                    }
                }
            });
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.stopped) {
                return Status.OK_STATUS;
            }
            this.currentAlpha += this.increment;
            if (this.currentAlpha <= 0) {
                this.currentAlpha = 0;
            } else if (this.currentAlpha >= 255) {
                this.currentAlpha = 255;
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (stopped) {
                        return;
                    }
                    if (shell.isDisposed()) {
                        stopped = true;
                        return;
                    }
                    shell.setAlpha(currentAlpha);
                    if (fadeListener != null) {
                        fadeListener.faded(shell, currentAlpha);
                    }
                }
            });
            if (this.currentAlpha == 0 || this.currentAlpha == 255) {
                this.stopped = true;
            }
            this.reschedule();
            return Status.OK_STATUS;
        }

        private int getLastAlpha() {
            return this.increment < 0 ? 0 : 255;
        }
    }

    public static interface IFadeListener {
        public void faded(Shell var1, int var2);
    }
}

