/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl.graph;

import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Insets;
import org.eclipse.draw2dl.graph.Edge;
import org.eclipse.draw2dl.graph.EdgeList;
import org.eclipse.draw2dl.graph.Node;
import org.eclipse.draw2dl.graph.NodeList;
import org.eclipse.draw2dl.graph.Rank;
import org.eclipse.draw2dl.graph.RankList;

public class DirectedGraph {
    private int direction = 4;
    private Insets defaultPadding = new Insets(16);
    public EdgeList edges = new EdgeList();
    public NodeList nodes = new NodeList();
    public RankList ranks = new RankList();
    Node forestRoot;
    Insets margin = new Insets();
    int[] rankLocations;
    int[][] cellLocations;
    int tensorStrength;
    int tensorSize;
    Dimension size = new Dimension();

    public Insets getDefaultPadding() {
        return this.defaultPadding;
    }

    public int getDirection() {
        return this.direction;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public Insets getPadding(Node node) {
        Insets pad = node.getPadding();
        if (pad == null) {
            return this.defaultPadding;
        }
        return pad;
    }

    int[] getCellLocations(int rank) {
        return this.cellLocations[rank];
    }

    int[] getRankLocations() {
        return this.rankLocations;
    }

    public Node getNode(int rank, int index) {
        if (this.ranks.size() <= rank) {
            return null;
        }
        Rank r = this.ranks.getRank(rank);
        if (r.size() <= index) {
            return null;
        }
        return r.getNode(index);
    }

    public void removeEdge(Edge edge) {
        this.edges.remove(edge);
        edge.source.outgoing.remove(edge);
        edge.target.incoming.remove(edge);
        if (edge.vNodes != null) {
            int j = 0;
            while (j < edge.vNodes.size()) {
                this.removeNode(edge.vNodes.getNode(j));
                ++j;
            }
        }
    }

    public void removeNode(Node node) {
        this.nodes.remove(node);
        if (this.ranks != null) {
            this.ranks.getRank(node.rank).remove(node);
        }
    }

    public void setDefaultPadding(Insets insets) {
        this.defaultPadding = insets;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
    }

    public Dimension getLayoutSize() {
        return this.size;
    }
}

