/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import org.eclipse.draw2dl.AbstractLocator;
import org.eclipse.draw2dl.Connection;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.PointList;

public class ConnectionLocator
extends AbstractLocator {
    public static final int START = 2;
    public static final int SOURCE = 2;
    public static final int END = 3;
    public static final int TARGET = 3;
    public static final int MIDPOINT = 4;
    public static final int MIDDLE = 4;
    private Connection connection;
    private int alignment;

    public ConnectionLocator(Connection connection) {
        this(connection, 4);
    }

    public ConnectionLocator(Connection connection, int align) {
        this.setConnection(connection);
        this.setAlignment(align);
    }

    public int getAlignment() {
        return this.alignment;
    }

    protected Connection getConnection() {
        return this.connection;
    }

    @Override
    protected Point getReferencePoint() {
        Point p = this.getLocation(this.getConnection().getPoints());
        this.getConnection().translateToAbsolute(p);
        return p;
    }

    protected Point getLocation(PointList points) {
        switch (this.getAlignment()) {
            case 2: {
                return points.getPoint(Point.SINGLETON, 0);
            }
            case 3: {
                return points.getPoint(Point.SINGLETON, points.size() - 1);
            }
            case 4: {
                if (points.size() % 2 == 0) {
                    int i = points.size() / 2;
                    int j = i - 1;
                    Point p1 = points.getPoint(j);
                    Point p2 = points.getPoint(i);
                    Dimension d = p2.getDifference(p1);
                    return Point.SINGLETON.setLocation(p1.x + d.width / 2, p1.y + d.height / 2);
                }
                int i = (points.size() - 1) / 2;
                return points.getPoint(Point.SINGLETON, i);
            }
        }
        return new Point();
    }

    protected void setAlignment(int align) {
        this.alignment = align;
    }

    protected void setConnection(Connection connection) {
        this.connection = connection;
    }
}

