/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.struct;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBIconComposite;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCColumnKeyType;
import org.jkiss.dbeaver.model.impl.struct.AbstractAttribute;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class JDBCAttribute
extends AbstractAttribute
implements DBSObject,
DBPImageProvider {
    protected JDBCAttribute() {
    }

    protected JDBCAttribute(String name, String typeName, int valueType, int ordinalPosition, long maxLength, Integer scale, Integer precision, boolean required, boolean sequence) {
        super(name, typeName, valueType, ordinalPosition, maxLength, scale, precision, required, sequence);
    }

    protected JDBCAttribute(DBSAttributeBase source) {
        super(source);
    }

    @Override
    @Nullable
    public DBPImage getObjectImage() {
        DBPImage columnImage = DBValueFormatting.getTypeImage(this);
        JDBCColumnKeyType keyType = this.getKeyType();
        if (keyType != null) {
            columnImage = JDBCAttribute.getOverlayImage(columnImage, keyType);
        }
        return columnImage;
    }

    @Nullable
    protected JDBCColumnKeyType getKeyType() {
        return null;
    }

    @Override
    public DBPDataKind getDataKind() {
        return JDBCUtils.resolveDataKind(this.getDataSource(), this.typeName, this.valueType);
    }

    protected static DBPImage getOverlayImage(DBPImage columnImage, JDBCColumnKeyType keyType) {
        if (keyType == null || !keyType.isInUniqueKey() && !keyType.isInReferenceKey()) {
            return columnImage;
        }
        DBIcon overImage = null;
        if (keyType.isInUniqueKey()) {
            overImage = DBIcon.OVER_KEY;
        } else if (keyType.isInReferenceKey()) {
            overImage = DBIcon.OVER_REFERENCE;
        }
        if (overImage == null) {
            return columnImage;
        }
        return new DBIconComposite(columnImage, false, null, null, null, overImage);
    }
}

