/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.storage.BytesContentStorage;
import org.jkiss.dbeaver.model.data.storage.TemporaryContentStorage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentLOB;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.utils.ContentUtils;

public class JDBCContentBLOB
extends JDBCContentLOB {
    private static final Log log = Log.getLog(JDBCContentBLOB.class);
    private Blob blob;
    private InputStream tmpStream;

    public JDBCContentBLOB(DBCExecutionContext dataSource, Blob blob) {
        super(dataSource);
        this.blob = blob;
    }

    @Override
    public long getLOBLength() throws DBCException {
        if (this.blob != null) {
            try {
                return this.blob.length();
            }
            catch (Throwable e) {
                throw new DBCException(e, this.executionContext);
            }
        }
        return 0L;
    }

    @Override
    @NotNull
    public String getContentType() {
        return "application/octet-stream";
    }

    @Override
    public DBDContentStorage getContents(DBRProgressMonitor monitor) throws DBCException {
        if (this.storage == null && this.blob != null) {
            block37: {
                File tempFile;
                DBPPlatform platform;
                long contentLength = this.getContentLength();
                if (contentLength < (long)(platform = this.executionContext.getDataSource().getContainer().getPlatform()).getPreferenceStore().getInt("content.memory.maxsize")) {
                    try {
                        Throwable throwable = null;
                        Object var6_9 = null;
                        try (InputStream bs = this.blob.getBinaryStream();){
                            this.storage = BytesContentStorage.createFromStream(bs, contentLength, this.getDefaultEncoding());
                            break block37;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        throw new DBCException("IO error while reading content", e);
                    }
                    catch (Throwable e) {
                        throw new DBCException(e, this.executionContext);
                    }
                }
                try {
                    tempFile = ContentUtils.createTempContentFile(monitor, platform, "blob" + this.blob.hashCode());
                }
                catch (IOException e) {
                    throw new DBCException("Can't create temporary file", e);
                }
                try {
                    Throwable e = null;
                    Object var7_17 = null;
                    try (FileOutputStream os = new FileOutputStream(tempFile);){
                        Throwable throwable = null;
                        Object var10_22 = null;
                        try (InputStream bs = this.blob.getBinaryStream();){
                            ContentUtils.copyStreams(bs, contentLength, os, monitor);
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    ContentUtils.deleteTempFile(tempFile);
                    throw new DBCException("IO error while copying stream", e);
                }
                catch (Throwable e) {
                    ContentUtils.deleteTempFile(tempFile);
                    throw new DBCException(e, this.executionContext);
                }
                this.storage = new TemporaryContentStorage(platform, tempFile, this.getDefaultEncoding(), true);
            }
            this.releaseBlob();
        }
        return this.storage;
    }

    @Override
    public void release() {
        this.releaseTempStream();
        this.releaseBlob();
        super.release();
    }

    private void releaseBlob() {
        if (this.blob != null) {
            try {
                this.blob.free();
            }
            catch (Throwable e) {
                log.debug("Error freeing BLOB: " + e.getClass().getName() + ": " + e.getMessage());
            }
            this.blob = null;
        }
    }

    private void releaseTempStream() {
        if (this.tmpStream != null) {
            ContentUtils.close(this.tmpStream);
            this.tmpStream = null;
        }
    }

    @Override
    public void bindParameter(JDBCSession session, JDBCPreparedStatement preparedStatement, DBSTypedObject columnType, int paramIndex) throws DBCException {
        block22: {
            try {
                if (this.storage != null) {
                    this.releaseTempStream();
                    this.tmpStream = this.storage.getContentStream();
                    try {
                        preparedStatement.setBinaryStream(paramIndex, this.tmpStream);
                    }
                    catch (Throwable e) {
                        try {
                            if (e instanceof SQLException) {
                                throw (SQLException)e;
                            }
                            try {
                                preparedStatement.setBinaryStream(paramIndex, this.tmpStream, this.storage.getContentLength());
                            }
                            catch (Throwable e1) {
                                if (e1 instanceof SQLException) {
                                    throw (SQLException)e1;
                                }
                                preparedStatement.setBinaryStream(paramIndex, this.tmpStream, (int)this.storage.getContentLength());
                            }
                            break block22;
                        }
                        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                            int contentLength = (int)this.storage.getContentLength();
                            ByteArrayOutputStream buffer = new ByteArrayOutputStream(contentLength);
                            ContentUtils.copyStreams(this.tmpStream, (long)contentLength, buffer, session.getProgressMonitor());
                            preparedStatement.setBytes(paramIndex, buffer.toByteArray());
                        }
                    }
                    break block22;
                }
                if (this.blob != null) {
                    try {
                        if (columnType.getDataKind() == DBPDataKind.BINARY) {
                            preparedStatement.setBinaryStream(paramIndex, this.blob.getBinaryStream());
                            break block22;
                        }
                        preparedStatement.setBlob(paramIndex, this.blob);
                    }
                    catch (Throwable throwable) {
                        this.releaseTempStream();
                        this.tmpStream = this.blob.getBinaryStream();
                        try {
                            preparedStatement.setBinaryStream(paramIndex, this.tmpStream);
                            break block22;
                        }
                        catch (Throwable e) {
                            if (e instanceof SQLException) {
                                throw (SQLException)e;
                            }
                            try {
                                preparedStatement.setBinaryStream(paramIndex, this.tmpStream, this.blob.length());
                                break block22;
                            }
                            catch (Throwable e1) {
                                if (e1 instanceof SQLException) {
                                    throw (SQLException)e1;
                                }
                                preparedStatement.setBinaryStream(paramIndex, this.tmpStream, (int)this.blob.length());
                            }
                        }
                    }
                    break block22;
                }
                preparedStatement.setNull(paramIndex, 2004);
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, session.getExecutionContext());
            }
            catch (Throwable e) {
                throw new DBCException("Error while reading content", e);
            }
        }
    }

    @Override
    public Object getRawValue() {
        return this.blob;
    }

    @Override
    public boolean isNull() {
        return this.blob == null && this.storage == null;
    }

    @Override
    protected JDBCContentLOB createNewContent() {
        return new JDBCContentBLOB(this.executionContext, null);
    }

    @Override
    public String getDisplayString(DBDDisplayFormat format) {
        Object cachedValue;
        if (this.blob == null && this.storage == null) {
            return null;
        }
        if (this.storage != null && this.storage instanceof DBDContentCached && (cachedValue = ((DBDContentCached)((Object)this.storage)).getCachedValue()) instanceof byte[]) {
            return DBValueFormatting.formatBinaryString(this.executionContext.getDataSource(), (byte[])cachedValue, format);
        }
        return "[BLOB]";
    }
}

