/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.ExasolSysTablePrefix;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class ExasolCurrentUserPrivileges {
    private static final Log LOG = Log.getLog(ExasolCurrentUserPrivileges.class);
    private static final String C_QUERY_DICTIONARY = "/*snapshot execution*/ SELECT CONNECTION_NAME FROM sys.EXA_DBA_CONNECTIONS WHERE false";
    private static final String C_MAJOR_VERSION = "/*snapshot execution*/ select TO_NUMBER(\"VALUE\") AS VERSION from \"$ODBCJDBC\".DB_METADATA WHERE name LIKE 'databaseMajorVersion'";
    private static final String C_MINOR_VERSION = "/*snapshot execution*/ select TO_NUMBER(\"VALUE\") AS VERSION from \"$ODBCJDBC\".DB_METADATA WHERE name LIKE 'databaseMinorVersion'";
    private final Boolean userHasDictionaryAccess;
    private final Integer majorVersion;
    private final Integer minorVersion;

    public ExasolCurrentUserPrivileges(DBRProgressMonitor monitor, JDBCSession session, ExasolDataSource exasolDataSource) {
        this.userHasDictionaryAccess = ExasolCurrentUserPrivileges.verifyPriv(C_QUERY_DICTIONARY, session);
        this.majorVersion = ExasolCurrentUserPrivileges.queryVersion(C_MAJOR_VERSION, session);
        this.minorVersion = ExasolCurrentUserPrivileges.queryVersion(C_MINOR_VERSION, session);
    }

    public int getExasolVersion() {
        return this.majorVersion;
    }

    public Boolean getatLeastV5() {
        if (this.majorVersion >= 5) {
            return true;
        }
        return false;
    }

    public Boolean getatLeastV6() {
        if (this.majorVersion >= 6) {
            return true;
        }
        return false;
    }

    public Boolean getUserHasDictionaryAccess() {
        return this.userHasDictionaryAccess;
    }

    public Integer getMajorVersion() {
        return this.majorVersion;
    }

    public Integer getMinorVersion() {
        return this.minorVersion;
    }

    public String getTablePrefix(ExasolSysTablePrefix fallback) {
        if (this.userHasDictionaryAccess.booleanValue()) {
            return ExasolSysTablePrefix.DBA.toString();
        }
        return fallback.toString();
    }

    /*
     * Loose catch block
     */
    private static Integer queryVersion(String sql, JDBCSession session) {
        try {
            Throwable throwable = null;
            Object var4_4 = null;
            try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
                Integer n;
                JDBCResultSet rs;
                Throwable throwable2;
                block21: {
                    Integer version;
                    throwable2 = null;
                    Object var7_9 = null;
                    rs = dbStat.executeQuery();
                    rs.next();
                    n = version = Integer.valueOf(JDBCUtils.safeGetInt((ResultSet)rs, (String)"VERSION"));
                    if (rs == null) break block21;
                    rs.close();
                }
                return n;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            LOG.error((Object)"Error extracting Exasol version: fallback to version 5");
            Integer version = 5;
            return version;
        }
    }

    private static Boolean verifyPriv(String sql, JDBCSession session) {
        Boolean hasPriv;
        try {
            Throwable throwable = null;
            Object var4_4 = null;
            try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
                Throwable throwable2 = null;
                Object var7_8 = null;
                try {
                    JDBCResultSet rs = dbStat.executeQuery();
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            hasPriv = true;
        }
        catch (Exception exception) {
            hasPriv = false;
        }
        return hasPriv;
    }

    public Boolean hasPartitionColumns() {
        return this.hasPasswordPolicy();
    }

    public Boolean hasPriorityGroups() {
        if (this.getatLeastV6().booleanValue() && this.getMinorVersion() >= 1 && this.getMajorVersion() < 7) {
            return true;
        }
        return false;
    }

    public Boolean hasPasswordPolicy() {
        if (!(this.getatLeastV6().booleanValue() && this.getMinorVersion() >= 1 || this.getMajorVersion() >= 7)) {
            return false;
        }
        return true;
    }

    public Boolean hasConsumerGroups() {
        if (this.getMajorVersion() >= 7) {
            return true;
        }
        return false;
    }
}

