/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.tasks;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.db2.model.DB2TableBase;
import org.jkiss.dbeaver.ext.db2.tasks.DB2RunstatsOptions;
import org.jkiss.dbeaver.ext.db2.tasks.DB2RunstatsToolSettings;
import org.jkiss.dbeaver.ext.db2.tasks.DB2ToolWithStatus;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.utils.CommonUtils;

public class DB2RunstatsTool
extends DB2ToolWithStatus<DB2TableBase, DB2RunstatsToolSettings> {
    @NotNull
    public DB2RunstatsToolSettings createToolSettings() {
        return new DB2RunstatsToolSettings();
    }

    public void generateObjectQueries(DBCSession session, DB2RunstatsToolSettings settings, List<DBEPersistAction> queries, DB2TableBase object) throws DBCException {
        String sql = "CALL SYSPROC.ADMIN_CMD('";
        sql = String.valueOf(sql) + "RUNSTATS ON TABLE ";
        sql = String.valueOf(sql) + object.getFullyQualifiedName(DBPEvaluationContext.DDL);
        sql = String.valueOf(sql) + CommonUtils.getLineSeparator();
        sql = String.valueOf(sql) + DB2RunstatsOptions.getOption(settings.getColumnStat()).getDdlString();
        if (!DB2RunstatsOptions.getOption(settings.getIndexStat()).getDdlString().equals("")) {
            sql = String.valueOf(sql) + " " + DB2RunstatsOptions.getOption(settings.getIndexStat()).getDdlString();
        }
        if (settings.isTableSampling()) {
            sql = String.valueOf(sql) + String.format(" TABLESAMPLE SYSTEM(%d)", settings.getSamplePercent());
        }
        sql = String.valueOf(sql) + "')";
        queries.add((DBEPersistAction)new SQLDatabasePersistAction(sql));
    }
}

