/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.security;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.DB2Utils;
import org.jkiss.dbeaver.ext.db2.editors.DB2ObjectType;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Index;
import org.jkiss.dbeaver.ext.db2.model.DB2Package;
import org.jkiss.dbeaver.ext.db2.model.DB2Routine;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2Sequence;
import org.jkiss.dbeaver.ext.db2.model.DB2TableBase;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2Tablespace;
import org.jkiss.dbeaver.ext.db2.model.DB2Variable;
import org.jkiss.dbeaver.ext.db2.model.DB2XMLSchema;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2RoutineType;
import org.jkiss.dbeaver.ext.db2.model.module.DB2Module;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthBase;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthColumn;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthIndex;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthMaterializedQueryTable;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthMethod;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthModule;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthPackage;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthProcedure;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthSchema;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthSequence;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthTable;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthTablespace;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthUDF;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthVariable;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthView;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthXMLSchema;
import org.jkiss.dbeaver.ext.db2.model.security.DB2Grantee;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public final class DB2GranteeAuthCache
extends JDBCObjectCache<DB2Grantee, DB2AuthBase> {
    private static final String SQL;
    private static final String SQL_WITHOUT_MODULE;

    static {
        StringBuilder sb = new StringBuilder(4096);
        sb.append("SELECT GRANTOR,GRANTORTYPE");
        sb.append("     , '").append(DB2ObjectType.TABLE.name()).append("' AS OBJ_TYPE");
        sb.append("     , TABSCHEMA AS OBJ_SCHEMA, TABNAME AS OBJ_NAME");
        sb.append("     , CONTROLAUTH, ALTERAUTH, DELETEAUTH, INDEXAUTH, INSERTAUTH, REFAUTH, SELECTAUTH, UPDATEAUTH");
        sb.append("     , NULL AS USAGEAUTH, NULL AS ALTERINAUTH, NULL AS CREATEINAUTH, NULL AS DROPINAUTH, NULL AS BINDAUTH, NULL AS EXECUTEAUTH");
        sb.append("  FROM SYSCAT.TABAUTH");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append("   AND GRANTEE = ?");
        sb.append(" UNION ALL ");
        sb.append("SELECT GRANTOR,GRANTORTYPE");
        sb.append("     , '").append(DB2ObjectType.COLUMN.name()).append("' AS OBJ_TYPE");
        sb.append("     , TABSCHEMA AS OBJ_SCHEMA, TABNAME AS OBJ_NAME");
        sb.append("     , NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL");
        sb.append("     , COLNAME, PRIVTYPE, GRANTABLE, NULL, NULL, NULL");
        sb.append("  FROM SYSCAT.COLAUTH ");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append("   AND GRANTEE = ?");
        sb.append(" UNION ALL ");
        sb.append("SELECT GRANTOR,GRANTORTYPE");
        sb.append("     , '").append(DB2ObjectType.INDEX.name()).append("' AS OBJ_TYPE");
        sb.append("     , INDSCHEMA AS OBJ_SCHEMA, INDNAME AS OBJ_NAME");
        sb.append("     , CONTROLAUTH, NULL, NULL, NULL, NULL, NULL, NULL, NULL");
        sb.append("     , NULL, NULL, NULL, NULL, NULL, NULL");
        sb.append("  FROM SYSCAT.INDEXAUTH");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append("   AND GRANTEE = ?");
        sb.append(" UNION ALL ");
        sb.append("SELECT GRANTOR,GRANTORTYPE");
        sb.append("     , '").append(DB2ObjectType.PACKAGE.name()).append("' AS OBJ_TYPE");
        sb.append("     , PKGSCHEMA AS OBJ_SCHEMA, PKGNAME AS OBJ_NAME");
        sb.append("     , CONTROLAUTH, NULL, NULL, NULL, NULL, NULL, NULL, NULL");
        sb.append("     , NULL, NULL, NULL, NULL, BINDAUTH, EXECUTEAUTH");
        sb.append("  FROM SYSCAT.PACKAGEAUTH");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append("   AND GRANTEE = ?");
        sb.append(" UNION ALL ");
        sb.append("SELECT GRANTOR,GRANTORTYPE");
        sb.append("     , '").append(DB2ObjectType.PROCEDURE.name()).append("' AS OBJ_TYPE");
        sb.append("     , SCHEMA AS OBJ_SCHEMA, SPECIFICNAME AS OBJ_NAME");
        sb.append("     , NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL");
        sb.append("     , ROUTINETYPE, NULL, NULL, NULL, NULL, EXECUTEAUTH");
        sb.append("  FROM SYSCAT.ROUTINEAUTH");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append("   AND GRANTEE = ?");
        sb.append(" UNION ALL ");
        sb.append("SELECT GRANTOR,GRANTORTYPE");
        sb.append("     , '").append(DB2ObjectType.SCHEMA.name()).append("' AS OBJ_TYPE");
        sb.append("     , NULL AS OBJ_SCHEMA, SCHEMANAME AS OBJ_NAME");
        sb.append("     , NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL");
        sb.append("     , NULL, ALTERINAUTH, CREATEINAUTH, DROPINAUTH, NULL, NULL");
        sb.append("  FROM SYSCAT.SCHEMAAUTH");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append("   AND GRANTEE = ?");
        sb.append(" UNION ALL ");
        sb.append("SELECT GRANTOR,GRANTORTYPE");
        sb.append("     , '").append(DB2ObjectType.SEQUENCE.name()).append("' AS OBJ_TYPE");
        sb.append("     , SEQSCHEMA AS OBJ_SCHEMA, SEQNAME AS OBJ_NAME");
        sb.append("     , NULL, ALTERAUTH, NULL, NULL, NULL, NULL, NULL, NULL");
        sb.append("     , USAGEAUTH, NULL, NULL, NULL, NULL, NULL");
        sb.append("  FROM SYSCAT.SEQUENCEAUTH");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append("   AND GRANTEE = ?");
        sb.append(" UNION ALL ");
        sb.append("SELECT GRANTOR,GRANTORTYPE");
        sb.append("     , '").append(DB2ObjectType.TABLESPACE.name()).append("' AS OBJ_TYPE");
        sb.append("     , NULL AS OBJ_SCHEMA, TBSPACE AS OBJ_NAME");
        sb.append("     , NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL");
        sb.append("     , USEAUTH, NULL, NULL, NULL, NULL, NULL");
        sb.append("  FROM SYSCAT.TBSPACEAUTH");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append("   AND GRANTEE = ?");
        sb.append(" UNION ALL ");
        sb.append("SELECT GRANTOR,GRANTORTYPE");
        sb.append("     , '").append(DB2ObjectType.VARIABLE.name()).append("' AS OBJ_TYPE");
        sb.append("     , VARSCHEMA AS OBJ_SCHEMA, VARNAME AS OBJ_NAME");
        sb.append("     , NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL");
        sb.append("     , READAUTH AS USAGEAUTH, WRITEAUTH AS ALTERINAUTH, NULL, NULL, NULL, NULL");
        sb.append("  FROM SYSCAT.VARIABLEAUTH");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append("   AND GRANTEE = ?");
        sb.append(" UNION ALL ");
        sb.append("SELECT GRANTOR,GRANTORTYPE");
        sb.append("     , '").append(DB2ObjectType.XML_SCHEMA.name()).append("' AS OBJ_TYPE");
        sb.append("     , NULL AS OBJ_SCHEMA, CAST(OBJECTID AS VARCHAR(32)) AS OBJ_NAME");
        sb.append("     , NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL");
        sb.append("     , USAGEAUTH, NULL , NULL, NULL, NULL, NULL");
        sb.append("  FROM SYSCAT.XSROBJECTAUTH ");
        sb.append(" WHERE GRANTEETYPE = ?");
        sb.append("   AND GRANTEE = ?");
        StringBuilder sb2 = new StringBuilder(512);
        sb2.append(" UNION ALL ");
        sb2.append("SELECT GRANTOR,GRANTORTYPE");
        sb2.append("     , '").append(DB2ObjectType.MODULE.name()).append("' AS OBJ_TYPE");
        sb2.append("     , MODULESCHEMA AS OBJ_SCHEMA, MODULENAME AS OBJ_NAME");
        sb2.append("     , NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL");
        sb2.append("     , NULL, NULL, NULL, NULL, NULL, EXECUTEAUTH");
        sb2.append("  FROM SYSCAT.MODULEAUTH");
        sb2.append(" WHERE GRANTEETYPE = ?");
        sb2.append("   AND GRANTEE = ?");
        StringBuilder sb3 = new StringBuilder(64);
        sb3.append(" ORDER BY OBJ_SCHEMA, OBJ_NAME, OBJ_TYPE");
        sb3.append(" WITH UR");
        SQL = String.valueOf(sb.toString()) + sb2.toString() + sb3.toString();
        SQL_WITHOUT_MODULE = String.valueOf(sb.toString()) + sb3.toString();
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull DB2Grantee db2Grantee) throws SQLException {
        int nbMax;
        String sql;
        String userType = db2Grantee.getType().name();
        String userName = db2Grantee.getName();
        if (db2Grantee.getDataSource().isAtLeastV9_7()) {
            sql = SQL;
            nbMax = 22;
        } else {
            sql = SQL_WITHOUT_MODULE;
            nbMax = 20;
        }
        JDBCPreparedStatement dbStat = session.prepareStatement(sql);
        int i = 1;
        while (i <= nbMax) {
            dbStat.setString(i++, userType);
            dbStat.setString(i++, userName);
        }
        return dbStat;
    }

    protected DB2AuthBase fetchObject(@NotNull JDBCSession session, @NotNull DB2Grantee db2Grantee, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
        DB2DataSource db2DataSource = db2Grantee.getDataSource();
        DBRProgressMonitor monitor = session.getProgressMonitor();
        String objectSchemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"OBJ_SCHEMA");
        String objectName = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"OBJ_NAME");
        DB2ObjectType objectType = (DB2ObjectType)CommonUtils.valueOf(DB2ObjectType.class, (String)JDBCUtils.safeGetString((ResultSet)resultSet, (String)"OBJ_TYPE"));
        switch (objectType) {
            case COLUMN: {
                String columnName = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"USAGEAUTH");
                DB2TableColumn db2TableColumn = DB2Utils.findColumnBySchemaNameAndTableNameAndName(monitor, db2DataSource, objectSchemaName, objectName, columnName);
                return new DB2AuthColumn(monitor, db2Grantee, db2TableColumn, (ResultSet)resultSet);
            }
            case INDEX: {
                DB2Index db2Index = DB2Utils.findIndexBySchemaNameAndName(monitor, db2DataSource, objectSchemaName, objectName);
                return new DB2AuthIndex(monitor, db2Grantee, db2Index, (ResultSet)resultSet);
            }
            case MODULE: {
                DB2Module db2Module = DB2Utils.findModuleBySchemaNameAndName(monitor, db2DataSource, objectSchemaName, objectName);
                return new DB2AuthModule(monitor, db2Grantee, db2Module, (ResultSet)resultSet);
            }
            case PACKAGE: {
                DB2Package db2Package = DB2Utils.findPackageBySchemaNameAndName(monitor, db2DataSource, objectSchemaName, objectName);
                return new DB2AuthPackage(monitor, db2Grantee, db2Package, (ResultSet)resultSet);
            }
            case PROCEDURE: {
                DB2RoutineType routineType = (DB2RoutineType)CommonUtils.valueOf(DB2RoutineType.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"USAGEAUTH"));
                switch (routineType) {
                    case F: {
                        DB2Routine db2Udf = DB2Utils.findUDFBySchemaNameAndName(monitor, db2DataSource, objectSchemaName, objectName);
                        return new DB2AuthUDF(monitor, db2Grantee, db2Udf, (ResultSet)resultSet);
                    }
                    case M: {
                        DB2Routine db2Method = DB2Utils.findMethodBySchemaNameAndName(monitor, db2DataSource, objectSchemaName, objectName);
                        return new DB2AuthMethod(monitor, db2Grantee, db2Method, (ResultSet)resultSet);
                    }
                    case P: {
                        DB2Routine db2Procedure = DB2Utils.findProcedureBySchemaNameAndName(monitor, db2DataSource, objectSchemaName, objectName);
                        return new DB2AuthProcedure(monitor, db2Grantee, db2Procedure, (ResultSet)resultSet);
                    }
                }
                throw new DBException((Object)((Object)routineType) + " is not a valid DB2RoutineType");
            }
            case SCHEMA: {
                DB2Schema db2Schema = db2DataSource.getSchema(monitor, objectName);
                return new DB2AuthSchema(monitor, db2Grantee, db2Schema, (ResultSet)resultSet);
            }
            case SEQUENCE: {
                DB2Sequence db2Sequence = DB2Utils.findSequenceBySchemaNameAndName(monitor, db2DataSource, objectSchemaName, objectName);
                return new DB2AuthSequence(monitor, db2Grantee, db2Sequence, (ResultSet)resultSet);
            }
            case TABLE: {
                DB2TableBase db2TableBase = DB2Utils.findTableBySchemaNameAndName(monitor, db2DataSource, objectSchemaName, objectName);
                if (db2TableBase != null) {
                    return new DB2AuthTable(monitor, db2Grantee, db2TableBase, (ResultSet)resultSet);
                }
                db2TableBase = DB2Utils.findViewBySchemaNameAndName(monitor, db2DataSource, objectSchemaName, objectName);
                if (db2TableBase != null) {
                    return new DB2AuthView(monitor, db2Grantee, db2TableBase, (ResultSet)resultSet);
                }
                db2TableBase = DB2Utils.findMQTBySchemaNameAndName(monitor, db2DataSource, objectSchemaName, objectName);
                return new DB2AuthMaterializedQueryTable(monitor, db2Grantee, db2TableBase, (ResultSet)resultSet);
            }
            case TABLESPACE: {
                DB2Tablespace db2Tablespace = db2DataSource.getTablespace(monitor, objectName);
                return new DB2AuthTablespace(monitor, db2Grantee, db2Tablespace, (ResultSet)resultSet);
            }
            case VARIABLE: {
                DB2Variable db2Variable = db2DataSource.getVariable(monitor, objectName);
                return new DB2AuthVariable(monitor, db2Grantee, db2Variable, (ResultSet)resultSet);
            }
            case XML_SCHEMA: {
                Long xmlSchemaId = Long.valueOf(objectName);
                DB2XMLSchema db2XmlSchema = DB2Utils.findXMLSchemaByById(monitor, db2DataSource, xmlSchemaId);
                return new DB2AuthXMLSchema(monitor, db2Grantee, db2XmlSchema, (ResultSet)resultSet);
            }
        }
        throw new DBException("Programming error: " + (Object)((Object)objectType) + " is not supported yet and the SELECT statement must exclude it");
    }
}

