/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.manager;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.db2.manager.DB2AbstractDropOnlyManager;
import org.jkiss.dbeaver.ext.db2.model.DB2Routine;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class DB2RoutineManager
extends DB2AbstractDropOnlyManager<DB2Routine, DB2Schema> {
    private static final String SQL_DROP_FUNCTION = "DROP SPECIFIC FUNCTION %s";
    private static final String SQL_DROP_METHOD = "DROP SPECIFIC METHOD %s";
    private static final String SQL_DROP_PROCEDURE = "DROP SPECIFIC PROCEDURE %s";

    @Override
    public String buildDropStatement(DB2Routine db2Routine) {
        String fullyQualifiedName = db2Routine.getFullyQualifiedName(DBPEvaluationContext.DDL);
        switch (db2Routine.getType()) {
            case F: {
                return String.format(SQL_DROP_FUNCTION, fullyQualifiedName);
            }
            case M: {
                return String.format(SQL_DROP_METHOD, fullyQualifiedName);
            }
            case P: {
                return String.format(SQL_DROP_PROCEDURE, fullyQualifiedName);
            }
        }
        throw new IllegalStateException((Object)((Object)db2Routine.getType()) + " not suppoted");
    }

    @Nullable
    public DBSObjectCache<DB2Schema, DB2Routine> getObjectsCache(DB2Routine db2Routine) {
        switch (db2Routine.getType()) {
            case F: {
                return db2Routine.getSchema().getUdfCache();
            }
            case M: {
                return db2Routine.getSchema().getMethodCache();
            }
            case P: {
                return db2Routine.getSchema().getProcedureCache();
            }
        }
        throw new IllegalStateException((Object)((Object)db2Routine.getType()) + " is not a supported DB2RoutineType");
    }
}

