/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import com.sun.security.auth.module.NTSystem;
import com.sun.security.auth.module.UnixSystem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.auth.SMSessionPrincipal;
import org.jkiss.dbeaver.model.auth.impl.AbstractSessionPersistent;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class BasicWorkspaceSession
extends AbstractSessionPersistent
implements SMSession,
SMSessionPrincipal {
    private final DBPWorkspace workspace;
    private String userName;
    private String domainName;

    public BasicWorkspaceSession(@NotNull DBPWorkspace workspace) {
        this.workspace = workspace;
        try {
            if (RuntimeUtils.isWindows()) {
                NTSystem ntSystem = new NTSystem();
                this.userName = ntSystem.getName();
                this.domainName = ntSystem.getDomain();
            } else {
                UnixSystem unixSystem = new UnixSystem();
                this.userName = unixSystem.getUsername();
            }
        }
        catch (Exception exception) {}
        if (CommonUtils.isEmpty((String)this.userName)) {
            this.userName = System.getProperty("user.name");
        }
        if (CommonUtils.isEmpty((String)this.userName)) {
            this.userName = "unknown";
        }
        if (CommonUtils.isEmpty((String)this.domainName)) {
            if (RuntimeUtils.isWindows()) {
                this.domainName = System.getenv("USERDOMAIN");
            }
            if (CommonUtils.isEmpty((String)this.domainName)) {
                this.domainName = "local";
            }
        }
    }

    @NotNull
    public SMAuthSpace getSessionSpace() {
        return this.workspace;
    }

    @NotNull
    public SMSessionContext getSessionContext() {
        return this.workspace.getAuthContext();
    }

    public SMSessionPrincipal getSessionPrincipal() {
        return this;
    }

    @NotNull
    public String getSessionId() {
        return this.workspace.getWorkspaceId();
    }

    public boolean isApplicationSession() {
        return true;
    }

    @Nullable
    public DBPProject getSingletonProject() {
        return null;
    }

    public String getUserDomain() {
        return this.domainName;
    }

    public String getUserName() {
        return this.userName;
    }
}

