/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.view;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.task.DBTTaskFolder;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.registry.task.TaskManagerImpl;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIViewMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public class TaskHandlerFolderCreate
extends AbstractHandler {
    private static final Log log = Log.getLog(TaskHandlerFolderCreate.class);

    public Object execute(ExecutionEvent event) {
        DBPProject project = NavigatorUtils.getSelectedProject();
        CreateFolderDialog createFolderDialog = new CreateFolderDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), project);
        if (createFolderDialog.open() == 0) {
            DBPProject folderProject = createFolderDialog.getProject();
            DBTTaskManager taskManager = folderProject.getTaskManager();
            DBTTaskFolder taskFolder = null;
            try {
                taskFolder = taskManager.createTaskFolder(folderProject, createFolderDialog.getName(), null);
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError(TaskUIViewMessages.task_handler_folder_create_error_title, NLS.bind((String)TaskUIViewMessages.task_handler_folder_create_error_message, (Object)createFolderDialog.getName()), (Throwable)e);
                log.error((Object)"Can't create new task folder", (Throwable)e);
            }
            if (taskFolder != null && taskManager instanceof TaskManagerImpl) {
                ((TaskManagerImpl)taskManager).saveConfiguration();
            }
        }
        return null;
    }

    private class CreateFolderDialog
    extends BaseDialog {
        private DBPProject project;
        private String name;

        CreateFolderDialog(Shell parentShell, DBPProject project) {
            super(parentShell, TaskUIViewMessages.task_handler_folder_create_dialog_title, null);
            this.project = project;
        }

        protected Composite createDialogArea(Composite parent) {
            Composite composite = super.createDialogArea(parent);
            Text nameText = UIUtils.createLabelText((Composite)composite, (String)TaskUIViewMessages.task_handler_folder_create_dialog_text_label_name, (String)"");
            nameText.addModifyListener(e -> {
                this.name = nameText.getText().trim();
                this.getButton(0).setEnabled(!this.name.isEmpty());
            });
            final List projects = DBWorkbench.getPlatform().getWorkspace().getProjects();
            UIUtils.createControlLabel((Composite)composite, (String)TaskUIViewMessages.task_handler_folder_create_dialog_text_label_folder_project);
            final Combo projectCombo = new Combo(composite, 12);
            projectCombo.setLayoutData((Object)new GridData(768));
            for (DBPProject project : projects) {
                projectCombo.add(project.getName());
            }
            projectCombo.setText(this.project.getName());
            projectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CreateFolderDialog.this.project = (DBPProject)projects.get(projectCombo.getSelectionIndex());
                }
            });
            return composite;
        }

        public String getName() {
            return this.name;
        }

        public DBPProject getProject() {
            return this.project;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.getButton(0).setEnabled(false);
        }
    }
}

