/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.operation.overlayng.Edge;
import org.locationtech.jts.operation.overlayng.EdgeKey;
import org.locationtech.jts.util.Assert;

class EdgeMerger {
    private Collection<Edge> edges;
    private Map<EdgeKey, Edge> edgeMap = new HashMap<EdgeKey, Edge>();

    public static List<Edge> merge(List<Edge> edges) {
        EdgeMerger merger = new EdgeMerger(edges);
        return merger.merge();
    }

    public EdgeMerger(List<Edge> edges) {
        this.edges = edges;
    }

    public ArrayList<Edge> merge() {
        for (Edge edge : this.edges) {
            EdgeKey edgeKey = EdgeKey.create(edge);
            Edge baseEdge = this.edgeMap.get(edgeKey);
            if (baseEdge == null) {
                this.edgeMap.put(edgeKey, edge);
                continue;
            }
            Assert.isTrue(baseEdge.size() == edge.size(), "Merge of edges of different sizes - probable noding error.");
            baseEdge.merge(edge);
        }
        return new ArrayList<Edge>(this.edgeMap.values());
    }
}

