/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerExtendedProperty;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerExtendedPropertyCache;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerExtendedPropertyOwner;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectClass;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPHiddenObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPOrderedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.DBPositiveNumberTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCColumnKeyType;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableColumn;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt4;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class SQLServerTableColumn
extends JDBCTableColumn<SQLServerTableBase>
implements DBSTableColumn,
DBSTypedObjectEx,
DBPNamedObject2,
DBPOrderedObject,
DBPHiddenObject,
SQLServerObject,
JDBCColumnKeyType,
DBSTypedObjectExt4<SQLServerDataType>,
DBPRefreshableObject,
SQLServerExtendedPropertyOwner {
    private static final Log log = Log.getLog(SQLServerTableColumn.class);
    private long objectId;
    private int userTypeId;
    private SQLServerDataType dataType;
    private int bytesMaxLength;
    private String collationName;
    private String description;
    private boolean hidden;
    private boolean computedPersisted;
    private String computedDefinition;
    private String defaultConstraintName;
    private IdentityInfo identityInfo = new IdentityInfo();
    private final SQLServerExtendedPropertyCache extendedPropertyCache = new SQLServerExtendedPropertyCache();

    public SQLServerTableColumn(SQLServerTableBase table) {
        super((DBSEntity)table, false);
    }

    public SQLServerTableColumn(DBRProgressMonitor monitor, SQLServerTableBase table, ResultSet dbResult) throws DBException {
        super((DBSEntity)table, true);
        this.loadInfo(monitor, dbResult);
    }

    public SQLServerTableColumn(DBRProgressMonitor monitor, SQLServerTableBase table, DBSEntityAttribute source) throws DBException {
        super((DBSEntity)table, source, false);
        this.description = source.getDescription();
        if (source instanceof SQLServerTableColumn) {
            SQLServerTableColumn cfr_ignored_0 = (SQLServerTableColumn)source;
        }
    }

    private void loadInfo(DBRProgressMonitor monitor, ResultSet dbResult) throws DBException {
        this.objectId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"column_id");
        this.setName(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name"));
        this.setOrdinalPosition(JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"column_id"));
        this.userTypeId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"user_type_id");
        this.dataType = ((SQLServerTableBase)this.getTable()).getDatabase().getDataTypeByUserTypeId(monitor, this.userTypeId);
        if (this.dataType == null) {
            throw new DBCException("Data type '" + this.userTypeId + "' not found for column '" + this.getName() + "'");
        }
        this.bytesMaxLength = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"max_length");
        long l = this.maxLength = this.getDataSource().supportsColumnProperty() ? JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"char_max_length") : 0L;
        if (this.maxLength == 0L) {
            this.maxLength = this.bytesMaxLength;
            String typeName = this.getTypeName();
            if (typeName.equals("nvarchar") || typeName.equals("nchar")) {
                this.maxLength /= 2L;
            }
        }
        this.setRequired(JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_nullable") == 0);
        this.setScale(JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"scale"));
        this.setPrecision(JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"precision"));
        this.setAutoGenerated(JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_identity") != 0);
        if (this.getName().equals("timestamp")) {
            this.setAutoGenerated(true);
        }
        this.setValueType(this.dataType.getTypeID());
        this.hidden = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_hidden") != 0;
        this.collationName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"collation_name");
        String dv = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"default_definition");
        if (!CommonUtils.isEmpty((String)dv)) {
            while (dv.startsWith("(") && dv.endsWith(")")) {
                dv = dv.substring(1, dv.length() - 1);
            }
            this.setDefaultValue(dv);
            this.defaultConstraintName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"default_constraint_name");
        }
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
        this.computedPersisted = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_persisted") != 0;
        this.computedDefinition = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"computed_definition");
    }

    @Override
    @NotNull
    public SQLServerDataSource getDataSource() {
        return (SQLServerDataSource)((SQLServerTableBase)this.getTable()).getDataSource();
    }

    public String getFullTypeName() {
        if (this.dataType == null) {
            return String.valueOf(this.userTypeId);
        }
        String typeName = this.dataType.getName();
        String typeModifiers = SQLUtils.getColumnTypeModifiers((DBPDataSource)this.getDataSource(), (DBSTypedObject)this, (String)typeName, (DBPDataKind)this.dataType.getDataKind());
        return typeModifiers == null ? typeName : String.valueOf(typeName) + CommonUtils.notEmpty((String)typeModifiers);
    }

    public String getTypeName() {
        return this.dataType == null ? String.valueOf(this.userTypeId) : this.dataType.getTypeName();
    }

    @Property(viewable=true, editable=true, updatable=true, order=40, listProvider=DataTypeListProvider.class)
    public DBSDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(SQLServerDataType dataType) {
        this.dataType = dataType;
        this.typeName = dataType.getTypeName();
    }

    @Property(viewable=true, editable=true, updatable=true, order=41)
    public long getMaxLength() {
        return super.getMaxLength();
    }

    @Property(order=42)
    public int getBytesMaxLength() {
        return this.bytesMaxLength;
    }

    @Property(viewable=true, editable=true, updatable=true, valueRenderer=DBPositiveNumberTransformer.class, order=43)
    public Integer getScale() {
        return super.getScale();
    }

    @Property(viewable=true, editable=true, updatable=true, valueRenderer=DBPositiveNumberTransformer.class, order=44)
    public Integer getPrecision() {
        return super.getPrecision();
    }

    @Property(viewable=true, editable=true, updatable=true, order=50)
    public boolean isRequired() {
        return super.isRequired();
    }

    public boolean isAutoGenerated() {
        return super.isAutoGenerated() || CommonUtils.isNotEmpty((String)this.getComputedDefinition());
    }

    @Property(viewable=true, editable=true, order=55)
    public boolean isIdentity() {
        return super.isAutoGenerated();
    }

    public void setIdentity(boolean identity) {
        super.setAutoGenerated(identity);
    }

    @Property(viewable=true, editable=true, updatable=true, order=70)
    public String getDefaultValue() {
        return super.getDefaultValue();
    }

    @Nullable
    public String getDefaultConstraintName() {
        return this.defaultConstraintName;
    }

    public DBPDataKind getDataKind() {
        return this.dataType == null ? DBPDataKind.UNKNOWN : this.dataType.getDataKind();
    }

    @Property(viewable=true, editable=true, updatable=true, order=75)
    public String getCollationName() {
        return this.collationName;
    }

    public void setCollationName(String collationName) {
        this.collationName = collationName;
    }

    @Property(editable=true, order=76)
    public String getComputedDefinition() {
        return this.computedDefinition;
    }

    public void setComputedDefinition(String computedDefinition) {
        this.computedDefinition = computedDefinition;
    }

    @Property(editable=true, order=77)
    public boolean isComputedPersisted() {
        return this.computedPersisted;
    }

    public void setComputedPersisted(boolean computedPersisted) {
        this.computedPersisted = computedPersisted;
    }

    @Property(viewable=false, order=80)
    public boolean isHidden() {
        return this.hidden;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Property(viewable=false, order=80)
    public long getObjectId() {
        return this.objectId;
    }

    protected JDBCColumnKeyType getKeyType() {
        return this;
    }

    public boolean isInUniqueKey() {
        return this.isIdentity();
    }

    public boolean isInReferenceKey() {
        return false;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.extendedPropertyCache.clearCache();
        return this;
    }

    @Association
    @NotNull
    public Collection<SQLServerExtendedProperty> getExtendedProperties(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.extendedPropertyCache.getAllObjects(monitor, this);
    }

    @Override
    public long getMajorObjectId() {
        return ((SQLServerTableBase)this.getTable()).getObjectId();
    }

    @Override
    public long getMinorObjectId() {
        return this.getObjectId();
    }

    @Override
    public Pair<String, SQLServerObject> getExtendedPropertyObject(@NotNull DBRProgressMonitor monitor, int level) {
        switch (level) {
            case 0: {
                return new Pair((Object)"Schema", (Object)((SQLServerTableBase)this.getTable()).getSchema());
            }
            case 1: {
                return new Pair((Object)"Table", (Object)((SQLServerObject)this.getTable()));
            }
            case 2: {
                return new Pair((Object)"Column", (Object)this);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public SQLServerObjectClass getExtendedPropertyObjectClass() {
        return SQLServerObjectClass.OBJECT_OR_COLUMN;
    }

    @Override
    @NotNull
    public SQLServerExtendedPropertyCache getExtendedPropertyCache() {
        return this.extendedPropertyCache;
    }

    @Override
    @NotNull
    public SQLServerDatabase getDatabase() {
        return ((SQLServerTableBase)this.getTable()).getDatabase();
    }

    @PropertyGroup
    @LazyProperty(cacheValidator=IdentityInfoValidator.class)
    public IdentityInfo getIdentityInfo(DBRProgressMonitor monitor) throws DBCException {
        if (!this.identityInfo.loaded) {
            if (!this.isIdentity()) {
                this.identityInfo.loaded = true;
            } else {
                this.loadIdentityInfo(monitor);
            }
        }
        return this.identityInfo;
    }

    private void loadIdentityInfo(DBRProgressMonitor monitor) throws DBCException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load column identity info");){
            try {
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT seed_value,increment_value,last_value FROM " + SQLServerUtils.getSystemTableName(((SQLServerTableBase)this.getTable()).getDatabase(), "identity_columns") + " WHERE object_id=?");){
                    dbStat.setLong(1, ((SQLServerTableBase)this.getTable()).getObjectId());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            this.identityInfo.seedValue = CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"seed_value"));
                            this.identityInfo.incrementValue = CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"increment_value"));
                            this.identityInfo.lastValue = CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"last_value"));
                        }
                        this.identityInfo.loaded = true;
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    public static class DataTypeListProvider
    implements IPropertyValueListProvider<SQLServerTableColumn> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(SQLServerTableColumn object) {
            ArrayList allTypes = new ArrayList(object.getDataSource().getLocalDataTypes());
            try {
                List schemaTypes = ((SQLServerTableBase)object.getTable()).getSchema().getDataTypes((DBRProgressMonitor)new VoidProgressMonitor()).stream().filter(type -> !type.isTableType()).collect(Collectors.toList());
                allTypes.addAll(schemaTypes);
            }
            catch (DBException e) {
                log.debug((Object)"Error getting schema data types", (Throwable)e);
            }
            return allTypes.toArray();
        }
    }

    public static class IdentityInfo {
        private long seedValue;
        private long incrementValue;
        private long lastValue;
        private boolean loaded;

        public long getSeedValue() {
            return this.seedValue;
        }

        public long getIncrementValue() {
            return this.incrementValue;
        }

        @Property(viewable=false, order=60)
        public long getLastValue() {
            return this.lastValue;
        }
    }

    public static class IdentityInfoValidator
    implements IPropertyCacheValidator<SQLServerTableColumn> {
        public boolean isPropertyCached(SQLServerTableColumn object, Object propertyId) {
            return object.identityInfo.loaded;
        }
    }
}

