/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.UIJob;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.dialogs.AbstractPopupPanel;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.editors.sql.scripts.ScriptsHandlerImpl;
import org.jkiss.utils.CommonUtils;

public class ScriptSelectorPanel
extends AbstractPopupPanel {
    public static final String PREF_SCRIPT_SELECTOR_SHOW_PROJECT_SCRIPTS = "script_dialog_mode";
    private static final Log log = Log.getLog(ScriptSelectorPanel.class);
    private static final String DIALOG_ID = "DBeaver.ScriptSelectorPopup";
    private final IWorkbenchWindow workbenchWindow;
    @NotNull
    private final SQLNavigatorContext navigatorContext;
    @NotNull
    private final IFolder rootFolder;
    @NotNull
    private final List<SQLEditorUtils.ResourceInfo> scriptFiles;
    private List<SQLEditorUtils.ResourceInfo> projectScriptFiles;
    private Text patternText;
    private TreeViewer scriptViewer;
    private volatile FilterJob filterJob;

    private ScriptSelectorPanel(@NotNull IWorkbenchWindow workbenchWindow, @NotNull SQLNavigatorContext navigatorContext, @NotNull IFolder rootFolder, @NotNull List<SQLEditorUtils.ResourceInfo> scriptFiles) {
        super(workbenchWindow.getShell(), navigatorContext.getDataSourceContainer() == null ? "Choose SQL script" : "Choose SQL script for '" + navigatorContext.getDataSourceContainer().getName() + "'");
        this.workbenchWindow = workbenchWindow;
        this.navigatorContext = navigatorContext;
        this.rootFolder = rootFolder;
        try {
            this.projectScriptFiles = SQLEditorUtils.getScriptsFromProject(navigatorContext.getProject());
        }
        catch (CoreException e) {
            log.error((Object)e);
        }
        this.scriptFiles = scriptFiles;
    }

    protected boolean isShowTitle() {
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.patternText = new Text(composite, 2048);
        this.patternText.setLayoutData((Object)new GridData(768));
        UIUtils.addEmptyTextHint((Control)this.patternText, text -> "Enter a part of script name here");
        this.patternText.addModifyListener(e -> {
            if (this.filterJob != null) {
                return;
            }
            this.filterJob = new FilterJob();
            this.filterJob.schedule(250L);
        });
        Color fg = this.patternText.getForeground();
        Color bg = this.patternText.getBackground();
        Composite childComposite = new Composite(composite, 0);
        childComposite.setLayout((Layout)new GridLayout(2, true));
        childComposite.setLayoutData((Object)new GridData(768));
        composite.setForeground(fg);
        composite.setBackground(bg);
        Button newButton = new Button(childComposite, 0x800008);
        final Button projectCheckbox = UIUtils.createCheckbox((Composite)childComposite, (String)SQLEditorMessages.script_selector_project_scripts, (boolean)false);
        newButton.setText(SQLEditorMessages.script_selector_create_script);
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IFile scriptFile = SQLEditorUtils.createNewScript(DBWorkbench.getPlatform().getWorkspace().getProject(ScriptSelectorPanel.this.rootFolder.getProject()), ScriptSelectorPanel.this.rootFolder, ScriptSelectorPanel.this.navigatorContext);
                    SQLEditorHandlerOpenEditor.openResource((IResource)scriptFile, ScriptSelectorPanel.this.navigatorContext);
                }
                catch (CoreException ex) {
                    log.error((Object)ex);
                }
                ScriptSelectorPanel.this.cancelPressed();
            }
        });
        ((GridData)UIUtils.createHorizontalLine((Composite)composite).getLayoutData()).horizontalSpan = 2;
        Tree scriptTree = new Tree(composite, 65540);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.widthHint = 500;
        gd.heightHint = 200;
        scriptTree.setLayoutData((Object)gd);
        scriptTree.setForeground(fg);
        scriptTree.setBackground(bg);
        scriptTree.setLinesVisible(true);
        this.scriptViewer = new TreeViewer(scriptTree);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.scriptViewer);
        this.scriptViewer.setContentProvider((IContentProvider)new TreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof SQLEditorUtils.ResourceInfo) {
                    List<SQLEditorUtils.ResourceInfo> children = ((SQLEditorUtils.ResourceInfo)parentElement).getChildren();
                    return CommonUtils.isEmpty(children) ? null : children.toArray();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof SQLEditorUtils.ResourceInfo) {
                    List<SQLEditorUtils.ResourceInfo> children = ((SQLEditorUtils.ResourceInfo)element).getChildren();
                    return !CommonUtils.isEmpty(children);
                }
                return false;
            }
        });
        projectCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBWorkbench.getPlatform().getPreferenceStore().setValue(ScriptSelectorPanel.PREF_SCRIPT_SELECTOR_SHOW_PROJECT_SCRIPTS, projectCheckbox.getSelection());
                ScriptSelectorPanel.this.useProjectScripts(projectCheckbox.getSelection());
            }
        });
        projectCheckbox.setSelection(DBWorkbench.getPlatform().getPreferenceStore().getBoolean(PREF_SCRIPT_SELECTOR_SHOW_PROJECT_SCRIPTS));
        ViewerColumnController columnController = new ViewerColumnController("scriptSelectorViewer", (ColumnViewer)this.scriptViewer);
        columnController.addColumn(SQLEditorMessages.script_selector_project_table_name_label, SQLEditorMessages.script_selector_project_table_name_description, 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                SQLEditorUtils.ResourceInfo ri = (SQLEditorUtils.ResourceInfo)element;
                if (!ri.isDirectory()) {
                    if (ri.getDataSource() == null) {
                        return DBeaverIcons.getImage((DBPImage)UIIcon.SQL_SCRIPT);
                    }
                    return DBeaverIcons.getImage((DBPImage)ri.getDataSource().getDriver().getIcon());
                }
                return DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOLDER);
            }

            public String getText(Object element) {
                return ((SQLEditorUtils.ResourceInfo)element).getName();
            }

            public String getToolTipText(Object element) {
                DBPDataSourceContainer dataSource = ((SQLEditorUtils.ResourceInfo)element).getDataSource();
                return dataSource == null ? null : dataSource.getName();
            }

            public Image getToolTipImage(Object element) {
                DBPDataSourceContainer dataSource = ((SQLEditorUtils.ResourceInfo)element).getDataSource();
                return dataSource == null ? null : DBeaverIcons.getImage((DBPImage)dataSource.getDriver().getIcon());
            }
        });
        columnController.addColumn(SQLEditorMessages.script_selector_project_table_time_label, SQLEditorMessages.script_selector_project_table_time_description, 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){
            private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

            public String getText(Object element) {
                File localFile = ((SQLEditorUtils.ResourceInfo)element).getLocalFile();
                if (localFile.isDirectory()) {
                    return null;
                }
                return this.sdf.format(new Date(localFile.lastModified()));
            }
        });
        columnController.addColumn(SQLEditorMessages.script_selector_project_table_info_label, SQLEditorMessages.script_selector_project_table_info_description, 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public String getToolTipText(Object element) {
                SQLEditorUtils.ResourceInfo ri = (SQLEditorUtils.ResourceInfo)element;
                String description = ri.getDescription();
                return description == null ? null : description.trim();
            }
        });
        columnController.addColumn(SQLEditorMessages.script_selector_project_table_folder_label, SQLEditorMessages.script_selector_project_table_folder_description, 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SQLEditorUtils.ResourceInfo ri = (SQLEditorUtils.ResourceInfo)element;
                IFolder resourceDefaultRoot = DBWorkbench.getPlatform().getWorkspace().getResourceDefaultRoot(ScriptSelectorPanel.this.navigatorContext.getProject(), ScriptsHandlerImpl.class, false);
                String path = ri.getLocalFile().getParentFile().getPath();
                if (resourceDefaultRoot == null) {
                    return "";
                }
                if (ri.getResource() == null) {
                    return path;
                }
                return ri.getResource().getParent().equals((Object)resourceDefaultRoot) ? resourceDefaultRoot.getName() : resourceDefaultRoot.getLocationURI().relativize(new File(path).toURI()).getPath();
            }

            public String getToolTipText(Object element) {
                SQLEditorUtils.ResourceInfo ri = (SQLEditorUtils.ResourceInfo)element;
                return ri.getLocalFile().getPath();
            }
        });
        columnController.autoSizeColumns();
        columnController.createColumns();
        columnController.sortByColumn(1, 1024);
        scriptTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ArrayList<SQLEditorUtils.ResourceInfo> files = new ArrayList<SQLEditorUtils.ResourceInfo>();
                Object[] objectArray = ((IStructuredSelection)ScriptSelectorPanel.this.scriptViewer.getSelection()).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (!((SQLEditorUtils.ResourceInfo)item).isDirectory()) {
                        files.add((SQLEditorUtils.ResourceInfo)item);
                    }
                    ++n2;
                }
                if (files.isEmpty()) {
                    return;
                }
                ScriptSelectorPanel.this.cancelPressed();
                for (SQLEditorUtils.ResourceInfo ri : files) {
                    SQLEditorHandlerOpenEditor.openResourceEditor(ScriptSelectorPanel.this.workbenchWindow, ri, null);
                }
            }
        });
        scriptTree.addListener(42, event -> {
            TreeItem item = (TreeItem)event.item;
            SQLEditorUtils.ResourceInfo ri = (SQLEditorUtils.ResourceInfo)item.getData();
            if (ri != null && !ri.isDirectory() && CommonUtils.isEmpty((String)item.getText(2))) {
                UIUtils.asyncExec(() -> {
                    if (!item.isDisposed()) {
                        item.setText(2, CommonUtils.getSingleLineString((String)CommonUtils.notEmpty((String)ri.getDescription())));
                    }
                });
            }
        });
        this.patternText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Tree tree = ScriptSelectorPanel.this.scriptViewer.getTree();
                if (e.keyCode == 0x1000002) {
                    ScriptSelectorPanel.this.scriptViewer.setSelection((ISelection)new StructuredSelection(tree.getItem(0).getData()));
                    tree.setFocus();
                } else if (e.keyCode == 0x1000001) {
                    ScriptSelectorPanel.this.scriptViewer.setSelection((ISelection)new StructuredSelection(tree.getItem(tree.getItemCount() - 1).getData()));
                    tree.setFocus();
                }
            }
        });
        this.closeOnFocusLost(new Control[]{this.patternText, this.scriptViewer.getTree(), newButton});
        this.useProjectScripts(projectCheckbox.getSelection());
        UIUtils.expandAll((AbstractTreeViewer)this.scriptViewer);
        Tree tree = this.scriptViewer.getTree();
        TreeColumn[] columns = tree.getColumns();
        tree.setHeaderVisible(true);
        columns[0].pack();
        columns[0].setWidth(columns[0].getWidth() + 10);
        columns[1].pack();
        columns[2].setWidth(1600);
        UIUtils.asyncExec(() -> ((Tree)scriptTree).setFocus());
        return composite;
    }

    private void useProjectScripts(boolean result) {
        if (result) {
            this.scriptViewer.setInput(this.projectScriptFiles);
        } else {
            this.scriptViewer.setInput(this.scriptFiles);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    public static void showTree(IWorkbenchWindow workbenchWindow, SQLNavigatorContext editorContext, IFolder rootFolder, List<SQLEditorUtils.ResourceInfo> scriptFiles) {
        ScriptSelectorPanel selectorPanel = new ScriptSelectorPanel(workbenchWindow, editorContext, rootFolder, scriptFiles);
        selectorPanel.setModeless(true);
        selectorPanel.open();
    }

    private class FilterJob
    extends UIJob {
        FilterJob() {
            super("Filter scripts");
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            ScriptSelectorPanel.this.filterJob = null;
            ScriptSelectorPanel.this.scriptViewer.setFilters(new ViewerFilter[]{new ScriptFilter()});
            UIUtils.expandAll((AbstractTreeViewer)ScriptSelectorPanel.this.scriptViewer);
            Tree tree = ScriptSelectorPanel.this.scriptViewer.getTree();
            if (tree.getItemCount() > 0) {
                ScriptSelectorPanel.this.scriptViewer.reveal(tree.getItem(0).getData());
            }
            return Status.OK_STATUS;
        }
    }

    private class ScriptFilter
    extends ViewerFilter {
        private final String pattern;

        ScriptFilter() {
            this.pattern = ScriptSelectorPanel.this.patternText.getText().toLowerCase(Locale.ENGLISH);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IResource resource = ((SQLEditorUtils.ResourceInfo)element).getResource();
            if (resource instanceof IFolder) {
                return this.isAnyChildMatches((SQLEditorUtils.ResourceInfo)element);
            }
            return ((SQLEditorUtils.ResourceInfo)element).getName().toLowerCase(Locale.ENGLISH).contains(this.pattern);
        }

        private boolean isAnyChildMatches(SQLEditorUtils.ResourceInfo ri) {
            for (SQLEditorUtils.ResourceInfo child : ri.getChildren()) {
                if (!(child.getResource() instanceof IFolder ? this.isAnyChildMatches(child) : child.getName().toLowerCase(Locale.ENGLISH).contains(this.pattern))) continue;
                return true;
            }
            return false;
        }
    }
}

