/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls.redshift;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableRegular;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class RedshiftTable
extends PostgreTableRegular {
    private static final Log log = Log.getLog(RedshiftTable.class);

    @Override
    public boolean isRefreshSchemaStatisticsOnTableRefresh() {
        return false;
    }

    public RedshiftTable(PostgreSchema catalog) {
        super(catalog);
    }

    public RedshiftTable(PostgreSchema catalog, ResultSet dbResult) {
        super(catalog, dbResult);
    }

    @Override
    protected void readTableStatistics(JDBCSession session) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT size, tbl_rows FROM SVV_TABLE_INFO WHERE \"schema\"=? AND table_id=?");){
            dbStat.setString(1, this.getSchema().getName());
            dbStat.setLong(2, this.getObjectId());
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                if (dbResult.next()) {
                    this.fetchStatistics(dbResult);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.hasStatistics()) {
            this.diskSpace = null;
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Calculate relation size on disk");){
                    this.readTableStatistics((JDBCSession)session);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.debug((Object)"Can't fetch disk space", (Throwable)e);
            }
        }
        return super.refreshObject(monitor);
    }

    @Override
    protected void fetchStatistics(JDBCResultSet dbResult) throws SQLException {
        this.diskSpace = dbResult.getLong("size") * 1024L * 1024L;
        this.rowCount = dbResult.getLong("tbl_rows");
        this.rowCountEstimate = this.rowCount;
    }
}

