/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class CDFDialog
extends JDialog
implements ActionListener,
CDFConstants {
    static final long serialVersionUID = 1L;
    private String name;
    private JButton enter;
    private JButton cancel;
    private JButton end;
    private JLabeledTF jtfcl;
    private JTextField tfcl;
    private JLabeledCB cbcp;
    private JLabeledCB cben;
    private JLabeledCB cbma;
    private JLabeledCB cbfo;
    private JLabeledCB cbcs;
    private JFrame myFrame;
    private boolean enChanged = false;
    private boolean maChanged = false;
    private boolean foChanged = false;
    private boolean csChanged = false;
    private long compression;
    private long complevel;
    private long encoding;
    private long majority;
    private long format;
    private long checksum;
    private static final String UPDATE = "Update";
    private static final String END = "End";
    private static final String CANCEL = "Reset";
    private CDF cdf = null;

    public CDFDialog() {
    }

    public CDFDialog(JFrame jFrame, CDF cDF) {
        super((Frame)jFrame, true);
        this.myFrame = jFrame;
        this.setTitle("Edit Spec for CDF: " + cDF.toString());
        this.cdf = cDF;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(jPanel);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
        this.setSize(450, 400);
        this.setLocation(10, 20);
        this.setVisible(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        Vector<String> vector = new Vector<String>();
        vector.addElement("NETWORK");
        vector.addElement("SUN");
        vector.addElement("VAX");
        vector.addElement("DECSTATION");
        vector.addElement("SGi");
        vector.addElement("IBMPC");
        vector.addElement("IBMRS");
        vector.addElement("HOST");
        vector.addElement("PPC");
        vector.addElement("HP");
        vector.addElement("NeXT");
        vector.addElement("ALPHAOSF1");
        vector.addElement("ALPHAVMSd");
        vector.addElement("ALPHAVMSg");
        vector.addElement("ALPHAVMSi");
        vector.addElement("ARM_LITTLE");
        vector.addElement("ARM_BIG");
        vector.addElement("IA64VMSi");
        vector.addElement("IA64VMSg");
        vector.addElement("IA64VMSd");
        this.cben = new JLabeledCB("Encoding", vector, false, true);
        this.cben.addItemListener(new EncodingListener());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.cben, gridBagConstraints);
        jPanel2.add(this.cben);
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("ROW");
        vector2.addElement("COLUMN");
        this.cbma = new JLabeledCB("Majority", vector2, false, true);
        this.cbma.addItemListener(new MajorityListener());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.cbma, gridBagConstraints);
        jPanel2.add(this.cbma);
        Vector<String> vector3 = new Vector<String>();
        vector3.addElement("SINGLE");
        vector3.addElement("MULTI");
        this.cbfo = new JLabeledCB("Format", vector3, false, true);
        this.cbfo.addItemListener(new FormatListener());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.cbfo, gridBagConstraints);
        jPanel2.add(this.cbfo);
        Vector<String> vector4 = new Vector<String>();
        vector4.addElement("None");
        vector4.addElement("RLE");
        vector4.addElement("HUFF");
        vector4.addElement("AHUFF");
        vector4.addElement("GZIP");
        this.tfcl = new JTextField(1);
        this.cbcp = new JLabeledCB("Compression", vector4, false);
        this.cbcp.addItemListener(new CompressionListener());
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.cbcp, gridBagConstraints);
        jPanel2.add(this.cbcp);
        this.jtfcl = new JLabeledTF("Level", this.tfcl, true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.jtfcl, gridBagConstraints);
        jPanel2.add(this.jtfcl);
        Vector<String> vector5 = new Vector<String>();
        vector5.addElement("NO");
        vector5.addElement("MD5");
        this.cbcs = new JLabeledCB("Checksum", vector5, false, true);
        this.cbcs.addItemListener(new ChecksumListener());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.cbcs, gridBagConstraints);
        jPanel2.add(this.cbcs);
        jPanel.add((Component)jPanel2, "Center");
        this.createButtonPanel(jPanel);
        this.reset();
        this.pack();
        this.setVisible(true);
    }

    private void createButtonPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        this.enter = new JButton(UPDATE);
        this.enter.addActionListener(this);
        this.enter.setToolTipText("Update the CDF specification");
        jPanel2.add(this.enter);
        this.cancel = new JButton(CANCEL);
        this.cancel.addActionListener(this);
        this.cancel.setToolTipText("Reset fields back to their last values");
        jPanel2.add(this.cancel);
        this.end = new JButton(END);
        this.end.addActionListener(this);
        this.end.setToolTipText("End editing");
        jPanel2.add(this.end);
        jPanel.add((Component)jPanel2, "South");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            String string = actionEvent.getActionCommand();
            if (string.equals(CANCEL)) {
                this.reset();
            } else if (string.equals(END)) {
                this.setVisible(false);
                this.enter.removeActionListener(this);
                this.cancel.removeActionListener(this);
                this.end.removeActionListener(this);
                this.dispose();
                System.gc();
            } else if (string.equals(UPDATE)) {
                ((JButton)object).setEnabled(false);
                long l = -1L;
                long[] lArray = new long[]{0L};
                l = this.cbcp.getIndex();
                if (l == 4L) {
                    ++l;
                }
                try {
                    if (l != this.compression) {
                        if (l == 5L) {
                            lArray[0] = Long.parseLong((String)this.jtfcl.get());
                            if (lArray[0] > 0L && lArray[0] < 10L) {
                                this.cdf.setCompression(l, lArray);
                                this.compression = l;
                                this.complevel = lArray[0];
                            } else {
                                Toolkit.getDefaultToolkit().beep();
                                JOptionPane.showMessageDialog(this.myFrame, "GZIP compression level: has to be between 1 and 9", "CDFEdit: CDFException", 0);
                            }
                        } else {
                            this.cdf.setCompression(l, lArray);
                            this.compression = l;
                            this.complevel = lArray[0];
                        }
                    } else if (l == 5L) {
                        lArray[0] = Long.parseLong((String)this.jtfcl.get());
                        if (lArray[0] != this.complevel) {
                            if (lArray[0] > 0L && lArray[0] < 10L) {
                                this.cdf.setCompression(l, lArray);
                                this.compression = l;
                                this.complevel = lArray[0];
                            } else {
                                Toolkit.getDefaultToolkit().beep();
                                JOptionPane.showMessageDialog(this.myFrame, "GZIP compression level: has to be between 1 and 9", "CDFEdit: CDFException", 0);
                            }
                        }
                    }
                }
                catch (CDFException cDFException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Compression Error!", 0);
                }
                if (this.enChanged) {
                    this.enChanged = false;
                    l = (long)this.cben.getIndex() + 1L;
                    if (l > 9L) {
                        ++l;
                    }
                    if (l != this.encoding) {
                        try {
                            this.cdf.setEncoding(l);
                            this.encoding = l;
                        }
                        catch (CDFException cDFException) {
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Encoding Error!", 0);
                        }
                    }
                }
                if (this.maChanged) {
                    this.maChanged = false;
                    l = (long)this.cbma.getIndex() + 1L;
                    if (l != this.majority) {
                        try {
                            this.cdf.setMajority(l);
                            this.majority = l;
                        }
                        catch (CDFException cDFException) {
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Majority Error!", 0);
                        }
                    }
                }
                if (this.foChanged) {
                    this.foChanged = false;
                    l = (long)this.cbfo.getIndex() + 1L;
                    if (l == 2L) {
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(this.myFrame, "Multi_file format is not supported yet!", "CDFEdit: Format Error!", 2);
                    } else {
                        try {
                            this.cdf.setFormat(l);
                            this.format = l;
                        }
                        catch (CDFException cDFException) {
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Format Error!", 0);
                        }
                    }
                }
                if (this.csChanged) {
                    this.csChanged = false;
                    l = this.cbcs.getIndex();
                    if (l != this.checksum) {
                        try {
                            this.cdf.setChecksum(l);
                            this.checksum = l;
                        }
                        catch (CDFException cDFException) {
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "CDFEdit: Checksum Error!", 0);
                        }
                    }
                }
                ((JButton)object).setEnabled(true);
            }
        } else if (object instanceof JTextField) {
            long l;
            long l2 = this.cbcp.getIndex();
            if (l2 > 3L) {
                ++l2;
            }
            if (l2 == 5L && ((l = Long.parseLong((String)this.jtfcl.get())) < 1L || l > 9L)) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this.myFrame, "GZIP compression level: has to be between 1 and 9", "CDFEdit: CDFException", 0);
            }
        }
    }

    public void reset() {
        this.enChanged = false;
        this.maChanged = false;
        this.foChanged = false;
        this.csChanged = false;
        this.compression = this.cdf.getCompressionType();
        if (this.compression == 5L) {
            long[] lArray = this.cdf.getCompressionParms();
            this.complevel = lArray[0];
        }
        this.encoding = this.cdf.getEncoding();
        this.format = this.cdf.getFormat();
        this.majority = this.cdf.getMajority();
        this.checksum = this.cdf.getChecksum();
        int n = (int)this.compression;
        if (n > 3) {
            --n;
        }
        this.cbcp.setIndex(n);
        if (this.compression == 5L) {
            this.jtfcl.set("" + this.complevel);
            this.tfcl.setVisible(true);
            this.jtfcl.setEnabled(true);
            this.jtfcl.setEditable(true);
        } else {
            this.tfcl.setVisible(true);
            this.jtfcl.setEnabled(true);
            this.jtfcl.setEditable(false);
            if (this.compression == 0L) {
                this.jtfcl.set("");
            } else {
                this.jtfcl.set("0");
            }
        }
        n = (int)this.encoding - 1;
        if ((long)n > 9L) {
            --n;
        }
        this.cben.setIndex(n);
        n = (int)this.majority - 1;
        this.cbma.setIndex(n);
        n = (int)this.format - 1;
        this.cbfo.setIndex(n);
        this.cbcs.setIndex((int)this.checksum);
    }

    class ChecksumListener
    implements ItemListener {
        ChecksumListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if ((long)CDFDialog.this.cbcs.getIndex() != CDFDialog.this.checksum - 1L) {
                CDFDialog.this.csChanged = true;
            }
        }
    }

    class FormatListener
    implements ItemListener {
        FormatListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if ((long)CDFDialog.this.cbfo.getIndex() != CDFDialog.this.format - 1L) {
                CDFDialog.this.csChanged = true;
            }
        }
    }

    class MajorityListener
    implements ItemListener {
        MajorityListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if ((long)CDFDialog.this.cbma.getIndex() != CDFDialog.this.majority - 1L) {
                CDFDialog.this.maChanged = true;
            }
        }
    }

    class EncodingListener
    implements ItemListener {
        EncodingListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            int n = CDFDialog.this.cben.getIndex() + 1;
            if ((long)n > 9L) {
                ++n;
            }
            if ((long)n != CDFDialog.this.encoding) {
                CDFDialog.this.enChanged = true;
            }
        }
    }

    class CompressionListener
    implements ItemListener {
        CompressionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            int n = CDFDialog.this.cbcp.getIndex();
            if (n == 4) {
                ++n;
            }
            if (n == 5) {
                CDFDialog.this.jtfcl.setVisible(true);
                CDFDialog.this.jtfcl.setEnabled(true);
                CDFDialog.this.jtfcl.setEditable(true);
                CDFDialog.this.jtfcl.set("5");
            } else {
                CDFDialog.this.jtfcl.setVisible(true);
                CDFDialog.this.jtfcl.setEnabled(true);
                CDFDialog.this.jtfcl.setEditable(false);
                if (n == 0) {
                    CDFDialog.this.jtfcl.set("");
                } else {
                    CDFDialog.this.jtfcl.set("0");
                }
            }
        }
    }
}

