# This script takes care of building your crate and packaging it for release

set -ex

main() {
    local src=$(pwd) \
          stage=

    case $TRAVIS_OS_NAME in
        linux)
            stage=$(mktemp -d)
            ;;
        osx)
            stage=$(mktemp -d -t tmp)
            ;;
    esac

    test -f Cargo.lock || cargo generate-lockfile

    cross rustc --bin mcfly --target $TARGET --release -- -C lto

#    strip target/$TARGET/release/mcfly

    cp target/$TARGET/release/mcfly $stage/
    cp mcfly.bash $stage/
    cp mcfly.zsh $stage/
    cp mcfly.fish $stage/

    cd $stage
    tar czf $src/$CRATE_NAME-$TRAVIS_TAG-$TARGET.tar.gz *
    cd $src

    rm -rf $stage
}

main
