/////////////////////////////////////////////////////////////////////////
// $Id: opcodes.inc 12247 2014-03-17 20:29:44Z sshwarts $
/////////////////////////////////////////////////////////////////////////
//
//   Copyright (c) 2005-2013 Stanislav Shwartsman
//          Written by Stanislav Shwartsman [sshwarts at sourceforge net]
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
//
/////////////////////////////////////////////////////////////////////////

Ia_aaa = { "aaa", "aaa", XX, XX, XX, XX, 0 },
Ia_aad = { "aad", "aad", Ib, XX, XX, XX, 0 },
Ia_aam = { "aam", "aam", Ib, XX, XX, XX, 0 },
Ia_aas = { "aas", "aas", XX, XX, XX, XX, 0 },
Ia_adcb_AL_Ib = { "adc", "adcb", AL_Reg, Ib, XX, XX, 0 },
Ia_adcb_Eb_Gb = { "adc", "adcb", Eb, Gb, XX, XX, 0 },
Ia_adcb_Eb_Ib = { "adc", "adcb", Eb, Ib, XX, XX, 0 },
Ia_adcb_Gb_Eb = { "adc", "adcb", Gb, Eb, XX, XX, 0 },
Ia_adcl_EAX_Id = { "adc", "adcl", EAX_Reg, Id, XX, XX, 0 },
Ia_adcl_Ed_Gd = { "adc", "adcl", Ed, Gd, XX, XX, 0 },
Ia_adcl_Ed_Id = { "adc", "adcl", Ed, Id, XX, XX, 0 },
Ia_adcl_Ed_sIb = { "adc", "adcl", Ed, sIbd, XX, XX, 0 },
Ia_adcl_Gd_Ed = { "adc", "adcl", Gd, Ed, XX, XX, 0 },
Ia_adcq_Eq_Gq = { "adc", "adcq", Eq, Gq, XX, XX, 0 },
Ia_adcq_Eq_sIb = { "adc", "adcq", Eq, sIbq, XX, XX, 0 },
Ia_adcq_Eq_sId = { "adc", "adcq", Eq, Iq, XX, XX, 0 },
Ia_adcq_Gq_Eq = { "adc", "adcq", Gq, Eq, XX, XX, 0 },
Ia_adcq_RAX_sId = { "adc", "adcq", RAX_Reg, sIdq, XX, XX, 0 },
Ia_adcw_AX_Iw = { "adc", "adcw", AX_Reg, Iw, XX, XX, 0 },
Ia_adcw_Ew_Gw = { "adc", "adcw", Ew, Gw, XX, XX, 0 },
Ia_adcw_Ew_Iw = { "adc", "adcw", Ew, Iw, XX, XX, 0 },
Ia_adcw_Ew_sIb = { "adc", "adcw", Ew, sIbw, XX, XX, 0 },
Ia_adcw_Gw_Ew = { "adc", "adcw", Gw, Ew, XX, XX, 0 },
Ia_adcx_Gd_Ed = { "adcx", "adcxd", Gd, Ed, XX, XX, IA_ADX },
Ia_adcx_Gq_Eq = { "adcx", "adcxq", Gq, Eq, XX, XX, IA_ADX },
Ia_addb_AL_Ib = { "add", "addb", AL_Reg, Ib, XX, XX, 0 },
Ia_addb_Eb_Gb = { "add", "addb", Eb, Gb, XX, XX, 0 },
Ia_addb_Eb_Ib = { "add", "addb", Eb, Ib, XX, XX, 0 },
Ia_addb_Gb_Eb = { "add", "addb", Gb, Eb, XX, XX, 0 },
Ia_addl_EAX_Id = { "add", "addl", EAX_Reg, Id, XX, XX, 0 },
Ia_addl_Ed_Gd = { "add", "addl", Ed, Gd, XX, XX, 0 },
Ia_addl_Ed_Id = { "add", "addl", Ed, Id, XX, XX, 0 },
Ia_addl_Ed_sIb = { "add", "addl", Ed, sIbd, XX, XX, 0 },
Ia_addl_Gd_Ed = { "add", "addl", Gd, Ed, XX, XX, 0 },
Ia_addpd_Vpd_Wpd = { "addpd", "addpd", Vpd, Wpd, XX, XX, IA_SSE2 },
Ia_addps_Vps_Wps = { "addps", "addps", Vps, Wps, XX, XX, IA_SSE },
Ia_addq_Eq_Gq = { "add", "addq", Eq, Gq, XX, XX, 0 },
Ia_addq_Eq_sIb = { "add", "addq", Eq, sIbq, XX, XX, 0 },
Ia_addq_Eq_sId = { "add", "addq", Eq, sIdq, XX, XX, 0 },
Ia_addq_Gq_Eq = { "add", "addq", Gq, Eq, XX, XX, 0 },
Ia_addq_RAX_sId = { "add", "addq", RAX_Reg, sIdq, XX, XX, 0 },
Ia_addsd_Vsd_Wsd = { "addsd", "addsd", Vsd, Wsd, XX, XX, IA_SSE2 },
Ia_addss_Vss_Wss = { "addss", "addss", Vss, Wss, XX, XX, IA_SSE },
Ia_addsubpd_Vpd_Wpd = { "addsubpd", "addsubpd", Vpd, Wpd, XX, XX, IA_SSE3 },
Ia_addsubps_Vps_Wps = { "addsubps", "addsubps", Vps, Wps, XX, XX, IA_SSE3 },
Ia_addw_AX_Iw = { "add", "addw", AX_Reg, Iw, XX, XX, 0 },
Ia_addw_Ew_Gw = { "add", "addw", Ew, Gw, XX, XX, 0 },
Ia_addw_Ew_Iw = { "add", "addw", Ew, Iw, XX, XX, 0 },
Ia_addw_Ew_sIb = { "add", "addw", Ew, sIbw, XX, XX, 0 },
Ia_addw_Gw_Ew = { "add", "addw", Gw, Ew, XX, XX, 0 },
Ia_adox_Gd_Ed = { "adox", "adoxd", Gd, Ed, XX, XX, IA_ADX },
Ia_adox_Gq_Eq = { "adox", "adoxq", Gq, Eq, XX, XX, IA_ADX },
Ia_aesdec_Vdq_Wdq = { "aesdec", "aesdec", Vdq, Wdq, XX, XX, IA_AES_PCLMULQDQ },
Ia_aesdeclast_Vdq_Wdq = { "aesdeclast", "aesdeclast", Vdq, Wdq, XX, XX, IA_AES_PCLMULQDQ },
Ia_aesenc_Vdq_Wdq = { "aesenc", "aesenc", Vdq, Wdq, XX, XX, IA_AES_PCLMULQDQ },
Ia_aesenclast_Vdq_Wdq = { "aesenclast", "aesenclast", Vdq, Wdq, XX, XX, IA_AES_PCLMULQDQ },
Ia_aesimc_Vdq_Wdq = { "aesimc", "aesimc", Vdq, Wdq, XX, XX, IA_AES_PCLMULQDQ },
Ia_aeskeygenassist_Vdq_Wdq_Ib = { "aeskeygenassist", "aeskeygenassist", Vdq, Wdq, Ib, XX, IA_AES_PCLMULQDQ },
Ia_andb_AL_Ib = { "and", "andb", AL_Reg, Ib, XX, XX, 0 },
Ia_andb_Eb_Gb = { "and", "andb", Eb, Gb, XX, XX, 0 },
Ia_andb_Eb_Ib = { "and", "andb", Eb, Ib, XX, XX, 0 },
Ia_andb_Gb_Eb = { "and", "andb", Gb, Eb, XX, XX, 0 },
Ia_andl_EAX_Id = { "and", "andl", EAX_Reg, Id, XX, XX, 0 },
Ia_andl_Ed_Gd = { "and", "andl", Ed, Gd, XX, XX, 0 },
Ia_andl_Ed_Id = { "and", "andl", Ed, Id, XX, XX, 0 },
Ia_andl_Ed_sIb = { "and", "andl", Ed, sIbd, XX, XX, 0 },
Ia_andl_Gd_Ed = { "and", "andl", Gd, Ed, XX, XX, 0 },
Ia_andn_Gy_By_Ey = { "andn", "andn", Gy, By, Ey, XX, IA_BMI1 },
Ia_andnpd_Vpd_Wpd = { "andnpd", "andnpd", Vpd, Wpd, XX, XX, IA_SSE2 },
Ia_andnps_Vps_Wps = { "andnps", "andnps", Vps, Wps, XX, XX, IA_SSE },
Ia_andpd_Vpd_Wpd = { "andpd", "andpd", Vpd, Wpd, XX, XX, IA_SSE2 },
Ia_andps_Vps_Wps = { "andps", "andps", Vps, Wps, XX, XX, IA_SSE },
Ia_andq_Eq_Gq = { "and", "andq", Eq, Gq, XX, XX, 0 },
Ia_andq_Eq_sIb = { "and", "andq", Eq, sIbq, XX, XX, 0 },
Ia_andq_Eq_sId = { "and", "andq", Eq, sIdq, XX, XX, 0 },
Ia_andq_Gq_Eq = { "and", "andq", Gq, Eq, XX, XX, 0 },
Ia_andq_RAX_sId = { "and", "andq", RAX_Reg, sIdq, XX, XX, 0 },
Ia_andw_AX_Iw = { "and", "andw", AX_Reg, Iw, XX, XX, 0 },
Ia_andw_Ew_Gw = { "and", "andw", Ew, Gw, XX, XX, 0 },
Ia_andw_Ew_Iw = { "and", "andw", Ew, Iw, XX, XX, 0 },
Ia_andw_Ew_sIb = { "and", "andw", Ew, sIbw, XX, XX, 0 },
Ia_andw_Gw_Ew = { "and", "andw", Gw, Ew, XX, XX, 0 },
Ia_arpl_Ew_Gw = { "arpl", "arpl", Ew, Gw, XX, XX, 0 },
Ia_bextr_Gy_Ey_By = { "bextr", "bextr", Gy, Ey, By, XX, IA_BMI1 },
Ia_bextr_Gy_Ey_Id = { "bextr", "bextr", Gy, Ey, Id, XX, IA_TBM },
Ia_blcfill_By_Ey = { "blcfill", "blcfill", Gy, By, Ey, XX, IA_TBM },
Ia_blci_By_Ey = { "blci", "blci", Gy, By, Ey, XX, IA_TBM },
Ia_blcic_By_Ey = { "blcic", "blcic", Gy, By, Ey, XX, IA_TBM },
Ia_blcmsk_By_Ey = { "blcmsk", "blcmsk", Gy, By, Ey, XX, IA_TBM },
Ia_blcs_By_Ey = { "blcs", "blcs", Gy, By, Ey, XX, IA_TBM },
Ia_blendpd_Vpd_Wpd_Ib = { "blendpd", "blendpd", Vpd, Wpd, Ib, XX, IA_SSE4_1 },
Ia_blendps_Vps_Wps_Ib = { "blendps", "blendps", Vps, Wps, Ib, XX, IA_SSE4_1 },
Ia_blendvpd_Vpd_Wpd = { "blendvpd", "blendvpd", Vpd, Wpd, XX, XX, IA_SSE4_1 },
Ia_blendvps_Vps_Wps = { "blendvps", "blendvps", Vps, Wps, XX, XX, IA_SSE4_1 },
Ia_blsfill_By_Ey = { "blsfill", "blsfill", Gy, By, Ey, XX, IA_TBM },
Ia_blsi_By_Ey = { "blsi", "blsi", By, Ey, XX, XX, IA_BMI1 },
Ia_blsic_By_Ey = { "blsic", "blsic", Gy, By, Ey, XX, IA_TBM },
Ia_blsmsk_By_Ey = { "blsmsk", "blsmsk", By, Ey, XX, XX, IA_BMI1 },
Ia_blsr_By_Ey = { "blsr", "blsr", By, Ey, XX, XX, IA_BMI1 },
Ia_boundl_Gd_Ma = { "bound", "boundl", Gd, Ma, XX, XX, 0 },
Ia_boundw_Gw_Ma = { "bound", "boundw", Gw, Ma, XX, XX, 0 },
Ia_bsfl_Gd_Ed = { "bsf", "bsfl", Gd, Ed, XX, XX, 0 },
Ia_bsfq_Gq_Eq = { "bsf", "bsfq", Gq, Eq, XX, XX, 0 },
Ia_bsfw_Gw_Ew = { "bsf", "bsfw", Gw, Ew, XX, XX, 0 },
Ia_bsrl_Gd_Ed = { "bsr", "bsrl", Gd, Ed, XX, XX, 0 },
Ia_bsrq_Gq_Eq = { "bsr", "bsrq", Gq, Eq, XX, XX, 0 },
Ia_bsrw_Gw_Ew = { "bsr", "bsrw", Gw, Ew, XX, XX, 0 },
Ia_bswapw_RX = { "bswap", "bswapw", RX, XX, XX, XX, IA_486 },
Ia_bswapl_ERX = { "bswap", "bswapl", ERX, XX, XX, XX, IA_486 },
Ia_bswapq_RRX = { "bswap", "bswapq", RRX, XX, XX, XX, 0 },
Ia_btcl_Ed_Gd = { "btc", "btcl", Ed, Gd, XX, XX, 0 },
Ia_btcl_Ed_Ib = { "btc", "btcl", Ed, Ib, XX, XX, 0 },
Ia_btcq_Eq_Gq = { "btc", "btcq", Eq, Gq, XX, XX, 0 },
Ia_btcq_Eq_Ib = { "btc", "btcq", Eq, Ib, XX, XX, 0 },
Ia_btcw_Ew_Gw = { "btc", "btcw", Ew, Gw, XX, XX, 0 },
Ia_btcw_Ew_Ib = { "btc", "btcw", Ew, Ib, XX, XX, 0 },
Ia_btl_Ed_Gd = { "bt", "btl", Ed, Gd, XX, XX, 0 },
Ia_btl_Ed_Ib = { "bt", "btl", Ed, Ib, XX, XX, 0 },
Ia_btq_Eq_Gq = { "bt", "btq", Eq, Gq, XX, XX, 0 },
Ia_btq_Eq_Ib = { "bt", "btq", Eq, Ib, XX, XX, 0 },
Ia_btrl_Ed_Gd = { "btr", "btrl", Ed, Gd, XX, XX, 0 },
Ia_btrl_Ed_Ib = { "btr", "btrl", Ed, Ib, XX, XX, 0 },
Ia_btrq_Eq_Gq = { "btr", "btrq", Eq, Gq, XX, XX, 0 },
Ia_btrq_Eq_Ib = { "btr", "btrq", Eq, Ib, XX, XX, 0 },
Ia_btrw_Ew_Gw = { "btr", "btrw", Ew, Gw, XX, XX, 0 },
Ia_btrw_Ew_Ib = { "btr", "btrw", Ew, Ib, XX, XX, 0 },
Ia_btsl_Ed_Gd = { "bts", "btsl", Ed, Gd, XX, XX, 0 },
Ia_btsl_Ed_Ib = { "bts", "btsl", Ed, Ib, XX, XX, 0 },
Ia_btsq_Eq_Gq = { "bts", "btsq", Eq, Gq, XX, XX, 0 },
Ia_btsq_Eq_Ib = { "bts", "btsq", Eq, Ib, XX, XX, 0 },
Ia_btsw_Ew_Gw = { "bts", "btsw", Ew, Gw, XX, XX, 0 },
Ia_btsw_Ew_Ib = { "bts", "btsw", Ew, Ib, XX, XX, 0 },
Ia_btw_Ew_Gw = { "bt", "btw", Ew, Gw, XX, XX, 0 },
Ia_btw_Ew_Ib = { "bt", "btw", Ew, Ib, XX, XX, 0 },
Ia_bzhi_Gy_Ey_By = { "bzhi", "bzhi", Gy, Ey, By, XX, IA_BMI2 },
Ia_call_Ed = { "call", "call", Ed, XX, XX, XX, 0 },
Ia_call_Eq = { "call", "call", Eq, XX, XX, XX, 0 },
Ia_call_Ew = { "call", "call", Ew, XX, XX, XX, 0 },
Ia_call_Jd = { "call", "call", Jd, XX, XX, XX, 0 },
Ia_call_Jw = { "call", "call", Jw, XX, XX, XX, 0 },
Ia_cbw = { "cbw", "cbtw", XX, XX, XX, XX, 0 },
Ia_cdq = { "cdq", "cltd", XX, XX, XX, XX, 0 },
Ia_cdqe = { "cdqe", "cltq", XX, XX, XX, XX, 0 },
Ia_clflush = { "clflush", "clflush", Mb, XX, XX, XX, IA_CLFLUSH },
Ia_clac = { "clac", "clac", XX, XX, XX, XX, IA_SMAP },
Ia_clc = { "clc", "clc", XX, XX, XX, XX, 0 },
Ia_cld = { "cld", "cld", XX, XX, XX, XX, 0 },
Ia_clgi = { "clgi", "clgi", XX, XX, XX, XX, IA_SVM },
Ia_cli = { "cli", "cli", XX, XX, XX, XX, 0 },
Ia_clts = { "clts", "clts", XX, XX, XX, XX, 0 },
Ia_cmc = { "cmc", "cmc", XX, XX, XX, XX, 0 },
Ia_cmovnbel_Gd_Ed = { "cmovnbe", "cmovnbel", Gd, Ed, XX, XX, IA_P6 },
Ia_cmovnbeq_Gq_Eq = { "cmovnbe", "cmovnbeq", Gq, Eq, XX, XX, 0 },
Ia_cmovnbew_Gw_Ew = { "cmovnbe", "cmovnbew", Gw, Ew, XX, XX, IA_P6 },
Ia_cmovbl_Gd_Ed = { "cmovb", "cmovbl", Gd, Ed, XX, XX, IA_P6 },
Ia_cmovbq_Gq_Eq = { "cmovb", "cmovbq", Gq, Eq, XX, XX, 0 },
Ia_cmovbw_Gw_Ew = { "cmovb", "cmovbw", Gw, Ew, XX, XX, IA_P6 },
Ia_cmovnlel_Gd_Ed = { "cmovnle", "cmovnlel", Gd, Ed, XX, XX, IA_P6 },
Ia_cmovnleq_Gq_Eq = { "cmovnle", "cmovnleq", Gq, Eq, XX, XX, 0 },
Ia_cmovnlew_Gw_Ew = { "cmovnle", "cmovnlew", Gw, Ew, XX, XX, IA_P6 },
Ia_cmovll_Gd_Ed = { "cmovl", "cmovll", Gd, Ed, XX, XX, IA_P6 },
Ia_cmovlq_Gq_Eq = { "cmovl", "cmovlq", Gq, Eq, XX, XX, 0 },
Ia_cmovlw_Gw_Ew = { "cmovl", "cmovlw", Gw, Ew, XX, XX, IA_P6 },
Ia_cmovbel_Gd_Ed = { "cmovbe", "cmovbel", Gd, Ed, XX, XX, IA_P6 },
Ia_cmovbeq_Gq_Eq = { "cmovbe", "cmovbeq", Gq, Eq, XX, XX, 0 },
Ia_cmovbew_Gw_Ew = { "cmovbe", "cmovbew", Gw, Ew, XX, XX, IA_P6 },
Ia_cmovnbl_Gd_Ed = { "cmovnb", "cmovnbl", Gd, Ed, XX, XX, IA_P6 },
Ia_cmovnbq_Gq_Eq = { "cmovnb", "cmovnbq", Gq, Eq, XX, XX, 0 },
Ia_cmovnbw_Gw_Ew = { "cmovnb", "cmovnbw", Gw, Ew, XX, XX, IA_P6 },
Ia_cmovlel_Gd_Ed = { "cmovle", "cmovlel", Gd, Ed, XX, XX, IA_P6 },
Ia_cmovleq_Gq_Eq = { "cmovle", "cmovleq", Gq, Eq, XX, XX, 0 },
Ia_cmovlew_Gw_Ew = { "cmovle", "cmovlew", Gw, Ew, XX, XX, IA_P6 },
Ia_cmovnll_Gd_Ed = { "cmovnl", "cmovnll", Gd, Ed, XX, XX, IA_P6 },
Ia_cmovnlq_Gq_Eq = { "cmovnl", "cmovnlq", Gq, Eq, XX, XX, 0 },
Ia_cmovnlw_Gw_Ew = { "cmovnl", "cmovnlw", Gw, Ew, XX, XX, IA_P6 },
Ia_cmovnol_Gd_Ed = { "cmovno", "cmovnol", Gd, Ed, XX, XX, IA_P6 },
Ia_cmovnoq_Gq_Eq = { "cmovno", "cmovnoq", Gq, Eq, XX, XX, 0 },
Ia_cmovnow_Gw_Ew = { "cmovno", "cmovnow", Gw, Ew, XX, XX, IA_P6 },
Ia_cmovnpl_Gd_Ed = { "cmovnp", "cmovnpl", Gd, Ed, XX, XX, IA_P6 },
Ia_cmovnpq_Gq_Eq = { "cmovnp", "cmovnpq", Gq, Eq, XX, XX, 0 },
Ia_cmovnpw_Gw_Ew = { "cmovnp", "cmovnpw", Gw, Ew, XX, XX, IA_P6 },
Ia_cmovnsl_Gd_Ed = { "cmovns", "cmovnsl", Gd, Ed, XX, XX, IA_P6 },
Ia_cmovnsq_Gq_Eq = { "cmovns", "cmovnsq", Gq, Eq, XX, XX, 0 },
Ia_cmovnsw_Gw_Ew = { "cmovns", "cmovnsw", Gw, Ew, XX, XX, IA_P6 },
Ia_cmovnzl_Gd_Ed = { "cmovnz", "cmovnzl", Gd, Ed, XX, XX, IA_P6 },
Ia_cmovnzq_Gq_Eq = { "cmovnz", "cmovnzq", Gq, Eq, XX, XX, 0 },
Ia_cmovnzw_Gw_Ew = { "cmovnz", "cmovnzw", Gw, Ew, XX, XX, IA_P6 },
Ia_cmovol_Gd_Ed = { "cmovo", "cmovol", Gd, Ed, XX, XX, IA_P6 },
Ia_cmovoq_Gq_Eq = { "cmovo", "cmovoq", Gq, Eq, XX, XX, 0 },
Ia_cmovow_Gw_Ew = { "cmovo", "cmovow", Gw, Ew, XX, XX, IA_P6 },
Ia_cmovpl_Gd_Ed = { "cmovp", "cmovpl", Gd, Ed, XX, XX, IA_P6 },
Ia_cmovpq_Gq_Eq = { "cmovp", "cmovpq", Gq, Eq, XX, XX, 0 },
Ia_cmovpw_Gw_Ew = { "cmovp", "cmovpw", Gw, Ew, XX, XX, IA_P6 },
Ia_cmovsl_Gd_Ed = { "cmovs", "cmovsl", Gd, Ed, XX, XX, IA_P6 },
Ia_cmovsq_Gq_Eq = { "cmovs", "cmovsq", Gq, Eq, XX, XX, 0 },
Ia_cmovsw_Gw_Ew = { "cmovs", "cmovsw", Gw, Ew, XX, XX, IA_P6 },
Ia_cmovzl_Gd_Ed = { "cmovz", "cmovzl", Gd, Ed, XX, XX, IA_P6 },
Ia_cmovzq_Gq_Eq = { "cmovz", "cmovzq", Gq, Eq, XX, XX, 0 },
Ia_cmovzw_Gw_Ew = { "cmovz", "cmovzw", Gw, Ew, XX, XX, IA_P6 },
Ia_cmpb_AL_Ib = { "cmp", "cmpb", AL_Reg, Ib, XX, XX, 0 },
Ia_cmpb_Eb_Gb = { "cmp", "cmpb", Eb, Gb, XX, XX, 0 },
Ia_cmpb_Eb_Ib = { "cmp", "cmpb", Eb, Ib, XX, XX, 0 },
Ia_cmpb_Gb_Eb = { "cmp", "cmpb", Gb, Eb, XX, XX, 0 },
Ia_cmpl_EAX_Id = { "cmp", "cmpl", EAX_Reg, Id, XX, XX, 0 },
Ia_cmpl_Ed_Gd = { "cmp", "cmpl", Ed, Gd, XX, XX, 0 },
Ia_cmpl_Ed_Id = { "cmp", "cmpl", Ed, Id, XX, XX, 0 },
Ia_cmpl_Ed_sIb = { "cmp", "cmpl", Ed, sIbd, XX, XX, 0 },
Ia_cmpl_Gd_Ed = { "cmp", "cmpl", Gd, Ed, XX, XX, 0 },
Ia_cmppd_Vpd_Wpd_Ib = { "cmppd", "cmppd", Vpd, Wpd, Ib, XX, IA_SSE2 },
Ia_cmpps_Vps_Wps_Ib = { "cmpps", "cmpps", Vps, Wps, Ib, XX, IA_SSE },
Ia_cmpq_Eq_Gq = { "cmp", "cmpq", Eq, Gq, XX, XX, 0 },
Ia_cmpq_Eq_sIb = { "cmp", "cmpq", Eq, sIbq, XX, XX, 0 },
Ia_cmpq_Eq_sId = { "cmp", "cmpq", Eq, sIdq, XX, XX, 0 },
Ia_cmpq_Gq_Eq = { "cmp", "cmpq", Gq, Eq, XX, XX, 0 },
Ia_cmpq_RAX_sId = { "cmp", "cmpq", RAX_Reg, sIdq, XX, XX, 0 },
Ia_cmpsb_Xb_Yb = { "cmpsb", "cmpsb", Xb, Yb, XX, XX, 0 },
Ia_cmpsd_Vsd_Wsd_Ib = { "cmpsd", "cmpsd", Vsd, Wsd, Ib, XX, IA_SSE2 },
Ia_cmpsl_Xd_Yd = { "cmpsd", "cmpsl", Xd, Yd, XX, XX, 0 },
Ia_cmpsq_Xq_Yq = { "cmpsq", "cmpsq", Xq, Yq, XX, XX, 0 },
Ia_cmpss_Vss_Wss_Ib = { "cmpss", "cmpss", Vss, Wss, Ib, XX, IA_SSE },
Ia_cmpsw_Xw_Yw = { "cmpsw", "cmpsw", Xw, Yw, XX, XX, 0 },
Ia_cmpw_AX_Iw = { "cmp", "cmpw", AX_Reg, Iw, XX, XX, 0 },
Ia_cmpw_Ew_Gw = { "cmp", "cmpw", Ew, Gw, XX, XX, 0 },
Ia_cmpw_Ew_Iw = { "cmp", "cmpw", Ew, Iw, XX, XX, 0 },
Ia_cmpw_Ew_sIb = { "cmp", "cmpw", Ew, sIbw, XX, XX, 0 },
Ia_cmpw_Gw_Ew = { "cmp", "cmpw", Gw, Ew, XX, XX, 0 },
Ia_cmpxchg16b_Mdq = { "cmpxchg16b", "cmpxchg16b", Mdq, XX, XX, XX, IA_CMPXCHG16B },
Ia_cmpxchg8b_Mq = { "cmpxchg8b", "cmpxchg8b", Mq, XX, XX, XX, IA_PENTIUM },
Ia_cmpxchgb_Eb_Gb = { "cmpxchg", "cmpxchgb", Eb, Gb, XX, XX, IA_486 },
Ia_cmpxchgl_Ed_Gd = { "cmpxchg", "cmpxchgl", Ed, Gd, XX, XX, IA_486 },
Ia_cmpxchgq_Eq_Gq = { "cmpxchg", "cmpxchgq", Eq, Gq, XX, XX, 0 },
Ia_cmpxchgw_Ew_Gw = { "cmpxchg", "cmpxchgw", Ew, Gw, XX, XX, IA_486 },
Ia_comisd_Vsd_Wsd = { "comisd", "comisd", Vsd, Wsd, XX, XX, 0 },
Ia_comiss_Vss_Wss = { "comiss", "comiss", Vss, Wss, XX, XX, 0 },
Ia_cpuid = { "cpuid", "cpuid", XX, XX, XX, XX, IA_486 },
Ia_cqo = { "cqo", "cqto", XX, XX, XX, XX, 0 },
Ia_crc32_Gd_Eb = { "crc32", "crc32", Gd, Eb, XX, XX, IA_SSE4_2 },
Ia_crc32_Gd_Ed = { "crc32", "crc32", Gd, Ed, XX, XX, IA_SSE4_2 },
Ia_crc32_Gd_Eq = { "crc32", "crc32", Gd, Eq, XX, XX, IA_SSE4_2 },
Ia_crc32_Gd_Ew = { "crc32", "crc32", Gd, Ew, XX, XX, IA_SSE4_2 },
Ia_cvtdq2pd_Vpd_Wq = { "cvtdq2pd", "cvtdq2pd", Vpd, Wq, XX, XX, IA_SSE2 },
Ia_cvtdq2ps_Vps_Wdq = { "cvtdq2ps", "cvtdq2ps", Vps, Wdq, XX, XX, IA_SSE2 },
Ia_cvtpd2dq_Vq_Wpd = { "cvtpd2dq", "cvtpd2dq", Vq, Wpd, XX, XX, IA_SSE2 },
Ia_cvtpd2pi_Pq_Wpd = { "cvtpd2pi", "cvtpd2pi", Pq, Wpd, XX, XX, IA_SSE2 },
Ia_cvtpd2ps_Vps_Wpd = { "cvtpd2ps", "cvtpd2ps", Vps, Wpd, XX, XX, IA_SSE2 },
Ia_cvtpi2pd_Vpd_Qq = { "cvtpi2pd", "cvtpi2pd", Vpd, Qq, XX, XX, IA_SSE2 },
Ia_cvtpi2ps_Vps_Qq = { "cvtpi2ps", "cvtpi2ps", Vps, Qq, XX, XX, IA_SSE },
Ia_cvtps2dq_Vdq_Wps = { "cvtps2dq", "cvtps2dq", Vdq, Wps, XX, XX, IA_SSE2 },
Ia_cvtps2pd_Vpd_Wps = { "cvtps2pd", "cvtps2pd", Vpd, Wps, XX, XX, IA_SSE2 },
Ia_cvtps2pi_Pq_Wps = { "cvtps2pi", "cvtps2pi", Pq, Wps, XX, XX, IA_SSE },
Ia_cvtsd2si_Gy_Wsd = { "cvtsd2si", "cvtsd2si", Gy, Wsd, XX, XX, IA_SSE2 },
Ia_cvtsd2ss_Vss_Wsd = { "cvtsd2ss", "cvtsd2ss", Vss, Wsd, XX, XX, IA_SSE2 },
Ia_cvtsi2sd_Vsd_Ey = { "cvtsi2sd", "cvtsi2sd", Vsd, Ey, XX, XX, IA_SSE2 },
Ia_cvtsi2ss_Vss_Ey = { "cvtsi2ss", "cvtsi2ss", Vss, Ey, XX, XX, IA_SSE },
Ia_cvtss2sd_Vsd_Wss = { "cvtss2sd", "cvtss2sd", Vsd, Wss, XX, XX, IA_SSE2 },
Ia_cvtss2si_Gy_Wss = { "cvtss2si", "cvtss2si", Gy, Wss, XX, XX, IA_SSE },
Ia_cvttpd2dq_Vq_Wpd = { "cvttpd2dq", "cvttpd2dq", Vq, Wpd, XX, XX, IA_SSE2 },
Ia_cvttpd2pi_Pq_Wpd = { "cvttpd2pi", "cvttpd2pi", Pq, Wpd, XX, XX, IA_SSE2 },
Ia_cvttps2dq_Vdq_Wps = { "cvttps2dq", "cvttps2dq", Vdq, Wps, XX, XX, IA_SSE2 },
Ia_cvttps2pi_Pq_Wps = { "cvttps2pi", "cvttps2pi", Pq, Wps, XX, XX, IA_SSE },
Ia_cvttsd2si_Gy_Wsd = { "cvttsd2si", "cvttsd2si", Gy, Wsd, XX, XX, IA_SSE2 },
Ia_cvttss2si_Gy_Wss = { "cvttss2si", "cvttss2si", Gy, Wss, XX, XX, IA_SSE },
Ia_cwd = { "cwd", "cwtd", XX, XX, XX, XX, 0 },
Ia_cwde = { "cwde", "cwtl", XX, XX, XX, XX, 0 },
Ia_daa = { "daa", "daa", XX, XX, XX, XX, 0 },
Ia_das = { "das", "das", XX, XX, XX, XX, 0 },
Ia_decb_Eb = { "dec", "decb", Eb, XX, XX, XX, 0 },
Ia_decl_Ed = { "dec", "decl", Ed, XX, XX, XX, 0 },
Ia_decl_ERX = { "dec", "decl", ERX, XX, XX, XX, 0 },
Ia_decq_Eq = { "dec", "decq", Eq, XX, XX, XX, 0 },
Ia_decw_Ew = { "dec", "decw", Ew, XX, XX, XX, 0 },
Ia_decw_RX = { "dec", "decw", RX, XX, XX, XX, 0 },
Ia_divb_AL_Eb = { "div", "divb", AL_Reg, Eb, XX, XX, 0 },
Ia_divl_EAX_Ed = { "div", "divl", EAX_Reg, Ed, XX, XX, 0 },
Ia_divpd_Vpd_Wpd = { "divpd", "divpd", Vpd, Wpd, XX, XX, IA_SSE2 },
Ia_divps_Vps_Wps = { "divps", "divps", Vps, Wps, XX, XX, IA_SSE },
Ia_divq_RAX_Eq = { "div", "divq", RAX_Reg, Eq, XX, XX, 0 },
Ia_divsd_Vsd_Wsd = { "divsd", "divsd", Vsd, Wsd, XX, XX, IA_SSE2 },
Ia_divss_Vss_Wss = { "divss", "divss", Vss, Wss, XX, XX, IA_SSE },
Ia_divw_AX_Ew = { "div", "divw", AX_Reg, Ew, XX, XX, 0 },
Ia_dppd_Vpd_Wpd_Ib = { "dppd", "dppd", Vpd, Wpd, Ib, XX, IA_SSE4_1 },
Ia_dpps_Vps_Wps_Ib = { "dpps", "dpps", Vps, Wps, Ib, XX, IA_SSE4_1 },
Ia_emms = { "emms", "emms", XX, XX, XX, XX, IA_MMX },
Ia_enter = { "enter", "enter", IwIb, XX, XX, XX, 0 },
Ia_error = { "(error)", "(error)", XX, XX, XX, XX, 0 },
Ia_extractps_Ed_Vdq_Ib = { "extractps", "extractps", Ed, Vdq, Ib, XX, IA_SSE4_1 },
Ia_extrq_Udq_Ib_Ib = { "extrq", "extrq", Udq, Ib, Ib, XX, IA_SSE4A },
Ia_extrq_Vdq_Uq = { "extrq", "extrq", Vdq, Uq, XX, XX, IA_SSE4A },
Ia_f2xm1 = { "f2xm1", "f2xm1", XX, XX, XX, XX, IA_X87 },
Ia_fabs = { "fabs", "fabs", XX, XX, XX, XX, IA_X87 },
Ia_fadd_ST0_STi = { "fadd", "fadd", ST0, STi, XX, XX, IA_X87 },
Ia_fadd_STi_ST0 = { "fadd", "fadd", STi, ST0, XX, XX, IA_X87 },
Ia_faddl_Mq = { "fadd", "faddl", Mq, XX, XX, XX, IA_X87 },
Ia_faddp_STi_ST0 = { "faddp", "faddp", STi, ST0, XX, XX, IA_X87 },
Ia_fadds_Md = { "fadd", "fadds", Md, XX, XX, XX, IA_X87 },
Ia_fbldt_Mt = { "fbld", "fbldt", Mt, XX, XX, XX, IA_X87 },
Ia_fbstpt_Mt = { "fbstp", "fbstpt", Mt, XX, XX, XX, IA_X87 },
Ia_fchs = { "fchs", "fchs", XX, XX, XX, XX, IA_X87 },
Ia_fcmovb_ST0_STi = { "fcmovb", "fcmovb", ST0, STi, XX, XX, IA_P6 },
Ia_fcmovbe_ST0_STi = { "fcmovbe", "fcmovbe", ST0, STi, XX, XX, IA_P6 },
Ia_fcmove_ST0_STi = { "fcmove", "fcmove", ST0, STi, XX, XX, IA_P6 },
Ia_fcmovnb_ST0_STi = { "fcmovnb", "fcmovnb", ST0, STi, XX, XX, IA_P6 },
Ia_fcmovnbe_ST0_STi = { "fcmovnbe", "fcmovnbe", ST0, STi, XX, XX, IA_P6 },
Ia_fcmovne_ST0_STi = { "fcmovne", "fcmovne", ST0, STi, XX, XX, IA_P6 },
Ia_fcmovnu_ST0_STi = { "fcmovnu", "fcmovnu", ST0, STi, XX, XX, IA_P6 },
Ia_fcmovu_ST0_STi = { "fcmovu", "fcmovu", ST0, STi, XX, XX, IA_P6 },
Ia_fcom_STi = { "fcom", "fcom", STi, XX, XX, XX, IA_X87 },
Ia_fcomi_ST0_STi = { "fcomi", "fcomi", ST0, STi, XX, XX, IA_P6 },
Ia_fcomip_ST0_STi = { "fcomip", "fcomip", ST0, STi, XX, XX, IA_X87 },
Ia_fcoml_Mq = { "fcom", "fcoml", Mq, XX, XX, XX, IA_X87 },
Ia_fcomp_STi = { "fcomp", "fcomp", STi, XX, XX, XX, IA_X87 },
Ia_fcompl_Mq = { "fcomp", "fcompl", Mq, XX, XX, XX, IA_X87 },
Ia_fcompp = { "fcompp", "fcompp", XX, XX, XX, XX, IA_X87 },
Ia_fcomps_Md = { "fcomp", "fcomps", Md, XX, XX, XX, IA_X87 },
Ia_fcoms_Md = { "fcom", "fcoms", Md, XX, XX, XX, IA_X87 },
Ia_fcos = { "fcos", "fcos", XX, XX, XX, XX, IA_X87 },
Ia_fdecstp = { "fdecstp", "fdecstp", XX, XX, XX, XX, IA_X87 },
Ia_fdisi = { "fdisi (287 legacy)", "fdisi (287 legacy)", XX, XX, XX, XX, IA_X87 },
Ia_fdiv_ST0_STi = { "fdiv", "fdiv", ST0, STi, XX, XX, IA_X87 },
Ia_fdiv_STi_ST0 = { "fdiv", "fdiv", STi, ST0, XX, XX, IA_X87 },
Ia_fdivl_Mq = { "fdiv", "fdivl", Mq, XX, XX, XX, IA_X87 },
Ia_fdivp_STi_ST0 = { "fdivp", "fdivp", STi, ST0, XX, XX, IA_X87 },
Ia_fdivr_ST0_STi = { "fdivr", "fdivr", ST0, STi, XX, XX, IA_X87 },
Ia_fdivr_STi_ST0 = { "fdivr", "fdivr", STi, ST0, XX, XX, IA_X87 },
Ia_fdivrl_Mq = { "fdivr", "fdivrl", Mq, XX, XX, XX, IA_X87 },
Ia_fdivrp_STi_ST0 = { "fdivrp", "fdivrp", STi, ST0, XX, XX, IA_X87 },
Ia_fdivrs_Md = { "fdivr", "fdivrs", Md, XX, XX, XX, IA_X87 },
Ia_fdivs_Md = { "fdiv", "fdivs", Md, XX, XX, XX, IA_X87 },
Ia_femms = { "femms", "femms", XX, XX, XX, XX, IA_3DNOW },
Ia_feni = { "feni (287 legacy)", "feni(287 legacy)", XX, XX, XX, XX, IA_X87 },
Ia_ffree_STi = { "ffree", "ffree", STi, XX, XX, XX, IA_X87 },
Ia_ffreep_STi = { "ffreep", "ffreep", STi, XX, XX, XX, IA_X87 },
Ia_fiaddl_Md = { "fiadd", "fiaddl", Md, XX, XX, XX, IA_X87 },
Ia_fiadds_Mw = { "fiadd", "fiadds", Mw, XX, XX, XX, IA_X87 },
Ia_ficoml_Md = { "ficom", "ficoml", Md, XX, XX, XX, IA_X87 },
Ia_ficompl_Md = { "ficomp", "ficompl", Md, XX, XX, XX, IA_X87 },
Ia_ficomps_Mw = { "ficomp", "ficomps", Mw, XX, XX, XX, IA_X87 },
Ia_ficoms_Mw = { "ficom", "ficoms", Mw, XX, XX, XX, IA_X87 },
Ia_fidivl_Md = { "fidiv", "fidivl", Md, XX, XX, XX, IA_X87 },
Ia_fidivrl_Md = { "fidivr", "fidivrl", Md, XX, XX, XX, IA_X87 },
Ia_fidivrs_Mw = { "fidivr", "fidivrs", Mw, XX, XX, XX, IA_X87 },
Ia_fidivs_Mw = { "fidiv", "fidivs", Mw, XX, XX, XX, IA_X87 },
Ia_fildl_Md = { "fild", "fildl", Md, XX, XX, XX, IA_X87 },
Ia_fildq_Mq = { "fild", "fildq", Mq, XX, XX, XX, IA_X87 },
Ia_filds_Mw = { "fild", "filds", Mw, XX, XX, XX, IA_X87 },
Ia_fimull_Md = { "fimul", "fimull", Md, XX, XX, XX, IA_X87 },
Ia_fimuls_Mw = { "fimul", "fimuls", Mw, XX, XX, XX, IA_X87 },
Ia_fincstp = { "fincstp", "fincstp", XX, XX, XX, XX, IA_X87 },
Ia_fistl_Md = { "fist", "fistl", Md, XX, XX, XX, IA_X87 },
Ia_fistpl_Md = { "fistp", "fistpl", Md, XX, XX, XX, IA_X87 },
Ia_fistpq_Mq = { "fistp", "fistpq", Mq, XX, XX, XX, IA_X87 },
Ia_fistps_Mw = { "fistp", "fistps", Mw, XX, XX, XX, IA_X87 },
Ia_fists_Mw = { "fist", "fists", Mw, XX, XX, XX, IA_X87 },
Ia_fisttpl_Md = { "fisttp", "fisttpl", Md, XX, XX, XX, IA_SSE3 },
Ia_fisttpq_Mq = { "fisttp", "fisttpq", Mq, XX, XX, XX, IA_SSE3 },
Ia_fisttps_Mw = { "fisttp", "fisttps", Mw, XX, XX, XX, IA_SSE3 },
Ia_fisubl_Md = { "fisub", "fisubl", Md, XX, XX, XX, IA_X87 },
Ia_fisubrl_Md = { "fisubr", "fisubrl", Md, XX, XX, XX, IA_X87 },
Ia_fisubrs_Mw = { "fisubr", "fisubrs", Mw, XX, XX, XX, IA_X87 },
Ia_fisubs_Mw = { "fisub", "fisubs", Mw, XX, XX, XX, IA_X87 },
Ia_fld_STi = { "fld", "fld", STi, XX, XX, XX, IA_X87 },
Ia_fld1 = { "fld1", "fld1", XX, XX, XX, XX, IA_X87 },
Ia_fldcw = { "fldcw", "fldcw", Ew, XX, XX, XX, IA_X87 },
Ia_fldenv = { "fldenv", "fldenv", Mx, XX, XX, XX, IA_X87 },
Ia_fldl_Mq = { "fld", "fldl", Mq, XX, XX, XX, IA_X87 },
Ia_fldl2e = { "fldl2e", "fldl2e", XX, XX, XX, XX, IA_X87 },
Ia_fldl2t = { "fldl2t", "fldl2t", XX, XX, XX, XX, IA_X87 },
Ia_fldlg2 = { "fldlg2", "fldlg2", XX, XX, XX, XX, IA_X87 },
Ia_fldln2 = { "fldln2", "fldln2", XX, XX, XX, XX, IA_X87 },
Ia_fldpi = { "fldpi", "fldpi", XX, XX, XX, XX, IA_X87 },
Ia_flds_Md = { "fld", "flds", Md, XX, XX, XX, IA_X87 },
Ia_fldt_Mt = { "fld", "fldt", Mt, XX, XX, XX, IA_X87 },
Ia_fldz = { "fldz", "fldz", XX, XX, XX, XX, IA_X87 },
Ia_fmul_ST0_STi = { "fmul", "fmul", ST0, STi, XX, XX, IA_X87 },
Ia_fmul_STi_ST0 = { "fmul", "fmul", STi, ST0, XX, XX, IA_X87 },
Ia_fmull_Mq = { "fmul", "fmull", Mq, XX, XX, XX, IA_X87 },
Ia_fmulp_STi_ST0 = { "fmulp", "fmulp", STi, ST0, XX, XX, IA_X87 },
Ia_fmuls_Md = { "fmul", "fmuls", Md, XX, XX, XX, IA_X87 },
Ia_fnclex = { "fnclex", "fnclex", XX, XX, XX, XX, IA_X87 },
Ia_fninit = { "fninit", "fninit", XX, XX, XX, XX, IA_X87 },
Ia_fnop = { "fnop", "fnop", XX, XX, XX, XX, IA_X87 },
Ia_fnsave = { "fnsave", "fnsave", Mx, XX, XX, XX, IA_X87 },
Ia_fnstcw = { "fnstcw", "fnstcw", Mw, XX, XX, XX, IA_X87 },
Ia_fnstenv = { "fnstenv", "fnstenv", Mx, XX, XX, XX, IA_X87 },
Ia_fnstsw = { "fnstsw", "fnstsw", Mw, XX, XX, XX, IA_X87 },
Ia_fnstsw_AX = { "fnstsw", "fnstsw", AX_Reg, XX, XX, XX, IA_X87 },
Ia_fpatan = { "fpatan", "fpatan", XX, XX, XX, XX, IA_X87 },
Ia_fprem = { "fprem", "fprem", XX, XX, XX, XX, IA_X87 },
Ia_fprem1 = { "fprem1", "fprem1", XX, XX, XX, XX, IA_X87 },
Ia_fptan = { "fptan", "fptan", XX, XX, XX, XX, IA_X87 },
Ia_frczpd_Vpd_Wpd = { "frczpd", "frczpd", Vpd, Wpd, XX, XX, IA_XOP },
Ia_frczps_Vps_Wps = { "frczps", "frczps", Vps, Wps, XX, XX, IA_XOP },
Ia_frczsd_Vsd_Wsd = { "frczsd", "frczsd", Vsd, Wsd, XX, XX, IA_XOP },
Ia_frczss_Vss_Wss = { "frczss", "frczss", Vss, Wss, XX, XX, IA_XOP },
Ia_frndint = { "frndint", "frndint", XX, XX, XX, XX, IA_X87 },
Ia_frstor = { "frstor", "frstor", Mx, XX, XX, XX, IA_X87 },
Ia_fscale = { "fscale", "fscale", XX, XX, XX, XX, IA_X87 },
Ia_fsetpm = { "fsetpm (287 legacy)", "fsetpm (287 legacy)", XX, XX, XX, XX, IA_X87 },
Ia_fsin = { "fsin", "fsin", XX, XX, XX, XX, IA_X87 },
Ia_fsincos = { "fsincos", "fsincos", XX, XX, XX, XX, IA_X87 },
Ia_fsqrt = { "fsqrt", "fsqrt", XX, XX, XX, XX, IA_X87 },
Ia_fst_STi = { "fst", "fst", STi, XX, XX, XX, IA_X87 },
Ia_fstl_Mq = { "fst", "fstl", Mq, XX, XX, XX, IA_X87 },
Ia_fstp_STi = { "fstp", "fstp", STi, XX, XX, XX, IA_X87 },
Ia_fstpl_Mq = { "fstp", "fstpl", Mq, XX, XX, XX, IA_X87 },
Ia_fstps_Md = { "fstp", "fstps", Md, XX, XX, XX, IA_X87 },
Ia_fstpt_Mt = { "fstp", "fstpt", Mt, XX, XX, XX, IA_X87 },
Ia_fsts_Md = { "fst", "fsts", Md, XX, XX, XX, IA_X87 },
Ia_fsub_ST0_STi = { "fsub", "fsub", ST0, STi, XX, XX, IA_X87 },
Ia_fsub_STi_ST0 = { "fsub", "fsub", STi, ST0, XX, XX, IA_X87 },
Ia_fsubl_Mq = { "fsub", "fsubl", Mq, XX, XX, XX, IA_X87 },
Ia_fsubp_STi_ST0 = { "fsubp", "fsubp", STi, ST0, XX, XX, IA_X87 },
Ia_fsubr_ST0_STi = { "fsubr", "fsubr", ST0, STi, XX, XX, IA_X87 },
Ia_fsubr_STi_ST0 = { "fsubr", "fsubr", STi, ST0, XX, XX, IA_X87 },
Ia_fsubrl_Mq = { "fsubr", "fsubrl", Mq, XX, XX, XX, IA_X87 },
Ia_fsubrp_STi_ST0 = { "fsubrp", "fsubrp", STi, ST0, XX, XX, IA_X87 },
Ia_fsubrs_Md = { "fsubr", "fsubrs", Md, XX, XX, XX, IA_X87 },
Ia_fsubs_Md = { "fsub", "fsubs", Md, XX, XX, XX, IA_X87 },
Ia_ftst = { "ftst", "ftst", XX, XX, XX, XX, IA_X87 },
Ia_fucom_STi = { "fucom", "fucom", STi, XX, XX, XX, IA_X87 },
Ia_fucomi_ST0_STi = { "fucomi", "fucomi", ST0, STi, XX, XX, IA_P6 },
Ia_fucomip_ST0_STi = { "fucomip", "fucomip", ST0, STi, XX, XX, IA_P6 },
Ia_fucomp_STi = { "fucomp", "fucomp", STi, XX, XX, XX, IA_X87 },
Ia_fucompp = { "fucompp", "fucompp", XX, XX, XX, XX, IA_X87 },
Ia_fwait = { "fwait", "fwait", XX, XX, XX, XX, IA_X87 },
Ia_fxam = { "fxam", "fxam", XX, XX, XX, XX, IA_X87 },
Ia_fxch = { "fxch", "fxch", STi, XX, XX, XX, IA_X87 },
Ia_fxrstor = { "fxrstor", "fxrstor", Mx, XX, XX, XX, IA_SSE },
Ia_fxsave = { "fxsave", "fxsave", Mx, XX, XX, XX, IA_SSE },
Ia_fxtract = { "fxtract", "fxtract", XX, XX, XX, XX, IA_X87 },
Ia_fyl2x = { "fyl2x", "fyl2x", XX, XX, XX, XX, IA_X87 },
Ia_fyl2xp1 = { "fyl2xp1", "fyl2xp1", XX, XX, XX, XX, IA_X87 },
Ia_getsec = { "getsec", "getsec", XX, XX, XX, XX, IA_SMX },
Ia_haddpd_Vpd_Wpd = { "haddpd", "haddpd", Vpd, Wpd, XX, XX, IA_SSE3 },
Ia_haddps_Vps_Wps = { "haddps", "haddps", Vps, Wps, XX, XX, IA_SSE3 },
Ia_hlt = { "hlt", "hlt", XX, XX, XX, XX, 0 },
Ia_hsubpd_Vpd_Wpd = { "hsubpd", "hsubpd", Vpd, Wpd, XX, XX, IA_SSE3 },
Ia_hsubps_Vps_Wps = { "hsubps", "hsubps", Vps, Wps, XX, XX, IA_SSE3 },
Ia_idivb_AL_Eb = { "idiv", "idivb", AL_Reg, Eb, XX, XX, 0 },
Ia_idivl_EAX_Ed = { "idiv", "idivl", EAX_Reg, Ed, XX, XX, 0 },
Ia_idivq_RAX_Eq = { "idiv", "idivq", RAX_Reg, Eq, XX, XX, 0 },
Ia_idivw_AX_Ew = { "idiv", "idivw", AX_Reg, Ew, XX, XX, 0 },
Ia_imulb_AL_Eb = { "imul", "imulb", AL_Reg, Eb, XX, XX, 0 },
Ia_imull_EAX_Ed = { "imul", "imull", EAX_Reg, Ed, XX, XX, 0 },
Ia_imull_Gd_Ed = { "imul", "imull", Gd, Ed, XX, XX, 0 },
Ia_imull_Gd_Ed_Id = { "imul", "imull", Gd, Ed, Id, XX, 0 },
Ia_imull_Gd_Ed_sIb = { "imul", "imull", Gd, Ed, sIbd, XX, 0 },
Ia_imulq_Gq_Eq = { "imul", "imulq", Gq, Eq, XX, XX, 0 },
Ia_imulq_Gq_Eq_sIb = { "imul", "imulq", Gq, Eq, sIbq, XX, 0 },
Ia_imulq_Gq_Eq_sId = { "imul", "imulq", Gq, Eq, sIdq, XX, 0 },
Ia_imulq_RAX_Eq = { "imul", "imulq", RAX_Reg, Eq, XX, XX, 0 },
Ia_imulw_AX_Ew = { "imul", "imulw", AX_Reg, Ew, XX, XX, 0 },
Ia_imulw_Gw_Ew = { "imul", "imulw", Gw, Ew, XX, XX, 0 },
Ia_imulw_Gw_Ew_Iw = { "imul", "imulw", Gw, Ew, Iw, XX, 0 },
Ia_imulw_Gw_Ew_sIb = { "imul", "imulw", Gw, Ew, sIbw, XX, 0 },
Ia_inb_AL_DX = { "in", "inb", AL_Reg, DX_Reg, XX, XX, 0 },
Ia_inb_AL_Ib = { "in", "inb", AL_Reg, Ib, XX, XX, 0 },
Ia_incb_Eb = { "inc", "incb", Eb, XX, XX, XX, 0 },
Ia_incl_Ed = { "inc", "incl", Ed, XX, XX, XX, 0 },
Ia_incl_ERX = { "inc", "incl", ERX, XX, XX, XX, 0 },
Ia_incq_Eq = { "inc", "incq", Eq, XX, XX, XX, 0 },
Ia_incw_Ew = { "inc", "incw", Ew, XX, XX, XX, 0 },
Ia_incw_RX = { "inc", "incw", RX, XX, XX, XX, 0 },
Ia_inl_EAX_DX = { "in", "inl", EAX_Reg, DX_Reg, XX, XX, 0 },
Ia_inl_EAX_Ib = { "in", "inl", EAX_Reg, Ib, XX, XX, 0 },
Ia_insb_Yb_DX = { "insb", "insb", Yb, DX_Reg, XX, XX, 0 },
Ia_insertps_Vps_Wss_Ib = { "insertps", "insertps", Vps, Wss, Ib, XX, IA_SSE4_1 },
Ia_insertq_Vdq_Udq = { "insertq", "insertq", Vdq, Udq, XX, XX, IA_SSE4A },
Ia_insertq_Vdq_Uq_Ib_Ib = { "insertq", "insertq", Vdq, Uq, Ib, Ib, IA_SSE4A },
Ia_insl_Yd_DX = { "insd", "insl", Yd, DX_Reg, XX, XX, 0 },
Ia_insw_Yw_DX = { "insw", "insw", Yw, DX_Reg, XX, XX, 0 },
Ia_int_Ib = { "int", "int", Ib, XX, XX, XX, 0 },
Ia_int1 = { "int1", "int1", XX, XX, XX, XX, 0 },
Ia_int3 = { "int3", "int3", XX, XX, XX, XX, 0 },
Ia_into = { "into", "into", XX, XX, XX, XX, 0 },
Ia_Invalid = { "(invalid)", "(invalid)", XX, XX, XX, XX, 0 },
Ia_invd = { "invd", "invd", XX, XX, XX, XX, IA_486 },
Ia_invept_Gy_Mdq = { "invept", "invept", Gy, Mdq, XX, XX, IA_VMX },
Ia_invlpg = { "invlpg", "invlpg", Mx, XX, XX, XX, IA_486 },
Ia_invlpga  = { "invlpga", "invlpga", RAX_Reg, RCX_Reg, XX, XX, IA_SVM },
Ia_invpcid_Gy_Mdq = { "invpcid", "invpcid", Gy, Mdq, XX, XX, IA_INVPCID },
Ia_invvpid_Gy_Mdq = { "invvpid", "invvpid", Gy, Mdq, XX, XX, IA_VMX },
Ia_inw_AX_DX = { "in", "inw", AX_Reg, DX_Reg, XX, XX, 0 },
Ia_inw_AX_Ib = { "in", "inw", AX_Reg, Ib, XX, XX, 0 },
Ia_iretl = { "iret", "iretd", XX, XX, XX, XX, 0 },
Ia_iretq = { "iret", "iretq", XX, XX, XX, XX, 0 },
Ia_iretw = { "iret", "iretw", XX, XX, XX, XX, 0 },
Ia_jb_Jb = { "jb", "jb", Jb, XX, XX, XX, 0 },
Ia_jb_Jd = { "jb", "jb", Jd, XX, XX, XX, 0 },
Ia_jb_Jw = { "jb", "jb", Jw, XX, XX, XX, 0 },
Ia_jbe_Jb = { "jbe", "jbe", Jb, XX, XX, XX, 0 },
Ia_jbe_Jd = { "jbe", "jbe", Jd, XX, XX, XX, 0 },
Ia_jbe_Jw = { "jbe", "jbe", Jw, XX, XX, XX, 0 },
Ia_jcxz_Jb = { "jcxz", "jcxz", Jb, XX, XX, XX, 0 },
Ia_jecxz_Jb = { "jecxz", "jecxz", Jb, XX, XX, XX, 0 },
Ia_jl_Jb = { "jl", "jl", Jb, XX, XX, XX, 0 },
Ia_jl_Jd = { "jl", "jl", Jd, XX, XX, XX, 0 },
Ia_jl_Jw = { "jl", "jl", Jw, XX, XX, XX, 0 },
Ia_jle_Jb = { "jle", "jle", Jb, XX, XX, XX, 0 },
Ia_jle_Jd = { "jle", "jle", Jd, XX, XX, XX, 0 },
Ia_jle_Jw = { "jle", "jle", Jw, XX, XX, XX, 0 },
Ia_jmp_Ed = { "jmp", "jmp", Ed, XX, XX, XX, 0 },
Ia_jmp_Eq = { "jmp", "jmp", Eq, XX, XX, XX, 0 },
Ia_jmp_Ew = { "jmp", "jmp", Ew, XX, XX, XX, 0 },
Ia_jmp_Jb = { "jmp", "jmp", Jb, XX, XX, XX, 0 },
Ia_jmp_Jd = { "jmp", "jmp", Jd, XX, XX, XX, 0 },
Ia_jmp_Jw = { "jmp", "jmp", Jw, XX, XX, XX, 0 },
Ia_jnb_Jb = { "jnb", "jnb", Jb, XX, XX, XX, 0 },
Ia_jnb_Jd = { "jnb", "jnb", Jd, XX, XX, XX, 0 },
Ia_jnb_Jw = { "jnb", "jnb", Jw, XX, XX, XX, 0 },
Ia_jnbe_Jb = { "jnbe", "jnbe", Jb, XX, XX, XX, 0 },
Ia_jnbe_Jd = { "jnbe", "jnbe", Jd, XX, XX, XX, 0 },
Ia_jnbe_Jw = { "jnbe", "jnbe", Jw, XX, XX, XX, 0 },
Ia_jnl_Jb = { "jnl", "jnl", Jb, XX, XX, XX, 0 },
Ia_jnl_Jd = { "jnl", "jnl", Jd, XX, XX, XX, 0 },
Ia_jnl_Jw = { "jnl", "jnl", Jw, XX, XX, XX, 0 },
Ia_jnle_Jb = { "jnle", "jnle", Jb, XX, XX, XX, 0 },
Ia_jnle_Jd = { "jnle", "jnle", Jd, XX, XX, XX, 0 },
Ia_jnle_Jw = { "jnle", "jnle", Jw, XX, XX, XX, 0 },
Ia_jno_Jb = { "jno", "jno", Jb, XX, XX, XX, 0 },
Ia_jno_Jd = { "jno", "jno", Jd, XX, XX, XX, 0 },
Ia_jno_Jw = { "jno", "jno", Jw, XX, XX, XX, 0 },
Ia_jnp_Jb = { "jnp", "jnp", Jb, XX, XX, XX, 0 },
Ia_jnp_Jd = { "jnp", "jnp", Jd, XX, XX, XX, 0 },
Ia_jnp_Jw = { "jnp", "jnp", Jw, XX, XX, XX, 0 },
Ia_jns_Jb = { "jns", "jns", Jb, XX, XX, XX, 0 },
Ia_jns_Jd = { "jns", "jns", Jd, XX, XX, XX, 0 },
Ia_jns_Jw = { "jns", "jns", Jw, XX, XX, XX, 0 },
Ia_jnz_Jb = { "jnz", "jnz", Jb, XX, XX, XX, 0 },
Ia_jnz_Jd = { "jnz", "jnz", Jd, XX, XX, XX, 0 },
Ia_jnz_Jw = { "jnz", "jnz", Jw, XX, XX, XX, 0 },
Ia_jo_Jb = { "jo", "jo", Jb, XX, XX, XX, 0 },
Ia_jo_Jd = { "jo", "jo", Jd, XX, XX, XX, 0 },
Ia_jo_Jw = { "jo", "jo", Jw, XX, XX, XX, 0 },
Ia_jp_Jb = { "jp", "jp", Jb, XX, XX, XX, 0 },
Ia_jp_Jd = { "jp", "jp", Jd, XX, XX, XX, 0 },
Ia_jp_Jw = { "jp", "jp", Jw, XX, XX, XX, 0 },
Ia_jrcxz_Jb = { "jrcxz", "jrcxz", Jb, XX, XX, XX, 0 },
Ia_js_Jb = { "js", "js", Jb, XX, XX, XX, 0 },
Ia_js_Jd = { "js", "js", Jd, XX, XX, XX, 0 },
Ia_js_Jw = { "js", "js", Jw, XX, XX, XX, 0 },
Ia_jz_Jb = { "jz", "jz", Jb, XX, XX, XX, 0 },
Ia_jz_Jd = { "jz", "jz", Jd, XX, XX, XX, 0 },
Ia_jz_Jw = { "jz", "jz", Jw, XX, XX, XX, 0 },
Ia_lahf = { "lahf", "lahf", XX, XX, XX, XX, 0 },
Ia_larl_Gd_Ew = { "lar", "larl", Gd, Ew, XX, XX, 0 },
Ia_larq_Gq_Ew = { "lar", "larq", Gq, Ew, XX, XX, 0 },
Ia_larw_Gw_Ew = { "lar", "larw", Gw, Ew, XX, XX, 0 },
Ia_lcall_Apd = { "callf", "lcall", Apd, XX, XX, XX, 0 },
Ia_lcall_Apw = { "callf", "lcall", Apw, XX, XX, XX, 0 },
Ia_lcall_Mp = { "callf", "lcall", Mp, XX, XX, XX, 0 },
Ia_lddqu_Vdq_Mdq = { "lddqu", "lddqu", Vdq, Mdq, XX, XX, IA_SSE3 },
Ia_ldmxcsr = { "ldmxcsr", "ldmxcsr", Md, XX, XX, XX, IA_SSE },
Ia_ldsl_Gd_Mp = { "lds", "ldsl", Gd, Mp, XX, XX, 0 },
Ia_ldsw_Gw_Mp = { "lds", "ldsw", Gw, Mp, XX, XX, 0 },
Ia_leal_Gd_Md = { "lea", "leal", Gd, Md, XX, XX, 0 },
Ia_leaq_Gq_Mq = { "lea", "leaq", Gq, Mq, XX, XX, 0 },
Ia_leave = { "leave", "leave", XX, XX, XX, XX, 0 },
Ia_leaw_Gw_Mw = { "lea", "leaw", Gw, Mw, XX, XX, 0 },
Ia_lesl_Gd_Mp = { "les", "lesl", Gd, Mp, XX, XX, 0 },
Ia_lesw_Gw_Mp = { "les", "lesw", Gw, Mp, XX, XX, 0 },
Ia_lfence = { "lfence", "lfence", XX, XX, XX, XX, IA_SSE2 },
Ia_lfsl_Gd_Mp = { "lfs", "lfsl", Gd, Mp, XX, XX, 0 },
Ia_lfsq_Gq_Mp = { "lfs", "lfsq", Gq, Mp, XX, XX, 0 },
Ia_lfsw_Gw_Mp = { "lfs", "lfsw", Gw, Mp, XX, XX, 0 },
Ia_lgdt = { "lgdt", "lgdt", Ms, XX, XX, XX, 0 },
Ia_lgsl_Gd_Mp = { "lgs", "lgsl", Gd, Mp, XX, XX, 0 },
Ia_lgsq_Gq_Mp = { "lgs", "lgsq", Gq, Mp, XX, XX, 0 },
Ia_lgsw_Gw_Mp = { "lgs", "lgsw", Gw, Mp, XX, XX, 0 },
Ia_lidt = { "lidt", "lidt", Ms, XX, XX, XX, 0 },
Ia_ljmp_Apd = { "jmpf", "ljmp", Apd, XX, XX, XX, 0 },
Ia_ljmp_Apw = { "jmpf", "ljmp", Apw, XX, XX, XX, 0 },
Ia_ljmp_Mp = { "jmpf", "ljmp", Mp, XX, XX, XX, 0 },
Ia_lldt = { "lldt", "lldt", Ew, XX, XX, XX, 0 },
Ia_lmsw_Ew = { "lmsw", "lmsw", Ew, XX, XX, XX, 0 },
Ia_lodsb_AL_Xb = { "lodsb", "lodsb", AL_Reg, Xb, XX, XX, 0 },
Ia_lodsl_EAX_Xd = { "lodsd", "lodsl", EAX_Reg, Xd, XX, XX, 0 },
Ia_lodsq_RAX_Xq = { "lodsq", "lodsq", RAX_Reg, Xq, XX, XX, 0 },
Ia_lodsw_AX_Xw = { "lodsw", "lodsw", AX_Reg, Xw, XX, XX, 0 },
Ia_loop_Jb = { "loop", "loop", Jb, XX, XX, XX, 0 },
Ia_loope_Jb = { "loope", "loope", Jb, XX, XX, XX, 0 },
Ia_loopne_Jb = { "loopne", "loopne", Jb, XX, XX, XX, 0 },
Ia_lret = { "retf", "lret", XX, XX, XX, XX, 0 },
Ia_lret_Iw = { "retf", "lret", Iw, XX, XX, XX, 0 },
Ia_lsll_Gd_Ew = { "lsl", "lsll", Gd, Ew, XX, XX, 0 },
Ia_lslq_Gq_Ew = { "lsl", "lslq", Gq, Ew, XX, XX, 0 },
Ia_lslw_Gw_Ew = { "lsl", "lslw", Gw, Ew, XX, XX, 0 },
Ia_lssl_Gd_Mp = { "lss", "lssl", Gd, Mp, XX, XX, 0 },
Ia_lssq_Gq_Mp = { "lss", "lssq", Gq, Mp, XX, XX, 0 },
Ia_lssw_Gw_Mp = { "lss", "lssw", Gw, Mp, XX, XX, 0 },
Ia_ltr = { "ltr", "ltr", Ew, XX, XX, XX, 0 },
Ia_lzcntl_Gd_Ed = { "lzcnt", "lzcntl", Gd, Ed, XX, XX, IA_LZCNT },
Ia_lzcntq_Gq_Eq = { "lzcnt", "lzcntq", Gq, Eq, XX, XX, IA_LZCNT },
Ia_lzcntw_Gw_Ew = { "lzcnt", "lzcntw", Gw, Ew, XX, XX, IA_LZCNT },
Ia_maskmovdqu_Vdq_Udq = { "maskmovdqu", "maskmovdqu", Vdq, Udq, sYdq, XX, IA_SSE2 },
Ia_maskmovq_Pq_Nq = { "maskmovq", "maskmovq", Pq, Nq, sYq, XX, IA_3DNOW | IA_SSE },
Ia_maxpd_Vpd_Wpd = { "maxpd", "maxpd", Vpd, Wpd, XX, XX, IA_SSE2 },
Ia_maxps_Vps_Wps = { "maxps", "maxps", Vps, Wps, XX, XX, IA_SSE },
Ia_maxsd_Vsd_Wsd = { "maxsd", "maxsd", Vsd, Wsd, XX, XX, IA_SSE2 },
Ia_maxss_Vss_Wss = { "maxss", "maxss", Vss, Wss, XX, XX, IA_SSE },
Ia_mfence = { "mfence", "mfence", XX, XX, XX, XX, IA_SSE2 },
Ia_minpd_Vpd_Wpd = { "minpd", "minpd", Vpd, Wpd, XX, XX, IA_SSE2 },
Ia_minps_Vps_Wps = { "minps", "minps", Vps, Wps, XX, XX, IA_SSE },
Ia_minsd_Vsd_Wsd = { "minsd", "minsd", Vsd, Wsd, XX, XX, IA_SSE2 },
Ia_minss_Vss_Wss = { "minss", "minss", Vss, Wss, XX, XX, IA_SSE },
Ia_monitor = { "monitor", "monitor", XX, XX, XX, XX, IA_MONITOR_MWAIT },
Ia_movapd_Vpd_Wpd = { "movapd", "movapd", Vpd, Wpd, XX, XX, IA_SSE2 },
Ia_movapd_Wpd_Vpd = { "movapd", "movapd", Wpd, Vpd, XX, XX, IA_SSE2 },
Ia_movaps_Vps_Wps = { "movaps", "movaps", Vps, Wps, XX, XX, IA_SSE },
Ia_movaps_Wps_Vps = { "movaps", "movaps", Wps, Vps, XX, XX, IA_SSE },
Ia_movb_AL_Ob = { "mov", "movb", AL_Reg, Ob, XX, XX, 0 },
Ia_movb_Eb_Gb = { "mov", "movb", Eb, Gb, XX, XX, 0 },
Ia_movb_Eb_Ib = { "mov", "movb", Eb, Ib, XX, XX, 0 },
Ia_movb_Gb_Eb = { "mov", "movb", Gb, Eb, XX, XX, 0 },
Ia_movb_Ob_AL = { "mov", "movb", Ob, AL_Reg, XX, XX, 0 },
Ia_movb_R8_Ib = { "mov", "movb", Reg8, Ib, XX, XX, 0 },
Ia_movbe_Gd_Md = { "movbe", "movbel", Gd, Md, XX, XX, IA_MOVBE },
Ia_movbe_Gq_Mq = { "movbe", "movbeq", Gq, Mq, XX, XX, IA_MOVBE },
Ia_movbe_Gw_Mw = { "movbe", "movbew", Gw, Mw, XX, XX, IA_MOVBE },
Ia_movbe_Md_Gd = { "movbe", "movbel", Md, Gd, XX, XX, IA_MOVBE },
Ia_movbe_Mq_Gq = { "movbe", "movbeq", Mq, Gq, XX, XX, IA_MOVBE },
Ia_movbe_Mw_Gw = { "movbe", "movbew", Mw, Gw, XX, XX, IA_MOVBE },
Ia_movd_Ed_Pq = { "movd", "movd", Ed, Pq, XX, XX, IA_MMX },
Ia_movd_Ed_Vd = { "movd", "movd", Ed, Vdq, XX, XX, IA_SSE2 },
Ia_movd_Pq_Ed = { "movd", "movd", Pq, Ed, XX, XX, IA_MMX },
Ia_movd_Vdq_Ed = { "movd", "movd", Vdq, Ed, XX, XX, IA_SSE2 },
Ia_movddup_Vdq_Wq = { "movddup", "movddup", Vdq, Wq, XX, XX, IA_SSE3 },
Ia_movdq2q_Pq_Udq = { "movdq2q", "movdq2q", Pq, Udq, XX, XX, IA_SSE2 },
Ia_movdqa_Vdq_Wdq = { "movdqa", "movdqa", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_movdqa_Wdq_Vdq = { "movdqa", "movdqa", Wdq, Vdq, XX, XX, IA_SSE2 },
Ia_movdqu_Vdq_Wdq = { "movdqu", "movdqu", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_movdqu_Wdq_Vdq = { "movdqu", "movdqu", Wdq, Vdq, XX, XX, IA_SSE2 },
Ia_movhlpd_Vpd_Udq = { "movhlpd", "movhlpd", Vpd, Udq, XX, XX, IA_SSE2 },
Ia_movhlps_Vps_Udq = { "movhlps", "movhlps", Vps, Udq, XX, XX, IA_SSE },
Ia_movhpd_Mq_Vpd = { "movhpd", "movhpd", Mq, Vpd, XX, XX, IA_SSE2 },
Ia_movhpd_Vpd_Mq = { "movhpd", "movhpd", Vpd, Mq, XX, XX, IA_SSE2 },
Ia_movhps_Mq_Vps = { "movhps", "movhps", Mq, Vps, XX, XX, IA_SSE },
Ia_movhps_Vps_Mq = { "movhps", "movhps", Vps, Mq, XX, XX, IA_SSE },
Ia_movl_Cd_Rd = { "mov", "movl", Cd, Rd, XX, XX, 0 },
Ia_movl_Dd_Rd = { "mov", "movl", Dd, Rd, XX, XX, 0 },
Ia_movl_EAX_Od = { "mov", "movl", EAX_Reg, Od, XX, XX, 0 },
Ia_movl_Ed_Gd = { "mov", "movl", Ed, Gd, XX, XX, 0 },
Ia_movl_Ed_Id = { "mov", "movl", Ed, Id, XX, XX, 0 },
Ia_movl_ERX_Id = { "mov", "movl", ERX, Id, XX, XX, 0 },
Ia_movl_Gd_Ed = { "mov", "movl", Gd, Ed, XX, XX, 0 },
Ia_movl_Od_EAX = { "mov", "movl", Od, EAX_Reg, XX, XX, 0 },
Ia_movl_Rd_Cd = { "mov", "movl", Rd, Cd, XX, XX, 0 },
Ia_movl_Rd_Dd = { "mov", "movl", Rd, Dd, XX, XX, 0 },
Ia_movlhpd_Vpd_Udq = { "movlhpd", "movlhpd", Vpd, Udq, XX, XX, IA_SSE2 },
Ia_movlhps_Vps_Udq = { "movlhps", "movlhps", Vps, Udq, XX, XX, IA_SSE },
Ia_movlpd_Mq_Vpd = { "movlpd", "movlpd", Mq, Vpd, XX, XX, IA_SSE2 },
Ia_movlpd_Vpd_Mq = { "movlpd", "movlpd", Vpd, Mq, XX, XX, IA_SSE2 },
Ia_movlps_Mq_Vps = { "movlps", "movlps", Mq, Vps, XX, XX, IA_SSE },
Ia_movlps_Vps_Mq = { "movlps", "movlps", Vps, Mq, XX, XX, IA_SSE },
Ia_movmskpd_Gd_Upd = { "movmskpd", "movmskpd", Gd, Upd, XX, XX, IA_SSE2 },
Ia_movmskps_Gd_Ups = { "movmskps", "movmskps", Gd, Ups, XX, XX, IA_SSE },
Ia_movntdq_Mdq_Vdq = { "movntdq", "movntdq", Mdq, Vdq, XX, XX, IA_SSE2 },
Ia_movntdqa_Vdq_Mdq = { "movntdqa", "movntdqa", Vdq, Mdq, XX, XX, IA_SSE4_1 },
Ia_movnti_Md_Gd = { "movnti", "movnti", Md, Gd, XX, XX, IA_SSE2 },
Ia_movntiq_Mq_Gq = { "movnti", "movntiq", Mq, Gq, XX, XX, 0 },
Ia_movntpd_Mpd_Vpd = { "movntpd", "movntpd", Mpd, Vpd, XX, XX, IA_SSE2 },
Ia_movntps_Mps_Vps = { "movntps", "movntps", Mps, Vps, XX, XX, IA_SSE },
Ia_movntq_Mq_Pq = { "movntq", "movntq", Mq, Pq, XX, XX, IA_3DNOW | IA_SSE },
Ia_movntsd_Msd_Vsd = { "movntsd", "movntsd", Msd, Vsd, XX, XX, IA_SSE4A },
Ia_movntss_Mss_Vss = { "movntss", "movntss", Mss, Vss, XX, XX, IA_SSE4A },
Ia_movq_Cq_Rq = { "mov", "movq", Cq, Rq, XX, XX, 0 },
Ia_movq_Dq_Rq = { "mov", "movq", Dq, Rq, XX, XX, 0 },
Ia_movq_Eq_Gq = { "mov", "movq", Eq, Gq, XX, XX, 0 },
Ia_movq_Eq_Pq = { "movq", "movq", Eq, Pq, XX, XX, 0 },
Ia_movq_Eq_sId = { "mov", "movq", Eq, sIdq, XX, XX, 0 },
Ia_movq_Eq_Vq = { "movq", "movq", Eq, Vq, XX, XX, 0 },
Ia_movq_Gq_Eq = { "mov", "movq", Gq, Eq, XX, XX, 0 },
Ia_movq_Oq_RAX = { "mov", "movq", Oq, RAX_Reg, XX, XX, 0 },
Ia_movq_Pq_Eq = { "movq", "movq", Pq, Eq, XX, XX, 0 },
Ia_movq_Pq_Qq = { "movq", "movq", Pq, Qq, XX, XX, IA_MMX },
Ia_movq_Qq_Pq = { "movq", "movq", Qq, Pq, XX, XX, IA_MMX },
Ia_movq_RAX_Oq = { "mov", "movq", RAX_Reg, Oq, XX, XX, 0 },
Ia_movq_Rq_Cq = { "mov", "movq", Rq, Cq, XX, XX, 0 },
Ia_movq_Rq_Dq = { "mov", "movq", Rq, Dq, XX, XX, 0 },
Ia_movq_RRX_Iq = { "mov", "movq", RRX, Iq, XX, XX, 0 },
Ia_movq_Vdq_Eq = { "movq", "movq", Vdq, Eq, XX, XX, 0 },
Ia_movq_Vq_Wq = { "movq", "movq", Vq, Wq, XX, XX, IA_SSE2 },
Ia_movq_Wq_Vq = { "movq", "movq", Wq, Vq, XX, XX, IA_SSE2 },
Ia_movq2dq_Vdq_Qq = { "movq2dq", "movq2dq", Vdq, Qq, XX, XX, IA_SSE2 },
Ia_movsb_Yb_Xb = { "movsb", "movsb", Yb, Xb, XX, XX, 0 },
Ia_movsbl_Gd_Eb = { "movsx", "movsbl", Gd, Eb, XX, XX, 0 },
Ia_movsbq_Gq_Eb = { "movsx", "movsbq", Gq, Eb, XX, XX, 0 },
Ia_movsbw_Gw_Eb = { "movsx", "movsbw", Gw, Eb, XX, XX, 0 },
Ia_movsd_Vsd_Wsd = { "movsd", "movsd", Vsd, Wsd, XX, XX, IA_SSE2 },
Ia_movsd_Wsd_Vsd = { "movsd", "movsd", Wsd, Vsd, XX, XX, IA_SSE2 },
Ia_movshdup_Vdq_Wdq = { "movshdup", "movshdup", Vdq, Wdq, XX, XX, IA_SSE3 },
Ia_movsl_Yd_Xd = { "movsd", "movsl", Yd, Xd, XX, XX, 0 },
Ia_movsldup_Vdq_Wdq = { "movsldup", "movsldup", Vdq, Wdq, XX, XX, IA_SSE3 },
Ia_movslq_Gq_Ed = { "movsxd", "movslq", Gq, Ed, XX, XX, 0 },
Ia_movsq_Yq_Xq = { "movsq", "movsq", Yq, Xq, XX, XX, 0 },
Ia_movss_Vss_Wss = { "movss", "movss", Vss, Wss, XX, XX, IA_SSE },
Ia_movss_Wss_Vss = { "movss", "movss", Wss, Vss, XX, XX, IA_SSE },
Ia_movsw_Yw_Xw = { "movsw", "movsw", Yw, Xw, XX, XX, 0 },
Ia_movswl_Gd_Ew = { "movsx", "movswl", Gd, Ew, XX, XX, 0 },
Ia_movswq_Gq_Ew = { "movsx", "movswq", Gq, Ew, XX, XX, 0 },
Ia_movupd_Vpd_Wpd = { "movupd", "movupd", Vpd, Wpd, XX, XX, IA_SSE2 },
Ia_movupd_Wpd_Vpd = { "movupd", "movupd", Wpd, Vpd, XX, XX, IA_SSE2 },
Ia_movups_Vps_Wps = { "movups", "movups", Vps, Wps, XX, XX, IA_SSE },
Ia_movups_Wps_Vps = { "movups", "movups", Wps, Vps, XX, XX, IA_SSE },
Ia_movw_AX_Ow = { "mov", "movw", AX_Reg, Ow, XX, XX, 0 },
Ia_movw_Ew_Gw = { "mov", "movw", Ew, Gw, XX, XX, 0 },
Ia_movw_Ew_Iw = { "mov", "movw", Ew, Iw, XX, XX, 0 },
Ia_movw_Ew_Sw = { "mov", "movw", Ew, Sw, XX, XX, 0 },
Ia_movw_Gw_Ew = { "mov", "movw", Gw, Ew, XX, XX, 0 },
Ia_movw_Ow_AX = { "mov", "movw", Ow, AX_Reg, XX, XX, 0 },
Ia_movw_RX_Iw = { "mov", "movw", RX, Iw, XX, XX, 0 },
Ia_movw_Sw_Ew = { "mov", "movw", Sw, Ew, XX, XX, 0 },
Ia_movzbl_Gd_Eb = { "movzx", "movzbl", Gd, Eb, XX, XX, 0 },
Ia_movzbq_Gq_Eb = { "movzx", "movzbq", Gq, Eb, XX, XX, 0 },
Ia_movzbw_Gw_Eb = { "movzx", "movzbw", Gw, Eb, XX, XX, 0 },
Ia_movzwl_Gd_Ew = { "movzx", "movzwl", Gd, Ew, XX, XX, 0 },
Ia_movzwq_Gq_Ew = { "movzx", "movzwq", Gq, Ew, XX, XX, 0 },
Ia_mpsadbw_Vdq_Wdq_Ib = { "mpsadbw", "mpsadbw", Vdq, Wdq, Ib, XX, IA_SSE4_1 },
Ia_mulb_AL_Eb = { "mul", "mulb", AL_Reg, Eb, XX, XX, 0 },
Ia_mull_EAX_Ed = { "mul", "mull", EAX_Reg, Ed, XX, XX, 0 },
Ia_mulpd_Vpd_Wpd = { "mulpd", "mulpd", Vpd, Wpd, XX, XX, IA_SSE2 },
Ia_mulps_Vps_Wps = { "mulps", "mulps", Vps, Wps, XX, XX, IA_SSE },
Ia_mulq_RAX_Eq = { "mul", "mulq", RAX_Reg, Eq, XX, XX, 0 },
Ia_mulsd_Vsd_Wsd = { "mulsd", "mulsd", Vsd, Wsd, XX, XX, IA_SSE2 },
Ia_mulss_Vss_Wss = { "mulss", "mulss", Vss, Wss, XX, XX, IA_SSE },
Ia_multibyte_nop = { "multibyte nop", "multibyte nop", XX, XX, XX, XX, 0 },
Ia_mulw_AX_Ew = { "mul", "mulw", AX_Reg, Ew, XX, XX, 0 },
Ia_mulx_By_Gy_Ey = { "mulx", "mulx", By, Gy, Ey, XX, IA_BMI2 },
Ia_mwait = { "mwait", "mwait", XX, XX, XX, XX, IA_MONITOR_MWAIT },
Ia_negb_Eb = { "neg", "negb", Eb, XX, XX, XX, 0 },
Ia_negl_Ed = { "neg", "negl", Ed, XX, XX, XX, 0 },
Ia_negq_Eq = { "neg", "negq", Eq, XX, XX, XX, 0 },
Ia_negw_Ew = { "neg", "negw", Ew, XX, XX, XX, 0 },
Ia_nop = { "nop", "nop", XX, XX, XX, XX, 0 },
Ia_notb_Eb = { "not", "notb", Eb, XX, XX, XX, 0 },
Ia_notl_Ed = { "not", "notl", Ed, XX, XX, XX, 0 },
Ia_notq_Eq = { "not", "notq", Eq, XX, XX, XX, 0 },
Ia_notw_Ew = { "not", "notw", Ew, XX, XX, XX, 0 },
Ia_orb_AL_Ib = { "or", "orb", AL_Reg, Ib, XX, XX, 0 },
Ia_orb_Eb_Gb = { "or", "orb", Eb, Gb, XX, XX, 0 },
Ia_orb_Eb_Ib = { "or", "orb", Eb, Ib, XX, XX, 0 },
Ia_orb_Gb_Eb = { "or", "orb", Gb, Eb, XX, XX, 0 },
Ia_orl_EAX_Id = { "or", "orl", EAX_Reg, Id, XX, XX, 0 },
Ia_orl_Ed_Gd = { "or", "orl", Ed, Gd, XX, XX, 0 },
Ia_orl_Ed_Id = { "or", "orl", Ed, Id, XX, XX, 0 },
Ia_orl_Ed_sIb = { "or", "orl", Ed, sIbd, XX, XX, 0 },
Ia_orl_Gd_Ed = { "or", "orl", Gd, Ed, XX, XX, 0 },
Ia_orpd_Vpd_Wpd = { "orpd", "orpd", Vpd, Wpd, XX, XX, IA_SSE2 },
Ia_orps_Vps_Wps = { "orps", "orps", Vps, Wps, XX, XX, IA_SSE },
Ia_orq_Eq_Gq = { "or", "orq", Eq, Gq, XX, XX, 0 },
Ia_orq_Eq_sIb = { "or", "orq", Eq, sIbq, XX, XX, 0 },
Ia_orq_Eq_sId = { "or", "orq", Eq, sIdq, XX, XX, 0 },
Ia_orq_Gq_Eq = { "or", "orq", Gq, Eq, XX, XX, 0 },
Ia_orq_RAX_sId = { "or", "orq", RAX_Reg, sIdq, XX, XX, 0 },
Ia_orw_AX_Iw = { "or", "orw", AX_Reg, Iw, XX, XX, 0 },
Ia_orw_Ew_Gw = { "or", "orw", Ew, Gw, XX, XX, 0 },
Ia_orw_Ew_Iw = { "or", "orw", Ew, Iw, XX, XX, 0 },
Ia_orw_Ew_sIb = { "or", "orw", Ew, sIbw, XX, XX, 0 },
Ia_orw_Gw_Ew = { "or", "orw", Gw, Ew, XX, XX, 0 },
Ia_outb_DX_AL = { "out", "outb", DX_Reg, AL_Reg, XX, XX, 0 },
Ia_outb_Ib_AL = { "out", "outb", Ib, AL_Reg, XX, XX, 0 },
Ia_outl_DX_EAX = { "out", "outl", DX_Reg, EAX_Reg, XX, XX, 0 },
Ia_outl_Ib_EAX = { "out", "outl", Ib, EAX_Reg, XX, XX, 0 },
Ia_outsb_DX_Xb = { "outsb", "outsb", DX_Reg, Xb, XX, XX, 0 },
Ia_outsl_DX_Xd = { "outsd", "outsl", DX_Reg, Xd, XX, XX, 0 },
Ia_outsw_DX_Xw = { "outsw", "outsw", DX_Reg, Xw, XX, XX, 0 },
Ia_outw_DX_AX = { "out", "outw", DX_Reg, AX_Reg, XX, XX, 0 },
Ia_outw_Ib_AX = { "out", "outw", Ib, AX_Reg, XX, XX, 0 },
Ia_pabsb_Pq_Qq = { "pabsb", "pabsb", Pq, Qq, XX, XX, IA_SSSE3 },
Ia_pabsb_Vdq_Wdq = { "pabsb", "pabsb", Vdq, Wdq, XX, XX, IA_SSSE3 },
Ia_pabsd_Pq_Qq = { "pabsd", "pabsd", Pq, Qq, XX, XX, IA_SSSE3 },
Ia_pabsd_Vdq_Wdq = { "pabsd", "pabsd", Vdq, Wdq, XX, XX, IA_SSSE3 },
Ia_pabsw_Pq_Qq = { "pabsw", "pabsw", Pq, Qq, XX, XX, IA_SSSE3 },
Ia_pabsw_Vdq_Wdq = { "pabsw", "pabsw", Vdq, Wdq, XX, XX, IA_SSSE3 },
Ia_packssdw_Pq_Qq = { "packssdw", "packssdw", Pq, Qq, XX, XX, IA_MMX },
Ia_packssdw_Vdq_Wdq = { "packssdw", "packssdw", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_packsswb_Pq_Qq = { "packsswb", "packsswb", Pq, Qq, XX, XX, IA_MMX },
Ia_packsswb_Vdq_Wdq = { "packsswb", "packsswb", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_packusdw_Vdq_Wdq = { "packusdw", "packusdw", Vdq, Wdq, XX, XX, IA_SSE4_1 },
Ia_packuswb_Pq_Qq = { "packuswb", "packuswb", Pq, Qq, XX, XX, IA_MMX },
Ia_packuswb_Vdq_Wdq = { "packuswb", "packuswb", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_paddb_Pq_Qq = { "paddb", "paddb", Pq, Qq, XX, XX, IA_MMX },
Ia_paddb_Vdq_Wdq = { "paddb", "paddb", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_paddd_Pq_Qq = { "paddd", "paddd", Pq, Qq, XX, XX, IA_MMX },
Ia_paddd_Vdq_Wdq = { "paddd", "paddd", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_paddq_Pq_Qq = { "paddq", "paddq", Pq, Qq, XX, XX, IA_SSE2 },
Ia_paddq_Vdq_Wdq = { "paddq", "paddq", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_paddsb_Pq_Qq = { "paddsb", "paddsb", Pq, Qq, XX, XX, IA_MMX },
Ia_paddsb_Vdq_Wdq = { "paddsb", "paddsb", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_paddsw_Pq_Qq = { "paddsw", "paddsw", Pq, Qq, XX, XX, IA_MMX },
Ia_paddsw_Vdq_Wdq = { "paddsw", "paddsw", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_paddusb_Pq_Qq = { "paddusb", "paddusb", Pq, Qq, XX, XX, IA_MMX },
Ia_paddusb_Vdq_Wdq = { "paddusb", "paddusb", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_paddusw_Pq_Qq = { "paddusw", "paddusw", Pq, Qq, XX, XX, IA_MMX },
Ia_paddusw_Vdq_Wdq = { "paddusw", "paddusw", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_paddw_Pq_Qq = { "paddw", "paddw", Pq, Qq, XX, XX, IA_MMX },
Ia_paddw_Vdq_Wdq = { "paddw", "paddw", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_palignr_Pq_Qq_Ib = { "palignr", "palignr", Pq, Qq, Ib, XX, IA_SSSE3 },
Ia_palignr_Vdq_Wdq_Ib = { "palignr", "palignr", Vdq, Wdq, Ib, XX, IA_SSSE3 },
Ia_pand_Pq_Qq = { "pand", "pand", Pq, Qq, XX, XX, IA_MMX },
Ia_pand_Vdq_Wdq = { "pand", "pand", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_pandn_Pq_Qq = { "pandn", "pandn", Pq, Qq, XX, XX, IA_MMX },
Ia_pandn_Vdq_Wdq = { "pandn", "pandn", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_pause = { "pause", "pause", XX, XX, XX, XX, 0 },
Ia_pavgb_Pq_Qq = { "pavgb", "pavgb", Pq, Qq, XX, XX, IA_MMX },
Ia_pavgb_Vdq_Wdq = { "pavgb", "pavgb", Vdq, Wdq, XX, XX, IA_SSE },
Ia_pavgw_Pq_Qq = { "pavgw", "pavgw", Pq, Qq, XX, XX, IA_MMX },
Ia_pavgw_Vdq_Wdq = { "pavgw", "pavgw", Vdq, Wdq, XX, XX, IA_SSE },
Ia_pblendvb_Vdq_Wdq = { "pblendvb", "pblendvb", Vdq, Wdq, XX, XX, IA_SSE4_1 },
Ia_pblendw_Vdq_Wdq_Ib = { "pblendw", "pblendw", Vdq, Wdq, Ib, XX, IA_SSE4_1 },
Ia_pclmulqdq_Vdq_Wdq_Ib = { "pclmulqdq", "pclmulqdq", Vdq, Wdq, Ib, XX, IA_AES_PCLMULQDQ },
Ia_pcmpeqb_Pq_Qq = { "pcmpeqb", "pcmpeqb", Pq, Qq, XX, XX, IA_MMX },
Ia_pcmpeqb_Vdq_Wdq = { "pcmpeqb", "pcmpeqb", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_pcmpeqd_Pq_Qq = { "pcmpeqd", "pcmpeqd", Pq, Qq, XX, XX, IA_MMX },
Ia_pcmpeqd_Vdq_Wdq = { "pcmpeqd", "pcmpeqd", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_pcmpeqq_Vdq_Wdq = { "pcmpeqq", "pcmpeqq", Vdq, Wdq, XX, XX, IA_SSE4_1 },
Ia_pcmpeqw_Pq_Qq = { "pcmpeqw", "pcmpeqw", Pq, Qq, XX, XX, IA_MMX },
Ia_pcmpeqw_Vdq_Wdq = { "pcmpeqw", "pcmpeqw", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_pcmpestri_Vdq_Wdq_Ib = { "pcmpestri", "pcmpestri", Vdq, Wdq, Ib, XX, IA_SSE4_2 },
Ia_pcmpestrm_Vdq_Wdq_Ib = { "pcmpestrm", "pcmpestrm", Vdq, Wdq, Ib, XX, IA_SSE4_2 },
Ia_pcmpgtb_Pq_Qq = { "pcmpgtb", "pcmpgtb", Pq, Qq, XX, XX, IA_MMX },
Ia_pcmpgtb_Vdq_Wdq = { "pcmpgtb", "pcmpgtb", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_pcmpgtd_Pq_Qq = { "pcmpgtd", "pcmpgtd", Pq, Qq, XX, XX, IA_MMX },
Ia_pcmpgtd_Vdq_Wdq = { "pcmpgtd", "pcmpgtd", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_pcmpgtq_Vdq_Wdq = { "pcmpgtq", "pcmpgtq", Vdq, Wdq, XX, XX, IA_SSE4_2 },
Ia_pcmpgtw_Pq_Qq = { "pcmpgtw", "pcmpgtw", Pq, Qq, XX, XX, IA_MMX },
Ia_pcmpgtw_Vdq_Wdq = { "pcmpgtw", "pcmpgtw", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_pcmpistri_Vdq_Wdq_Ib = { "pcmpistri", "pcmpistri", Vdq, Wdq, Ib, XX, IA_SSE4_2 },
Ia_pcmpistrm_Vdq_Wdq_Ib = { "pcmpistrm", "pcmpistrm", Vdq, Wdq, Ib, XX, IA_SSE4_2 },
Ia_pdep_Gy_By_Ey = { "pdep", "pdep", Gy, By, Ey, XX, IA_BMI2 },
Ia_pext_Gy_By_Ey = { "pext", "pext", Gy, By, Ey, XX, IA_BMI2 },
Ia_pextrb_Ebd_Vdq_Ib = { "pextrb", "pextrb", Ebd, Vdq, Ib, XX, IA_SSE4_1 },
Ia_pextrd_Ed_Vdq_Ib = { "pextrd", "pextrd", Ed, Vdq, Ib, XX, IA_SSE4_1 },
Ia_pextrq_Eq_Vdq_Ib = { "pextrq", "pextrq", Eq, Vdq, Ib, XX, IA_SSE4_1 },
Ia_pextrw_Ewd_Vdq_Ib = { "pextrw", "pextrw", Ewd, Vdq, Ib, XX, IA_SSE4_1 },
Ia_pextrw_Gd_Nq_Ib = { "pextrw", "pextrw", Gd, Nq, Ib, XX, IA_3DNOW | IA_SSE },
Ia_pextrw_Gd_Udq_Ib = { "pextrw", "pextrw", Gd, Udq, Ib, XX, IA_SSE2 },
Ia_pf2id_Pq_Qq = { "pf2id", "pf2id", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pf2iw_Pq_Qq = { "pf2iw", "pf2iw", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pfacc_Pq_Qq = { "pfacc", "pfacc", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pfadd_Pq_Qq = { "pfadd", "pfadd", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pfcmpeq_Pq_Qq = { "pfcmpeq", "pfcmpeq", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pfcmpge_Pq_Qq = { "pfcmpge", "pfcmpge", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pfcmpgt_Pq_Qq = { "pfcmpgt", "pfcmpgt", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pfmax_Pq_Qq = { "pfmax", "pfmax", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pfmin_Pq_Qq = { "pfmin", "pfmin", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pfmul_Pq_Qq = { "pfmul", "pfmul", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pfnacc_Pq_Qq = { "pfnacc", "pfnacc", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pfpnacc_Pq_Qq = { "pfpnacc", "pfpnacc", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pfrcp_Pq_Qq = { "pfrcp", "pfrcp", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pfrcpit1_Pq_Qq = { "pfrcpit1", "pfrcpit1", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pfrcpit2_Pq_Qq = { "pfrcpit2", "pfrcpit2", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pfrsqit1_Pq_Qq = { "pfrsqit1", "pfrsqit1", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pfrsqrt_Pq_Qq = { "pfrsqrt", "pfrsqrt", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pfsub_Pq_Qq = { "pfsub", "pfsub", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pfsubr_Pq_Qq = { "pfsubr", "pfsubr", Pq, Qq, XX, XX, IA_3DNOW },
Ia_phaddd_Pq_Qq = { "phaddd", "phaddd", Pq, Qq, XX, XX, IA_SSSE3 },
Ia_phaddd_Vdq_Wdq = { "phaddd", "phaddd", Vdq, Wdq, XX, XX, IA_SSSE3 },
Ia_phaddsw_Pq_Qq = { "phaddsw", "phaddsw", Pq, Qq, XX, XX, IA_SSSE3 },
Ia_phaddsw_Vdq_Wdq = { "phaddsw", "phaddsw", Vdq, Wdq, XX, XX, IA_SSSE3 },
Ia_phaddw_Pq_Qq = { "phaddw", "phaddw", Pq, Qq, XX, XX, IA_SSSE3 },
Ia_phaddw_Vdq_Wdq = { "phaddw", "phaddw", Vdq, Wdq, XX, XX, IA_SSSE3 },
Ia_phminposuw_Vdq_Wdq = { "phminposuw", "phminposuw", Vdq, Wdq, XX, XX, IA_SSE4_1 },
Ia_phsubd_Pq_Qq = { "phsubd", "phsubd", Pq, Qq, XX, XX, IA_SSSE3 },
Ia_phsubd_Vdq_Wdq = { "phsubd", "phsubd", Vdq, Wdq, XX, XX, IA_SSSE3 },
Ia_phsubsw_Pq_Qq = { "phsubsw", "phsubsw", Pq, Qq, XX, XX, IA_SSSE3 },
Ia_phsubsw_Vdq_Wdq = { "phsubsw", "phsubsw", Vdq, Wdq, XX, XX, IA_SSSE3 },
Ia_phsubw_Pq_Qq = { "phsubw", "phsubw", Pq, Qq, XX, XX, IA_SSSE3 },
Ia_phsubw_Vdq_Wdq = { "phsubw", "phsubw", Vdq, Wdq, XX, XX, IA_SSSE3 },
Ia_pi2fd_Pq_Qq = { "pi2fd", "pi2fd", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pi2fw_Pq_Qq = { "pi2fw", "pi2fw", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pinsrb_Vdq_Ew_Ib = { "pinsrb", "pinsrb", Vdq, Ew, Ib, XX, IA_SSE4_1 },
Ia_pinsrd_Vdq_Ed_Ib = { "pinsrd", "pinsrd", Vdq, Ed, Ib, XX, IA_SSE4_1 },
Ia_pinsrq_Vdq_Eq_Ib = { "pinsrq", "pinsrq", Vdq, Eq, Ib, XX, IA_SSE4_1 },
Ia_pinsrw_Pq_Ew_Ib = { "pinsrw", "pinsrw", Pq, Ew, Ib, XX, IA_3DNOW | IA_SSE },
Ia_pinsrw_Vdq_Ew_Ib = { "pinsrw", "pinsrw", Vdq, Ew, Ib, XX, IA_SSE2 },
Ia_pmaddubsw_Pq_Qq = { "pmaddubsw", "pmaddubsw", Pq, Qq, XX, XX, IA_SSSE3 },
Ia_pmaddubsw_Vdq_Wdq = { "pmaddubsw", "pmaddubsw", Vdq, Wdq, XX, XX, IA_SSSE3 },
Ia_pmaddwd_Pq_Qq = { "pmaddwd", "pmaddwd", Pq, Qq, XX, XX, IA_MMX },
Ia_pmaddwd_Vdq_Wdq = { "pmaddwd", "pmaddwd", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_pmaxsb_Vdq_Wdq = { "pmaxsb", "pmaxsb", Vdq, Wdq, XX, XX, IA_SSE4_1 },
Ia_pmaxsd_Vdq_Wdq = { "pmaxsd", "pmaxsd", Vdq, Wdq, XX, XX, IA_SSE4_1 },
Ia_pmaxsw_Pq_Qq = { "pmaxsw", "pmaxsw", Pq, Qq, XX, XX, 0 },
Ia_pmaxsw_Vdq_Wdq = { "pmaxsw", "pmaxsw", Vdq, Wdq, XX, XX, 0 },
Ia_pmaxub_Pq_Qq = { "pmaxub", "pmaxub", Pq, Qq, XX, XX, IA_3DNOW | IA_SSE },
Ia_pmaxub_Vdq_Wdq = { "pmaxub", "pmaxub", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_pmaxud_Vdq_Wdq = { "pmaxud", "pmaxud", Vdq, Wdq, XX, XX, IA_SSE4_1 },
Ia_pmaxuw_Vdq_Wdq = { "pmaxuw", "pmaxuw", Vdq, Wdq, XX, XX, IA_SSE4_1 },
Ia_pminsb_Vdq_Wdq = { "pminsb", "pminsb", Vdq, Wdq, XX, XX, IA_SSE4_1 },
Ia_pminsd_Vdq_Wdq = { "pminsd", "pminsd", Vdq, Wdq, XX, XX, IA_SSE4_1 },
Ia_pminsw_Pq_Qq = { "pminsw", "pminsw", Pq, Qq, XX, XX, IA_3DNOW | IA_SSE },
Ia_pminsw_Vdq_Wdq = { "pminsw", "pminsw", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_pminub_Pq_Qq = { "pminub", "pminub", Pq, Qq, XX, XX, IA_3DNOW | IA_SSE },
Ia_pminub_Vdq_Wdq = { "pminub", "pminub", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_pminud_Vdq_Wdq = { "pminud", "pminud", Vdq, Wdq, XX, XX, IA_SSE4_1 },
Ia_pminuw_Vdq_Wdq = { "pminuw", "pminuw", Vdq, Wdq, XX, XX, IA_SSE4_1 },
Ia_pmovmskb_Gd_Nq = { "pmovmskb", "pmovmskb", Gd, Nq, XX, XX, IA_3DNOW | IA_SSE },
Ia_pmovmskb_Gd_Udq = { "pmovmskb", "pmovmskb", Gd, Udq, XX, XX, IA_SSE2 },
Ia_pmovsxbd_Vdq_Wd = { "pmovsxbd", "pmovsxbd", Vdq, Wd, XX, XX, IA_SSE4_1 },
Ia_pmovsxbq_Vdq_Ww = { "pmovsxbq", "pmovsxbq", Vdq, Ww, XX, XX, IA_SSE4_1 },
Ia_pmovsxbw_Vdq_Wq = { "pmovsxbw", "pmovsxbw", Vdq, Wq, XX, XX, IA_SSE4_1 },
Ia_pmovsxdq_Vdq_Wq = { "pmovsxdq", "pmovsxdq", Vdq, Wq, XX, XX, IA_SSE4_1 },
Ia_pmovsxwd_Vdq_Wq = { "pmovsxwd", "pmovsxwd", Vdq, Wq, XX, XX, IA_SSE4_1 },
Ia_pmovsxwq_Vdq_Wd = { "pmovsxwq", "pmovsxwq", Vdq, Wd, XX, XX, IA_SSE4_1 },
Ia_pmovzxbd_Vdq_Wd = { "pmovzxbd", "pmovzxbd", Vdq, Wd, XX, XX, IA_SSE4_1 },
Ia_pmovzxbq_Vdq_Ww = { "pmovzxbq", "pmovzxbq", Vdq, Ww, XX, XX, IA_SSE4_1 },
Ia_pmovzxbw_Vdq_Wq = { "pmovzxbw", "pmovzxbw", Vdq, Wq, XX, XX, IA_SSE4_1 },
Ia_pmovzxdq_Vdq_Wq = { "pmovzxdq", "pmovzxdq", Vdq, Wq, XX, XX, IA_SSE4_1 },
Ia_pmovzxwd_Vdq_Wq = { "pmovzxwd", "pmovzxwd", Vdq, Wq, XX, XX, IA_SSE4_1 },
Ia_pmovzxwq_Vdq_Wd = { "pmovzxwq", "pmovzxwq", Vdq, Wd, XX, XX, IA_SSE4_1 },
Ia_pmuldq_Vdq_Wdq = { "pmuldq", "pmuldq", Vdq, Wdq, XX, XX, IA_SSE4_1 },
Ia_pmulhrsw_Pq_Qq = { "pmulhrsw", "pmulhrsw", Pq, Qq, XX, XX, IA_SSSE3 },
Ia_pmulhrsw_Vdq_Wdq = { "pmulhrsw", "pmulhrsw", Vdq, Wdq, XX, XX, IA_SSSE3 },
Ia_pmulhrw_Pq_Qq = { "pmulhrw", "pmulhrw", Pq, Qq, XX, XX, IA_3DNOW },
Ia_pmulhuw_Pq_Qq = { "pmulhuw", "pmulhuw", Pq, Qq, XX, XX, IA_3DNOW | IA_SSE },
Ia_pmulhuw_Vdq_Wdq = { "pmulhuw", "pmulhuw", Vdq, Wdq, XX, XX, IA_SSE },
Ia_pmulhw_Pq_Qq = { "pmulhw", "pmulhw", Pq, Qq, XX, XX, IA_MMX },
Ia_pmulhw_Vdq_Wdq = { "pmulhw", "pmulhw", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_pmulld_Vdq_Wdq = { "pmulld", "pmulld", Vdq, Wdq, XX, XX, IA_SSE4_1 },
Ia_pmullw_Pq_Qq = { "pmullw", "pmullw", Pq, Qq, XX, XX, IA_MMX },
Ia_pmullw_Vdq_Wdq = { "pmullw", "pmullw", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_pmuludq_Pq_Qq = { "pmuludq", "pmuludq", Pq, Qq, XX, XX, IA_SSE2 },
Ia_pmuludq_Vdq_Wdq = { "pmuludq", "pmuludq", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_popal = { "popa", "popal", XX, XX, XX, XX, 0 },
Ia_popaw = { "popa", "popa", XX, XX, XX, XX, 0 },
Ia_popcnt_Gd_Ed = { "popcnt", "popcnt", Gd, Ed, XX, XX, IA_POPCNT },
Ia_popcnt_Gq_Eq = { "popcnt", "popcnt", Gq, Eq, XX, XX, IA_POPCNT },
Ia_popcnt_Gw_Ew = { "popcnt", "popcnt", Gw, Ew, XX, XX, IA_POPCNT },
Ia_popfl = { "popf", "popfl", XX, XX, XX, XX, 0 },
Ia_popfq = { "popf", "popfq", XX, XX, XX, XX, 0 },
Ia_popfw = { "popf", "popf", XX, XX, XX, XX, 0 },
Ia_popl_DS = { "pop", "popl", DS, XX, XX, XX, 0 },
Ia_popl_Ed = { "pop", "popl", Ed, XX, XX, XX, 0 },
Ia_popl_ERX = { "pop", "popl", ERX, XX, XX, XX, 0 },
Ia_popl_ES = { "pop", "popl", ES, XX, XX, XX, 0 },
Ia_popl_FS = { "pop", "popl", FS, XX, XX, XX, 0 },
Ia_popl_GS = { "pop", "popl", GS, XX, XX, XX, 0 },
Ia_popl_SS = { "pop", "popl", SS, XX, XX, XX, 0 },
Ia_popq_Eq = { "pop", "popq", Eq, XX, XX, XX, 0 },
Ia_popq_FS = { "pop", "popq", FS, XX, XX, XX, 0 },
Ia_popq_GS = { "pop", "popq", GS, XX, XX, XX, 0 },
Ia_popq_RRX = { "pop", "popq", RRX, XX, XX, XX, 0 },
Ia_popw_DS = { "pop", "popw", DS, XX, XX, XX, 0 },
Ia_popw_ES = { "pop", "popw", ES, XX, XX, XX, 0 },
Ia_popw_Ew = { "pop", "popw", Ew, XX, XX, XX, 0 },
Ia_popw_FS = { "pop", "popw", FS, XX, XX, XX, 0 },
Ia_popw_GS = { "pop", "popw", GS, XX, XX, XX, 0 },
Ia_popw_RX = { "pop", "popw", RX, XX, XX, XX, 0 },
Ia_popw_SS = { "pop", "popw", SS, XX, XX, XX, 0 },
Ia_por_Pq_Qq = { "por", "por", Pq, Qq, XX, XX, IA_MMX },
Ia_por_Vdq_Wdq = { "por", "por", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_prefetch_hint = { "prefetch_hint", "prefetch_hint", Mb, XX, XX, XX, IA_SSE },
Ia_prefetchnta = { "prefetchnta", "prefetchnta", Mb, XX, XX, XX, IA_SSE },
Ia_prefetcht0 = { "prefetcht0", "prefetcht0", Mb, XX, XX, XX, IA_SSE },
Ia_prefetcht1 = { "prefetcht1", "prefetcht1", Mb, XX, XX, XX, IA_SSE },
Ia_prefetcht2 = { "prefetcht2", "prefetcht2", Mb, XX, XX, XX, IA_SSE },
Ia_prefetchw = { "prefetchw", "prefetchw", Mb, XX, XX, XX, 0 },
Ia_prefix_asize = { "asize", "asize", XX, XX, XX, XX, 0 },
Ia_prefix_cs = { "cs", "cs", XX, XX, XX, XX, 0 },
Ia_prefix_ds = { "ds", "ds", XX, XX, XX, XX, 0 },
Ia_prefix_es = { "es", "es", XX, XX, XX, XX, 0 },
Ia_prefix_fs = { "fs", "fs", XX, XX, XX, XX, 0 },
Ia_prefix_gs = { "gs", "gs", XX, XX, XX, XX, 0 },
Ia_prefix_lock = { "lock", "lock", XX, XX, XX, XX, 0 },
Ia_prefix_osize = { "osize", "osize", XX, XX, XX, XX, 0 },
Ia_prefix_rep = { "rep", "rep", XX, XX, XX, XX, 0 },
Ia_prefix_repne = { "repne", "repne", XX, XX, XX, XX, 0 },
Ia_prefix_rex = { "rex", "rex", XX, XX, XX, XX, 0 },
Ia_prefix_ss = { "ss", "ss", XX, XX, XX, XX, 0 },
Ia_psadbw_Pq_Qq = { "psadbw", "psadbw", Pq, Qq, XX, XX, IA_3DNOW | IA_SSE },
Ia_psadbw_Vdq_Wdq = { "psadbw", "psadbw", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_pshufb_Pq_Qq = { "pshufb", "pshufb", Pq, Qq, XX, XX, IA_SSSE3 },
Ia_pshufb_Vdq_Wdq = { "pshufb", "pshufb", Vdq, Wdq, XX, XX, IA_SSSE3 },
Ia_pshufd_Vdq_Wdq_Ib = { "pshufd", "pshufd", Vdq, Wdq, Ib, XX, IA_SSE2 },
Ia_pshufhw_Vdq_Wdq_Ib = { "pshufhw", "pshufhw", Vdq, Wdq, Ib, XX, IA_SSE2 },
Ia_pshuflw_Vdq_Wdq_Ib = { "pshuflw", "pshuflw", Vdq, Wdq, Ib, XX, IA_SSE2 },
Ia_pshufw_Pq_Qq_Ib = { "pshufw", "pshufw", Pq, Qq, Ib, XX, IA_3DNOW | IA_SSE },
Ia_psignb_Pq_Qq = { "psignb", "psignb", Pq, Qq, XX, XX, IA_SSSE3 },
Ia_psignb_Vdq_Wdq = { "psignb", "psignb", Vdq, Wdq, XX, XX, IA_SSSE3 },
Ia_psignd_Pq_Qq = { "psignd", "psignd", Pq, Qq, XX, XX, IA_SSSE3 },
Ia_psignd_Vdq_Wdq = { "psignd", "psignd", Vdq, Wdq, XX, XX, IA_SSSE3 },
Ia_psignw_Pq_Qq = { "psignw", "psignw", Pq, Qq, XX, XX, IA_SSSE3 },
Ia_psignw_Vdq_Wdq = { "psignw", "psignw", Vdq, Wdq, XX, XX, IA_SSSE3 },
Ia_pslld_Nq_Ib = { "pslld", "pslld", Nq, Ib, XX, XX, IA_MMX },
Ia_pslld_Pq_Qq = { "pslld", "pslld", Pq, Qq, XX, XX, IA_MMX },
Ia_pslld_Udq_Ib = { "pslld", "pslld", Udq, Ib, XX, XX, IA_SSE2 },
Ia_pslld_Vdq_Wdq = { "pslld", "pslld", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_pslldq_Udq_Ib = { "pslldq", "pslldq", Udq, Ib, XX, XX, IA_SSE2 },
Ia_psllq_Nq_Ib = { "psllq", "psllq", Nq, Ib, XX, XX, IA_MMX },
Ia_psllq_Pq_Qq = { "psllq", "psllq", Pq, Qq, XX, XX, IA_MMX },
Ia_psllq_Udq_Ib = { "psllq", "psllq", Udq, Ib, XX, XX, IA_SSE2 },
Ia_psllq_Vdq_Wdq = { "psllq", "psllq", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_psllw_Nq_Ib = { "psllw", "psllw", Nq, Ib, XX, XX, IA_MMX },
Ia_psllw_Pq_Qq = { "psllw", "psllw", Pq, Qq, XX, XX, IA_MMX },
Ia_psllw_Udq_Ib = { "psllw", "psllw", Udq, Ib, XX, XX, IA_SSE2 },
Ia_psllw_Vdq_Wdq = { "psllw", "psllw", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_psrad_Nq_Ib = { "psrad", "psrad", Nq, Ib, XX, XX, IA_MMX },
Ia_psrad_Pq_Qq = { "psrad", "psrad", Pq, Qq, XX, XX, IA_MMX },
Ia_psrad_Udq_Ib = { "psrad", "psrad", Udq, Ib, XX, XX, IA_SSE2 },
Ia_psrad_Vdq_Wdq = { "psrad", "psrad", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_psraw_Nq_Ib = { "psraw", "psraw", Nq, Ib, XX, XX, IA_MMX },
Ia_psraw_Pq_Qq = { "psraw", "psraw", Pq, Qq, XX, XX, IA_MMX },
Ia_psraw_Udq_Ib = { "psraw", "psraw", Udq, Ib, XX, XX, IA_SSE2 },
Ia_psraw_Vdq_Wdq = { "psraw", "psraw", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_psrld_Nq_Ib = { "psrld", "psrld", Nq, Ib, XX, XX, IA_MMX },
Ia_psrld_Pq_Qq = { "psrld", "psrld", Pq, Qq, XX, XX, IA_MMX },
Ia_psrld_Udq_Ib = { "psrld", "psrld", Udq, Ib, XX, XX, IA_SSE2 },
Ia_psrld_Vdq_Wdq = { "psrld", "psrld", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_psrldq_Udq_Ib = { "psrldq", "psrldq", Udq, Ib, XX, XX, IA_SSE2 },
Ia_psrlq_Nq_Ib = { "psrlq", "psrlq", Nq, Ib, XX, XX, IA_MMX },
Ia_psrlq_Pq_Qq = { "psrlq", "psrlq", Pq, Qq, XX, XX, IA_MMX },
Ia_psrlq_Udq_Ib = { "psrlq", "psrlq", Udq, Ib, XX, XX, IA_SSE2 },
Ia_psrlq_Vdq_Wdq = { "psrlq", "psrlq", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_psrlw_Nq_Ib = { "psrlw", "psrlw", Nq, Ib, XX, XX, IA_MMX },
Ia_psrlw_Pq_Qq = { "psrlw", "psrlw", Pq, Qq, XX, XX, IA_MMX },
Ia_psrlw_Udq_Ib = { "psrlw", "psrlw", Udq, Ib, XX, XX, IA_SSE2 },
Ia_psrlw_Vdq_Wdq = { "psrlw", "psrlw", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_psubb_Pq_Qq = { "psubb", "psubb", Pq, Qq, XX, XX, IA_MMX },
Ia_psubb_Vdq_Wdq = { "psubb", "psubb", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_psubd_Pq_Qq = { "psubd", "psubd", Pq, Qq, XX, XX, IA_MMX },
Ia_psubd_Vdq_Wdq = { "psubd", "psubd", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_psubq_Pq_Qq = { "psubq", "psubq", Pq, Qq, XX, XX, IA_SSE2 },
Ia_psubq_Vdq_Wdq = { "psubq", "psubq", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_psubsb_Pq_Qq = { "psubsb", "psubsb", Pq, Qq, XX, XX, IA_MMX },
Ia_psubsb_Vdq_Wdq = { "psubsb", "psubsb", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_psubsw_Pq_Qq = { "psubsw", "psubsw", Pq, Qq, XX, XX, IA_MMX },
Ia_psubsw_Vdq_Wdq = { "psubsw", "psubsw", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_psubusb_Pq_Qq = { "psubusb", "psubusb", Pq, Qq, XX, XX, IA_MMX },
Ia_psubusb_Vdq_Wdq = { "psubusb", "psubusb", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_psubusw_Pq_Qq = { "psubusw", "psubusw", Pq, Qq, XX, XX, IA_MMX },
Ia_psubusw_Vdq_Wdq = { "psubusw", "psubusw", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_psubw_Pq_Qq = { "psubw", "psubw", Pq, Qq, XX, XX, IA_MMX },
Ia_psubw_Vdq_Wdq = { "psubw", "psubw", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_pswapd_Pq_Qq = { "pswapd", "pswapd", Pq, Qq, XX, XX, IA_3DNOW },
Ia_ptest_Vdq_Wdq = { "ptest", "ptest", Vdq, Wdq, XX, XX, IA_SSE4_1 },
Ia_punpckhbw_Pq_Qq = { "punpckhbw", "punpckhbw", Pq, Qq, XX, XX, IA_MMX },
Ia_punpckhbw_Vdq_Wdq = { "punpckhbw", "punpckhbw", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_punpckhdq_Pq_Qq = { "punpckhdq", "punpckhdq", Pq, Qq, XX, XX, IA_MMX },
Ia_punpckhdq_Vdq_Wdq = { "punpckhdq", "punpckhdq", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_punpckhqdq_Vdq_Wdq = { "punpckhqdq", "punpckhqdq", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_punpckhwd_Pq_Qq = { "punpckhwd", "punpckhwd", Pq, Qq, XX, XX, IA_MMX },
Ia_punpckhwd_Vdq_Wdq = { "punpckhwd", "punpckhwd", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_punpcklbw_Pq_Qd = { "punpcklbw", "punpcklbw", Pq, Qd, XX, XX, IA_MMX },
Ia_punpcklbw_Vdq_Wdq = { "punpcklbw", "punpcklbw", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_punpckldq_Pq_Qd = { "punpckldq", "punpckldq", Pq, Qd, XX, XX, IA_MMX },
Ia_punpckldq_Vdq_Wdq = { "punpckldq", "punpckldq", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_punpcklqdq_Vdq_Wdq = { "punpcklqdq", "punpcklqdq", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_punpcklwd_Pq_Qd = { "punpcklwd", "punpcklwd", Pq, Qd, XX, XX, IA_MMX },
Ia_punpcklwd_Vdq_Wdq = { "punpcklwd", "punpcklwd", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_pushal = { "pusha", "pushal", XX, XX, XX, XX, 0 },
Ia_pushaw = { "pusha", "pusha", XX, XX, XX, XX, 0 },
Ia_pushfl = { "pushf", "pushfl", XX, XX, XX, XX, 0 },
Ia_pushfq = { "pushf", "pushfq", XX, XX, XX, XX, 0 },
Ia_pushfw = { "pushf", "pushf", XX, XX, XX, XX, 0 },
Ia_pushl_CS = { "push", "pushl", CS, XX, XX, XX, 0 },
Ia_pushl_DS = { "push", "pushl", DS, XX, XX, XX, 0 },
Ia_pushl_Ed = { "push", "pushl", Ed, XX, XX, XX, 0 },
Ia_pushl_ERX = { "push", "pushl", ERX, XX, XX, XX, 0 },
Ia_pushl_ES = { "push", "pushl", ES, XX, XX, XX, 0 },
Ia_pushl_FS = { "push", "pushl", FS, XX, XX, XX, 0 },
Ia_pushl_GS = { "push", "pushl", GS, XX, XX, XX, 0 },
Ia_pushl_Id = { "push", "pushl", Id, XX, XX, XX, 0 },
Ia_pushl_sIb = { "push", "pushl", sIbd, XX, XX, XX, 0 },
Ia_pushl_SS = { "push", "pushl", SS, XX, XX, XX, 0 },
Ia_pushq_Eq = { "push", "pushq", Eq, XX, XX, XX, 0 },
Ia_pushq_FS = { "push", "pushq", FS, XX, XX, XX, 0 },
Ia_pushq_GS = { "push", "pushq", GS, XX, XX, XX, 0 },
Ia_pushq_RRX = { "push", "pushq", RRX, XX, XX, XX, 0 },
Ia_pushq_sIb = { "push", "pushq", sIbq, XX, XX, XX, 0 },
Ia_pushq_sId = { "push", "pushq", sIdq, XX, XX, XX, 0 },
Ia_pushw_CS = { "push", "pushw", CS, XX, XX, XX, 0 },
Ia_pushw_DS = { "push", "pushw", DS, XX, XX, XX, 0 },
Ia_pushw_ES = { "push", "pushw", ES, XX, XX, XX, 0 },
Ia_pushw_Ew = { "push", "pushw", Ew, XX, XX, XX, 0 },
Ia_pushw_FS = { "push", "pushw", FS, XX, XX, XX, 0 },
Ia_pushw_GS = { "push", "pushw", GS, XX, XX, XX, 0 },
Ia_pushw_Iw = { "push", "pushw", Iw, XX, XX, XX, 0 },
Ia_pushw_RX = { "push", "pushw", RX, XX, XX, XX, 0 },
Ia_pushw_sIb = { "push", "pushw", sIbw, XX, XX, XX, 0 },
Ia_pushw_SS = { "push", "pushw", SS, XX, XX, XX, 0 },
Ia_pxor_Pq_Qq = { "pxor", "pxor", Pq, Qq, XX, XX, IA_MMX },
Ia_pxor_Vdq_Wdq = { "pxor", "pxor", Vdq, Wdq, XX, XX, IA_SSE2 },
Ia_rclb_Eb_CL = { "rcl", "rclb", Eb, CL_Reg, XX, XX, 0 },
Ia_rclb_Eb_I1 = { "rcl", "rclb", Eb, I1, XX, XX, 0 },
Ia_rclb_Eb_Ib = { "rcl", "rclb", Eb, Ib, XX, XX, 0 },
Ia_rcll_Ed_CL = { "rcl", "rcll", Ed, CL_Reg, XX, XX, 0 },
Ia_rcll_Ed_I1 = { "rcl", "rcll", Ed, I1, XX, XX, 0 },
Ia_rcll_Ed_Ib = { "rcl", "rcll", Ed, Ib, XX, XX, 0 },
Ia_rclq_Eq_CL = { "rcl", "rclq", Eq, CL_Reg, XX, XX, 0 },
Ia_rclq_Eq_I1 = { "rcl", "rclq", Eq, I1, XX, XX, 0 },
Ia_rclq_Eq_Ib = { "rcl", "rclq", Eq, Ib, XX, XX, 0 },
Ia_rclw_Ew_CL = { "rcl", "rclw", Ew, CL_Reg, XX, XX, 0 },
Ia_rclw_Ew_I1 = { "rcl", "rclw", Ew, I1, XX, XX, 0 },
Ia_rclw_Ew_Ib = { "rcl", "rclw", Ew, Ib, XX, XX, 0 },
Ia_rcpps_Vps_Wps = { "rcpps", "rcpps", Vps, Wps, XX, XX, IA_SSE },
Ia_rcpss_Vss_Wss = { "rcpss", "rcpss", Vss, Wss, XX, XX, IA_SSE },
Ia_rcrb_Eb_CL = { "rcr", "rcrb", Eb, CL_Reg, XX, XX, 0 },
Ia_rcrb_Eb_I1 = { "rcr", "rcrb", Eb, I1, XX, XX, 0 },
Ia_rcrb_Eb_Ib = { "rcr", "rcrb", Eb, Ib, XX, XX, 0 },
Ia_rcrl_Ed_CL = { "rcr", "rcrl", Ed, CL_Reg, XX, XX, 0 },
Ia_rcrl_Ed_I1 = { "rcr", "rcrl", Ed, I1, XX, XX, 0 },
Ia_rcrl_Ed_Ib = { "rcr", "rcrl", Ed, Ib, XX, XX, 0 },
Ia_rcrq_Eq_CL = { "rcr", "rcrq", Eq, CL_Reg, XX, XX, 0 },
Ia_rcrq_Eq_I1 = { "rcr", "rcrq", Eq, I1, XX, XX, 0 },
Ia_rcrq_Eq_Ib = { "rcr", "rcrq", Eq, Ib, XX, XX, 0 },
Ia_rcrw_Ew_CL = { "rcr", "rcrw", Ew, CL_Reg, XX, XX, 0 },
Ia_rcrw_Ew_I1 = { "rcr", "rcrw", Ew, I1, XX, XX, 0 },
Ia_rcrw_Ew_Ib = { "rcr", "rcrw", Ew, Ib, XX, XX, 0 },
Ia_rdfsbase_Ry = { "rdfsbase", "rdfsbase", Ry, XX, XX, XX, IA_FSGSBASE },
Ia_rdgsbase_Ry = { "rdgsbase", "rdgsbase", Ry, XX, XX, XX, IA_FSGSBASE },
Ia_rdmsr = { "rdmsr", "rdmsr", XX, XX, XX, XX, IA_PENTIUM },
Ia_rdpmc = { "rdpmc", "rdpmc", XX, XX, XX, XX, IA_P6 },
Ia_rdrand_Ed = { "rdrand", "rdrandd", Ed, XX, XX, XX, IA_RDRAND },
Ia_rdrand_Eq = { "rdrand", "rdrandq", Eq, XX, XX, XX, IA_RDRAND },
Ia_rdrand_Ew = { "rdrand", "rdrandw", Ew, XX, XX, XX, IA_RDRAND },
Ia_rdseed_Ed = { "rdseed", "rdseedd", Ed, XX, XX, XX, IA_RDSEED },
Ia_rdseed_Eq = { "rdseed", "rdseedq", Eq, XX, XX, XX, IA_RDSEED },
Ia_rdseed_Ew = { "rdseed", "rdseedw", Ew, XX, XX, XX, IA_RDSEED },
Ia_rdtsc = { "rdtsc", "rdtsc", XX, XX, XX, XX, IA_PENTIUM },
Ia_rdtscp = { "rdtscp", "rdtscp", XX, XX, XX, XX, IA_RDTSCP },
Ia_ret = { "ret", "ret", XX, XX, XX, XX, 0 },
Ia_ret_Iw = { "ret", "ret", Iw, XX, XX, XX, 0 },
Ia_rolb_Eb_CL = { "rol", "rolb", Eb, CL_Reg, XX, XX, 0 },
Ia_rolb_Eb_I1 = { "rol", "rolb", Eb, I1, XX, XX, 0 },
Ia_rolb_Eb_Ib = { "rol", "rolb", Eb, Ib, XX, XX, 0 },
Ia_roll_Ed_CL = { "rol", "roll", Ed, CL_Reg, XX, XX, 0 },
Ia_roll_Ed_I1 = { "rol", "roll", Ed, I1, XX, XX, 0 },
Ia_roll_Ed_Ib = { "rol", "roll", Ed, Ib, XX, XX, 0 },
Ia_rolq_Eq_CL = { "rol", "rolq", Eq, CL_Reg, XX, XX, 0 },
Ia_rolq_Eq_I1 = { "rol", "rolq", Eq, I1, XX, XX, 0 },
Ia_rolq_Eq_Ib = { "rol", "rolq", Eq, Ib, XX, XX, 0 },
Ia_rolw_Ew_CL = { "rol", "rolw", Ew, CL_Reg, XX, XX, 0 },
Ia_rolw_Ew_I1 = { "rol", "rolw", Ew, I1, XX, XX, 0 },
Ia_rolw_Ew_Ib = { "rol", "rolw", Ew, Ib, XX, XX, 0 },
Ia_rorb_Eb_CL = { "ror", "rorb", Eb, CL_Reg, XX, XX, 0 },
Ia_rorb_Eb_I1 = { "ror", "rorb", Eb, I1, XX, XX, 0 },
Ia_rorb_Eb_Ib = { "ror", "rorb", Eb, Ib, XX, XX, 0 },
Ia_rorl_Ed_CL = { "ror", "rorl", Ed, CL_Reg, XX, XX, 0 },
Ia_rorl_Ed_I1 = { "ror", "rorl", Ed, I1, XX, XX, 0 },
Ia_rorl_Ed_Ib = { "ror", "rorl", Ed, Ib, XX, XX, 0 },
Ia_rorq_Eq_CL = { "ror", "rorq", Eq, CL_Reg, XX, XX, 0 },
Ia_rorq_Eq_I1 = { "ror", "rorq", Eq, I1, XX, XX, 0 },
Ia_rorq_Eq_Ib = { "ror", "rorq", Eq, Ib, XX, XX, 0 },
Ia_rorw_Ew_CL = { "ror", "rorw", Ew, CL_Reg, XX, XX, 0 },
Ia_rorw_Ew_I1 = { "ror", "rorw", Ew, I1, XX, XX, 0 },
Ia_rorw_Ew_Ib = { "ror", "rorw", Ew, Ib, XX, XX, 0 },
Ia_rorx_Gy_Ey_Ib = { "rorx", "rorx", Gy, Ey, Ib, XX, IA_BMI2 },
Ia_roundpd_Vpd_Wpd_Ib = { "roundpd", "roundpd", Vpd, Wpd, Ib, XX, IA_SSE4_1 },
Ia_roundps_Vps_Wps_Ib = { "roundps", "roundps", Vps, Wps, Ib, XX, IA_SSE4_1 },
Ia_roundsd_Vsd_Wsd_Ib = { "roundsd", "roundsd", Vsd, Wsd, Ib, XX, IA_SSE4_1 },
Ia_roundss_Vss_Wss_Ib = { "roundss", "roundss", Vss, Wss, Ib, XX, IA_SSE4_1 },
Ia_rsm = { "rsm", "rsm", XX, XX, XX, XX, 0 },
Ia_rsqrtps_Vps_Wps = { "rsqrtps", "rsqrtps", Vps, Wps, XX, XX, IA_SSE },
Ia_rsqrtss_Vss_Wss = { "rsqrtss", "rsqrtss", Vss, Wss, XX, XX, IA_SSE },
Ia_sahf = { "sahf", "sahf", XX, XX, XX, XX, 0 },
Ia_salc = { "salc", "salc", XX, XX, XX, XX, 0 },
Ia_sarb_Eb_CL = { "sar", "sarb", Eb, CL_Reg, XX, XX, 0 },
Ia_sarb_Eb_I1 = { "sar", "sarb", Eb, I1, XX, XX, 0 },
Ia_sarb_Eb_Ib = { "sar", "sarb", Eb, Ib, XX, XX, 0 },
Ia_sarl_Ed_CL = { "sar", "sarl", Ed, CL_Reg, XX, XX, 0 },
Ia_sarl_Ed_I1 = { "sar", "sarl", Ed, I1, XX, XX, 0 },
Ia_sarl_Ed_Ib = { "sar", "sarl", Ed, Ib, XX, XX, 0 },
Ia_sarq_Eq_CL = { "sar", "sarq", Eq, CL_Reg, XX, XX, 0 },
Ia_sarq_Eq_I1 = { "sar", "sarq", Eq, I1, XX, XX, 0 },
Ia_sarq_Eq_Ib = { "sar", "sarq", Eq, Ib, XX, XX, 0 },
Ia_sarw_Ew_CL = { "sar", "sarw", Ew, CL_Reg, XX, XX, 0 },
Ia_sarw_Ew_I1 = { "sar", "sarw", Ew, I1, XX, XX, 0 },
Ia_sarw_Ew_Ib = { "sar", "sarw", Ew, Ib, XX, XX, 0 },
Ia_sarx_Gy_Ey_By = { "sarx", "sarx", Gy, Ey, By, XX, IA_BMI2 },
Ia_sbbb_AL_Ib = { "sbb", "sbbb", AL_Reg, Ib, XX, XX, 0 },
Ia_sbbb_Eb_Gb = { "sbb", "sbbb", Eb, Gb, XX, XX, 0 },
Ia_sbbb_Eb_Ib = { "sbb", "sbbb", Eb, Ib, XX, XX, 0 },
Ia_sbbb_Gb_Eb = { "sbb", "sbbb", Gb, Eb, XX, XX, 0 },
Ia_sbbl_EAX_Id = { "sbb", "sbbl", EAX_Reg, Id, XX, XX, 0 },
Ia_sbbl_Ed_Gd = { "sbb", "sbbl", Ed, Gd, XX, XX, 0 },
Ia_sbbl_Ed_Id = { "sbb", "sbbl", Ed, Id, XX, XX, 0 },
Ia_sbbl_Ed_sIb = { "sbb", "sbbl", Ed, sIbd, XX, XX, 0 },
Ia_sbbl_Gd_Ed = { "sbb", "sbbl", Gd, Ed, XX, XX, 0 },
Ia_sbbq_Eq_Gq = { "sbb", "sbbq", Eq, Gq, XX, XX, 0 },
Ia_sbbq_Eq_sIb = { "sbb", "sbbq", Eq, sIbq, XX, XX, 0 },
Ia_sbbq_Eq_sId = { "sbb", "sbbq", Eq, sIdq, XX, XX, 0 },
Ia_sbbq_Gq_Eq = { "sbb", "sbbq", Gq, Eq, XX, XX, 0 },
Ia_sbbq_RAX_sId = { "sbb", "sbbq", RAX_Reg, sIdq, XX, XX, 0 },
Ia_sbbw_AX_Iw = { "sbb", "sbbw", AX_Reg, Iw, XX, XX, 0 },
Ia_sbbw_Ew_Gw = { "sbb", "sbbw", Ew, Gw, XX, XX, 0 },
Ia_sbbw_Ew_Iw = { "sbb", "sbbw", Ew, Iw, XX, XX, 0 },
Ia_sbbw_Ew_sIb = { "sbb", "sbbw", Ew, sIbw, XX, XX, 0 },
Ia_sbbw_Gw_Ew = { "sbb", "sbbw", Gw, Ew, XX, XX, 0 },
Ia_scasb_AL_Yb = { "scasb", "scasb", AL_Reg, Yb, XX, XX, 0 },
Ia_scasl_EAX_Yd = { "scasd", "scasl", EAX_Reg, Yd, XX, XX, 0 },
Ia_scasq_RAX_Yq = { "scasq", "scasq", RAX_Reg, Yq, XX, XX, 0 },
Ia_scasw_AX_Yw = { "scasw", "scasw", AX_Reg, Yw, XX, XX, 0 },
Ia_setb_Eb = { "setb", "setb", Eb, XX, XX, XX, 0 },
Ia_setbe_Eb = { "setbe", "setbe", Eb, XX, XX, XX, 0 },
Ia_setl_Eb = { "setl", "setl", Eb, XX, XX, XX, 0 },
Ia_setle_Eb = { "setle", "setle", Eb, XX, XX, XX, 0 },
Ia_setnb_Eb = { "setnb", "setnb", Eb, XX, XX, XX, 0 },
Ia_setnbe_Eb = { "setnbe", "setnbe", Eb, XX, XX, XX, 0 },
Ia_setnl_Eb = { "setnl", "setnl", Eb, XX, XX, XX, 0 },
Ia_setnle_Eb = { "setnle", "setnle", Eb, XX, XX, XX, 0 },
Ia_setno_Eb = { "setno", "setno", Eb, XX, XX, XX, 0 },
Ia_setnp_Eb = { "setnp", "setnp", Eb, XX, XX, XX, 0 },
Ia_setns_Eb = { "setns", "setns", Eb, XX, XX, XX, 0 },
Ia_setnz_Eb = { "setnz", "setnz", Eb, XX, XX, XX, 0 },
Ia_seto_Eb = { "seto", "seto", Eb, XX, XX, XX, 0 },
Ia_setp_Eb = { "setp", "setp", Eb, XX, XX, XX, 0 },
Ia_sets_Eb = { "sets", "sets", Eb, XX, XX, XX, 0 },
Ia_setz_Eb = { "setz", "setz", Eb, XX, XX, XX, 0 },
Ia_sfence = { "sfence", "sfence", XX, XX, XX, XX, IA_SSE },
Ia_sgdt = { "sgdt", "sgdt", Ms, XX, XX, XX, 0 },
Ia_sha1msg1_Vdq_Wdq = { "sha1msg1", "sha1msg1", Vdq, Wdq, XX, XX, IA_SHA },
Ia_sha1msg2_Vdq_Wdq = { "sha1msg2", "sha1msg2", Vdq, Wdq, XX, XX, IA_SHA },
Ia_sha1nexte_Vdq_Wdq = { "sha1nexte", "sha1nexte", Vdq, Wdq, XX, XX, IA_SHA },
Ia_sha1rnds4_Vdq_Wdq_Ib = { "sha1rnds4", "sha1rnds4", Vdq, Wdq, Ib, XX, IA_SHA },
Ia_sha256msg1_Vdq_Wdq = { "sha256msg1", "sha256msg1", Vdq, Wdq, XX, XX, IA_SHA },
Ia_sha256msg2_Vdq_Wdq = { "sha256msg2", "sha256msg2", Vdq, Wdq, XX, XX, IA_SHA },
Ia_sha256rnds2_Vdq_Wdq = { "sha256rnds2", "sha256rnds2", Vdq, Wdq, XX, XX, IA_SHA },
Ia_shlb_Eb_CL = { "shl", "shlb", Eb, CL_Reg, XX, XX, 0 },
Ia_shlb_Eb_I1 = { "shl", "shlb", Eb, I1, XX, XX, 0 },
Ia_shlb_Eb_Ib = { "shl", "shlb", Eb, Ib, XX, XX, 0 },
Ia_shldl_Ed_Gd_CL = { "shld", "shldl", Ed, Gd, CL_Reg, XX, 0 },
Ia_shldl_Ed_Gd_Ib = { "shld", "shldl", Ed, Gd, Ib, XX, 0 },
Ia_shldq_Eq_Gq_CL = { "shld", "shldq", Eq, Gq, CL_Reg, XX, 0 },
Ia_shldq_Eq_Gq_Ib = { "shld", "shldq", Eq, Gq, Ib, XX, 0 },
Ia_shldw_Ew_Gw_CL = { "shld", "shldw", Ew, Gw, CL_Reg, XX, 0 },
Ia_shldw_Ew_Gw_Ib = { "shld", "shldw", Ew, Gw, Ib, XX, 0 },
Ia_shll_Ed_CL = { "shl", "shll", Ed, CL_Reg, XX, XX, 0 },
Ia_shll_Ed_I1 = { "shl", "shll", Ed, I1, XX, XX, 0 },
Ia_shll_Ed_Ib = { "shl", "shll", Ed, Ib, XX, XX, 0 },
Ia_shlq_Eq_CL = { "shl", "shlq", Eq, CL_Reg, XX, XX, 0 },
Ia_shlq_Eq_I1 = { "shl", "shlq", Eq, I1, XX, XX, 0 },
Ia_shlq_Eq_Ib = { "shl", "shlq", Eq, Ib, XX, XX, 0 },
Ia_shlw_Ew_CL = { "shl", "shlw", Ew, CL_Reg, XX, XX, 0 },
Ia_shlw_Ew_I1 = { "shl", "shlw", Ew, I1, XX, XX, 0 },
Ia_shlw_Ew_Ib = { "shl", "shlw", Ew, Ib, XX, XX, 0 },
Ia_shlx_Gy_Ey_By = { "shlx", "shlx", Gy, Ey, By, XX, IA_BMI2 },
Ia_shrb_Eb_CL = { "shr", "shrb", Eb, CL_Reg, XX, XX, 0 },
Ia_shrb_Eb_I1 = { "shr", "shrb", Eb, I1, XX, XX, 0 },
Ia_shrb_Eb_Ib = { "shr", "shrb", Eb, Ib, XX, XX, 0 },
Ia_shrdl_Ed_Gd_CL = { "shrd", "shrdl", Ed, Gd, CL_Reg, XX, 0 },
Ia_shrdl_Ed_Gd_Ib = { "shrd", "shrdl", Ed, Gd, Ib, XX, 0 },
Ia_shrdq_Eq_Gq_CL = { "shrd", "shrdq", Eq, Gq, CL_Reg, XX, 0 },
Ia_shrdq_Eq_Gq_Ib = { "shrd", "shrdq", Eq, Gq, Ib, XX, 0 },
Ia_shrdw_Ew_Gw_CL = { "shrd", "shrdw", Ew, Gw, CL_Reg, XX, 0 },
Ia_shrdw_Ew_Gw_Ib = { "shrd", "shrdw", Ew, Gw, Ib, XX, 0 },
Ia_shrl_Ed_CL = { "shr", "shrl", Ed, CL_Reg, XX, XX, 0 },
Ia_shrl_Ed_I1 = { "shr", "shrl", Ed, I1, XX, XX, 0 },
Ia_shrl_Ed_Ib = { "shr", "shrl", Ed, Ib, XX, XX, 0 },
Ia_shrq_Eq_CL = { "shr", "shrq", Eq, CL_Reg, XX, XX, 0 },
Ia_shrq_Eq_I1 = { "shr", "shrq", Eq, I1, XX, XX, 0 },
Ia_shrq_Eq_Ib = { "shr", "shrq", Eq, Ib, XX, XX, 0 },
Ia_shrw_Ew_CL = { "shr", "shrw", Ew, CL_Reg, XX, XX, 0 },
Ia_shrw_Ew_I1 = { "shr", "shrw", Ew, I1, XX, XX, 0 },
Ia_shrw_Ew_Ib = { "shr", "shrw", Ew, Ib, XX, XX, 0 },
Ia_shrx_Gy_Ey_By = { "shrx", "shrx", Gy, Ey, By, XX, IA_BMI2 },
Ia_shufpd_Vpd_Wpd_Ib = { "shufpd", "shufpd", Vpd, Wpd, Ib, XX, IA_SSE2 },
Ia_shufps_Vps_Wps_Ib = { "shufps", "shufps", Vps, Wps, Ib, XX, IA_SSE },
Ia_sidt = { "sidt", "sidt", Ms, XX, XX, XX, 0 },
Ia_skinit = { "skinit", "skinit", RAX_Reg, XX, XX, XX, IA_SVM },
Ia_sldt = { "sldt", "sldt", Ew, XX, XX, XX, 0 },
Ia_smsw_Ew = { "smsw", "smsw", Ew, XX, XX, XX, 0 },
Ia_sqrtpd_Vpd_Wpd = { "sqrtpd", "sqrtpd", Vpd, Wpd, XX, XX, IA_SSE2 },
Ia_sqrtps_Vps_Wps = { "sqrtps", "sqrtps", Vps, Wps, XX, XX, IA_SSE },
Ia_sqrtsd_Vsd_Wsd = { "sqrtsd", "sqrtsd", Vsd, Wsd, XX, XX, IA_SSE2 },
Ia_sqrtss_Vss_Wss = { "sqrtss", "sqrtss", Vss, Wss, XX, XX, IA_SSE },
Ia_stac = { "stac", "stac", XX, XX, XX, XX, IA_SMAP },
Ia_stc = { "stc", "stc", XX, XX, XX, XX, 0 },
Ia_std = { "std", "std", XX, XX, XX, XX, 0 },
Ia_stgi = { "stgi", "stgi", XX, XX, XX, XX, IA_SVM },
Ia_sti = { "sti", "sti", XX, XX, XX, XX, 0 },
Ia_stmxcsr = { "stmxcsr", "stmxcsr", Md, XX, XX, XX, IA_SSE },
Ia_stosb_Yb_AL = { "stosb", "stosb", Yb, AL_Reg, XX, XX, 0 },
Ia_stosl_Yd_EAX = { "stosd", "stosl", Yd, EAX_Reg, XX, XX, 0 },
Ia_stosq_Yq_RAX = { "stosq", "stosq", Yq, RAX_Reg, XX, XX, 0 },
Ia_stosw_Yw_AX = { "stosw", "stosw", Yw, AX_Reg, XX, XX, 0 },
Ia_str = { "str", "str", Ew, XX, XX, XX, 0 },
Ia_subb_AL_Ib = { "sub", "subb", AL_Reg, Ib, XX, XX, 0 },
Ia_subb_Eb_Gb = { "sub", "subb", Eb, Gb, XX, XX, 0 },
Ia_subb_Eb_Ib = { "sub", "subb", Eb, Ib, XX, XX, 0 },
Ia_subb_Gb_Eb = { "sub", "subb", Gb, Eb, XX, XX, 0 },
Ia_subl_EAX_Id = { "sub", "subl", EAX_Reg, Id, XX, XX, 0 },
Ia_subl_Ed_Gd = { "sub", "subl", Ed, Gd, XX, XX, 0 },
Ia_subl_Ed_Id = { "sub", "subl", Ed, Id, XX, XX, 0 },
Ia_subl_Ed_sIb = { "sub", "subl", Ed, sIbd, XX, XX, 0 },
Ia_subl_Gd_Ed = { "sub", "subl", Gd, Ed, XX, XX, 0 },
Ia_subpd_Vpd_Wpd = { "subpd", "subpd", Vpd, Wpd, XX, XX, IA_SSE2 },
Ia_subps_Vps_Wps = { "subps", "subps", Vps, Wps, XX, XX, IA_SSE },
Ia_subq_Eq_Gq = { "sub", "subq", Eq, Gq, XX, XX, 0 },
Ia_subq_Eq_sIb = { "sub", "subq", Eq, sIbq, XX, XX, 0 },
Ia_subq_Eq_sId = { "sub", "subq", Eq, sIdq, XX, XX, 0 },
Ia_subq_Gq_Eq = { "sub", "subq", Gq, Eq, XX, XX, 0 },
Ia_subq_RAX_sId = { "sub", "subq", RAX_Reg, sIdq, XX, XX, 0 },
Ia_subsd_Vsd_Wsd = { "subsd", "subsd", Vsd, Wsd, XX, XX, IA_SSE2 },
Ia_subss_Vss_Wss = { "subss", "subss", Vss, Wss, XX, XX, IA_SSE },
Ia_subw_AX_Iw = { "sub", "subw", AX_Reg, Iw, XX, XX, 0 },
Ia_subw_Ew_Gw = { "sub", "subw", Ew, Gw, XX, XX, 0 },
Ia_subw_Ew_Iw = { "sub", "subw", Ew, Iw, XX, XX, 0 },
Ia_subw_Ew_sIb = { "sub", "subw", Ew, sIbw, XX, XX, 0 },
Ia_subw_Gw_Ew = { "sub", "subw", Gw, Ew, XX, XX, 0 },
Ia_swapgs = { "swapgs", "swapgs", XX, XX, XX, XX, 0 },
Ia_syscall = { "syscall", "syscall", XX, XX, XX, XX, 0 },
Ia_sysenter = { "sysenter", "sysenter", XX, XX, XX, XX, IA_SYSENTER_SYSEXIT },
Ia_sysexit = { "sysexit", "sysexit", XX, XX, XX, XX, IA_SYSENTER_SYSEXIT },
Ia_sysret = { "sysret", "sysret", XX, XX, XX, XX, 0 },
Ia_t1mskc_By_Ey = { "t1mskc", "t1mskc", Gy, By, Ey, XX, IA_TBM },
Ia_testb_AL_Ib = { "test", "testb", AL_Reg, Ib, XX, XX, 0 },
Ia_testb_Eb_Gb = { "test", "testb", Eb, Gb, XX, XX, 0 },
Ia_testb_Eb_Ib = { "test", "testb", Eb, Ib, XX, XX, 0 },
Ia_testl_EAX_Id = { "test", "testl", EAX_Reg, Id, XX, XX, 0 },
Ia_testl_Ed_Gd = { "test", "testl", Ed, Gd, XX, XX, 0 },
Ia_testl_Ed_Id = { "test", "testl", Ed, Id, XX, XX, 0 },
Ia_testq_Eq_Gq = { "test", "testq", Eq, Gq, XX, XX, 0 },
Ia_testq_Eq_sId = { "test", "testq", Eq, sIdq, XX, XX, 0 },
Ia_testq_RAX_sId = { "test", "testq", RAX_Reg, sIdq, XX, XX, 0 },
Ia_testw_AX_Iw = { "test", "testw", AX_Reg, Iw, XX, XX, 0 },
Ia_testw_Ew_Gw = { "test", "testw", Ew, Gw, XX, XX, 0 },
Ia_testw_Ew_Iw = { "test", "testw", Ew, Iw, XX, XX, 0 },
Ia_tzcntl_Gd_Ed = { "tzcnt", "tzcntl", Gd, Ed, XX, XX, IA_BMI1 },
Ia_tzcntq_Gq_Eq = { "tzcnt", "tzcntq", Gq, Eq, XX, XX, IA_BMI1 },
Ia_tzcntw_Gw_Ew = { "tzcnt", "tzcntw", Gw, Ew, XX, XX, IA_BMI1 },
Ia_tzmsk_By_Ey = { "tzmsk", "tzmsk", Gy, By, Ey, XX, IA_TBM },
Ia_ucomisd_Vsd_Wsd = { "ucomisd", "ucomisd", Vsd, Wsd, XX, XX, IA_SSE2 },
Ia_ucomiss_Vss_Wss = { "ucomiss", "ucomiss", Vss, Wss, XX, XX, IA_SSE },
Ia_ud2a = { "ud2a", "ud2a", XX, XX, XX, XX, 0 },
Ia_ud2b = { "ud2b", "ud2b", XX, XX, XX, XX, 0 },
Ia_unpckhpd_Vpd_Wpd = { "unpckhpd", "unpckhpd", Vpd, Wpd, XX, XX, IA_SSE2 },
Ia_unpckhps_Vps_Wps = { "unpckhps", "unpckhps", Vps, Wps, XX, XX, IA_SSE },
Ia_unpcklpd_Vpd_Wpd = { "unpcklpd", "unpcklpd", Vpd, Wpd, XX, XX, IA_SSE2 },
Ia_unpcklps_Vps_Wps = { "unpcklps", "unpcklps", Vps, Wps, XX, XX, IA_SSE },
Ia_vaddpd_Vpd_Hpd_Wpd = { "vaddpd", "vaddpd", Vpd, Hpd, Wpd, XX, IA_AVX },
Ia_vaddps_Vps_Hps_Wps = { "vaddps", "vaddps", Vps, Hps, Wps, XX, IA_AVX },
Ia_vaddsd_Vsd_Hpd_Wsd = { "vaddsd", "vaddsd", Vsd, Hpd, Wsd, XX, IA_AVX },
Ia_vaddss_Vss_Hps_Wss = { "vaddss", "vaddss", Vss, Hps, Wss, XX, IA_AVX },
Ia_vaddsubpd_Vpd_Hpd_Wpd = { "vaddsubpd", "vaddsubpd", Vpd, Hpd, Wpd, XX, IA_AVX },
Ia_vaddsubps_Vps_Hps_Wps = { "vaddsubps", "vaddsubps", Vps, Hps, Wps, XX, IA_AVX },
Ia_vaesdec_Vdq_Hdq_Wdq = { "vaesdec", "vaesdec", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vaesdeclast_Vdq_Hdq_Wdq = { "vaesdeclast", "vaesdeclast", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vaesenc_Vdq_Hdq_Wdq = { "vaesenc", "vaesenc", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vaesenclast_Vdq_Hdq_Wdq = { "vaesenclast", "vaesenclast", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vaesimc_Vdq_Wdq = { "vaesimc", "vaesimc", Vdq, Wdq, XX, XX, IA_AVX },
Ia_vaeskeygenassist_Vdq_Wdq_Ib = { "vaeskeygenassist", "vaeskeygenassist", Vdq, Wdq, Ib, XX, IA_AVX },
Ia_vandnpd_Vpd_Hpd_Wpd = { "vandnpd", "vandnpd", Vpd, Hpd, Wpd, XX, IA_AVX },
Ia_vandnps_Vps_Hps_Wps = { "vandnps", "vandnps", Vps, Hps, Wps, XX, IA_AVX },
Ia_vandpd_Vpd_Hpd_Wpd = { "vandpd", "vandpd", Vpd, Hpd, Wpd, XX, IA_AVX },
Ia_vandps_Vps_Hps_Wps = { "vandps", "vandps", Vps, Hps, Wps, XX, IA_AVX },
Ia_vblendpd_Vpd_Hpd_Wpd_Ib = { "vblendpd", "vblendpd", Vpd, Hpd, Wpd, Ib, IA_AVX },
Ia_vblendps_Vps_Hps_Wps_Ib = { "vblendps", "vblendps", Vps, Hps, Wps, Ib, IA_AVX },
Ia_vblendvpd_Vpd_Hpd_Wpd_Ib = { "vblendvpd", "vblendvpd", Vpd, Hpd, Wpd, VIb, IA_AVX },
Ia_vblendvps_Vps_Hps_Wps_Ib = { "vblendvps", "vblendvps", Vps, Hps, Wps, VIb, IA_AVX },
Ia_vbroadcastf128_Vdq_Mdq = { "vbroadcastf128", "vbroadcastf128", Vdq, Mdq, XX, XX, IA_AVX },
Ia_vbroadcasti128_Vdq_Mdq = { "vbroadcasti128", "vbroadcasti128", Vdq, Mdq, XX, XX, IA_AVX2 },
Ia_vbroadcastsd_Vpd_Wsd = { "vbroadcastsd", "vbroadcastsd", Vpd, Wsd, XX, XX, IA_AVX },
Ia_vbroadcastss_Vps_Wss = { "vbroadcastss", "vbroadcastss", Vps, Wss, XX, XX, IA_AVX },
Ia_vcmppd_Vpd_Hpd_Wpd_Ib = { "vcmppd", "vcmppd", Vpd, Hpd, Wpd, Ib, IA_AVX },
Ia_vcmpps_Vps_Hps_Wps_Ib = { "vcmpps", "vcmpps", Vps, Hps, Wps, Ib, IA_AVX },
Ia_vcmpsd_Vsd_Hpd_Wsd_Ib = { "vcmpsd", "vcmpsd", Vsd, Hpd, Wsd, Ib, IA_AVX },
Ia_vcmpss_Vss_Hps_Wss_Ib = { "vcmpss", "vcmpss", Vss, Hps, Wss, Ib, IA_AVX },
Ia_vcomisd_Vsd_Wsd = { "vcomisd", "vcomisd", Vsd, Wsd, XX, XX, IA_AVX },
Ia_vcomiss_Vss_Wss = { "vcomiss", "vcomiss", Vss, Wss, XX, XX, IA_AVX },
Ia_vcvtdq2pd_Vpd_Wq = { "vcvtdq2pd", "vcvtdq2pd", Vpd, Wq, XX, XX, IA_AVX },
Ia_vcvtdq2ps_Vps_Wdq = { "vcvtdq2ps", "vcvtdq2ps", Vps, Wdq, XX, XX, IA_AVX },
Ia_vcvtpd2dq_Vq_Wpd = { "vcvtpd2dq", "vcvtpd2dq", Vq, Wpd, XX, XX, IA_AVX },
Ia_vcvtpd2ps_Vps_Wpd = { "vcvtpd2ps", "vcvtpd2ps", Vps, Wpd, XX, XX, IA_AVX },
Ia_vcvtph2ps_Vps_Wq = { "vcvtph2ps", "vcvtph2ps", Vps, Wq, XX, XX, IA_AVX_F16C },
Ia_vcvtps2dq_Vdq_Wps = { "vcvtps2dq", "vcvtps2dq", Vdq, Wps, XX, XX, IA_AVX },
Ia_vcvtps2pd_Vpd_Wps = { "vcvtps2pd", "vcvtps2pd", Vpd, Wps, XX, XX, IA_AVX },
Ia_vcvtps2ph_Wq_Vps_Ib = { "vcvtps2ph", "vcvtps2ph", Wq, Vps, Ib, XX, IA_AVX_F16C },
Ia_vcvtsd2si_Gy_Wsd = { "vcvtsd2si", "vcvtsd2si", Gy, Wsd, XX, XX, IA_AVX },
Ia_vcvtsd2ss_Vss_Hps_Wsd = { "vcvtsd2ss", "vcvtsd2ss", Vss, Hps, Wsd, XX, IA_AVX },
Ia_vcvtsi2sd_Vsd_Hpd_Ey = { "vcvtsi2sd", "vcvtsi2sd", Vsd, Hpd, Ey, XX, IA_AVX },
Ia_vcvtsi2ss_Vss_Hps_Ey = { "vcvtsi2ss", "vcvtsi2ss", Vss, Hps, Ey, XX, IA_AVX },
Ia_vcvtss2sd_Vsd_Hpd_Wss = { "vcvtss2sd", "vcvtss2sd", Vsd, Hpd, Wss, XX, IA_AVX },
Ia_vcvtss2si_Gy_Wss = { "vcvtss2si", "vcvtss2si", Gy, Wss, XX, XX, IA_AVX },
Ia_vcvttpd2dq_Vq_Wpd = { "vcvttpd2dq", "vcvttpd2dq", Vq, Wpd, XX, XX, IA_AVX },
Ia_vcvttps2dq_Vdq_Wps = { "vcvttps2dq", "vcvttps2dq", Vdq, Wps, XX, XX, IA_AVX },
Ia_vcvttsd2si_Gy_Wsd = { "vcvttsd2si", "vcvttsd2si", Gy, Wsd, XX, XX, IA_AVX },
Ia_vcvttss2si_Gy_Wss = { "vcvttss2si", "vcvttss2si", Gy, Wss, XX, XX, IA_AVX },
Ia_vdivpd_Vpd_Hpd_Wpd = { "vdivpd", "vdivpd", Vpd, Hpd, Wpd, XX, IA_AVX },
Ia_vdivps_Vps_Hps_Wps = { "vdivps", "vdivps", Vps, Hps, Wps, XX, IA_AVX },
Ia_vdivsd_Vsd_Hpd_Wsd = { "vdivsd", "vdivsd", Vsd, Hpd, Wsd, XX, IA_AVX },
Ia_vdivss_Vss_Hps_Wss = { "vdivss", "vdivss", Vss, Hps, Wss, XX, IA_AVX },
Ia_vdppd_Vpd_Hpd_Wpd_Ib = { "vdppd", "vdppd", Vpd, Hpd, Wpd, Ib, IA_AVX },
Ia_vdpps_Vps_Hps_Wps_Ib = { "vdpps", "vdpps", Vps, Hps, Wps, Ib, IA_AVX },
Ia_verr = { "verr", "verr", Ew, XX, XX, XX, 0 },
Ia_verw = { "verw", "verw", Ew, XX, XX, XX, 0 },
Ia_vextractf128_Wdq_Vdq_Ib = { "vextractf128", "vextractf128", Wdq, Vdq, Ib, XX, IA_AVX },
Ia_vextracti128_Wdq_Vdq_Ib = { "vextracti128", "vextracti128", Wdq, Vdq, Ib, XX, IA_AVX2 },
Ia_vextractps_Ed_Vdq_Ib = { "vextractps", "vextractps", Ed, Vdq, Ib, XX, IA_AVX },
Ia_vfmadd132pd_Vpd_Hpd_Wpd = { "vfmadd132pd", "vfmadd132pd", Vpd, Hpd, Wpd, XX, IA_AVX_FMA },
Ia_vfmadd132ps_Vps_Hps_Wps = { "vfmadd132ps", "vfmadd132ps", Vps, Hps, Wps, XX, IA_AVX_FMA },
Ia_vfmadd132sd_Vpd_Hsd_Wsd = { "vfmadd132sd", "vfmadd132sd", Vpd, Hsd, Wsd, XX, IA_AVX_FMA },
Ia_vfmadd132ss_Vps_Hss_Wss = { "vfmadd132ss", "vfmadd132ss", Vps, Hss, Wss, XX, IA_AVX_FMA },
Ia_vfmadd213pd_Vpd_Hpd_Wpd = { "vfmadd213pd", "vfmadd213pd", Vpd, Hpd, Wpd, XX, IA_AVX_FMA },
Ia_vfmadd213ps_Vps_Hps_Wps = { "vfmadd213ps", "vfmadd213ps", Vps, Hps, Wps, XX, IA_AVX_FMA },
Ia_vfmadd213sd_Vpd_Hsd_Wsd = { "vfmadd213sd", "vfmadd213sd", Vpd, Hsd, Wsd, XX, IA_AVX_FMA },
Ia_vfmadd213ss_Vps_Hss_Wss = { "vfmadd213ss", "vfmadd213ss", Vps, Hss, Wss, XX, IA_AVX_FMA },
Ia_vfmadd231pd_Vpd_Hpd_Wpd = { "vfmadd231pd", "vfmadd231pd", Vpd, Hpd, Wpd, XX, IA_AVX_FMA },
Ia_vfmadd231ps_Vps_Hps_Wps = { "vfmadd231ps", "vfmadd231ps", Vps, Hps, Wps, XX, IA_AVX_FMA },
Ia_vfmadd231sd_Vpd_Hsd_Wsd = { "vfmadd231sd", "vfmadd231sd", Vpd, Hsd, Wsd, XX, IA_AVX_FMA },
Ia_vfmadd231ss_Vps_Hss_Wss = { "vfmadd231ss", "vfmadd231ss", Vps, Hss, Wss, XX, IA_AVX_FMA },
Ia_vfmaddpd_Vpd_Hpd_VIb_Wpd = { "vfmaddpd", "vfmaddpd", Vpd, Hpd, VIb, Wpd, IA_FMA4 },
Ia_vfmaddpd_Vpd_Hpd_Wpd_VIb = { "vfmaddpd", "vfmaddpd", Vpd, Hpd, Wpd, VIb, IA_FMA4 },
Ia_vfmaddps_Vps_Hps_VIb_Wps = { "vfmaddps", "vfmaddps", Vps, Hps, VIb, Wps, IA_FMA4 },
Ia_vfmaddps_Vps_Hps_Wps_VIb = { "vfmaddps", "vfmaddps", Vps, Hps, Wps, VIb, IA_FMA4 },
Ia_vfmaddsd_Vsd_Hsd_VIb_Wsd = { "vfmaddsd", "vfmaddsd", Vsd, Hsd, VIb, Wsd, IA_FMA4 },
Ia_vfmaddsd_Vsd_Hsd_Wsd_VIb = { "vfmaddsd", "vfmaddsd", Vsd, Hsd, Wsd, VIb, IA_FMA4 },
Ia_vfmaddss_Vss_Hss_VIb_Wss = { "vfmaddss", "vfmaddss", Vss, Hss, VIb, Wss, IA_FMA4 },
Ia_vfmaddss_Vss_Hss_Wss_VIb = { "vfmaddss", "vfmaddss", Vss, Hss, Wss, VIb, IA_FMA4 },
Ia_vfmaddsub132pd_Vpd_Hpd_Wpd = { "vfmaddsub132pd", "vfmaddsub132pd", Vpd, Hpd, Wpd, XX, IA_AVX_FMA },
Ia_vfmaddsub132ps_Vps_Hps_Wps = { "vfmaddsub132ps", "vfmaddsub132ps", Vps, Hps, Wps, XX, IA_AVX_FMA },
Ia_vfmaddsub213pd_Vpd_Hpd_Wpd = { "vfmaddsub213pd", "vfmaddsub213pd", Vpd, Hpd, Wpd, XX, IA_AVX_FMA },
Ia_vfmaddsub213ps_Vps_Hps_Wps = { "vfmaddsub213ps", "vfmaddsub213ps", Vps, Hps, Wps, XX, IA_AVX_FMA },
Ia_vfmaddsub231pd_Vpd_Hpd_Wpd = { "vfmaddsub231pd", "vfmaddsub231pd", Vpd, Hpd, Wpd, XX, IA_AVX_FMA },
Ia_vfmaddsub231ps_Vps_Hps_Wps = { "vfmaddsub231ps", "vfmaddsub231ps", Vps, Hps, Wps, XX, IA_AVX_FMA },
Ia_vfmaddsubpd_Vpd_Hpd_VIb_Wpd = { "vfmaddsubpd", "vfmaddsubpd", Vpd, Hpd, VIb, Wpd, IA_FMA4 },
Ia_vfmaddsubpd_Vpd_Hpd_Wpd_VIb = { "vfmaddsubpd", "vfmaddsubpd", Vpd, Hpd, Wpd, VIb, IA_FMA4 },
Ia_vfmaddsubps_Vps_Hps_VIb_Wps = { "vfmaddsubps", "vfmaddsubps", Vps, Hps, VIb, Wps, IA_FMA4 },
Ia_vfmaddsubps_Vps_Hps_Wps_VIb = { "vfmaddsubps", "vfmaddsubps", Vps, Hps, Wps, VIb, IA_FMA4 },
Ia_vfmsub132pd_Vpd_Hpd_Wpd = { "vfmsub132pd", "vfmsub132pd", Vpd, Hpd, Wpd, XX, IA_AVX_FMA },
Ia_vfmsub132ps_Vps_Hps_Wps = { "vfmsub132ps", "vfmsub132ps", Vps, Hps, Wps, XX, IA_AVX_FMA },
Ia_vfmsub132sd_Vpd_Hsd_Wsd = { "vfmsub132sd", "vfmsub132sd", Vpd, Hsd, Wsd, XX, IA_AVX_FMA },
Ia_vfmsub132ss_Vps_Hss_Wss = { "vfmsub132ss", "vfmsub132ss", Vps, Hss, Wss, XX, IA_AVX_FMA },
Ia_vfmsub213pd_Vpd_Hpd_Wpd = { "vfmsub213pd", "vfmsub213pd", Vpd, Hpd, Wpd, XX, IA_AVX_FMA },
Ia_vfmsub213ps_Vps_Hps_Wps = { "vfmsub213ps", "vfmsub213ps", Vps, Hps, Wps, XX, IA_AVX_FMA },
Ia_vfmsub213sd_Vpd_Hsd_Wsd = { "vfmsub213sd", "vfmsub213sd", Vpd, Hsd, Wsd, XX, IA_AVX_FMA },
Ia_vfmsub213ss_Vps_Hss_Wss = { "vfmsub213ss", "vfmsub213ss", Vps, Hss, Wss, XX, IA_AVX_FMA },
Ia_vfmsub231pd_Vpd_Hpd_Wpd = { "vfmsub231pd", "vfmsub231pd", Vpd, Hpd, Wpd, XX, IA_AVX_FMA },
Ia_vfmsub231ps_Vps_Hps_Wps = { "vfmsub231ps", "vfmsub231ps", Vps, Hps, Wps, XX, IA_AVX_FMA },
Ia_vfmsub231sd_Vpd_Hsd_Wsd = { "vfmsub231sd", "vfmsub231sd", Vpd, Hsd, Wsd, XX, IA_AVX_FMA },
Ia_vfmsub231ss_Vps_Hss_Wss = { "vfmsub231ss", "vfmsub231ss", Vps, Hss, Wss, XX, IA_AVX_FMA },
Ia_vfmsubadd132pd_Vpd_Hpd_Wpd = { "vfmsubadd132pd", "vfmsubadd132pd", Vpd, Hpd, Wpd, XX, IA_AVX_FMA },
Ia_vfmsubadd132ps_Vps_Hps_Wps = { "vfmsubadd132ps", "vfmsubadd132ps", Vps, Hps, Wps, XX, IA_AVX_FMA },
Ia_vfmsubadd213pd_Vpd_Hpd_Wpd = { "vfmsubadd213pd", "vfmsubadd213pd", Vpd, Hpd, Wpd, XX, IA_AVX_FMA },
Ia_vfmsubadd213ps_Vps_Hps_Wps = { "vfmsubadd213ps", "vfmsubadd213ps", Vps, Hps, Wps, XX, IA_AVX_FMA },
Ia_vfmsubadd231pd_Vpd_Hpd_Wpd = { "vfmsubadd231pd", "vfmsubadd231pd", Vpd, Hpd, Wpd, XX, IA_AVX_FMA },
Ia_vfmsubadd231ps_Vps_Hps_Wps = { "vfmsubadd231ps", "vfmsubadd231ps", Vps, Hps, Wps, XX, IA_AVX_FMA },
Ia_vfmsubaddpd_Vpd_Hpd_VIb_Wpd = { "vfmsubaddpd", "vfmsubaddpd", Vpd, Hpd, VIb, Wpd, IA_FMA4 },
Ia_vfmsubaddpd_Vpd_Hpd_Wpd_VIb = { "vfmsubaddpd", "vfmsubaddpd", Vpd, Hpd, Wpd, VIb, IA_FMA4 },
Ia_vfmsubaddps_Vps_Hps_VIb_Wps = { "vfmsubaddps", "vfmsubaddps", Vps, Hps, VIb, Wps, IA_FMA4 },
Ia_vfmsubaddps_Vps_Hps_Wps_VIb = { "vfmsubaddps", "vfmsubaddps", Vps, Hps, Wps, VIb, IA_FMA4 },
Ia_vfmsubpd_Vpd_Hpd_VIb_Wpd = { "vfmsubpd", "vfmsubpd", Vpd, Hpd, VIb, Wpd, IA_FMA4 },
Ia_vfmsubpd_Vpd_Hpd_Wpd_VIb = { "vfmsubpd", "vfmsubpd", Vpd, Hpd, Wpd, VIb, IA_FMA4 },
Ia_vfmsubps_Vps_Hps_VIb_Wps = { "vfmsubps", "vfmsubps", Vps, Hps, VIb, Wps, IA_FMA4 },
Ia_vfmsubps_Vps_Hps_Wps_VIb = { "vfmsubps", "vfmsubps", Vps, Hps, Wps, VIb, IA_FMA4 },
Ia_vfmsubsd_Vsd_Hsd_VIb_Wsd = { "vfmsubsd", "vfmsubsd", Vsd, Hsd, VIb, Wsd, IA_FMA4 },
Ia_vfmsubsd_Vsd_Hsd_Wsd_VIb = { "vfmsubsd", "vfmsubsd", Vsd, Hsd, Wsd, VIb, IA_FMA4 },
Ia_vfmsubss_Vss_Hss_VIb_Wss = { "vfmsubss", "vfmsubss", Vss, Hss, VIb, Wss, IA_FMA4 },
Ia_vfmsubss_Vss_Hss_Wss_VIb = { "vfmsubss", "vfmsubss", Vss, Hss, Wss, VIb, IA_FMA4 },
Ia_vfnmadd132pd_Vpd_Hpd_Wpd = { "vfnmadd132pd", "vfnmadd132pd", Vpd, Hpd, Wpd, XX, IA_AVX_FMA },
Ia_vfnmadd132ps_Vps_Hps_Wps = { "vfnmadd132ps", "vfnmadd132ps", Vps, Hps, Wps, XX, IA_AVX_FMA },
Ia_vfnmadd132sd_Vpd_Hsd_Wsd = { "vfnmadd132sd", "vfnmadd132sd", Vpd, Hsd, Wsd, XX, IA_AVX_FMA },
Ia_vfnmadd132ss_Vps_Hss_Wss = { "vfnmadd132ss", "vfnmadd132ss", Vps, Hss, Wss, XX, IA_AVX_FMA },
Ia_vfnmadd213pd_Vpd_Hpd_Wpd = { "vfnmadd213pd", "vfnmadd213pd", Vpd, Hpd, Wpd, XX, IA_AVX_FMA },
Ia_vfnmadd213ps_Vps_Hps_Wps = { "vfnmadd213ps", "vfnmadd213ps", Vps, Hps, Wps, XX, IA_AVX_FMA },
Ia_vfnmadd213sd_Vpd_Hsd_Wsd = { "vfnmadd213sd", "vfnmadd213sd", Vpd, Hsd, Wsd, XX, IA_AVX_FMA },
Ia_vfnmadd213ss_Vps_Hss_Wss = { "vfnmadd213ss", "vfnmadd213ss", Vps, Hss, Wss, XX, IA_AVX_FMA },
Ia_vfnmadd231pd_Vpd_Hpd_Wpd = { "vfnmadd231pd", "vfnmadd231pd", Vpd, Hpd, Wpd, XX, IA_AVX_FMA },
Ia_vfnmadd231ps_Vps_Hps_Wps = { "vfnmadd231ps", "vfnmadd231ps", Vps, Hps, Wps, XX, IA_AVX_FMA },
Ia_vfnmadd231sd_Vpd_Hsd_Wsd = { "vfnmadd231sd", "vfnmadd231sd", Vpd, Hsd, Wsd, XX, IA_AVX_FMA },
Ia_vfnmadd231ss_Vps_Hss_Wss = { "vfnmadd231ss", "vfnmadd231ss", Vps, Hss, Wss, XX, IA_AVX_FMA },
Ia_vfnmaddpd_Vpd_Hpd_VIb_Wpd = { "vfnmaddpd", "vfnmaddpd", Vpd, Hpd, VIb, Wpd, IA_FMA4 },
Ia_vfnmaddpd_Vpd_Hpd_Wpd_VIb = { "vfnmaddpd", "vfnmaddpd", Vpd, Hpd, Wpd, VIb, IA_FMA4 },
Ia_vfnmaddps_Vps_Hps_VIb_Wps = { "vfnmaddps", "vfnmaddps", Vps, Hps, VIb, Wps, IA_FMA4 },
Ia_vfnmaddps_Vps_Hps_Wps_VIb = { "vfnmaddps", "vfnmaddps", Vps, Hps, Wps, VIb, IA_FMA4 },
Ia_vfnmaddsd_Vsd_Hsd_VIb_Wsd = { "vfnmaddsd", "vfnmaddsd", Vsd, Hsd, VIb, Wsd, IA_FMA4 },
Ia_vfnmaddsd_Vsd_Hsd_Wsd_VIb = { "vfnmaddsd", "vfnmaddsd", Vsd, Hsd, Wsd, VIb, IA_FMA4 },
Ia_vfnmaddss_Vss_Hss_VIb_Wss = { "vfnmaddss", "vfnmaddss", Vss, Hss, VIb, Wss, IA_FMA4 },
Ia_vfnmaddss_Vss_Hss_Wss_VIb = { "vfnmaddss", "vfnmaddss", Vss, Hss, Wss, VIb, IA_FMA4 },
Ia_vfnmsub132pd_Vpd_Hpd_Wpd = { "vfnmsub132pd", "vfnmsub132pd", Vpd, Hpd, Wpd, XX, IA_AVX_FMA },
Ia_vfnmsub132ps_Vps_Hps_Wps = { "vfnmsub132ps", "vfnmsub132ps", Vps, Hps, Wps, XX, IA_AVX_FMA },
Ia_vfnmsub132sd_Vpd_Hsd_Wsd = { "vfnmsub132sd", "vfnmsub132sd", Vpd, Hsd, Wsd, XX, IA_AVX_FMA },
Ia_vfnmsub132ss_Vps_Hss_Wss = { "vfnmsub132ss", "vfnmsub132ss", Vps, Hss, Wss, XX, IA_AVX_FMA },
Ia_vfnmsub213pd_Vpd_Hpd_Wpd = { "vfnmsub213pd", "vfnmsub213pd", Vpd, Hpd, Wpd, XX, IA_AVX_FMA },
Ia_vfnmsub213ps_Vps_Hps_Wps = { "vfnmsub213ps", "vfnmsub213ps", Vps, Hps, Wps, XX, IA_AVX_FMA },
Ia_vfnmsub213sd_Vpd_Hsd_Wsd = { "vfnmsub213sd", "vfnmsub213sd", Vpd, Hsd, Wsd, XX, IA_AVX_FMA },
Ia_vfnmsub213ss_Vps_Hss_Wss = { "vfnmsub213ss", "vfnmsub213ss", Vps, Hss, Wss, XX, IA_AVX_FMA },
Ia_vfnmsub231pd_Vpd_Hpd_Wpd = { "vfnmsub231pd", "vfnmsub231pd", Vpd, Hpd, Wpd, XX, IA_AVX_FMA },
Ia_vfnmsub231ps_Vps_Hps_Wps = { "vfnmsub231ps", "vfnmsub231ps", Vps, Hps, Wps, XX, IA_AVX_FMA },
Ia_vfnmsub231sd_Vpd_Hsd_Wsd = { "vfnmsub231sd", "vfnmsub231sd", Vpd, Hsd, Wsd, XX, IA_AVX_FMA },
Ia_vfnmsub231ss_Vps_Hss_Wss = { "vfnmsub231ss", "vfnmsub231ss", Vps, Hss, Wss, XX, IA_AVX_FMA },
Ia_vfnmsubpd_Vpd_Hpd_VIb_Wpd = { "vfnmsubpd", "vfnmsubpd", Vpd, Hpd, VIb, Wpd, IA_FMA4 },
Ia_vfnmsubpd_Vpd_Hpd_Wpd_VIb = { "vfnmsubpd", "vfnmsubpd", Vpd, Hpd, Wpd, VIb, IA_FMA4 },
Ia_vfnmsubps_Vps_Hps_VIb_Wps = { "vfnmsubps", "vfnmsubps", Vps, Hps, VIb, Wps, IA_FMA4 },
Ia_vfnmsubps_Vps_Hps_Wps_VIb = { "vfnmsubps", "vfnmsubps", Vps, Hps, Wps, VIb, IA_FMA4 },
Ia_vfnmsubsd_Vsd_Hsd_VIb_Wsd = { "vfnmsubsd", "vfnmsubsd", Vsd, Hsd, VIb, Wsd, IA_FMA4 },
Ia_vfnmsubsd_Vsd_Hsd_Wsd_VIb = { "vfnmsubsd", "vfnmsubsd", Vsd, Hsd, Wsd, VIb, IA_FMA4 },
Ia_vfnmsubss_Vss_Hss_VIb_Wss = { "vfnmsubss", "vfnmsubss", Vss, Hss, VIb, Wss, IA_FMA4 },
Ia_vfnmsubss_Vss_Hss_Wss_VIb = { "vfnmsubss", "vfnmsubss", Vss, Hss, Wss, VIb, IA_FMA4 },
Ia_vgatherdd_Vdq_VSib_Hdq = { "vgatherdd", "vgatherdd", Vdq, VSib, Hdq, XX, IA_AVX2 },
Ia_vgatherdpd_Vpd_VSib_Hpd = { "vgatherdpd", "vgatherdpd", Vpd, VSib, Hpd, XX, IA_AVX2 },
Ia_vgatherdps_Vps_VSib_Hps = { "vgatherdps", "vgatherdps", Vps, VSib, Hps, XX, IA_AVX2 },
Ia_vgatherdq_Vdq_VSib_Hdq = { "vgatherdq", "vgatherdq", Vdq, VSib, Hdq, XX, IA_AVX2 },
Ia_vgatherqd_Vdq_VSib_Hdq = { "vgatherqd", "vgatherqd", Vdq, VSib, Hdq, XX, IA_AVX2 },
Ia_vgatherqpd_Vpd_VSib_Hpd = { "vgatherqpd", "vgatherqpd", Vpd, VSib, Hpd, XX, IA_AVX2 },
Ia_vgatherqps_Vps_VSib_Hps = { "vgatherqps", "vgatherqps", Vps, VSib, Hps, XX, IA_AVX2 },
Ia_vgatherqq_Vdq_VSib_Hdq = { "vgatherqq", "vgatherqq", Vdq, VSib, Hdq, XX, IA_AVX2 },
Ia_vhaddpd_Vpd_Hpd_Wpd = { "vhaddpd", "vhaddpd", Vpd, Hpd, Wpd, XX, IA_AVX },
Ia_vhaddps_Vps_Hps_Wps = { "vhaddps", "vhaddps", Vps, Hps, Wps, XX, IA_AVX },
Ia_vhsubpd_Vpd_Hpd_Wpd = { "vhsubpd", "vhsubpd", Vpd, Hpd, Wpd, XX, IA_AVX },
Ia_vhsubps_Vps_Hps_Wps = { "vhsubps", "vhsubps", Vps, Hps, Wps, XX, IA_AVX },
Ia_vinsertf128_Vdq_Hdq_Wdq_Ib = { "vinsertf128", "vinsertf128", Vdq, Hdq, Wdq, Ib, IA_AVX },
Ia_vinserti128_Vdq_Hdq_Wdq_Ib = { "vinserti128", "vinserti128", Vdq, Hdq, Wdq, Ib, IA_AVX2 },
Ia_vinsertps_Vps_Hps_Wss_Ib = { "vinsertps", "vinsertps", Vps, Hps, Wss, Ib, IA_AVX },
Ia_vlddqu_Vdq_Mdq = { "vlddqu", "vlddqu", Vdq, Mdq, XX, XX, IA_AVX },
Ia_vldmxcsr = { "vldmxcsr", "vldmxcsr", Md, XX, XX, XX, IA_AVX },
Ia_vmaskmovd_Mdq_Hdq_Vdq = { "vmaskmovd", "vmaskmovd", Mdq, Hdq, Vdq, XX, IA_AVX2 },
Ia_vmaskmovd_Vdq_Hdq_Mdq = { "vmaskmovd", "vmaskmovd", Vdq, Hdq, Mdq, XX, IA_AVX2 },
Ia_vmaskmovdqu_Vdq_Udq = { "vmaskmovdqu", "vmaskmovdqu", Vdq, Udq, XX, XX, IA_AVX },
Ia_vmaskmovpd_Mpd_Hpd_Vpd = { "vmaskmovpd", "vmaskmovpd", Mpd, Hpd, Vpd, XX, IA_AVX },
Ia_vmaskmovpd_Vpd_Hpd_Mpd = { "vmaskmovpd", "vmaskmovpd", Vpd, Hpd, Mpd, XX, IA_AVX },
Ia_vmaskmovps_Mps_Hps_Vps = { "vmaskmovps", "vmaskmovps", Mps, Hps, Vps, XX, IA_AVX },
Ia_vmaskmovps_Vps_Hps_Mps = { "vmaskmovps", "vmaskmovps", Vps, Hps, Mps, XX, IA_AVX },
Ia_vmaskmovq_Mdq_Hdq_Vdq = { "vmaskmovq", "vmaskmovq", Mdq, Hdq, Vdq, XX, IA_AVX2 },
Ia_vmaskmovq_Vdq_Hdq_Mdq = { "vmaskmovq", "vmaskmovq", Vdq, Hdq, Mdq, XX, IA_AVX2 },
Ia_vmaxpd_Vpd_Hpd_Wpd = { "vmaxpd", "vmaxpd", Vpd, Hpd, Wpd, XX, IA_AVX },
Ia_vmaxps_Vps_Hps_Wps = { "vmaxps", "vmaxps", Vps, Hps, Wps, XX, IA_AVX },
Ia_vmaxsd_Vsd_Hpd_Wsd = { "vmaxsd", "vmaxsd", Vsd, Hpd, Wsd, XX, IA_AVX },
Ia_vmaxss_Vss_Hps_Wss = { "vmaxss", "vmaxss", Vss, Hps, Wss, XX, IA_AVX },
Ia_vmcall = { "vmcall", "vmcall", XX, XX, XX, XX, IA_VMX },
Ia_vmclear_Mq = { "vmclear", "vmclear", Mq, XX, XX, XX, IA_VMX },
Ia_vmfunc = { "vmfunc", "vmfunc", EAX_Reg, XX, XX, XX, IA_VMX },
Ia_vminpd_Vpd_Hpd_Wpd = { "vminpd", "vminpd", Vpd, Hpd, Wpd, XX, IA_AVX },
Ia_vminps_Vps_Hps_Wps = { "vminps", "vminps", Vps, Hps, Wps, XX, IA_AVX },
Ia_vminsd_Vsd_Hpd_Wsd = { "vminsd", "vminsd", Vsd, Hpd, Wsd, XX, IA_AVX },
Ia_vminss_Vss_Hps_Wss = { "vminss", "vminss", Vss, Hps, Wss, XX, IA_AVX },
Ia_vmlaunch = { "vmlaunch", "vmlaunch", XX, XX, XX, XX, IA_VMX },
Ia_vmload = { "vmload", "vmload", RAX_Reg, XX, XX, XX, IA_SVM },
Ia_vmmcall = { "vmmcall", "vmmcall", XX, XX, XX, XX, IA_SVM },
Ia_vmovapd_Vpd_Wpd = { "vmovapd", "vmovapd", Vpd, Wpd, XX, XX, IA_AVX },
Ia_vmovapd_Wpd_Vpd = { "vmovapd", "vmovapd", Wpd, Vpd, XX, XX, IA_AVX },
Ia_vmovaps_Vps_Wps = { "vmovaps", "vmovaps", Vps, Wps, XX, XX, IA_AVX },
Ia_vmovaps_Wps_Vps = { "vmovaps", "vmovaps", Wps, Vps, XX, XX, IA_AVX },
Ia_vmovd_Ed_Vd = { "vmovd", "vmovd", Ed, Vdq, XX, XX, IA_AVX },
Ia_vmovd_Vdq_Ed = { "vmovd", "vmovd", Vdq, Ed, XX, XX, IA_AVX },
Ia_vmovddup_Vdq_Wq = { "vmovddup", "vmovddup", Vdq, Wq, XX, XX, IA_AVX },
Ia_vmovdqa_Vdq_Wdq = { "vmovdqa", "vmovdqa", Vdq, Wdq, XX, XX, IA_AVX },
Ia_vmovdqa_Wdq_Vdq = { "vmovdqa", "vmovdqa", Wdq, Vdq, XX, XX, IA_AVX },
Ia_vmovdqu_Vdq_Wdq = { "vmovdqu", "vmovdqu", Vdq, Wdq, XX, XX, IA_AVX },
Ia_vmovdqu_Wdq_Vdq = { "vmovdqu", "vmovdqu", Wdq, Vdq, XX, XX, IA_AVX },
Ia_vmovhlpd_Vpd_Hdq_Udq = { "vmovhlpd", "vmovhlpd", Vpd, Hdq, Udq, XX, IA_AVX },
Ia_vmovhlps_Vps_Hdq_Udq = { "vmovhlps", "vmovhlps", Vps, Hdq, Udq, XX, IA_AVX },
Ia_vmovhpd_Mq_Vpd = { "vmovhpd", "vmovhpd", Mq, Vpd, XX, XX, IA_AVX },
Ia_vmovhpd_Vpd_Hdq_Mq = { "vmovhpd", "vmovhpd", Vpd, Hdq, Mq, XX, IA_AVX },
Ia_vmovhps_Mq_Vps = { "vmovhps", "vmovhps", Mq, Vps, XX, XX, IA_AVX },
Ia_vmovhps_Vps_Hdq_Mq = { "vmovhps", "vmovhps", Vps, Hdq, Mq, XX, IA_AVX },
Ia_vmovlhpd_Vpd_Hdq_Udq = { "vmovlhpd", "vmovlhpd", Vpd, Hdq, Udq, XX, IA_AVX },
Ia_vmovlhps_Vps_Hdq_Udq = { "vmovlhps", "vmovlhps", Vps, Hdq, Udq, XX, IA_AVX },
Ia_vmovlpd_Mq_Vpd = { "vmovlpd", "vmovlpd", Mq, Vpd, XX, XX, IA_AVX },
Ia_vmovlpd_Vpd_Hdq_Mq = { "vmovlpd", "vmovlpd", Vpd, Hdq, Mq, XX, IA_AVX },
Ia_vmovlps_Mq_Vps = { "vmovlps", "vmovlps", Mq, Vps, XX, XX, IA_AVX },
Ia_vmovlps_Vps_Hdq_Mq = { "vmovlps", "vmovlps", Vps, Hdq, Mq, XX, IA_AVX },
Ia_vmovmskpd_Gd_Upd = { "vmovmskpd", "vmovmskpd", Gd, Upd, XX, XX, IA_AVX },
Ia_vmovmskps_Gd_Ups = { "vmovmskps", "vmovmskps", Gd, Ups, XX, XX, IA_AVX },
Ia_vmovntdq_Mdq_Vdq = { "vmovntdq", "vmovntdq", Mdq, Vdq, XX, XX, IA_AVX },
Ia_vmovntdqa_Vdq_Mdq = { "vmovntdqa", "vmovntdqa", Vdq, Mdq, XX, XX, IA_AVX },
Ia_vmovntpd_Mpd_Vpd = { "vmovntpd", "vmovntpd", Mpd, Vpd, XX, XX, IA_AVX },
Ia_vmovntps_Mps_Vps = { "vmovntps", "vmovntps", Mps, Vps, XX, XX, IA_AVX },
Ia_vmovq_Eq_Vq = { "vmovq", "vmovq", Eq, Vq, XX, XX, IA_AVX },
Ia_vmovq_Vdq_Eq = { "vmovq", "vmovq", Vdq, Eq, XX, XX, IA_AVX },
Ia_vmovq_Vq_Wq = { "vmovq", "vmovq", Vq, Wq, XX, XX, IA_AVX },
Ia_vmovq_Wq_Vq = { "vmovq", "vmovq", Wq, Vq, XX, XX, IA_AVX },
Ia_vmovsd_Vsd_Wsd = { "vmovsd", "vmovsd", Vsd, Hpd, Wsd, XX, IA_AVX },
Ia_vmovsd_Wsd_Vsd = { "vmovsd", "vmovsd", Wsd, Vsd, XX, XX, IA_AVX },
Ia_vmovshdup_Vdq_Wdq = { "vmovshdup", "vmovshdup", Vdq, Wdq, XX, XX, IA_AVX },
Ia_vmovsldup_Vdq_Wdq = { "vmovsldup", "vmovsldup", Vdq, Wdq, XX, XX, IA_AVX },
Ia_vmovss_Vss_Wss = { "vmovss", "vmovss", Vss, Hps, Wss, XX, IA_AVX },
Ia_vmovss_Wss_Vss = { "vmovss", "vmovss", Wss, Vss, XX, XX, IA_AVX },
Ia_vmovupd_Vpd_Wpd = { "vmovupd", "vmovupd", Vpd, Wpd, XX, XX, IA_AVX },
Ia_vmovupd_Wpd_Vpd = { "vmovupd", "vmovupd", Wpd, Vpd, XX, XX, IA_AVX },
Ia_vmovups_Vps_Wps = { "vmovups", "vmovups", Vps, Wps, XX, XX, IA_AVX },
Ia_vmovups_Wps_Vps = { "vmovups", "vmovups", Wps, Vps, XX, XX, IA_AVX },
Ia_vmpsadbw_Vdq_Hdq_Wdq_Ib = { "vmpsadbw", "vmpsadbw", Vdq, Hdq, Wdq, Ib, IA_AVX },
Ia_vmptrld_Mq = { "vmptrld", "vmptrld", Mq, XX, XX, XX, IA_VMX },
Ia_vmptrst_Mq = { "vmptrst", "vmptrst", Mq, XX, XX, XX, IA_VMX },
Ia_vmread_Ed_Gd = { "vmread", "vmread", Ed, Gd, XX, XX, IA_VMX },
Ia_vmread_Eq_Gq = { "vmread", "vmread", Eq, Gq, XX, XX, IA_VMX },
Ia_vmresume = { "vmresume", "vmresume", XX, XX, XX, XX, IA_VMX },
Ia_vmrun = { "vmrun", "vmrun", RAX_Reg, XX, XX, XX, IA_SVM },
Ia_vmsave = { "vmsave", "vmsave", RAX_Reg, XX, XX, XX, IA_SVM },
Ia_vmulpd_Vpd_Hpd_Wpd = { "vmulpd", "vmulpd", Vpd, Hpd, Wpd, XX, IA_AVX },
Ia_vmulps_Vps_Hps_Wps = { "vmulps", "vmulps", Vps, Hps, Wps, XX, IA_AVX },
Ia_vmulsd_Vsd_Hpd_Wsd = { "vmulsd", "vmulsd", Vsd, Hpd, Wsd, XX, IA_AVX },
Ia_vmulss_Vss_Hps_Wss = { "vmulss", "vmulss", Vss, Hps, Wss, XX, IA_AVX },
Ia_vmwrite_Gd_Ed = { "vmwrite", "vmwrite", Gd, Ed, XX, XX, IA_VMX },
Ia_vmwrite_Gq_Eq = { "vmwrite", "vmwrite", Gq, Eq, XX, XX, IA_VMX },
Ia_vmxoff = { "vmxoff", "vmxoff", XX, XX, XX, XX, IA_VMX },
Ia_vmxon_Mq = { "vmxon", "vmxon", Mq, XX, XX, XX, IA_VMX },
Ia_vorpd_Vpd_Hpd_Wpd = { "vorpd", "vorpd", Vpd, Hpd, Wpd, XX, IA_AVX },
Ia_vorps_Vps_Hps_Wps = { "vorps", "vorps", Vps, Hps, Wps, XX, IA_AVX },
Ia_vpabsb_Vdq_Hdq_Wdq = { "vpabsb", "vpabsb", Vdq, Wdq, XX, XX, IA_AVX },
Ia_vpabsd_Vdq_Hdq_Wdq = { "vpabsd", "vpabsd", Vdq, Wdq, XX, XX, IA_AVX },
Ia_vpabsw_Vdq_Hdq_Wdq = { "vpabsw", "vpabsw", Vdq, Wdq, XX, XX, IA_AVX },
Ia_vpackssdw_Vdq_Hdq_Wdq = { "vpackssdw", "vpackssdw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpacksswb_Vdq_Hdq_Wdq = { "vpacksswb", "vpacksswb", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpackusdw_Vdq_Hdq_Wdq = { "vpackusdw", "vpackusdw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpackuswb_Vdq_Hdq_Wdq = { "vpackuswb", "vpackuswb", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpaddb_Vdq_Hdq_Wdq = { "vpaddb", "vpaddb", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpaddd_Vdq_Hdq_Wdq = { "vpaddd", "vpaddd", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpaddq_Vdq_Hdq_Wdq = { "vpaddq", "vpaddq", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpaddsb_Vdq_Hdq_Wdq = { "vpaddsb", "vpaddsb", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpaddsw_Vdq_Hdq_Wdq = { "vpaddsw", "vpaddsw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpaddusb_Vdq_Hdq_Wdq = { "vpaddusb", "vpaddusb", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpaddusw_Vdq_Hdq_Wdq = { "vpaddusw", "vpaddusw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpaddw_Vdq_Hdq_Wdq = { "vpaddw", "vpaddw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpalignr_Vdq_Hdq_Wdq_Ib = { "vpalignr", "vpalignr", Vdq, Hdq, Wdq, Ib, IA_AVX },
Ia_vpand_Vdq_Hdq_Wdq = { "vpand", "vpand", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpandn_Vdq_Hdq_Wdq = { "vpandn", "vpandn", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpavgb_Vdq_Hdq_Wdq = { "vpavgb", "vpavgb", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpavgw_Vdq_Hdq_Wdq = { "vpavgw", "vpavgw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpblendd_Vdq_Hdq_Wdq_Ib = { "vpblendd", "vpblendd", Vdq, Hdq, Wdq, Ib, IA_AVX2 },
Ia_vpblendvb_Vdq_Hdq_Wdq_Ib = { "vpblendvb", "vpblendvb", Vdq, Hdq, Wdq, VIb, IA_AVX },
Ia_vpblendw_Vdq_Hdq_Wdq_Ib = { "vpblendw", "vpblendw", Vdq, Hdq, Wdq, Ib, IA_AVX },
Ia_vpbroadcastb_Vdq_Wb = { "vpbroadcastb", "vpbroadcastb", Vdq, Wb, XX, XX, IA_AVX2 },
Ia_vpbroadcastd_Vdq_Wd = { "vpbroadcastd", "vpbroadcastd", Vdq, Wd, XX, XX, IA_AVX2 },
Ia_vpbroadcastq_Vdq_Wq = { "vpbroadcastq", "vpbroadcastq", Vdq, Wq, XX, XX, IA_AVX2 },
Ia_vpbroadcastw_Vdq_Ww = { "vpbroadcastw", "vpbroadcastw", Vdq, Ww, XX, XX, IA_AVX2 },
Ia_vpclmulqdq_Vdq_Hdq_Wdq_Ib = { "vpclmulqdq", "vpclmulqdq", Vdq, Hdq, Wdq, Ib, IA_AVX },
Ia_vpcmov_Vdq_Hdq_VIb_Wdq = { "vpcmov", "vpcmov", Vdq, Hdq, VIb, Wdq, IA_XOP },
Ia_vpcmov_Vdq_Hdq_Wdq_VIb = { "vpcmov", "vpcmov", Vdq, Hdq, Wdq, VIb, IA_XOP },
Ia_vpcmpeqb_Vdq_Hdq_Wdq = { "vpcmpeqb", "vpcmpeqb", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpcmpeqd_Vdq_Hdq_Wdq = { "vpcmpeqd", "vpcmpeqd", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpcmpeqq_Vdq_Hdq_Wdq = { "vpcmpeqq", "vpcmpeqq", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpcmpeqw_Vdq_Hdq_Wdq = { "vpcmpeqw", "vpcmpeqw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpcmpestri_Vdq_Wdq_Ib = { "vpcmpestri", "vpcmpestri", Vdq, Wdq, Ib, XX, IA_AVX },
Ia_vpcmpestrm_Vdq_Wdq_Ib = { "vpcmpestrm", "vpcmpestrm", Vdq, Wdq, Ib, XX, IA_AVX },
Ia_vpcmpgtb_Vdq_Hdq_Wdq = { "vpcmpgtb", "vpcmpgtb", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpcmpgtd_Vdq_Hdq_Wdq = { "vpcmpgtd", "vpcmpgtd", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpcmpgtq_Vdq_Hdq_Wdq = { "vpcmpgtq", "vpcmpgtq", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpcmpgtw_Vdq_Hdq_Wdq = { "vpcmpgtw", "vpcmpgtw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpcmpistri_Vdq_Wdq_Ib = { "vpcmpistri", "vpcmpistri", Vdq, Wdq, Ib, XX, IA_AVX },
Ia_vpcmpistrm_Vdq_Wdq_Ib = { "vpcmpistrm", "vpcmpistrm", Vdq, Wdq, Ib, XX, IA_AVX },
Ia_vpcomb_Vdq_Hdq_Wdq_Ib = { "vpcomb", "vpcomb", Vdq, Hdq, Wdq, Ib, IA_XOP },
Ia_vpcomd_Vdq_Hdq_Wdq_Ib = { "vpcomd", "vpcomd", Vdq, Hdq, Wdq, Ib, IA_XOP },
Ia_vpcomq_Vdq_Hdq_Wdq_Ib = { "vpcomq", "vpcomq", Vdq, Hdq, Wdq, Ib, IA_XOP },
Ia_vpcomub_Vdq_Hdq_Wdq_Ib = { "vpcomub", "vpcomub", Vdq, Hdq, Wdq, Ib, IA_XOP },
Ia_vpcomud_Vdq_Hdq_Wdq_Ib = { "vpcomud", "vpcomud", Vdq, Hdq, Wdq, Ib, IA_XOP },
Ia_vpcomuq_Vdq_Hdq_Wdq_Ib = { "vpcomuq", "vpcomuq", Vdq, Hdq, Wdq, Ib, IA_XOP },
Ia_vpcomuw_Vdq_Hdq_Wdq_Ib = { "vpcomuw", "vpcomuw", Vdq, Hdq, Wdq, Ib, IA_XOP },
Ia_vpcomw_Vdq_Hdq_Wdq_Ib = { "vpcomw", "vpcomw", Vdq, Hdq, Wdq, Ib, IA_XOP },
Ia_vperm2f128_Vdq_Hdq_Wdq_Ib = { "vperm2f128", "vperm2f128", Vdq, Hdq, Wdq, Ib, IA_AVX },
Ia_vperm2i128_Vdq_Hdq_Wdq_Ib = { "vperm2i128", "vperm2i128", Vdq, Hdq, Wdq, Ib, IA_AVX2 },
Ia_vpermd_Vdq_Hdq_Wdq = { "vpermd", "vpermd", Vdq, Hdq, Wdq, XX, IA_AVX2 },
Ia_vpermilpd_Vpd_Hpd_Wpd = { "vpermilpd", "vpermilpd", Vpd, Hpd, Wpd, XX, IA_AVX },
Ia_vpermilpd_Vpd_Wpd_Ib = { "vpermilpd", "vpermilpd", Vpd, Wpd, Ib, XX, IA_AVX },
Ia_vpermilps_Vps_Hps_Wps = { "vpermilps", "vpermilps", Vps, Hps, Wps, XX, IA_AVX },
Ia_vpermilps_Vps_Wps_Ib = { "vpermilps", "vpermilps", Vps, Wps, Ib, XX, IA_AVX },
Ia_vpermpd_Vpd_Wpd_Ib = { "vpermpd", "vpermpd", Vpd, Wpd, Ib, XX, IA_AVX2 },
Ia_vpermps_Vps_Hps_Wps = { "vpermps", "vpermps", Vps, Hps, Wps, XX, IA_AVX2 },
Ia_vpermq_Vdq_Wdq_Ib = { "vpermq", "vpermq", Vdq, Wdq, Ib, XX, IA_AVX2 },
Ia_vpextrb_Ebd_Vdq_Ib = { "vpextrb", "vpextrb", Ebd, Vdq, Ib, XX, IA_AVX },
Ia_vpextrd_Ed_Vdq_Ib = { "vpextrd", "vpextrd", Ed, Vdq, Ib, XX, IA_AVX },
Ia_vpextrq_Eq_Vdq_Ib = { "vpextrq", "vpextrq", Eq, Vdq, Ib, XX, IA_AVX },
Ia_vpextrw_Ewd_Vdq_Ib = { "vpextrw", "vpextrw", Ewd, Vdq, Ib, XX, IA_AVX },
Ia_vpextrw_Gd_Udq_Ib = { "vpextrw", "vpextrw", Gd, Udq, Ib, XX, IA_AVX },
Ia_vphaddbd_Vdq_Wdq = { "vphaddbd", "vphaddbd", Vdq, Wdq, XX, XX, IA_XOP },
Ia_vphaddbq_Vdq_Wdq = { "vphaddbq", "vphaddbq", Vdq, Wdq, XX, XX, IA_XOP },
Ia_vphaddbw_Vdq_Wdq = { "vphaddbw", "vphaddbw", Vdq, Wdq, XX, XX, IA_XOP },
Ia_vphaddd_Vdq_Hdq_Wdq = { "vphaddd", "vphaddd", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vphadddq_Vdq_Wdq = { "vphadddq", "vphadddq", Vdq, Wdq, XX, XX, IA_XOP },
Ia_vphaddsw_Vdq_Hdq_Wdq = { "vphaddsw", "vphaddsw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vphaddubd_Vdq_Wdq = { "vphaddubd", "vphaddubd", Vdq, Wdq, XX, XX, IA_XOP },
Ia_vphaddubq_Vdq_Wdq = { "vphaddubq", "vphaddubq", Vdq, Wdq, XX, XX, IA_XOP },
Ia_vphaddubw_Vdq_Wdq = { "vphaddubw", "vphaddubw", Vdq, Wdq, XX, XX, IA_XOP },
Ia_vphaddudq_Vdq_Wdq = { "vphaddudq", "vphaddudq", Vdq, Wdq, XX, XX, IA_XOP },
Ia_vphadduwd_Vdq_Wdq = { "vphadduwd", "vphadduwd", Vdq, Wdq, XX, XX, IA_XOP },
Ia_vphadduwq_Vdq_Wdq = { "vphadduwq", "vphadduwq", Vdq, Wdq, XX, XX, IA_XOP },
Ia_vphaddw_Vdq_Hdq_Wdq = { "vphaddw", "vphaddw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vphaddwd_Vdq_Wdq = { "vphaddwd", "vphaddwd", Vdq, Wdq, XX, XX, IA_XOP },
Ia_vphaddwq_Vdq_Wdq = { "vphaddwq", "vphaddwq", Vdq, Wdq, XX, XX, IA_XOP },
Ia_vphminposuw_Vdq_Wdq = { "vphminposuw", "vphminposuw", Vdq, Wdq, XX, XX, IA_AVX },
Ia_vphsubbw_Vdq_Wdq = { "vphsubbw", "vphsubbw", Vdq, Wdq, XX, XX, IA_XOP },
Ia_vphsubd_Vdq_Hdq_Wdq = { "vphsubd", "vphsubd", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vphsubdq_Vdq_Wdq = { "vphsubdq", "vphsubdq", Vdq, Wdq, XX, XX, IA_XOP },
Ia_vphsubsw_Vdq_Hdq_Wdq = { "vphsubsw", "vphsubsw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vphsubw_Vdq_Hdq_Wdq = { "vphsubw", "vphsubw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vphsubwd_Vdq_Wdq = { "vphsubwd", "vphsubwd", Vdq, Wdq, XX, XX, IA_XOP },
Ia_vpinsrb_Vdq_Hdq_Ew_Ib = { "vpinsrb", "vpinsrb", Vdq, Hdq, Ew, Ib, IA_AVX },
Ia_vpinsrd_Vdq_Hdq_Ed_Ib = { "vpinsrd", "vpinsrd", Vdq, Hdq, Ed, Ib, IA_AVX },
Ia_vpinsrq_Vdq_Hdq_Eq_Ib = { "vpinsrq", "vpinsrq", Vdq, Hdq, Eq, Ib, IA_AVX },
Ia_vpinsrw_Vdq_Hdq_Ew_Ib = { "vpinsrw", "vpinsrw", Vdq, Hdq, Ew, Ib, IA_AVX },
Ia_vpmacsdd_Vdq_Hdq_Wdq_VIb = { "vpmacsdd", "vpmacsdd", Vdq, Hdq, Wdq, VIb, IA_XOP },
Ia_vpmacsdqh_Vdq_Hdq_Wdq_VIb = { "vpmacsdqh", "vpmacsdqh", Vdq, Hdq, Wdq, VIb, IA_XOP },
Ia_vpmacsdql_Vdq_Hdq_Wdq_VIb = { "vpmacsdql", "vpmacsdql", Vdq, Hdq, Wdq, VIb, IA_XOP },
Ia_vpmacssdd_Vdq_Hdq_Wdq_VIb = { "vpmacssdd", "vpmacssdd", Vdq, Hdq, Wdq, VIb, IA_XOP },
Ia_vpmacssdqh_Vdq_Hdq_Wdq_VIb = { "vpmacssdqh", "vpmacssdqh", Vdq, Hdq, Wdq, VIb, IA_XOP },
Ia_vpmacssdql_Vdq_Hdq_Wdq_VIb = { "vpmacssdql", "vpmacssdql", Vdq, Hdq, Wdq, VIb, IA_XOP },
Ia_vpmacsswd_Vdq_Hdq_Wdq_VIb = { "vpmacsswd", "vpmacsswd", Vdq, Hdq, Wdq, VIb, IA_XOP },
Ia_vpmacssww_Vdq_Hdq_Wdq_VIb = { "vpmacssww", "vpmacssww", Vdq, Hdq, Wdq, VIb, IA_XOP },
Ia_vpmacswd_Vdq_Hdq_Wdq_VIb = { "vpmacswd", "vpmacswd", Vdq, Hdq, Wdq, VIb, IA_XOP },
Ia_vpmacsww_Vdq_Hdq_Wdq_VIb = { "vpmacsww", "vpmacsww", Vdq, Hdq, Wdq, VIb, IA_XOP },
Ia_vpmadcsswd_Vdq_Hdq_Wdq_VIb = { "vpmadcsswd", "vpmadcsswd", Vdq, Hdq, Wdq, VIb, IA_XOP },
Ia_vpmadcswd_Vdq_Hdq_Wdq_VIb = { "vpmadcswd", "vpmadcswd", Vdq, Hdq, Wdq, VIb, IA_XOP },
Ia_vpmaddubsw_Vdq_Hdq_Wdq = { "vpmaddubsw", "vpmaddubsw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpmaddwd_Vdq_Hdq_Wdq = { "vpmaddwd", "vpmaddwd", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpmaxsb_Vdq_Hdq_Wdq = { "vpmaxsb", "vpmaxsb", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpmaxsd_Vdq_Hdq_Wdq = { "vpmaxsd", "vpmaxsd", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpmaxsw_Vdq_Hdq_Wdq = { "vpmaxsw", "vpmaxsw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpmaxub_Vdq_Hdq_Wdq = { "vpmaxub", "vpmaxub", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpmaxud_Vdq_Hdq_Wdq = { "vpmaxud", "vpmaxud", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpmaxuw_Vdq_Hdq_Wdq = { "vpmaxuw", "vpmaxuw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpminsb_Vdq_Hdq_Wdq = { "vpminsb", "vpminsb", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpminsd_Vdq_Hdq_Wdq = { "vpminsd", "vpminsd", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpminsw_Vdq_Hdq_Wdq = { "vpminsw", "vpminsw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpminub_Vdq_Hdq_Wdq = { "vpminub", "vpminub", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpminud_Vdq_Hdq_Wdq = { "vpminud", "vpminud", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpminuw_Vdq_Hdq_Wdq = { "vpminuw", "vpminuw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpmovmskb_Gd_Udq = { "vpmovmskb", "vpmovmskb", Gd, Udq, XX, XX, IA_AVX },
Ia_vpmovsxbd_Vdq_Wd = { "vpmovsxbd", "vpmovsxbd", Vdq, Wd, XX, XX, IA_AVX },
Ia_vpmovsxbq_Vdq_Ww = { "vpmovsxbq", "vpmovsxbq", Vdq, Ww, XX, XX, IA_AVX },
Ia_vpmovsxbw_Vdq_Wq = { "vpmovsxbw", "vpmovsxbw", Vdq, Wq, XX, XX, IA_AVX },
Ia_vpmovsxdq_Vdq_Wq = { "vpmovsxdq", "vpmovsxdq", Vdq, Wq, XX, XX, IA_AVX },
Ia_vpmovsxwd_Vdq_Wq = { "vpmovsxwd", "vpmovsxwd", Vdq, Wq, XX, XX, IA_AVX },
Ia_vpmovsxwq_Vdq_Wd = { "vpmovsxwq", "vpmovsxwq", Vdq, Wd, XX, XX, IA_AVX },
Ia_vpmovzxbd_Vdq_Wd = { "vpmovzxbd", "vpmovzxbd", Vdq, Wd, XX, XX, IA_AVX },
Ia_vpmovzxbq_Vdq_Ww = { "vpmovzxbq", "vpmovzxbq", Vdq, Ww, XX, XX, IA_AVX },
Ia_vpmovzxbw_Vdq_Wq = { "vpmovzxbw", "vpmovzxbw", Vdq, Wq, XX, XX, IA_AVX },
Ia_vpmovzxdq_Vdq_Wq = { "vpmovzxdq", "vpmovzxdq", Vdq, Wq, XX, XX, IA_AVX },
Ia_vpmovzxwd_Vdq_Wq = { "vpmovzxwd", "vpmovzxwd", Vdq, Wq, XX, XX, IA_AVX },
Ia_vpmovzxwq_Vdq_Wd = { "vpmovzxwq", "vpmovzxwq", Vdq, Wd, XX, XX, IA_AVX },
Ia_vpmuldq_Vdq_Hdq_Wdq = { "vpmuldq", "vpmuldq", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpmulhrsw_Vdq_Hdq_Wdq = { "vpmulhrsw", "vpmulhrsw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpmulhuw_Vdq_Hdq_Wdq = { "vpmulhuw", "vpmulhuw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpmulhw_Vdq_Hdq_Wdq = { "vpmulhw", "vpmulhw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpmulld_Vdq_Hdq_Wdq = { "vpmulld", "vpmulld", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpmullw_Vdq_Hdq_Wdq = { "vpmullw", "vpmullw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpmuludq_Vdq_Hdq_Wdq = { "vpmuludq", "vpmuludq", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpor_Vdq_Hdq_Wdq = { "vpor", "vpor", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpperm_Vdq_Hdq_VIb_Wdq = { "vpperm", "vpperm", Vdq, Hdq, VIb, Wdq, IA_XOP },
Ia_vpperm_Vdq_Hdq_Wdq_VIb = { "vpperm", "vpperm", Vdq, Hdq, Wdq, VIb, IA_XOP },
Ia_vprotb_Vdq_Hdq_Wdq = { "vprotb", "vprotb", Vdq, Hdq, Wdq, XX, IA_XOP },
Ia_vprotb_Vdq_Wdq_Hdq = { "vprotb", "vprotb", Vdq, Wdq, Hdq, XX, IA_XOP },
Ia_vprotb_Vdq_Wdq_Ib = { "vprotb", "vprotb", Vdq, Wdq, Ib, XX, IA_XOP },
Ia_vprotd_Vdq_Hdq_Wdq = { "vprotd", "vprotd", Vdq, Hdq, Wdq, XX, IA_XOP },
Ia_vprotd_Vdq_Wdq_Hdq = { "vprotd", "vprotd", Vdq, Wdq, Hdq, XX, IA_XOP },
Ia_vprotd_Vdq_Wdq_Ib = { "vprotd", "vprotd", Vdq, Wdq, Ib, XX, IA_XOP },
Ia_vprotq_Vdq_Hdq_Wdq = { "vprotq", "vprotq", Vdq, Hdq, Wdq, XX, IA_XOP },
Ia_vprotq_Vdq_Wdq_Hdq = { "vprotq", "vprotq", Vdq, Wdq, Hdq, XX, IA_XOP },
Ia_vprotq_Vdq_Wdq_Ib = { "vprotq", "vprotq", Vdq, Wdq, Ib, XX, IA_XOP },
Ia_vprotw_Vdq_Hdq_Wdq = { "vprotw", "vprotw", Vdq, Hdq, Wdq, XX, IA_XOP },
Ia_vprotw_Vdq_Wdq_Hdq = { "vprotw", "vprotw", Vdq, Wdq, Hdq, XX, IA_XOP },
Ia_vprotw_Vdq_Wdq_Ib = { "vprotw", "vprotw", Vdq, Wdq, Ib, XX, IA_XOP },
Ia_vpsadbw_Vdq_Hdq_Wdq = { "vpsadbw", "vpsadbw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpshab_Vdq_Hdq_Wdq = { "vpshab", "vpshab", Vdq, Hdq, Wdq, XX, IA_XOP },
Ia_vpshab_Vdq_Wdq_Hdq = { "vpshab", "vpshab", Vdq, Wdq, Hdq, XX, IA_XOP },
Ia_vpshad_Vdq_Hdq_Wdq = { "vpshad", "vpshad", Vdq, Hdq, Wdq, XX, IA_XOP },
Ia_vpshad_Vdq_Wdq_Hdq = { "vpshad", "vpshad", Vdq, Wdq, Hdq, XX, IA_XOP },
Ia_vpshaq_Vdq_Hdq_Wdq = { "vpshaq", "vpshaq", Vdq, Hdq, Wdq, XX, IA_XOP },
Ia_vpshaq_Vdq_Wdq_Hdq = { "vpshaq", "vpshaq", Vdq, Wdq, Hdq, XX, IA_XOP },
Ia_vpshaw_Vdq_Hdq_Wdq = { "vpshaw", "vpshaw", Vdq, Hdq, Wdq, XX, IA_XOP },
Ia_vpshaw_Vdq_Wdq_Hdq = { "vpshaw", "vpshaw", Vdq, Wdq, Hdq, XX, IA_XOP },
Ia_vpshlb_Vdq_Hdq_Wdq = { "vpshlb", "vpshlb", Vdq, Hdq, Wdq, XX, IA_XOP },
Ia_vpshlb_Vdq_Wdq_Hdq = { "vpshlb", "vpshlb", Vdq, Wdq, Hdq, XX, IA_XOP },
Ia_vpshld_Vdq_Hdq_Wdq = { "vpshld", "vpshld", Vdq, Hdq, Wdq, XX, IA_XOP },
Ia_vpshld_Vdq_Wdq_Hdq = { "vpshld", "vpshld", Vdq, Wdq, Hdq, XX, IA_XOP },
Ia_vpshlq_Vdq_Hdq_Wdq = { "vpshlq", "vpshlq", Vdq, Hdq, Wdq, XX, IA_XOP },
Ia_vpshlq_Vdq_Wdq_Hdq = { "vpshlq", "vpshlq", Vdq, Wdq, Hdq, XX, IA_XOP },
Ia_vpshlw_Vdq_Hdq_Wdq = { "vpshlw", "vpshlw", Vdq, Hdq, Wdq, XX, IA_XOP },
Ia_vpshlw_Vdq_Wdq_Hdq = { "vpshlw", "vpshlw", Vdq, Wdq, Hdq, XX, IA_XOP },
Ia_vpshufb_Vdq_Hdq_Wdq = { "vpshufb", "vpshufb", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpshufd_Vdq_Hdq_Wdq_Ib = { "vpshufd", "vpshufd", Vdq, Wdq, Ib, XX, IA_AVX },
Ia_vpshufhw_Vdq_Hdq_Wdq_Ib = { "vpshufhw", "vpshufhw", Vdq, Wdq, Ib, XX, IA_AVX },
Ia_vpshuflw_Vdq_Hdq_Wdq_Ib = { "vpshuflw", "vpshuflw", Vdq, Wdq, Ib, XX, IA_AVX },
Ia_vpsignb_Vdq_Hdq_Wdq = { "vpsignb", "vpsignb", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpsignd_Vdq_Hdq_Wdq = { "vpsignd", "vpsignd", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpsignw_Vdq_Hdq_Wdq = { "vpsignw", "vpsignw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpslld_Hdq_Udq_Ib = { "vpslld", "vpslld", Hdq, Udq, Ib, XX, IA_AVX },
Ia_vpslld_Vdq_Hdq_Wdq = { "vpslld", "vpslld", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpslldq_Hdq_Udq_Ib = { "vpslldq", "vpslldq", Hdq, Udq, Ib, XX, IA_AVX },
Ia_vpsllq_Hdq_Udq_Ib = { "vpsllq", "vpsllq", Hdq, Udq, Ib, XX, IA_AVX },
Ia_vpsllq_Vdq_Hdq_Wdq = { "vpsllq", "vpsllq", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpsllvd_Vdq_Hdq_Wdq = { "vpsllvd", "vpsllvd", Vdq, Hdq, Wdq, XX, IA_AVX2 },
Ia_vpsllvq_Vdq_Hdq_Wdq = { "vpsllvq", "vpsllvq", Vdq, Hdq, Wdq, XX, IA_AVX2 },
Ia_vpsllw_Hdq_Udq_Ib = { "vpsllw", "vpsllw", Hdq, Udq, Ib, XX, IA_AVX },
Ia_vpsllw_Vdq_Hdq_Wdq = { "vpsllw", "vpsllw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpsrad_Hdq_Udq_Ib = { "vpsrad", "vpsrad", Hdq, Udq, Ib, XX, IA_AVX },
Ia_vpsrad_Vdq_Hdq_Wdq = { "vpsrad", "vpsrad", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpsravd_Vdq_Hdq_Wdq = { "vpsravd", "vpsravd", Vdq, Hdq, Wdq, XX, IA_AVX2 },
Ia_vpsraw_Hdq_Udq_Ib = { "vpsraw", "vpsraw", Hdq, Udq, Ib, XX, IA_AVX },
Ia_vpsraw_Vdq_Hdq_Wdq = { "vpsraw", "vpsraw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpsrld_Hdq_Udq_Ib = { "vpsrld", "vpsrld", Hdq, Udq, Ib, XX, IA_AVX },
Ia_vpsrld_Vdq_Hdq_Wdq = { "vpsrld", "vpsrld", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpsrldq_Hdq_Udq_Ib = { "vpsrldq", "vpsrldq", Hdq, Udq, Ib, XX, IA_AVX },
Ia_vpsrlq_Hdq_Udq_Ib = { "vpsrlq", "vpsrlq", Hdq, Udq, Ib, XX, IA_AVX },
Ia_vpsrlq_Vdq_Hdq_Wdq = { "vpsrlq", "vpsrlq", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpsrlvd_Vdq_Hdq_Wdq = { "vpsrlvd", "vpsrlvd", Vdq, Hdq, Wdq, XX, IA_AVX2 },
Ia_vpsrlvq_Vdq_Hdq_Wdq = { "vpsrlvq", "vpsrlvq", Vdq, Hdq, Wdq, XX, IA_AVX2 },
Ia_vpsrlw_Hdq_Udq_Ib = { "vpsrlw", "vpsrlw", Hdq, Udq, Ib, XX, IA_AVX },
Ia_vpsrlw_Vdq_Hdq_Wdq = { "vpsrlw", "vpsrlw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpsubb_Vdq_Hdq_Wdq = { "vpsubb", "vpsubb", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpsubd_Vdq_Hdq_Wdq = { "vpsubd", "vpsubd", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpsubq_Vdq_Hdq_Wdq = { "vpsubq", "vpsubq", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpsubsb_Vdq_Hdq_Wdq = { "vpsubsb", "vpsubsb", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpsubsw_Vdq_Hdq_Wdq = { "vpsubsw", "vpsubsw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpsubusb_Vdq_Hdq_Wdq = { "vpsubusb", "vpsubusb", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpsubusw_Vdq_Hdq_Wdq = { "vpsubusw", "vpsubusw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpsubw_Vdq_Hdq_Wdq = { "vpsubw", "vpsubw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vptest_Vdq_Wdq = { "vptest", "vptest", Vdq, Wdq, XX, XX, IA_AVX },
Ia_vpunpckhbw_Vdq_Hdq_Wdq = { "vpunpckhbw", "vpunpckhbw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpunpckhdq_Vdq_Hdq_Wdq = { "vpunpckhdq", "vpunpckhdq", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpunpckhqdq_Vdq_Hdq_Wdq = { "vpunpckhqdq", "vpunpckhqdq", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpunpckhwd_Vdq_Hdq_Wdq = { "vpunpckhwd", "vpunpckhwd", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpunpcklbw_Vdq_Hdq_Wdq = { "vpunpcklbw", "vpunpcklbw", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpunpckldq_Vdq_Hdq_Wdq = { "vpunpckldq", "vpunpckldq", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpunpcklqdq_Vdq_Hdq_Wdq = { "vpunpcklqdq", "vpunpcklqdq", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpunpcklwd_Vdq_Hdq_Wdq = { "vpunpcklwd", "vpunpcklwd", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vpxor_Vdq_Hdq_Wdq = { "vpxor", "vpxor", Vdq, Hdq, Wdq, XX, IA_AVX },
Ia_vrcpps_Vps_Wps = { "vrcpps", "vrcpps", Vps, Wps, XX, XX, IA_AVX },
Ia_vrcpss_Vss_Hps_Wss = { "vrcpss", "vrcpss", Vss, Hps, Wss, XX, IA_AVX },
Ia_vroundpd_Vpd_Wpd_Ib = { "vroundpd", "vroundpd", Vpd, Wpd, Ib, XX, IA_AVX },
Ia_vroundps_Vps_Wps_Ib = { "vroundps", "vroundps", Vps, Wps, Ib, XX, IA_AVX },
Ia_vroundsd_Vsd_Hpd_Wsd_Ib = { "vroundsd", "vroundsd", Vsd, Hpd, Wsd, Ib, IA_AVX },
Ia_vroundss_Vss_Hps_Wss_Ib = { "vroundss", "vroundss", Vss, Hps, Wss, Ib, IA_AVX },
Ia_vrsqrtps_Vps_Wps = { "vrsqrtps", "vrsqrtps", Vps, Wps, XX, XX, IA_AVX },
Ia_vrsqrtss_Vss_Hps_Wss = { "vrsqrtss", "vrsqrtss", Vss, Hps, Wss, XX, IA_AVX },
Ia_vshufpd_Vpd_Hpd_Wpd_Ib = { "vshufpd", "vshufpd", Vpd, Hpd, Wpd, Ib, IA_AVX },
Ia_vshufps_Vps_Hps_Wps_Ib = { "vshufps", "vshufps", Vps, Hps, Wps, Ib, IA_AVX },
Ia_vsqrtpd_Vpd_Wpd = { "vsqrtpd", "vsqrtpd", Vpd, Wpd, XX, XX, IA_AVX },
Ia_vsqrtps_Vps_Wps = { "vsqrtps", "vsqrtps", Vps, Wps, XX, XX, IA_AVX },
Ia_vsqrtsd_Vsd_Hpd_Wsd = { "vsqrtsd", "vsqrtsd", Vsd, Hpd, Wsd, XX, IA_AVX },
Ia_vsqrtss_Vss_Hps_Wss = { "vsqrtss", "vsqrtss", Vss, Hps, Wss, XX, IA_AVX },
Ia_vstmxcsr = { "vstmxcsr", "vstmxcsr", Md, XX, XX, XX, IA_AVX },
Ia_vsubpd_Vpd_Hpd_Wpd = { "vsubpd", "vsubpd", Vpd, Hpd, Wpd, XX, IA_AVX },
Ia_vsubps_Vps_Hps_Wps = { "vsubps", "vsubps", Vps, Hps, Wps, XX, IA_AVX },
Ia_vsubsd_Vsd_Hpd_Wsd = { "vsubsd", "vsubsd", Vsd, Hpd, Wsd, XX, IA_AVX },
Ia_vsubss_Vss_Hps_Wss = { "vsubss", "vsubss", Vss, Hps, Wss, XX, IA_AVX },
Ia_vtestpd_Vpd_Wpd = { "vtestpd", "vtestpd", Vpd, Wpd, XX, XX, IA_AVX },
Ia_vtestps_Vps_Wps = { "vtestps", "vtestps", Vps, Wps, XX, XX, IA_AVX },
Ia_vucomisd_Vsd_Wsd = { "vucomisd", "vucomisd", Vsd, Wsd, XX, XX, IA_AVX },
Ia_vucomiss_Vss_Wss = { "vucomiss", "vucomiss", Vss, Wss, XX, XX, IA_AVX },
Ia_vunpckhpd_Vpd_Hpd_Wpd = { "vunpckhpd", "vunpckhpd", Vpd, Hpd, Wpd, XX, IA_AVX },
Ia_vunpckhps_Vps_Hps_Wps = { "vunpckhps", "vunpckhps", Vps, Hps, Wps, XX, IA_AVX },
Ia_vunpcklpd_Vpd_Hpd_Wpd = { "vunpcklpd", "vunpcklpd", Vpd, Hpd, Wpd, XX, IA_AVX },
Ia_vunpcklps_Vps_Hps_Wps = { "vunpcklps", "vunpcklps", Vps, Hps, Wps, XX, IA_AVX },
Ia_vxorpd_Vpd_Hpd_Wpd = { "vxorpd", "vxorpd", Vpd, Hpd, Wpd, XX, IA_AVX },
Ia_vxorps_Vps_Hps_Wps = { "vxorps", "vxorps", Vps, Hps, Wps, XX, IA_AVX },
Ia_vzeroall = { "vzeroall", "vzeroall", XX, XX, XX, XX, IA_AVX },
Ia_vzeroupper = { "vzeroupper", "vzeroupper", XX, XX, XX, XX, IA_AVX },
Ia_wbinvd = { "wbinvd", "wbinvd", XX, XX, XX, XX, IA_486 },
Ia_wrfsbase_Ry = { "wrfsbase", "wrfsbase", Ry, XX, XX, XX, IA_FSGSBASE },
Ia_wrgsbase_Ry = { "wrgsbase", "wrgsbase", Ry, XX, XX, XX, IA_FSGSBASE },
Ia_wrmsr = { "wrmsr", "wrmsr", XX, XX, XX, XX, IA_PENTIUM },
Ia_xaddb_Eb_Gb = { "xadd", "xaddb", Eb, Gb, XX, XX, IA_486 },
Ia_xaddl_Ed_Gd = { "xadd", "xaddl", Ed, Gd, XX, XX, IA_486 },
Ia_xaddq_Eq_Gq = { "xadd", "xaddq", Eq, Gq, XX, XX, 0 },
Ia_xaddw_Ew_Gw = { "xadd", "xaddw", Ew, Gw, XX, XX, IA_486 },
Ia_xchgb_Eb_Gb = { "xchg", "xchgb", Eb, Gb, XX, XX, 0 },
Ia_xchgl_Ed_Gd = { "xchg", "xchgl", Ed, Gd, XX, XX, 0 },
Ia_xchgl_ERX_EAX = { "xchg", "xchgl", ERX, EAX_Reg, XX, XX, 0 },
Ia_xchgq_Eq_Gq = { "xchg", "xchgq", Eq, Gq, XX, XX, 0 },
Ia_xchgq_RRX_RAX = { "xchg", "xchgq", RRX, RAX_Reg, XX, XX, 0 },
Ia_xchgw_Ew_Gw = { "xchg", "xchgw", Ew, Gw, XX, XX, 0 },
Ia_xchgw_RX_AX = { "xchg", "xchgw", RX, AX_Reg, XX, XX, 0 },
Ia_xgetbv = { "xgetbv", "xgetbv", XX, XX, XX, XX, IA_XSAVE },
Ia_xlat = { "xlat", "xlat", XX, XX, XX, XX, 0 },
Ia_xorb_AL_Ib = { "xor", "xorb", AL_Reg, Ib, XX, XX, 0 },
Ia_xorb_Eb_Gb = { "xor", "xorb", Eb, Gb, XX, XX, 0 },
Ia_xorb_Eb_Ib = { "xor", "xorb", Eb, Ib, XX, XX, 0 },
Ia_xorb_Gb_Eb = { "xor", "xorb", Gb, Eb, XX, XX, 0 },
Ia_xorl_EAX_Id = { "xor", "xorl", EAX_Reg, Id, XX, XX, 0 },
Ia_xorl_Ed_Gd = { "xor", "xorl", Ed, Gd, XX, XX, 0 },
Ia_xorl_Ed_Id = { "xor", "xorl", Ed, Id, XX, XX, 0 },
Ia_xorl_Ed_sIb = { "xor", "xorl", Ed, sIbd, XX, XX, 0 },
Ia_xorl_Gd_Ed = { "xor", "xorl", Gd, Ed, XX, XX, 0 },
Ia_xorpd_Vpd_Wpd = { "xorpd", "xorpd", Vpd, Wpd, XX, XX, IA_SSE2 },
Ia_xorps_Vps_Wps = { "xorps", "xorps", Vps, Wps, XX, XX, IA_SSE },
Ia_xorq_Eq_Gq = { "xor", "xorq", Eq, Gq, XX, XX, 0 },
Ia_xorq_Eq_sIb = { "xor", "xorq", Eq, sIbq, XX, XX, 0 },
Ia_xorq_Eq_sId = { "xor", "xorq", Eq, sIdq, XX, XX, 0 },
Ia_xorq_Gq_Eq = { "xor", "xorq", Gq, Eq, XX, XX, 0 },
Ia_xorq_RAX_sId = { "xor", "xorq", RAX_Reg, sIdq, XX, XX, 0 },
Ia_xorw_AX_Iw = { "xor", "xorw", AX_Reg, Iw, XX, XX, 0 },
Ia_xorw_Ew_Gw = { "xor", "xorw", Ew, Gw, XX, XX, 0 },
Ia_xorw_Ew_Iw = { "xor", "xorw", Ew, Iw, XX, XX, 0 },
Ia_xorw_Ew_sIb = { "xor", "xorw", Ew, sIbw, XX, XX, 0 },
Ia_xorw_Gw_Ew = { "xor", "xorw", Gw, Ew, XX, XX, 0 },
Ia_xrstor = { "xrstor", "xrstor", Mx, XX, XX, XX, IA_XSAVE },
Ia_xsave = { "xsave", "xsave", Mx, XX, XX, XX, IA_XSAVE },
Ia_xsavec = { "xsavec", "xsavec", Mx, XX, XX, XX, IA_XSAVEC },
Ia_xsaveopt = { "xsaveopt", "xsaveopt", Mx, XX, XX, XX, IA_XSAVEOPT },
Ia_xsetbv = { "xsetbv", "xsetbv", XX, XX, XX, XX, IA_XSAVE };
