;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Expand/mvalue.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Mar 22 10:35:52 2005                          */
;*    Last change :  Mon Oct  8 19:44:37 2007 (serrano)                */
;*    Copyright   :  2005-07 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The macro expansion of multiple values                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module expand_multiple-values
   (include "Expand/expander.sch"
	    "Tools/trace.sch")
   (import  tools_progn
	    tools_args
	    tools_speek
	    tools_misc
	    expand_expander
	    expand_eps
	    expand_lambda
	    engine_param
	    type_type
	    ast_ident)
   (export  (expand-mvalue-bind ::obj ::procedure)
	    (expand-O-call-with-values ::obj ::procedure)
	    (expand-O-values ::obj ::procedure)))

;*---------------------------------------------------------------------*/
;*    expand-mvalue-bind ...                                           */
;*---------------------------------------------------------------------*/
(define (expand-mvalue-bind x e)
   (match-case x
      ((?- ?vars ?call . ?exprs)
       (expand-O-call-with-values `(call-with-values (lambda () ,call)
						     (lambda ,vars ,@exprs))
				  e))
      (else
       (error "multiple-value-bind" "Illegal form" x))))

;*---------------------------------------------------------------------*/
;*    expand-O-call-with-values ...                                    */
;*---------------------------------------------------------------------*/
(define (expand-O-call-with-values x e)
   (e (match-case x
	 ((?- ?producer (lambda () . ?body))
	  `(begin
	      ,(match-case producer
		  ((lambda () . ?prod)
		   `(begin ,@prod))
		  (else
		   `(,producer)))
	      ,@body))
	 ((?- ?producer (lambda (?v0) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      ,@body))
	 ((?- ?producer (lambda (?v0 ?v1) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2))
		    (,v3 ((@ %get-mvalues-val __r5_control_features_6_4) 3)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3 ?v4) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2))
		    (,v3 ((@ %get-mvalues-val __r5_control_features_6_4) 3))
		    (,v4 ((@ %get-mvalues-val __r5_control_features_6_4) 4)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3 ?v4 ?v5) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2))
		    (,v3 ((@ %get-mvalues-val __r5_control_features_6_4) 3))
		    (,v4 ((@ %get-mvalues-val __r5_control_features_6_4) 4))
		    (,v5 ((@ %get-mvalues-val __r5_control_features_6_4) 5)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3 ?v4 ?v5 ?v6) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2))
		    (,v3 ((@ %get-mvalues-val __r5_control_features_6_4) 3))
		    (,v4 ((@ %get-mvalues-val __r5_control_features_6_4) 4))
		    (,v5 ((@ %get-mvalues-val __r5_control_features_6_4) 5))
		    (,v6 ((@ %get-mvalues-val __r5_control_features_6_4) 6)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3 ?v4 ?v5 ?v6 ?v7) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2))
		    (,v3 ((@ %get-mvalues-val __r5_control_features_6_4) 3))
		    (,v4 ((@ %get-mvalues-val __r5_control_features_6_4) 4))
		    (,v5 ((@ %get-mvalues-val __r5_control_features_6_4) 5))
		    (,v6 ((@ %get-mvalues-val __r5_control_features_6_4) 6))
		    (,v7 ((@ %get-mvalues-val __r5_control_features_6_4) 7)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3 ?v4 ?v5 ?v6 ?v7 ?v8) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2))
		    (,v3 ((@ %get-mvalues-val __r5_control_features_6_4) 3))
		    (,v4 ((@ %get-mvalues-val __r5_control_features_6_4) 4))
		    (,v5 ((@ %get-mvalues-val __r5_control_features_6_4) 5))
		    (,v6 ((@ %get-mvalues-val __r5_control_features_6_4) 6))
		    (,v7 ((@ %get-mvalues-val __r5_control_features_6_4) 7))
		    (,v8 ((@ %get-mvalues-val __r5_control_features_6_4) 8)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3 ?v4 ?v5 ?v6 ?v7 ?v8 ?v9) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2))
		    (,v3 ((@ %get-mvalues-val __r5_control_features_6_4) 3))
		    (,v4 ((@ %get-mvalues-val __r5_control_features_6_4) 4))
		    (,v5 ((@ %get-mvalues-val __r5_control_features_6_4) 5))
		    (,v6 ((@ %get-mvalues-val __r5_control_features_6_4) 6))
		    (,v7 ((@ %get-mvalues-val __r5_control_features_6_4) 7))
		    (,v8 ((@ %get-mvalues-val __r5_control_features_6_4) 8))
		    (,v9 ((@ %get-mvalues-val __r5_control_features_6_4) 9)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3 ?v4 ?v5 ?v6 ?v7 ?v8 ?v9 ?v10) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2))
		    (,v3 ((@ %get-mvalues-val __r5_control_features_6_4) 3))
		    (,v4 ((@ %get-mvalues-val __r5_control_features_6_4) 4))
		    (,v5 ((@ %get-mvalues-val __r5_control_features_6_4) 5))
		    (,v6 ((@ %get-mvalues-val __r5_control_features_6_4) 6))
		    (,v7 ((@ %get-mvalues-val __r5_control_features_6_4) 7))
		    (,v8 ((@ %get-mvalues-val __r5_control_features_6_4) 8))
		    (,v9 ((@ %get-mvalues-val __r5_control_features_6_4) 9))
		    (,v10 ((@ %get-mvalues-val __r5_control_features_6_4) 10)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3 ?v4 ?v5 ?v6 ?v7 ?v8 ?v9 ?v10 ?v11) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2))
		    (,v3 ((@ %get-mvalues-val __r5_control_features_6_4) 3))
		    (,v4 ((@ %get-mvalues-val __r5_control_features_6_4) 4))
		    (,v5 ((@ %get-mvalues-val __r5_control_features_6_4) 5))
		    (,v6 ((@ %get-mvalues-val __r5_control_features_6_4) 6))
		    (,v7 ((@ %get-mvalues-val __r5_control_features_6_4) 7))
		    (,v8 ((@ %get-mvalues-val __r5_control_features_6_4) 8))
		    (,v9 ((@ %get-mvalues-val __r5_control_features_6_4) 9))
		    (,v10 ((@ %get-mvalues-val __r5_control_features_6_4) 10))
		    (,v11 ((@ %get-mvalues-val __r5_control_features_6_4) 11)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3 ?v4 ?v5 ?v6 ?v7 ?v8 ?v9 ?v10 ?v11 ?v12) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2))
		    (,v3 ((@ %get-mvalues-val __r5_control_features_6_4) 3))
		    (,v4 ((@ %get-mvalues-val __r5_control_features_6_4) 4))
		    (,v5 ((@ %get-mvalues-val __r5_control_features_6_4) 5))
		    (,v6 ((@ %get-mvalues-val __r5_control_features_6_4) 6))
		    (,v7 ((@ %get-mvalues-val __r5_control_features_6_4) 7))
		    (,v8 ((@ %get-mvalues-val __r5_control_features_6_4) 8))
		    (,v9 ((@ %get-mvalues-val __r5_control_features_6_4) 9))
		    (,v10 ((@ %get-mvalues-val __r5_control_features_6_4) 10))
		    (,v11 ((@ %get-mvalues-val __r5_control_features_6_4) 11))
		    (,v12 ((@ %get-mvalues-val __r5_control_features_6_4) 12)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3 ?v4 ?v5 ?v6 ?v7 ?v8 ?v9 ?v10 ?v11 ?v12 ?v13) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2))
		    (,v3 ((@ %get-mvalues-val __r5_control_features_6_4) 3))
		    (,v4 ((@ %get-mvalues-val __r5_control_features_6_4) 4))
		    (,v5 ((@ %get-mvalues-val __r5_control_features_6_4) 5))
		    (,v6 ((@ %get-mvalues-val __r5_control_features_6_4) 6))
		    (,v7 ((@ %get-mvalues-val __r5_control_features_6_4) 7))
		    (,v8 ((@ %get-mvalues-val __r5_control_features_6_4) 8))
		    (,v9 ((@ %get-mvalues-val __r5_control_features_6_4) 9))
		    (,v10 ((@ %get-mvalues-val __r5_control_features_6_4) 10))
		    (,v11 ((@ %get-mvalues-val __r5_control_features_6_4) 11))
		    (,v12 ((@ %get-mvalues-val __r5_control_features_6_4) 12))
		    (,v13 ((@ %get-mvalues-val __r5_control_features_6_4) 13)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3 ?v4 ?v5 ?v6 ?v7 ?v8 ?v9 ?v10 ?v11 ?v12 ?v13 ?v14) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2))
		    (,v3 ((@ %get-mvalues-val __r5_control_features_6_4) 3))
		    (,v4 ((@ %get-mvalues-val __r5_control_features_6_4) 4))
		    (,v5 ((@ %get-mvalues-val __r5_control_features_6_4) 5))
		    (,v6 ((@ %get-mvalues-val __r5_control_features_6_4) 6))
		    (,v7 ((@ %get-mvalues-val __r5_control_features_6_4) 7))
		    (,v8 ((@ %get-mvalues-val __r5_control_features_6_4) 8))
		    (,v9 ((@ %get-mvalues-val __r5_control_features_6_4) 9))
		    (,v10 ((@ %get-mvalues-val __r5_control_features_6_4) 10))
		    (,v11 ((@ %get-mvalues-val __r5_control_features_6_4) 11))
		    (,v12 ((@ %get-mvalues-val __r5_control_features_6_4) 12))
		    (,v13 ((@ %get-mvalues-val __r5_control_features_6_4) 13))
		    (,v14 ((@ %get-mvalues-val __r5_control_features_6_4) 14)))
		 ,@body)))
	 ((?- ?producer (lambda (?v0 ?v1 ?v2 ?v3 ?v4 ?v5 ?v6 ?v7 ?v8 ?v9 ?v10 ?v11 ?v12 ?v13 ?v14 ?v15) . ?body))
	  `(let ((,v0 ,(match-case producer
			  ((lambda () . ?prod)
			   `(begin ,@prod))
			  (else
			   `(,producer)))))
	      (let ((,v1 ((@ %get-mvalues-val __r5_control_features_6_4) 1))
		    (,v2 ((@ %get-mvalues-val __r5_control_features_6_4) 2))
		    (,v3 ((@ %get-mvalues-val __r5_control_features_6_4) 3))
		    (,v4 ((@ %get-mvalues-val __r5_control_features_6_4) 4))
		    (,v5 ((@ %get-mvalues-val __r5_control_features_6_4) 5))
		    (,v6 ((@ %get-mvalues-val __r5_control_features_6_4) 6))
		    (,v7 ((@ %get-mvalues-val __r5_control_features_6_4) 7))
		    (,v8 ((@ %get-mvalues-val __r5_control_features_6_4) 8))
		    (,v9 ((@ %get-mvalues-val __r5_control_features_6_4) 9))
		    (,v10 ((@ %get-mvalues-val __r5_control_features_6_4) 10))
		    (,v11 ((@ %get-mvalues-val __r5_control_features_6_4) 11))
		    (,v12 ((@ %get-mvalues-val __r5_control_features_6_4) 12))
		    (,v13 ((@ %get-mvalues-val __r5_control_features_6_4) 13))
		    (,v14 ((@ %get-mvalues-val __r5_control_features_6_4) 14))
		    (,v15 ((@ %get-mvalues-val __r5_control_features_6_4) 15)))
		 ,@body)))
	 (else
	  `((@ call-with-values __r5_control_features_6_4) ,@(cdr x))))
      e))

;*---------------------------------------------------------------------*/
;*    expand-O-values ...                                              */
;*---------------------------------------------------------------------*/
(define (expand-O-values x e)
   (match-case x
      ((?-)
       '((@ %set-mvalues-number! __r5_control_features_6_4) 0))
      ((?- ?val0)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_))))
	  `(let ((,g0 ,(e val0 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 1)
	      ,g0)))
      ((?- ?val0 ?val1)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 3)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2 ?val3)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_)))
	     (g3 (mark-symbol-non-user! (gensym 'val3_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e))
		 (,g3 ,(e val3 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 4)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 3 ,g3)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2 ?val3 ?val4)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_)))
	     (g3 (mark-symbol-non-user! (gensym 'val3_)))
	     (g4 (mark-symbol-non-user! (gensym 'val4_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e))
		 (,g3 ,(e val3 e))
		 (,g4 ,(e val4 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 5)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 3 ,g3)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 4 ,g4)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2 ?val3 ?val4 ?val5)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_)))
	     (g3 (mark-symbol-non-user! (gensym 'val3_)))
	     (g4 (mark-symbol-non-user! (gensym 'val4_)))
	     (g5 (mark-symbol-non-user! (gensym 'val5_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e))
		 (,g3 ,(e val3 e))
		 (,g4 ,(e val4 e))
		 (,g5 ,(e val5 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 6)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 3 ,g3)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 4 ,g4)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 5 ,g5)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2 ?val3 ?val4 ?val5 ?val6)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_)))
	     (g3 (mark-symbol-non-user! (gensym 'val3_)))
	     (g4 (mark-symbol-non-user! (gensym 'val4_)))
	     (g5 (mark-symbol-non-user! (gensym 'val5_)))
	     (g6 (mark-symbol-non-user! (gensym 'val6_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e))
		 (,g3 ,(e val3 e))
		 (,g4 ,(e val4 e))
		 (,g5 ,(e val5 e))
		 (,g6 ,(e val6 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 7)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 3 ,g3)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 4 ,g4)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 5 ,g5)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 6 ,g6)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2 ?val3 ?val4 ?val5 ?val6 ?val7)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_)))
	     (g3 (mark-symbol-non-user! (gensym 'val3_)))
	     (g4 (mark-symbol-non-user! (gensym 'val4_)))
	     (g5 (mark-symbol-non-user! (gensym 'val5_)))
	     (g6 (mark-symbol-non-user! (gensym 'val6_)))
	     (g7 (mark-symbol-non-user! (gensym 'val7_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e))
		 (,g3 ,(e val3 e))
		 (,g4 ,(e val4 e))
		 (,g5 ,(e val5 e))
		 (,g6 ,(e val6 e))
		 (,g7 ,(e val7 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 8)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 3 ,g3)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 4 ,g4)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 5 ,g5)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 6 ,g6)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 7 ,g7)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2 ?val3 ?val4 ?val5 ?val6 ?val7 ?val8)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_)))
	     (g3 (mark-symbol-non-user! (gensym 'val3_)))
	     (g4 (mark-symbol-non-user! (gensym 'val4_)))
	     (g5 (mark-symbol-non-user! (gensym 'val5_)))
	     (g6 (mark-symbol-non-user! (gensym 'val6_)))
	     (g7 (mark-symbol-non-user! (gensym 'val7_)))
	     (g8 (mark-symbol-non-user! (gensym 'val8_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e))
		 (,g3 ,(e val3 e))
		 (,g4 ,(e val4 e))
		 (,g5 ,(e val5 e))
		 (,g6 ,(e val6 e))
		 (,g7 ,(e val7 e))
		 (,g8 ,(e val8 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 8)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 3 ,g3)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 4 ,g4)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 5 ,g5)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 6 ,g6)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 7 ,g7)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 8 ,g8)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2 ?val3 ?val4 ?val5 ?val6 ?val7 ?val8 ?val9)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_)))
	     (g3 (mark-symbol-non-user! (gensym 'val3_)))
	     (g4 (mark-symbol-non-user! (gensym 'val4_)))
	     (g5 (mark-symbol-non-user! (gensym 'val5_)))
	     (g6 (mark-symbol-non-user! (gensym 'val6_)))
	     (g7 (mark-symbol-non-user! (gensym 'val7_)))
	     (g8 (mark-symbol-non-user! (gensym 'val8_)))
	     (g9 (mark-symbol-non-user! (gensym 'val9_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e))
		 (,g3 ,(e val3 e))
		 (,g4 ,(e val4 e))
		 (,g5 ,(e val5 e))
		 (,g6 ,(e val6 e))
		 (,g7 ,(e val7 e))
		 (,g8 ,(e val8 e))
		 (,g9 ,(e val9 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 8)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 3 ,g3)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 4 ,g4)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 5 ,g5)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 6 ,g6)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 7 ,g7)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 8 ,g8)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 9 ,g9)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2 ?val3 ?val4 ?val5 ?val6 ?val7 ?val8 ?val9 ?val10)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_)))
	     (g3 (mark-symbol-non-user! (gensym 'val3_)))
	     (g4 (mark-symbol-non-user! (gensym 'val4_)))
	     (g5 (mark-symbol-non-user! (gensym 'val5_)))
	     (g6 (mark-symbol-non-user! (gensym 'val6_)))
	     (g7 (mark-symbol-non-user! (gensym 'val7_)))
	     (g8 (mark-symbol-non-user! (gensym 'val8_)))
	     (g9 (mark-symbol-non-user! (gensym 'val9_)))
	     (g10 (mark-symbol-non-user! (gensym 'val10_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e))
		 (,g3 ,(e val3 e))
		 (,g4 ,(e val4 e))
		 (,g5 ,(e val5 e))
		 (,g6 ,(e val6 e))
		 (,g7 ,(e val7 e))
		 (,g8 ,(e val8 e))
		 (,g9 ,(e val9 e))
		 (,g10 ,(e val10 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 8)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 3 ,g3)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 4 ,g4)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 5 ,g5)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 6 ,g6)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 7 ,g7)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 8 ,g8)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 9 ,g9)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 10 ,g10)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2 ?val3 ?val4 ?val5 ?val6 ?val7 ?val8 ?val9 ?val10 ?val11)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_)))
	     (g3 (mark-symbol-non-user! (gensym 'val3_)))
	     (g4 (mark-symbol-non-user! (gensym 'val4_)))
	     (g5 (mark-symbol-non-user! (gensym 'val5_)))
	     (g6 (mark-symbol-non-user! (gensym 'val6_)))
	     (g7 (mark-symbol-non-user! (gensym 'val7_)))
	     (g8 (mark-symbol-non-user! (gensym 'val8_)))
	     (g9 (mark-symbol-non-user! (gensym 'val9_)))
	     (g10 (mark-symbol-non-user! (gensym 'val10_)))
	     (g11 (mark-symbol-non-user! (gensym 'val11_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e))
		 (,g3 ,(e val3 e))
		 (,g4 ,(e val4 e))
		 (,g5 ,(e val5 e))
		 (,g6 ,(e val6 e))
		 (,g7 ,(e val7 e))
		 (,g8 ,(e val8 e))
		 (,g9 ,(e val9 e))
		 (,g10 ,(e val10 e))
		 (,g11 ,(e val11 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 8)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 3 ,g3)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 4 ,g4)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 5 ,g5)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 6 ,g6)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 7 ,g7)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 8 ,g8)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 9 ,g9)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 10 ,g10)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 11 ,g11)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2 ?val3 ?val4 ?val5 ?val6 ?val7 ?val8 ?val9 ?val10 ?val11 ?val12)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_)))
	     (g3 (mark-symbol-non-user! (gensym 'val3_)))
	     (g4 (mark-symbol-non-user! (gensym 'val4_)))
	     (g5 (mark-symbol-non-user! (gensym 'val5_)))
	     (g6 (mark-symbol-non-user! (gensym 'val6_)))
	     (g7 (mark-symbol-non-user! (gensym 'val7_)))
	     (g8 (mark-symbol-non-user! (gensym 'val8_)))
	     (g9 (mark-symbol-non-user! (gensym 'val9_)))
	     (g10 (mark-symbol-non-user! (gensym 'val10_)))
	     (g11 (mark-symbol-non-user! (gensym 'val11_)))
	     (g12 (mark-symbol-non-user! (gensym 'val12_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e))
		 (,g3 ,(e val3 e))
		 (,g4 ,(e val4 e))
		 (,g5 ,(e val5 e))
		 (,g6 ,(e val6 e))
		 (,g7 ,(e val7 e))
		 (,g8 ,(e val8 e))
		 (,g9 ,(e val9 e))
		 (,g10 ,(e val10 e))
		 (,g11 ,(e val11 e))
		 (,g12 ,(e val12 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 8)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 3 ,g3)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 4 ,g4)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 5 ,g5)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 6 ,g6)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 7 ,g7)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 8 ,g8)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 9 ,g9)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 10 ,g10)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 11 ,g11)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 12 ,g12)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2 ?val3 ?val4 ?val5 ?val6 ?val7 ?val8 ?val9 ?val10 ?val11 ?val12 ?val13)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_)))
	     (g3 (mark-symbol-non-user! (gensym 'val3_)))
	     (g4 (mark-symbol-non-user! (gensym 'val4_)))
	     (g5 (mark-symbol-non-user! (gensym 'val5_)))
	     (g6 (mark-symbol-non-user! (gensym 'val6_)))
	     (g7 (mark-symbol-non-user! (gensym 'val7_)))
	     (g8 (mark-symbol-non-user! (gensym 'val8_)))
	     (g9 (mark-symbol-non-user! (gensym 'val9_)))
	     (g10 (mark-symbol-non-user! (gensym 'val10_)))
	     (g11 (mark-symbol-non-user! (gensym 'val11_)))
	     (g12 (mark-symbol-non-user! (gensym 'val12_)))
	     (g13 (mark-symbol-non-user! (gensym 'val13_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e))
		 (,g3 ,(e val3 e))
		 (,g4 ,(e val4 e))
		 (,g5 ,(e val5 e))
		 (,g6 ,(e val6 e))
		 (,g7 ,(e val7 e))
		 (,g8 ,(e val8 e))
		 (,g9 ,(e val9 e))
		 (,g10 ,(e val10 e))
		 (,g11 ,(e val11 e))
		 (,g12 ,(e val12 e))
		 (,g13 ,(e val13 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 8)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 3 ,g3)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 4 ,g4)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 5 ,g5)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 6 ,g6)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 7 ,g7)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 8 ,g8)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 9 ,g9)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 10 ,g10)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 11 ,g11)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 12 ,g12)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 13 ,g13)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2 ?val3 ?val4 ?val5 ?val6 ?val7 ?val8 ?val9 ?val10 ?val11 ?val12 ?val13 ?val14)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_)))
	     (g3 (mark-symbol-non-user! (gensym 'val3_)))
	     (g4 (mark-symbol-non-user! (gensym 'val4_)))
	     (g5 (mark-symbol-non-user! (gensym 'val5_)))
	     (g6 (mark-symbol-non-user! (gensym 'val6_)))
	     (g7 (mark-symbol-non-user! (gensym 'val7_)))
	     (g8 (mark-symbol-non-user! (gensym 'val8_)))
	     (g9 (mark-symbol-non-user! (gensym 'val9_)))
	     (g10 (mark-symbol-non-user! (gensym 'val10_)))
	     (g11 (mark-symbol-non-user! (gensym 'val11_)))
	     (g12 (mark-symbol-non-user! (gensym 'val12_)))
	     (g13 (mark-symbol-non-user! (gensym 'val13_)))
	     (g14 (mark-symbol-non-user! (gensym 'val14_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e))
		 (,g3 ,(e val3 e))
		 (,g4 ,(e val4 e))
		 (,g5 ,(e val5 e))
		 (,g6 ,(e val6 e))
		 (,g7 ,(e val7 e))
		 (,g8 ,(e val8 e))
		 (,g9 ,(e val9 e))
		 (,g10 ,(e val10 e))
		 (,g11 ,(e val11 e))
		 (,g12 ,(e val12 e))
		 (,g13 ,(e val13 e))
		 (,g14 ,(e val14 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 8)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 3 ,g3)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 4 ,g4)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 5 ,g5)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 6 ,g6)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 7 ,g7)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 8 ,g8)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 9 ,g9)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 10 ,g10)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 11 ,g11)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 12 ,g12)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 13 ,g13)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 14 ,g14)
	      ,g0)))
      ((?- ?val0 ?val1 ?val2 ?val3 ?val4 ?val5 ?val6 ?val7 ?val8 ?val9 ?val10 ?val11 ?val12 ?val13 ?val14 ?val15)
       (let ((g0 (mark-symbol-non-user! (gensym 'val0_)))
	     (g1 (mark-symbol-non-user! (gensym 'val1_)))
	     (g2 (mark-symbol-non-user! (gensym 'val2_)))
	     (g3 (mark-symbol-non-user! (gensym 'val3_)))
	     (g4 (mark-symbol-non-user! (gensym 'val4_)))
	     (g5 (mark-symbol-non-user! (gensym 'val5_)))
	     (g6 (mark-symbol-non-user! (gensym 'val6_)))
	     (g7 (mark-symbol-non-user! (gensym 'val7_)))
	     (g8 (mark-symbol-non-user! (gensym 'val8_)))
	     (g9 (mark-symbol-non-user! (gensym 'val9_)))
	     (g10 (mark-symbol-non-user! (gensym 'val10_)))
	     (g11 (mark-symbol-non-user! (gensym 'val11_)))
	     (g12 (mark-symbol-non-user! (gensym 'val12_)))
	     (g13 (mark-symbol-non-user! (gensym 'val13_)))
	     (g14 (mark-symbol-non-user! (gensym 'val14_)))
	     (g15 (mark-symbol-non-user! (gensym 'val15_))))
	  `(let ((,g0 ,(e val0 e))
		 (,g1 ,(e val1 e))
		 (,g2 ,(e val2 e))
		 (,g3 ,(e val3 e))
		 (,g4 ,(e val4 e))
		 (,g5 ,(e val5 e))
		 (,g6 ,(e val6 e))
		 (,g7 ,(e val7 e))
		 (,g8 ,(e val8 e))
		 (,g9 ,(e val9 e))
		 (,g10 ,(e val10 e))
		 (,g11 ,(e val11 e))
		 (,g12 ,(e val12 e))
		 (,g13 ,(e val13 e))
		 (,g14 ,(e val14 e))
		 (,g15 ,(e val15 e)))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) 8)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 1 ,g1)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 2 ,g2)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 3 ,g3)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 4 ,g4)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 5 ,g5)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 6 ,g6)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 7 ,g7)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 8 ,g8)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 9 ,g9)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 10 ,g10)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 11 ,g11)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 12 ,g12)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 13 ,g13)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 14 ,g14)
	      ((@ %set-mvalues-val! __r5_control_features_6_4) 15 ,g15)
	      ,g0)))
      (else
       (let ((g0 (mark-symbol-non-user! (gensym 'val_))))
	  `(let ((,g0 (list ,@(map (lambda (x) (e x e)) (cdr x)))))
	      ((@ %set-mvalues-number! __r5_control_features_6_4) -1)
	      ,g0)))))
