# arch.mk for BerkeleyGW codes
#
# suitable for Steele at Purdue
# module swap mpich-intel64 mpich2-1.2-intel64/11.1.038
# default mpich is deprecated for some reason
# build in $RCAC_SCRATCH rather than $HOME or you will exceed disk quota
# make -j all-j will give errors relating to 'mpif.h', use only -j 8.
# testsuite success last confirmed 1/27/11 r2204
#
# D. Strubbe
# November 2010, UC Berkeley

# Precompiler options
#
COMPFLAG  = -DINTEL
PARAFLAG  = -DMPI
MATHFLAG  = -DUSESCALAPACK
DEBUGFLAG = -DDEBUG -DVERBOSE

FCPP    = cpp -ansi
F90free = mpif90 -free
LINK    = mpif90 -i-static
FOPTS   = -O3 -no-prec-div
FNOOPTS = -O2 -no-prec-div
MOD_OPT = -module 
INCFLAG = -I

C_PARAFLAG = -DPARA -DMPICH_IGNORE_CXX_SEEK
CC_COMP = mpicxx
C_COMP  = mpicc
C_LINK  = mpicxx
C_OPTS  = -O3

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWPATH     = /apps/rhel5/fftw-2.1.5
FFTWLIB      = $(FFTWPATH)/intel-impi/lib/libdfftw.a
FFTWINCLUDE  = $(FFTWPATH)/include
MKLPATH      = /opt/intel/mkl/10.2.5.035/lib/em64t
LAPACKLIB    = -Wl,--start-group $(MKLPATH)/libmkl_intel_lp64.a $(MKLPATH)/libmkl_sequential.a \
               $(MKLPATH)/libmkl_core.a $(MKLPATH)/libmkl_blacs_intelmpi_lp64.a -Wl,--end-group
SCALAPACKLIB = $(MKLPATH)/libmkl_scalapack_lp64.a

# Steele requires a specification of allocation and does not supply a default
TESTSCRIPT = qsub steele.scr -A `tgusage | grep -B1 steele | awk '(NR==1) {print $$2}'`
