# arch.mk for BerkeleyGW codes
#
# single processor with ifort, MKL, 32-bit on x86_64, suitable for Tigger
# note that Ubuntu 10.10 is 'unsupported' by Intel
# but it seems to work fine nonetheless
#
# D. Strubbe
# Jan 2011, UCB

# Precompiler options
#
COMPFLAG  = -DINTEL
MATHFLAG  = 
DEBUGFLAG = -DDEBUG -DVERBOSE

FCPP    = cpp -ansi
F90free = ifort -free
LINK    = ifort
# -warn all can often lead to compiler crashes!
FOPTS   = -O3
# -O3 generates correct code, but especially with -warn all takes forever and can crash the compiler
FNOOPTS = -O3
MOD_OPT = -module 
INCFLAG = -I

CC_COMP = icc
C_COMP  = icc
C_LINK  = icc
C_OPTS  = -O3

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWLIB      = -L/usr/lib -lfftw
FFTWINCLUDE  = /usr/share/doc/fftw-dev/fortran
MKLPATH = /auto/opt/intel/mkl/lib/intel64
LAPACKLIB = -Wl,--start-group $(MKLPATH)/libmkl_intel_lp64.a $(MKLPATH)/libmkl_sequential.a \
            $(MKLPATH)/libmkl_core.a -Wl,--end-group -lpthread
