# arch.mk for BerkeleyGW codes
#
# g95 serial
# needs packages liblapack-dev, fftw-dev, g++ packages 
#
# D. Strubbe
# September 2010, UCB

# Precompiler options
#
COMPFLAG  = -DG95
MATHFLAG  = 
DEBUGFLAG = -DDEBUG -DVERBOSE

# note that we use many cpp features that g95 -cpp does not support, so you cannot use g95's built-in cpp
FCPP    = cpp -P -ansi
F90free = g95 -ffree-form -ffree-line-length-huge -fno-second-underscore
#F90free = g95 -fbounds-check -ftrace=full -ffree-form -ffree-line-length-huge -fno-second-underscore
# debug flags: -ftrace=full will identify memory leaks
LINK    = g95
FOPTS   = -O3
FNOOPTS = $(FOPTS)
MOD_OPT = -fmod=
INCFLAG = -I

CC_COMP = g++
C_COMP  = gcc
C_LINK  = g++
C_OPTS  = -O3

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWLIB      = -L/usr/lib/ -lfftw
FFTWINCLUDE  = /usr/share/doc/fftw-dev/fortran
LAPACKLIB    = -L/usr/lib/ -llapack
