# arch.mk for BerkeleyGW codes
#
# suitable for SCRS North cluster mako.berkeley.edu
#
# D. Strubbe
# February 2010, UC Berkeley
#
# module load openmpi/1.4.1-intel
# module load fftw/2.1.5-intel
# module load mkl/11.1.064

# Precompiler options
#
COMPFLAG  = -DINTEL
PARAFLAG  = -DMPI
MATHFLAG  = -DUSESCALAPACK
DEBUGFLAG = -DDEBUG -DVERBOSE

FCPP    = cpp -ansi
F90free = mpif90 -free
LINK    = mpif90 -i-static -openmp
FOPTS   = -O3 -no-prec-div
FNOOPTS = -O2 -no-prec-div
MOD_OPT = -module 
INCFLAG = -I

C_PARAFLAG = -DPARA
CC_COMP = mpiCC
C_COMP  = mpicc
C_LINK  = mpiCC
C_OPTS  = -O3

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWPATH     = /global/software/centos-5.x86_64/modules/fftw/2.1.5-intel
FFTWLIB      = -L$(FFTWPATH)/lib -ldfftw
FFTWINCLUDE  = $(FFTWPATH)/include
MKLPATH      = /global/software/centos-5.x86_64/modules/intel/Compiler/11.1/064/mkl/lib/em64t
LAPACKLIB    = -Wl,--start-group $(MKLPATH)/libmkl_intel_lp64.a $(MKLPATH)/libmkl_sequential.a \
	       $(MKLPATH)/libmkl_core.a $(MKLPATH)/libmkl_blacs_openmpi_lp64.a -Wl,--end-group -lpthread
SCALAPACKLIB = $(MKLPATH)/libmkl_scalapack_lp64.a 

TESTSCRIPT = qsub mako.scr
