# arch.mk for BerkeleyGW codes
#
# Suitable for generic single-processor MacOS 
# Tested on Intel Macbook with Snow Leopard, Leopard, Lion, Mountain Lion
# Use macports to install gcc46, fftw +gcc46, atlas +gcc46 (or any other of gcc, for all)
# Add location of the binaries (/opt/local/bin by default) to PATH
#
# On Leopard atlas that is built by macports is buggy. Install
# atlas on your own and then add all the generic lapack symbols to
# it if needed (as described on their website). The linking is done
# by the commented LAPACKLIB
#
# All tests passed 2 Aug 2012, r4658
#
# D. Strubbe
# Sept 2011, UCB

COMPFLAG  = -DGNU
MATHFLAG  = 
DEBUGFLAG = -DDEBUG -DVERBOSE

VERSION = -mp-4.6
FCPP    = cpp$(VERSION) -ansi
F90free = gfortran$(VERSION) -ffree-form -ffree-line-length-none -fno-second-underscore
LINK    = gfortran$(VERSION)
#FOPTS   = -g -fbounds-check -fbacktrace
FOPTS   = -O3
FNOOPTS = $(FOPTS)
MOD_OPT = -J
INCFLAG = -I

CC_COMP = g++$(VERSION)
C_COMP  = gcc$(VERSION)
C_LINK  = g++$(VERSION)
C_OPTS  = -O3

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWLIB      = -L/opt/local/lib/ -ldfftw
FFTWINCLUDE  = /opt/local/include
LAPACKLIB    = -L/opt/local/lib/ -llapack -lf77blas -latlas -lcblas
#LAPACKLIB    = /Users/mjain/blas/ATLAS/macosX/lib/liblapack.a /Users/mjain/blas/ATLAS/macosX/lib/libf77blas.a /Users/mjain/blas/ATLAS/macosX/lib/libatlas.a /Users/mjain/blas/ATLAS/macosX/lib/libcblas.a -lpthread -lm

#To build with HDF5, install port hdf5-18 +gcc46 and set:
#MATHFLAG += -DHDF5
#HDF5INCLUDE  = /opt/local/include
#HDF5LIB      = -L/opt/local/lib -lhdf5_fortran -lhdf5
