#!/usr/bin/python
# eqp.py
#
# Usage: eqp.py edft|ecor|eqp0|eqp1|eqp0p|eqp1p sigma_hp.log eqp.dat
#
# Extracts quasiparticle energies from sigma_hp.log file produced by Sigma
# Writes eqp.dat file that can be read in Epsilon/Sigma/BSE(absorption/inteqp)
#
# 1st parameter specifies whether to write edft|ecor|eqp0|eqp1|eqp0p|eqp1p energies
#
# Georgy Samsonidze, UCB, August 2009

def main(argv = None):
   if argv is None:
      argv = sys.argv
   argc = len(argv)
   if argc != 4:
      print("\n   Usage: %s edft|ecor|eqp0|eqp1|eqp0p|eqp1p sigma_hp.log eqp.dat\n" % argv[0])
      return 2
   seqp = argv[1].lower()
   fni = argv[2]
   fno = argv[3]
   if seqp == 'edft':
      ieqp = 1
   elif seqp == 'ecor':
      ieqp = 2
   elif seqp == 'eqp0':
      ieqp = 8
   elif seqp == 'eqp1':
      ieqp = 9
   elif seqp == 'eqp0p':
      ieqp = 12
   elif seqp == 'eqp1p':
      ieqp = 13
   else:
      print("\n   Error: eqp type %s\n" % seqp)
      return 2
 
   ifrq = 1

   try:
      h = open(fni, 'r')
      r = h.readlines()
      h.close()
      kpt = []
      kidx = []
      spin = []
      pos = []
      i = 0
      for s in r:
         if s.find("frequency_dependence") != -1:
            t = s.split()
            freq_dep = int(t[1])
            print("Frequency dependence = %s" % freq_dep)
            if freq_dep > 1:
               ifrq = 2
         if s.find("ik =") != -1:
            t = s.split()
            kpt.append([float(t[2]),float(t[3]),float(t[4])])
            kidx.append(int(t[7]))
            spin.append(int(t[10]))
            pos.append(i+2+ifrq)
         i += 1
      nks = len(kidx)
      ns = max(spin)
      nb = []
      band = []
      edft = []
      eqp = []
      for i in range(nks):
         band.append([])
         edft.append([])
         eqp.append([])
         j = 0
         while 1:
            t = r[pos[i]+j*ifrq].split()
            if len(t) < 11:
               break
            band[i].append(int(t[0]))
            edft[i].append(float(t[1]))
            eqp[i].append(float(t[ieqp]))
            j += 1
         nb.append(j)
   except:
      print("\n   Error: input file %s\n" % fni)
      return 2
   try:
      h = open(fno, 'w')
      for i in range(nks):
         if spin[i] == 1:
            s = '%13.9f%13.9f%13.9f%8i\n' % (kpt[i][0], kpt[i][1], kpt[i][2], ns * nb[i])
            h.write(s)
         else:
            if kpt[i] != kpt[i-1]:
               print("\n   Error: k-point/spin order\n")
               return 2
         for j in range(nb[i]):
            s = '%8i%8i%15.9f%15.9f\n' % (spin[i], band[i][j], edft[i][j], eqp[i][j])
            h.write(s)
      h.close()
   except:
      print("\n   Error: output file %s\n" % fno)
      return 2
   return 0

if __name__ == "__main__":
   import sys
   import math
   import string
   sys.exit(main())
