!===========================================================================
!
! Routines()
!
! (1) shiftenergy()     Originally by ?         Last Edited: 5/12/2008 (JRD)
!
!     Computes and symmetrizes the quasiparticle spectrum
!
!===========================================================================

#include "f_defs.h"

subroutine shiftenergy(sig,wfnk,alda,asx,ach,achcor,ax,efsto,asig,enew,zrenorm)

  use global_m
  implicit none

  type (siginfo), intent(in) :: sig
  type (wfnkstates), intent(in) :: wfnk
  SCALAR, intent(inout) :: &
    alda(sig%ndiag+sig%noffdiag,sig%nspin), &
    asx(3,sig%ndiag+sig%noffdiag,sig%nspin), &
    ach(3,sig%ndiag+sig%noffdiag,sig%nspin)
  complex(DPC), intent(inout) :: achcor(sig%ndiag+sig%noffdiag,sig%nspin)
  SCALAR, intent(inout) :: ax(sig%ndiag+sig%noffdiag,sig%nspin)
  real(DP), intent(out) :: efsto(sig%ndiag,sig%nspin)
  SCALAR, intent(inout) :: asig(sig%ndiag+sig%noffdiag,sig%nspin)
  real(DP), intent(out) :: enew(sig%ndiag,sig%nspin)
  real(DP), intent(out) :: zrenorm(sig%ndiag,sig%nspin)

  integer :: i,j,istart,istop,nl,iflag,ispin
  integer, allocatable :: ndeg(:)
  real(DP) :: fact,dek,dele
  SCALAR :: aldai,axi,asig1,asig2,asig3, &
    asxi1,asxi2,asxi3,achi1,achi2,achi3
  complex(DPC) :: achcori
  
  PUSH_SUB(shiftenergy)
  
  SAFE_ALLOCATE(ndeg, (sig%ntband))

  do ispin=1,sig%nspin
    
    nl=1
    ndeg(nl)=1
    do i=2,sig%ndiag
      iflag=0
      dek = wfnk%elda(sig%diag(i),ispin) - wfnk%elda(sig%diag(i-1),ispin)
      if(abs(dek) .lt. TOL_Degeneracy) iflag=1
      if (iflag.eq.0) nl=nl+1
      if (iflag.eq.0) ndeg(nl)=1
      if (iflag.eq.1) ndeg(nl)=ndeg(nl)+1
    enddo
    
    istop = 0
    do i=1,nl
      istart = istop + 1
      istop = istart + ndeg(i) - 1
      aldai = ZERO
      axi = ZERO
      asxi1 = ZERO
      achi1 = ZERO
      asxi2 = ZERO
      achi2 = ZERO
      asxi3 = ZERO
      achi3 = ZERO
      achcori = (0.0d0, 0.0d0)
      do j=istart,istop
        aldai = aldai + alda(j,ispin)
        axi = axi + ax(j,ispin)
        asxi1 = asxi1 + asx(1,j,ispin)
        achi1 = achi1 + ach(1,j,ispin)
        asxi2 = asxi2 + asx(2,j,ispin)
        achi2 = achi2 + ach(2,j,ispin)
        asxi3 = asxi3 + asx(3,j,ispin)
        achi3 = achi3 + ach(3,j,ispin)
        achcori = achcori + achcor(j,ispin)
      enddo
      
      fact = ryd / dble(ndeg(i))
      do j=istart,istop
        alda(j,ispin) = aldai * fact
        ax(j,ispin) = axi * fact
        asx(1,j,ispin) = asxi1 * fact
        asx(2,j,ispin) = asxi2 * fact
        asx(3,j,ispin) = asxi3 * fact
        ach(1,j,ispin) = achi1 * fact
        ach(2,j,ispin) = achi2 * fact
        ach(3,j,ispin) = achi3 * fact
        achcor(j,ispin) = achcori * fact
        asig1 = ax(j,ispin) + asx(1,j,ispin) + ach(1,j,ispin)
        asig2 = ax(j,ispin) + asx(2,j,ispin) + ach(2,j,ispin)
        asig3 = ax(j,ispin) + asx(3,j,ispin) + ach(3,j,ispin)
        asig(j,ispin) = asig2

! Correcting Eqp [Eq. (37) of Hybertsen & Louie PRB]
! by Murilo (Aug 11, 2000)

        efsto(j,ispin) = wfnk%elda(sig%diag(j),ispin) - &
          alda(j,ispin) + asig(j,ispin)
        dele = efsto(j,ispin) - wfnk%ek(sig%diag(j),ispin)

! SIB:  It seems silly to have the if below.  If we really
! believe that Sigma is a linear function of energy (which
! is assumed by doing the correction to efsto), then using
! both -dw (asig1) and +dw (asig3) is pointless.
!
!            if (dele.gt.0.0d0) enew(j,ispin) = efsto(j,ispin)
!     >       +(asig3-asig2)/( sig%dw-asig3+asig2)*dele
!            if (dele.le.0.0d0) enew(j,ispin) = efsto(j,ispin)
!     >       +(asig1-asig2)/(-sig%dw-asig1+asig2)*dele
!
! gsm: Instead, let`s use either -dw (asig1) or +dw (asig3)
! or both depending on the value of sig%fdf.  This allows
! us to skip either iw=1 or iw=3 in subroutine mtxel_sxch.

        if (sig%fdf.eq.-1) then
          enew(j,ispin) = efsto(j,ispin) + &
            (asig2-asig1)/(sig%dw-asig2+asig1)*dele
          zrenorm(j, ispin) = 1d0 / (1d0 - (asig2 - asig1)/sig%dw)
        elseif (sig%fdf.eq.0) then
          enew(j,ispin) = efsto(j,ispin) + &
            (asig3-asig1)/(2.0d0*sig%dw-asig3+asig1)*dele
          zrenorm(j, ispin) = 1d0 / (1d0 - (asig3 - asig1)/(2d0 * sig%dw))
        elseif (sig%fdf.eq.1.or.sig%fdf.eq.2) then
          enew(j,ispin) = efsto(j,ispin) + &
            (asig3-asig2)/(sig%dw-asig3+asig2)*dele
          zrenorm(j, ispin) = 1d0 / (1d0 - (asig3 - asig2)/sig%dw)
        else
          enew(j,ispin) = efsto(j,ispin)
          zrenorm(j, ispin) = 1d0
        endif
        
      enddo ! j
    enddo ! i
  enddo ! ispin
  
  SAFE_DEALLOCATE(ndeg)
  
  POP_SUB(shiftenergy)
  
  return
end subroutine shiftenergy
