#include "f_defs.h"

!*************************************************************************
Module densityArrayMod
!*************************************************************************
! Module for density defined on a grid
! densityArrayT is a type containing the wavefunction and density information
!*************************************************************************
! NEED TO CHANGE TO MAKE MORE UNIVERSAL
!*************************************************************************

  use SysParams,    only : double
  use push_pop_m

  type densityArrayT
    complex(double), pointer :: densityArray(:), waveFunction(:), rhog(:)
    integer,         pointer :: gridDimensions(:)
    integer                  :: gridSize
  end type densityArrayT

  contains

!*************************************************************************
  Subroutine densityArrayInit( densityArray, ndim, maxGLen, numGVectors )
!*************************************************************************

    implicit none
    
    type( densityArrayT ), pointer :: densityArray
    integer, intent(in) :: ndim
    integer, intent(in) :: maxGLen(3)
    integer, intent(in) :: numGVectors
    integer :: i, error

    PUSH_SUB(densityArrayInit)

    if( associated( densityArray )) stop 'Error, densityArray already allocated.'
    allocate( densityArray, stat=error )
    if( error /= 0 ) stop 'Error, densityArray allocation failed.'
    nullify( densityArray%densityArray )
    nullify( densityArray%waveFunction )
    nullify( densityArray%rhog )
    nullify( densityArray%gridDimensions )

    densityArray%gridSize = 1

    allocate(densityArray%gridDimensions(ndim), stat = error)
    if(error /= 0) stop 'Error allocating gridDimensions.'

    do i = 1, ndim
      densityArray%gridDimensions(i) = maxGLen(i)
      densityArray%gridSize = densityArray%gridSize * densityArray%gridDimensions(i)
    end do

    allocate( densityArray%densityArray(densityArray%gridSize), &
            & densityArray%waveFunction(densityArray%gridSize), &
            & densityArray%rhog(numGVectors), stat = error )
    if(error /= 0) stop 'Error allocating densityMatrix in densityArrayInit.'

    POP_SUB(densityArrayInit)
  end Subroutine densityArrayInit

!*************************************************************************
  Subroutine densityArrayDestroy( densityArray )
!*************************************************************************

    implicit none
    
    type( densityArrayT ), pointer :: densityArray
    integer :: error

    PUSH_SUB(densityArrayDestroy)

    if( .not. associated( densityArray )) stop 'Error, densityArray not allocated.'

    deallocate( densityArray%gridDimensions, densityArray%densityArray, &
              & densityArray%waveFunction, densityArray%rhog, stat = error )
    if(error /= 0) stop 'Error deallocating densityArray.'

    deallocate( densityArray, stat = error )
    if(error /= 0) stop 'Error, densityArray deallocation failed.'

    nullify( densityArray )

    POP_SUB(densityArrayDestroy)
  end Subroutine densityArrayDestroy

end Module densityArrayMod

