!================================================================================
!
! Modules:
!
! (1) peinfo_m      Originally by DAS 8/20/2010
!
!     Defines type and global instance of object for "processor equivalent" info.
!     Use mpi module to define interfaces for MPI calls.
!     [For F77, MPI header 'mpif.h' was included.]
!
!================================================================================

#include "f_defs.h"

module peinfo_m

! The MPICH1 version of mpi.mod has a limited set of interfaces which will cause
! errors of inability to match generic procedure on compilation for certain
! multidimensional-array calls to MPI_Bcast, MPI_Allreduce, etc.
! Solution: pass explicitly the first element, i.e. (1,1,1), of the array.
#ifdef MPI
  use mpi
#endif
  use nrtype_m
  implicit none

  public ::      &
    peinfo,      &
    peinfo_init

!-------------------------------

  type peinfo
    ! default values for serial
    integer :: npes = 1
    integer :: inode = 0
    ! initialize to zero, then keep track of memory
    real(DP) :: mymem = 0d0
    real(DP) :: mymaxmem = 0d0
    integer :: igroupworld
    integer :: nckmem
    integer :: nckpe
    integer :: nkpe
    integer :: nck
    integer :: myown
    integer :: jobtypeeval
    integer :: nblocks
    integer :: nblockd
    integer, pointer :: wown(:,:,:,:,:,:)
    integer, pointer :: ciown(:)
    integer, pointer :: ik(:,:)
    integer, pointer :: ic(:,:)
    integer, pointer :: iv(:,:)
    integer, pointer :: ikp(:,:)
    integer, pointer :: icp(:,:)
    integer, pointer :: ivp(:,:)
    integer, pointer :: ib(:,:)
    integer, pointer :: ick(:,:)
    integer, pointer :: ipe(:)
    integer, pointer :: ipec(:,:,:)
    integer, pointer :: ipev(:,:,:)
    integer, pointer :: ipek(:,:)
    integer, pointer :: ipecb(:,:)
    integer, pointer :: ivckpe(:)
    integer, pointer :: ikt(:)
    integer, pointer :: ibt(:)
    integer, pointer :: ikb(:,:)
    integer, pointer :: ivb(:,:)
    integer, pointer :: icb(:,:)
    integer, pointer :: neig(:)
    integer, pointer :: peig(:,:)
    integer :: npools
    integer :: nvown
    integer :: ncown
    integer :: nvownt
    integer :: ncownt
    integer, pointer :: global_pairowner(:,:)
    integer, pointer :: global_nvown(:)
    integer, pointer :: global_ncown(:)
    integer, pointer :: indexv(:)
    integer, pointer :: indexc(:)
    integer, pointer :: ivprincipalowner(:)
    integer, pointer :: nvprincipalown(:)
    integer, pointer :: invindexv(:)
    integer, pointer :: invindexc(:)
    integer, pointer :: doiownv(:)
    integer, pointer :: doiownc(:)
    integer, pointer :: iownwfv(:)
    integer, pointer :: iownwfc(:)
    integer, pointer :: iownwfk(:)
    integer, pointer :: nxqown(:)
    integer, pointer :: nxqi(:)
    integer :: ndiag_max
    integer :: noffdiag_max
    integer :: ntband_max
    integer :: ntband_node
    integer :: nvband_node
    integer, pointer :: indext(:)
    integer, pointer :: index_diag(:)
    logical, pointer :: flag_diag(:)
    integer, pointer :: index_offdiag(:)
    logical, pointer :: flag_offdiag(:)
  end type peinfo
  
  type(peinfo), save, public :: peinf
#ifdef MPI
  integer, public :: mpistatus(MPI_STATUS_SIZE)
  integer, public :: mpierr
#endif

contains

  subroutine peinfo_init()
    ! cannot use push_pop because that module uses this one

#ifdef MPI
    call MPI_Init(mpierr)
    if(mpierr .ne. MPI_SUCCESS) then
      write(0,'(a)') 'ERROR: MPI initialization failed!'
      stop 999
    endif
    call MPI_Comm_rank(MPI_COMM_WORLD, peinf%inode, mpierr)
    call MPI_Comm_size(MPI_COMM_WORLD, peinf%npes, mpierr)
#endif

! if serial, default values set in type peinfo above are left alone

    return
  end subroutine peinfo_init
  
end module peinfo_m
