!===============================================================================
!
! Routines:
!
! (1) mtxel_v()         Originally By MLT       Last Modified: 6/5/2008 (JRD)
!
!     input: wfnc, wfnvq, gvec types
!            qshift   length of the q-shift vector
!
!     output: s0   velocity matrix elements at a k-point
!
!     Calculates the velocity operator between two sets of wavefunctions
!     < ic,k | exp(-i q.r) | iv,k+q > / q
!     Each set has its own isort vector and the number of bands is nband
!     q is a small but finite shift to k in reciprocal space
!
!===============================================================================

#include "f_defs.h"

subroutine mtxel_v(wfnc,wfnvq,gvec,qshift,s0_dim1,s0_dim2,s0)

  use global_m
  implicit none

  type (wavefunction), intent(in) :: wfnc, wfnvq
  type (gspace), intent(in) :: gvec
  real(DP), intent(in) :: qshift
  integer, intent(in) :: s0_dim1, s0_dim2
  SCALAR, intent(out) :: s0(s0_dim1, s0_dim2, wfnc%nspin)
  
  integer :: ig, igq, ic, iv, isc
  integer, allocatable :: isorti(:)
  SCALAR :: sum

!--------------------------------
! Initialize isorti array

  PUSH_SUB(mtxel_v)
  
  s0 = ZERO
  SAFE_ALLOCATE(isorti, (gvec%ng))
  isorti(:)=0
  do ig=1, gvec%ng
    isorti(wfnvq%isort(ig)) = ig
  enddo

!--------------------------------
! Calculate s0(ic,iv) = < ic,k | exp(-i q.r) | iv,k+q > / q

  do isc=1,wfnc%nspin
    do ic=1,s0_dim1
      do iv=1,s0_dim2
        sum=ZERO
        do ig=1, wfnc%ng
          igq=isorti(wfnc%isort(ig))
          if (igq.gt.wfnvq%ng) exit
          sum = sum + MYCONJG(wfnc%cg(ig,ic,isc)) * wfnvq%cg(igq,iv,isc)
        enddo
        s0(ic,iv,isc) = sum / qshift
      enddo ! iv
    enddo ! ic
  enddo ! isc
  
  SAFE_DEALLOCATE(isorti)
  
  POP_SUB(mtxel_v)
  
  return
end subroutine mtxel_v
