!===========================================================================
!
! Routines:
!
! (1) Xinvert_with_scalapack_d() Originally By JRD       Last Modified 11/2/2010 (DAS)
!
!     This routine inverts a matrix which is already distributed in block-diagonal
!     form with scaLAPACK.
!
! (2) Xinvert_serial()      Originally By JRD       Last Modified 11/2/2010 (DAS)
!
!     Inverts a matrix using LAPACK or ESSL.
!
!============================================================================

module inversion_m

  use global_m
#ifdef USEESSL
  use essl_m
#else
  use lapack_m
#endif
  use scalapack_m
  implicit none

  public :: &
#ifdef USESCALAPACK
    dinvert_with_scalapack,  &
    zinvert_with_scalapack,  &
#endif
    dinvert_serial,          &
    zinvert_serial

contains

!overrules arch.mk
#undef CPLX
#include "f_defs.h"
#include "inversion_inc.f90"

#include "undef.h"

#define CPLX
#include "f_defs.h"
#include "inversion_inc.f90"

end module inversion_m

!! Local Variables:
!! mode: f90
!! coding: utf-8
!! End:
