#include "f_defs.h"

module genwf_m

  use global_m
  use blas_m
  use gmap_m
  use sort_m
  implicit none

  public :: genwf

contains

  !-----------------------------------------------------------------------
  subroutine genwf(crys,gvec,kg,syms,wfn,xct,ik,ik2,work,intwfn,is_cond)
  !-----------------------------------------------------------------------
  !
  !     input: crys, gvec, kg,  syms, xct types
  !            ik       label of k-point
  !
  !     output: wfn    conduction wavefunctions at k-point ik
  !
    type (crystal), intent(in) :: crys
    type (gspace), intent(in) :: gvec
    type (grid), intent(in) :: kg
    type (symmetry), intent(in) :: syms
    type (wavefunction), intent(out) :: wfn
    type (xctinfo), intent(in) :: xct
    integer, intent(in) :: ik, ik2
    type (work_genwf), intent(inout) :: work
    type (int_wavefunction), intent(in) :: intwfn
    logical, intent(in) :: is_cond
    
    integer :: iwrite
    character :: filename*20, wfnname*10
    integer :: irk, iunit
    integer :: ii, jj, kk, eof
    real(DP) :: xnorm
    
    integer, allocatable :: isorti(:)
    real(DP) :: qk(3)
    real(DP), allocatable :: ekin(:)
    
    PUSH_SUB(genwf)
  
    if (xct%iwriteint .eq. 0) then
      if(peinf%inode.lt.10000) then
        if(is_cond) then
          write(filename,'(a,i4.4)') 'INT_CWFN_', peinf%inode
          iunit=128+(2*peinf%inode)+1
          wfnname = "conduction"
        else
          write(filename,'(a,i4.4)') 'INT_VWFNQ_', peinf%inode
          iunit=128+(2*peinf%inode)+2
          wfnname = "valence"
        endif
      else
        call die('genwf: cannot use more than 9999 nodes')
      endif
    endif
  
  !-----------------------------------------------------------------------
  !     Start looking for the right k-point in tape iunit
  
    if(ik.ne.work%ikold) then
      if (xct%iwriteint .eq. 0) then
        call open_file(iunit,file=filename,form='unformatted',status='old')
        
        eof=0
        read(iunit) irk,work%ng,work%nb,work%ns
        do while((irk.ne.kg%indr(ik2)).and.(eof.eq.0))
          read(iunit)
          read(iunit,iostat=eof) irk,work%ng,work%nb,work%ns
        enddo
        if(eof.ne.0) then
          write(0,*) 'BUG: PE ', peinf%inode, ' could not find the ', trim(wfnname), &
            'wavefunctions for k-point ', ik2
          write(0,*) '  (equivalent to k-point ', kg%indr(ik2), 'in the IBZ) in file ', filename
          call die("genwf wfns missing")
        endif
      else
        iwrite=0
        do ii=1, peinf%ikt(peinf%inode+1)
          if(peinf%ik(peinf%inode+1,ii).eq.ik) then
            iwrite=ii
            work%ng=intwfn%ng(ii)
            if(is_cond) then
              work%nb=xct%ncband
            else
              work%nb=xct%nvband
            endif
            work%ns=xct%nspin
          endif
        enddo
      endif
      
      if(work%ikold.ne.0) then
        SAFE_DEALLOCATE_P(work%cg)
        SAFE_DEALLOCATE_P(work%ph)
        SAFE_DEALLOCATE_P(work%ind)
        SAFE_DEALLOCATE_P(work%isort)
      endif
      SAFE_ALLOCATE(work%cg, (work%ng,work%nb,work%ns))
      SAFE_ALLOCATE(work%ind, (work%ng))
      SAFE_ALLOCATE(work%ph, (work%ng))
      SAFE_ALLOCATE(work%isort, (gvec%ng))
    endif
  
    wfn%ng=work%ng
    wfn%nband=work%nb
    wfn%nspin=work%ns
    if (work%ns.ne.xct%nspin) then
      write(0,*) 'spin number mismatch in file ', filename, xct%nspin, work%ns
      call die("genwf spin number mismatch")
    endif
    
    SAFE_ALLOCATE(wfn%cg, (wfn%ng,wfn%nband,wfn%nspin))
    SAFE_ALLOCATE(wfn%isort, (gvec%ng))
    
    if(ik.ne.work%ikold) then
  !       Read the wavefunctions for the rk-kpoint
      if (xct%iwriteint .eq. 0) then
        read(iunit) (work%isort(ii),ii=1,gvec%ng), &
          (((work%cg(ii,jj,kk),ii=1,wfn%ng),jj=1,wfn%nband), kk=1,wfn%nspin)
      else
        work%isort(:)=intwfn%isort(:,iwrite)
        work%cg(1:wfn%ng,:,:)=intwfn%cgk(1:wfn%ng,:,:,iwrite)
      endif
  
  !       Compute inverse index array of Fourier components around rk-kpoint
      SAFE_ALLOCATE(isorti, (gvec%ng))
      isorti(:)=0
      do ii=1,wfn%ng
        isorti(work%isort(ii))=ii
      enddo
  
  !       Compute index array of Fourier components around fk-kpoint
      SAFE_ALLOCATE(ekin, (gvec%ng))
      do ii=1,gvec%ng
        qk(1:3)=kg%f(1:3,ik2)+gvec%k(1:3,ii)
        ekin(ii)=0.0d0
        do jj=1,3
          do kk=1,3
            ekin(ii)=ekin(ii)+qk(jj)*crys%bdot(jj,kk)*qk(kk)
          enddo
        enddo
      enddo
      call sortrx_D(gvec%ng, ekin, work%isort, gvec = gvec%k)
      SAFE_DEALLOCATE(ekin)
  
  !       Find ind and ph relating wavefunctions in fk to rk-kpoint
      work%ind=0
      work%ph=0
      call gmap(gvec,syms,wfn%ng,kg%itran(ik2), &
        kg%kg0(:,ik2),work%isort,isorti,work%ind,work%ph,.true.)
      SAFE_DEALLOCATE(isorti)
  
  !       Compute and renormalize wavefunctions
      do kk=1,wfn%nspin
        do jj=1,wfn%nband
          xnorm=0.0d0
          do ii=1,wfn%ng
            if (work%ind(ii) .gt. 0) then
              wfn%cg(ii,jj,kk)=work%ph(ii)*work%cg(work%ind(ii),jj,kk)
            else
              wfn%cg(ii,jj,kk)=0d0
            endif
          enddo
          xnorm = blas_nrm2(wfn%ng, wfn%cg(:, jj, kk), 1)
          wfn%cg(1:wfn%ng,jj,kk)=wfn%cg(1:wfn%ng,jj,kk)/xnorm
          if (abs(1.0-xnorm).gt.TOL_Small) then
            write(0,*) 'WARNING: bad normalization for', &
              kk,jj,peinf%inode
          endif
        enddo
      enddo
      work%cg=wfn%cg

      if(xct%iwriteint == 0) call close_file(iunit)
    endif
    
    wfn%cg=work%cg
    wfn%isort=work%isort
    
    work%ikold=ik
    
    POP_SUB(genwf)
    
    return
  end subroutine genwf
  
end module genwf_m
