!==============================================================================
!
! Utilities:
!
! (1) summarize_eigenvectors()       Originally By JRD,CHP   Last Modified: 6/5/2008 (JRD)
!
!     This program prints some useful information about the exciton wavefunction.
!
!==============================================================================

#include "f_defs.h"

program summarize_eigenvectors

  use global_m
  implicit none

  integer :: ns, nc, nv, nk, nmat, i, m, uu, c, v, s, ik, ikmax
  integer :: ijk, up,nexc, ninfile
  real(DP) :: energy, weight, wmax, emax, emin
  real(DP), allocatable :: kk(:,:), energies(:)
  SCALAR, allocatable :: Aread(:),A(:,:,:,:)
  character*20, allocatable :: filename(:)
  
  uu = 10
  up = 11
  
  call open_file(unit=uu,file='eigenvectors',form='unformatted',status='old')
  call open_file(unit=up,file='summarize_eigenvectors.inp',status='old')
  
  read(up,*) ninfile
  read(up,*) emin, emax
  read(up,*) nexc
  if (nexc .gt. 0) then
    SAFE_ALLOCATE(energies, (nexc))
    SAFE_ALLOCATE(filename, (nexc))
    do ijk =1, nexc
      read(up,*) energies(ijk)
    enddo
    do ijk =1, nexc
      write(filename(ijk),'(a8,i2.2)') 'exciton_',ijk
    enddo
  endif
  
  read(uu) ns
  read(uu) nv
  read(uu) nc
  read(uu) nk
  nmat = ns*nv*nc*nk
  
  if (ninfile .eq. 0) then
    ninfile = nmat
  endif
  
  write(6,'(a)')
  write(6,'(a)') 'Reading eigenvectors'
  write(6,'(a)')
  write(6,'(a,4i5)') ' ns, nv, nc, nk = ',ns,nv,nc,nk
  write(6,'(a,i8)') ' nmat = ',nmat
  SAFE_ALLOCATE(kk, (3,nk))
  read(uu) kk(:,:)
  write(6,'(a)')
  write(6,'(a)') 'kpoints follow:'
  do ik=1,nk
    write(6,'(i5,3f10.5)') ik, kk(:,ik)
  enddo
  write(6,'(a)')
  write(6,'(a)') 'exciton energies follow'
  SAFE_ALLOCATE(Aread, (nmat))
  SAFE_ALLOCATE(A, (ns,nv,nc,nk))
  do i=1,ninfile
    read(uu) energy
    read(uu) Aread(:)
    if ((energy <= emax) .and. (energy >= emin))  then
      m = 0
      do ik=1,nk
        do c=1,nc
          do v=1,nv
            do s=1,ns
              m = m+1
              A(s,v,c,ik) = Aread(m)
            enddo
          enddo
        enddo
      enddo
      write(6,'(a)')
      write(6,'(a,i5,f10.5)') ' Special analysis for state ',i,energy
      write(6,'(2a5,3a10)') 'c','v','wtot','wmax','ikmax'
      do c=1,nc
        do v=1,nv
          weight = 0.0d0
          wmax = 0.0d0
          do ik=1,nk
            do s=1,ns
              weight = weight + abs(A(s,v,c,ik))**2
              if (abs(A(s,v,c,ik))**2 > wmax) then
                wmax = abs(A(s,v,c,ik))**2
                ikmax = ik
              endif
            enddo
          enddo
          write(6,'(2i5,2f10.5,i10)') c, v, weight, wmax, ikmax
        enddo
      enddo
      
      do ijk = 1, nexc
        if (abs(energy - energies(ijk)) .le. 1d-5) then
          write(6,'(a,i6,f12.6)') 'Calculating A(k) for :',ijk,energies(ijk)
          call open_file(unit=200+ijk,file=filename(ijk),status='replace')
          do ik=1,nk
            weight = 0.0d0
            do c=1,nc
              do v=1,nv
                do s=1,ns
                  weight = weight + abs(A(s,v,c,ik))**2
                enddo
              enddo
            enddo
            write(200+ijk,'(3f10.5,f10.5)') kk(1:3,ik),weight
          enddo
          call close_file(200+ijk)
        endif
      enddo
      
    endif
  enddo
  write(6,'(a)')
  call close_file(uu)
  
  SAFE_DEALLOCATE(kk)
  SAFE_DEALLOCATE(Aread)
  SAFE_DEALLOCATE(A)
  
end program summarize_eigenvectors
