!==============================================================================
!
! Routines:
!
! (1) bsewrite()        Originally By MLT       Last Modified 7/1/2008 (JRD)
!
!     input:  xct types
!            bsedbody,bsedhead,bsedwing,bsex
!     output: binary files "bsedmat", "bsexmat"
!
!     Write out all interaction matrices elements in "bsedmat", "bsexmat"
!
!     Since all PEs write into the same tapes, the access must be organized:
!     one PE at a time
!
!     It appears the imatrix code is: 1 dhead, 2 dwing, 3 dbody, 4 x
!     5 head1, 6 wing1, 7 body1, 8 head2, 9 wing2, 10 body2 (dyn screening only)
!     But why do we have head1 and head2 at all? head1 is the same as head
!     in the calling routine. This seems like a waste.
!
!=============================================================================

#include "f_defs.h"

subroutine bsewrite(xct,iownsize,bsedbody,bsedhead,bsedwing,bsex, &
  bsedhead1,bsedbody1,bsedwing1,bsedbody2,bsedwing2)

  use global_m
  implicit none

  type (xctinfo), intent(in) :: xct
  integer, intent(in) :: iownsize
  SCALAR, intent(in) :: &
    bsedbody(iownsize,xct%nspin,xct%nspin), &
    bsedhead(iownsize,xct%nspin,xct%nspin), &
    bsedwing(iownsize,xct%nspin,xct%nspin), &
    bsex(iownsize,xct%nspin,xct%nspin), &
    bsedhead1(iownsize,xct%nspin,xct%nspin), &
    bsedbody1(iownsize,xct%nspin,xct%nspin), &
    bsedwing1(iownsize,xct%nspin,xct%nspin), &
    bsedbody2(iownsize,xct%nspin,xct%nspin), &
    bsedwing2(iownsize,xct%nspin,xct%nspin)

  SCALAR, allocatable :: bsemt(:,:,:,:,:), bsemtt(:,:,:,:,:)
  SCALAR :: bsem

  integer :: nmatrices,imatrix,iunit
  integer :: ic,icp,ik,ikp,is1,is2,iv,ivp,it
  real(DP) :: bsedhm,bsedwm,bsedbm,bsexm
  real(DP) :: bsedhmt,bsedwmt,bsedbmt,bsexmt

  PUSH_SUB(bsewrite)

  SAFE_ALLOCATE(bsemt,(xct%nkpt,xct%ncband,xct%nvband,xct%nspin,xct%nspin))
  SAFE_ALLOCATE(bsemtt,(xct%nkpt,xct%ncband,xct%nvband,xct%nspin,xct%nspin))

  if(peinf%inode .eq. 0 ) then
    call open_file(unit=11,file='bsedmat',position='append',form='unformatted',status='old')
    call open_file(unit=12,file='bsexmat',position='append',form='unformatted',status='old')
    if (xct%dynamic_screening .and. xct%dynamic_type .eq. 0) then
      call open_file(unit=13,file='bsedmat1',position='append',form='unformatted',status='old')
      call open_file(unit=14,file='bsedmat2',position='append',form='unformatted',status='old')
    endif
  endif

!      write(6,*) peinf%inode, 'opened files'

  if (xct%dynamic_screening .and. xct%dynamic_type .eq. 0) then
    nmatrices = 10
  else
    nmatrices = 4
  endif

  bsedhm=0.d0
  bsedwm=0.d0
  bsedbm=0.d0
  bsexm=0.d0
  
  do ik=1,xct%nkpt
    do imatrix = 1, nmatrices
      do ic=1,xct%ncband
        do iv=1,xct%nvband
          
          bsemt=0.d0
          do ikp=1,xct%nkpt
            do icp=1,xct%ncband
              do ivp=1,xct%nvband
                
                if (xct%icpar .eq. 0) then
                  it = peinf%wown(1,1,ikp,1,1,ik)
                  if (it .ne. 0) then 
                    it = peinf%wown(1,1,ikp,1,1,ik) + xct%nvband*xct%nvband*xct%ncband*(icp-1) &
                      + xct%nvband*xct%nvband*(ic-1) + xct%nvband*(ivp-1) + iv -1
                  endif
                else if (xct%ivpar .eq. 0) then
                  it = peinf%wown(1,icp,ikp,1,ic,ik)
                  if (it .ne. 0) then
                    it = it + xct%nvband*(ivp-1) + iv -1
                  endif
                else
                  it = peinf%wown(ivp,icp,ikp,iv,ic,ik) 
                endif

!              it = peinf%wown(ivp,icp,ikp,iv,ic,ik)
                if (it .ne. 0) then
                  do is1=1,xct%nspin
                    do is2=1,xct%nspin
                      if ( imatrix .eq. 1) then
                        bsem=bsedhead(it,is1,is2)
                        if (bsedhm.lt.abs(bsem)) bsedhm=abs(bsem)
                      else if ( imatrix .eq. 2) then
                        bsem=bsedwing(it,is1,is2)
                        if (bsedwm.lt.abs(bsem)) bsedwm=abs(bsem)
                      else if ( imatrix .eq. 3) then
                        bsem=bsedbody(it,is1,is2)
                        if (bsedbm.lt.abs(bsem)) bsedbm=abs(bsem)
                      else if ( imatrix .eq. 4) then
                        bsem=bsex(it,is1,is2)
                        if (bsexm.lt.abs(bsem)) bsexm=abs(bsem)
                      else if ( imatrix .eq. 5) then
                        bsem=bsedhead1(it,is1,is2)
                      else if ( imatrix .eq. 6) then
                        bsem=bsedwing1(it,is1,is2)
                      else if ( imatrix .eq. 7) then
                        bsem=bsedbody1(it,is1,is2)
                      else if ( imatrix .eq. 8) then
                        bsem=bsedhead1(it,is1,is2)
                      else if ( imatrix .eq. 9) then
                        bsem=bsedwing2(it,is1,is2)
                      else if ( imatrix .eq. 10) then
                        bsem=bsedbody2(it,is1,is2)
                      endif
                      bsemt(ikp,icp,ivp,is1,is2)= bsem
                    enddo !is2
                  enddo !is1
                endif
              enddo !ivp
            enddo !icp
          enddo !ikp
          bsemtt=0D0

#ifdef MPI
          call MPI_REDUCE(bsemt(1,1,1,1,1),bsemtt(1,1,1,1,1),xct%nkpt*xct%ncband*xct%nvband*xct%nspin*xct%nspin, &
            MPI_SCALAR,MPI_SUM,0,MPI_COMM_WORLD,mpierr)
          call MPI_BARRIER(MPI_COMM_WORLD,mpierr)
          if (peinf%inode .eq. 0) then
            bsemt=bsemtt
          endif
#endif

          if (peinf%inode .eq. 0) then
            if ( imatrix .lt. 4) then
              iunit = 11
            else if (imatrix .eq. 4) then
              iunit = 12
            else if (imatrix .lt. 8) then
              iunit = 13
            else 
              iunit = 14
            endif
            write(iunit) ik,ic,iv,(((((bsemt(ikp,icp,ivp,is1,is2), &
              is2=1,xct%nspin),is1=1,xct%nspin), &
              ivp=1,xct%nvband),icp=1,xct%ncband),ikp=1,xct%nkpt)
          endif
        enddo !ii
      enddo !ic
    enddo !imatrix
  enddo !ik
  
! JRD: Print out the maximum values of matrix elements found across PEs!
! bse*t are used to write matrix elements in the right format
!
! bse*m contain the maximum values (in absolute value) of each
! part of the kernel calculated by each PE. Their only purpose is
! to check if the matrix elements have the right order or
! magnitude.

#ifdef MPI
!      do ii=2,peinf%npes
!        if (peinf%inode.eq.ii-1) then
!          call MPI_SEND(bsedhm,1,MPI_REAL_DP, &
!          0,ii*4,MPI_COMM_WORLD,mpierr)
!          call MPI_SEND(bsedwm,1,MPI_REAL_DP, &
!          0,ii*4+1,MPI_COMM_WORLD,mpierr)
!          call MPI_SEND(bsedbm,1,MPI_REAL_DP, &
!          0,ii*4+2,MPI_COMM_WORLD,mpierr)
!          call MPI_SEND(bsexm,1,MPI_REAL_DP, &
!          0,ii*4+3,MPI_COMM_WORLD,mpierr)
!        endif
!        if (peinf%inode.eq.0) then
!          call MPI_RECV(bsedhm,1,MPI_REAL_DP, &
!          ii-1,ii*4,MPI_COMM_WORLD,mpistatus,mpierr)
!          call MPI_RECV(bsedwm,1,MPI_REAL_DP, &
!          ii-1,ii*4+1,MPI_COMM_WORLD,mpistatus,mpierr)
!          call MPI_RECV(bsedbm,1,MPI_REAL_DP, &
!          ii-1,ii*4+2,MPI_COMM_WORLD,mpistatus,mpierr)
!          call MPI_RECV(bsexm,1,MPI_REAL_DP, &
!          ii-1,ii*4+3,MPI_COMM_WORLD,mpistatus,mpierr)
!          write(6,*)
!          write(6,'(a,i6)')        'Proc   :       ',ii-1
!          write(6,'(a,i6,f22.15)') 'maximum: head  ',ii,bsedhm
!          write(6,'(a,i6,f22.15)') '         wing  ',ii,bsedwm
!          write(6,'(a,i6,f22.15)') '         body  ',ii,bsedbm
!          write(6,'(a,i6,f22.15)') '         x     ',ii,bsexm
!        endif
!      enddo
  call MPI_Barrier(MPI_COMM_WORLD,mpierr)
  call MPI_Reduce(bsedhm,bsedhmt,1,MPI_REAL_DP, &
    MPI_MAX,0,MPI_COMM_WORLD,mpierr)
  call MPI_Reduce(bsedbm,bsedbmt,1,MPI_REAL_DP, &
    MPI_MAX,0,MPI_COMM_WORLD,mpierr)
  call MPI_Reduce(bsedwm,bsedwmt,1,MPI_REAL_DP, &
    MPI_MAX,0,MPI_COMM_WORLD,mpierr)
  call MPI_Reduce(bsexm,bsexmt,1,MPI_REAL_DP, &
    MPI_MAX,0,MPI_COMM_WORLD,mpierr)
#else
  bsedhmt=bsedhm
  bsedbmt=bsedbm
  bsedwmt=bsedwm
  bsexmt=bsexm
#endif

  if (peinf%inode.eq.0) then
    write(6,*)
    write(6,'(a,f22.15)') 'maximum: head  ',bsedhmt
    write(6,'(a,f22.15)') '         wing  ',bsedwmt
    write(6,'(a,f22.15)') '         body  ',bsedbmt
    write(6,'(a,f22.15)') '         x     ',bsexmt
  endif

  SAFE_DEALLOCATE(bsemt)
  SAFE_DEALLOCATE(bsemtt)
  
  POP_SUB(bsewrite)
  
  return
end subroutine bsewrite
