!===============================================================================
!
! Routines:
!
! (1) absorption         Originally by JRD       Last Edited: 9/12/2011 (JRD)
!
!     This routine calls either diag or haydock.
!
!     For more details the README_absorption file:
!
!     Please report bugs to: jdeslip@civet.berkeley.edu
!     
!================================================================================

#include "f_defs.h"

program absorption

  use global_m
  use inread_m
  implicit none

  type (eqpinfo) :: eqp
  type (xctinfo) :: xct
  type (flags) :: flag

  integer :: nmax,neig
  logical :: diagonalization

  call peinfo_init()

!---------------------------
! Write header

  call write_program_header('BSE/Absorption', .false.)

!---------------------------
! Read absorption.inp

  call logit('Calling inread')
  call open_file(8,file='absorption.inp',form='formatted',status='old')
  call inread(eqp,xct,flag,nmax,neig,diagonalization)
  call close_file(8)

  if (diagonalization) then
    call diag(eqp,xct,flag,neig)
  else 
    call haydock(eqp,xct,flag,nmax)
  endif

end program absorption
